webpackJsonp([140],[
/* 0 */,
/* 1 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreSitesProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_common_http__ = __webpack_require__(263);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ngx_translate_core__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__app__ = __webpack_require__(9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__events__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__logger__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__sites_factory__ = __webpack_require__(438);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__utils_text__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__utils_url__ = __webpack_require__(23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__utils_utils__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__ws__ = __webpack_require__(202);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__core_constants__ = __webpack_require__(40);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__configconstants__ = __webpack_require__(119);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__classes_site__ = __webpack_require__(52);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14_ts_md5_dist_md5__ = __webpack_require__(203);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14_ts_md5_dist_md5___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_14_ts_md5_dist_md5__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15__app_app_module__ = __webpack_require__(533);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
















/*
 * Service to manage and interact with sites.
 * It allows creating tables in the databases of all sites. Each service or component should be responsible of creating
 * their own database tables. Example:
 *
 * constructor(sitesProvider: CoreSitesProvider) {
 *     this.sitesProvider.createTableFromSchema(this.tableSchema);
 *
 * This provider will automatically create the tables in the databases of all the instantiated sites, and also to the
 * databases of sites instantiated from now on.
*/
var CoreSitesProvider = /** @class */ (function () {
    function CoreSitesProvider(logger, http, sitesFactory, appProvider, translate, urlUtils, eventsProvider, textUtils, utils, injector, wsProvider) {
        this.http = http;
        this.sitesFactory = sitesFactory;
        this.appProvider = appProvider;
        this.translate = translate;
        this.urlUtils = urlUtils;
        this.eventsProvider = eventsProvider;
        this.textUtils = textUtils;
        this.utils = utils;
        this.injector = injector;
        this.wsProvider = wsProvider;
        // Variables for the database.
        this.SITES_TABLE = 'sites';
        this.CURRENT_SITE_TABLE = 'current_site';
        this.SCHEMA_VERSIONS_TABLE = 'schema_versions';
        this.appTablesSchema = [
            {
                name: this.SITES_TABLE,
                columns: [
                    {
                        name: 'id',
                        type: 'TEXT',
                        primaryKey: true
                    },
                    {
                        name: 'siteUrl',
                        type: 'TEXT',
                        notNull: true
                    },
                    {
                        name: 'token',
                        type: 'TEXT'
                    },
                    {
                        name: 'info',
                        type: 'TEXT'
                    },
                    {
                        name: 'privateToken',
                        type: 'TEXT'
                    },
                    {
                        name: 'config',
                        type: 'TEXT'
                    },
                    {
                        name: 'loggedOut',
                        type: 'INTEGER'
                    }
                ]
            },
            {
                name: this.CURRENT_SITE_TABLE,
                columns: [
                    {
                        name: 'id',
                        type: 'INTEGER',
                        primaryKey: true
                    },
                    {
                        name: 'siteId',
                        type: 'TEXT',
                        notNull: true,
                        unique: true
                    }
                ]
            }
        ];
        // Constants to validate a site version.
        this.WORKPLACE_APP = 3;
        this.MOODLE_APP = 2;
        this.VALID_VERSION = 1;
        this.LEGACY_APP_VERSION = 0;
        this.INVALID_VERSION = -1;
        this.services = {};
        this.sessionRestored = false;
        this.sites = {};
        this.siteSchemasMigration = {};
        // Schemas for site tables. Other providers can add schemas in here.
        this.siteSchemas = {};
        this.siteTablesSchemas = [
            {
                name: this.SCHEMA_VERSIONS_TABLE,
                columns: [
                    {
                        name: 'name',
                        type: 'TEXT',
                        primaryKey: true,
                    },
                    {
                        name: 'version',
                        type: 'INTEGER'
                    }
                ]
            }
        ];
        // Site schema for this provider.
        this.siteSchema = {
            name: 'CoreSitesProvider',
            version: 1,
            canBeCleared: [__WEBPACK_IMPORTED_MODULE_13__classes_site__["a" /* CoreSite */].WS_CACHE_TABLE],
            tables: [
                {
                    name: __WEBPACK_IMPORTED_MODULE_13__classes_site__["a" /* CoreSite */].WS_CACHE_TABLE,
                    columns: [
                        {
                            name: 'id',
                            type: 'TEXT',
                            primaryKey: true
                        },
                        {
                            name: 'data',
                            type: 'TEXT'
                        },
                        {
                            name: 'key',
                            type: 'TEXT'
                        },
                        {
                            name: 'expirationTime',
                            type: 'INTEGER'
                        }
                    ]
                },
                {
                    name: __WEBPACK_IMPORTED_MODULE_13__classes_site__["a" /* CoreSite */].CONFIG_TABLE,
                    columns: [
                        {
                            name: 'name',
                            type: 'TEXT',
                            unique: true,
                            notNull: true
                        },
                        {
                            name: 'value'
                        }
                    ]
                }
            ]
        };
        this.logger = logger.getInstance('CoreSitesProvider');
        this.appDB = appProvider.getDB();
        this.appDB.createTablesFromSchema(this.appTablesSchema);
        this.registerSiteSchema(this.siteSchema);
    }
    /**
     * Get the demo data for a certain "name" if it is a demo site.
     *
     * @param {string} name Name of the site to check.
     * @return {any} Site data if it's a demo site, undefined otherwise.
     */
    CoreSitesProvider.prototype.getDemoSiteData = function (name) {
        var demoSites = __WEBPACK_IMPORTED_MODULE_12__configconstants__["a" /* CoreConfigConstants */].demo_sites;
        if (typeof demoSites != 'undefined' && typeof demoSites[name] != 'undefined') {
            return demoSites[name];
        }
    };
    /**
     * Check if a site is valid and if it has specifics settings for authentication (like force to log in using the browser).
     * It will test both protocols if the first one fails: http and https.
     *
     * @param {string} siteUrl URL of the site to check.
     * @param {string} [protocol=https://] Protocol to use first.
     * @return {Promise<CoreSiteCheckResponse>} A promise resolved when the site is checked.
     */
    CoreSitesProvider.prototype.checkSite = function (siteUrl, protocol) {
        var _this = this;
        if (protocol === void 0) { protocol = 'https://'; }
        // The formatURL function adds the protocol if is missing.
        siteUrl = this.urlUtils.formatURL(siteUrl);
        if (!this.urlUtils.isHttpURL(siteUrl)) {
            return Promise.reject(this.translate.instant('core.login.invalidsite'));
        }
        else if (!this.appProvider.isOnline()) {
            return Promise.reject(this.translate.instant('core.networkerrormsg'));
        }
        else {
            return this.checkSiteWithProtocol(siteUrl, protocol).catch(function (error) {
                // Do not continue checking if a critical error happened.
                if (error.critical) {
                    return Promise.reject(error);
                }
                // Retry with the other protocol.
                protocol = protocol == 'https://' ? 'http://' : 'https://';
                return _this.checkSiteWithProtocol(siteUrl, protocol).catch(function (secondError) {
                    if (secondError.critical) {
                        return Promise.reject(secondError);
                    }
                    // Site doesn't exist. Return the error message.
                    if (_this.textUtils.getErrorMessageFromError(error)) {
                        return Promise.reject(error);
                    }
                    else if (_this.textUtils.getErrorMessageFromError(secondError)) {
                        return Promise.reject(secondError);
                    }
                    else {
                        return _this.translate.instant('core.cannotconnect');
                    }
                });
            });
        }
    };
    /**
     * Helper function to check if a site is valid and if it has specifics settings for authentication.
     *
     * @param {string} siteUrl URL of the site to check.
     * @param {string} protocol Protocol to use.
     * @return {Promise<CoreSiteCheckResponse>} A promise resolved when the site is checked.
     */
    CoreSitesProvider.prototype.checkSiteWithProtocol = function (siteUrl, protocol) {
        var _this = this;
        var publicConfig;
        // Now, replace the siteUrl with the protocol.
        siteUrl = siteUrl.replace(/^http(s)?\:\/\//i, protocol);
        return this.siteExists(siteUrl).catch(function (error) {
            // Do not continue checking if WS are not enabled.
            if (error.errorcode == 'enablewsdescription') {
                return rejectWithCriticalError(error.error, error.errorcode);
            }
            // Site doesn't exist. Try to add or remove 'www'.
            var treatedUrl = _this.urlUtils.addOrRemoveWWW(siteUrl);
            return _this.siteExists(treatedUrl).then(function () {
                // Success, use this new URL as site url.
                siteUrl = treatedUrl;
            }).catch(function (secondError) {
                // Do not continue checking if WS are not enabled.
                if (secondError.errorcode == 'enablewsdescription') {
                    return rejectWithCriticalError(secondError.error, secondError.errorcode);
                }
                // Return the error message.
                if (_this.textUtils.getErrorMessageFromError(error)) {
                    return Promise.reject(error);
                }
                else {
                    return Promise.reject(secondError);
                }
            });
        }).then(function () {
            // Create a temporary site to check if local_mobile is installed.
            var temporarySite = _this.sitesFactory.makeSite(undefined, siteUrl);
            return temporarySite.checkLocalMobilePlugin().then(function (data) {
                data.service = data.service || __WEBPACK_IMPORTED_MODULE_12__configconstants__["a" /* CoreConfigConstants */].wsservice;
                _this.services[siteUrl] = data.service; // No need to store it in DB.
                if (data.coreSupported ||
                    (data.code != __WEBPACK_IMPORTED_MODULE_11__core_constants__["a" /* CoreConstants */].LOGIN_SSO_CODE && data.code != __WEBPACK_IMPORTED_MODULE_11__core_constants__["a" /* CoreConstants */].LOGIN_SSO_INAPP_CODE)) {
                    // SSO using local_mobile not needed, try to get the site public config.
                    return temporarySite.getPublicConfig().then(function (config) {
                        publicConfig = config;
                        // Check that the user can authenticate.
                        if (!config.enablewebservices) {
                            return rejectWithCriticalError(_this.translate.instant('core.login.webservicesnotenabled'));
                        }
                        else if (!config.enablemobilewebservice) {
                            return rejectWithCriticalError(_this.translate.instant('core.login.mobileservicesnotenabled'));
                        }
                        else if (config.maintenanceenabled) {
                            var message = _this.translate.instant('core.sitemaintenance');
                            if (config.maintenancemessage) {
                                message += config.maintenancemessage;
                            }
                            return rejectWithCriticalError(message);
                        }
                        // Everything ok.
                        if (data.code === 0) {
                            data.code = config.typeoflogin;
                        }
                        return data;
                    }, function (error) {
                        // Error, check if not supported.
                        if (error.available === 1) {
                            // Service supported but an error happened. Return error.
                            error.critical = true;
                            if (error.errorcode == 'codingerror') {
                                // This could be caused by a redirect. Check if it's the case.
                                return _this.utils.checkRedirect(siteUrl).then(function (redirect) {
                                    if (redirect) {
                                        error.error = _this.translate.instant('core.login.sitehasredirect');
                                    }
                                    else {
                                        // We can't be sure if there is a redirect or not. Display cannot connect error.
                                        error.error = _this.translate.instant('core.cannotconnect');
                                    }
                                    return Promise.reject(error);
                                });
                            }
                            return Promise.reject(error);
                        }
                        return data;
                    });
                }
                return data;
            }, function (error) {
                // Local mobile check returned an error. This only happens if the plugin is installed and it returns an error.
                return rejectWithCriticalError(error);
            }).then(function (data) {
                siteUrl = temporarySite.getURL();
                return { siteUrl: siteUrl, code: data.code, warning: data.warning, service: data.service, config: publicConfig };
            });
        });
        // Return a rejected promise with a "critical" error.
        function rejectWithCriticalError(message, errorCode) {
            return Promise.reject({
                error: message,
                errorcode: errorCode,
                critical: true
            });
        }
    };
    /**
     * Check if a site exists.
     *
     * @param  {string} siteUrl URL of the site to check.
     * @return {Promise} A promise to be resolved if the site exists.
     */
    CoreSitesProvider.prototype.siteExists = function (siteUrl) {
        var _this = this;
        return this.http.post(siteUrl + '/login/token.php', {}).timeout(this.wsProvider.getRequestTimeout()).toPromise()
            .catch(function () {
            // Default error messages are kinda bad, return our own message.
            return Promise.reject({ error: _this.translate.instant('core.cannotconnect') });
        }).then(function (data) {
            if (data.errorcode && (data.errorcode == 'enablewsdescription' || data.errorcode == 'requirecorrectaccess')) {
                return Promise.reject({ errorcode: data.errorcode, error: data.error });
            }
            else if (data.error && data.error == 'Web services must be enabled in Advanced features.') {
                return Promise.reject({ errorcode: 'enablewsdescription', error: data.error });
            }
            // Other errors are not being checked because invalid login will be always raised and we cannot differ them.
        });
    };
    /**
     * Gets a user token from the server.
     *
     * @param {string} siteUrl The site url.
     * @param {string} username User name.
     * @param {string} password Password.
     * @param {string} [service] Service to use. If not defined, it will be searched in memory.
     * @param {boolean} [retry] Whether we are retrying with a prefixed URL.
     * @return {Promise<CoreSiteUserTokenResponse>} A promise resolved when the token is retrieved.
     */
    CoreSitesProvider.prototype.getUserToken = function (siteUrl, username, password, service, retry) {
        var _this = this;
        if (!this.appProvider.isOnline()) {
            return Promise.reject(this.translate.instant('core.networkerrormsg'));
        }
        if (!service) {
            service = this.determineService(siteUrl);
        }
        var params = {
            username: username,
            password: password,
            service: service
        }, loginUrl = siteUrl + '/login/token.php', promise = this.http.post(loginUrl, params).timeout(this.wsProvider.getRequestTimeout()).toPromise();
        return promise.then(function (data) {
            if (typeof data == 'undefined') {
                return Promise.reject(_this.translate.instant('core.cannotconnect'));
            }
            else {
                if (typeof data.token != 'undefined') {
                    return { token: data.token, siteUrl: siteUrl, privateToken: data.privatetoken };
                }
                else {
                    if (typeof data.error != 'undefined') {
                        // We only allow one retry (to avoid loops).
                        if (!retry && data.errorcode == 'requirecorrectaccess') {
                            siteUrl = _this.urlUtils.addOrRemoveWWW(siteUrl);
                            return _this.getUserToken(siteUrl, username, password, service, true);
                        }
                        else if (data.errorcode == 'missingparam') {
                            // It seems the server didn't receive all required params, it could be due to a redirect.
                            return _this.utils.checkRedirect(loginUrl).then(function (redirect) {
                                if (redirect) {
                                    return Promise.reject({ error: _this.translate.instant('core.login.sitehasredirect') });
                                }
                                else {
                                    return Promise.reject({ error: data.error, errorcode: data.errorcode });
                                }
                            });
                        }
                        else if (typeof data.errorcode != 'undefined') {
                            return Promise.reject({ error: data.error, errorcode: data.errorcode });
                        }
                        else {
                            return Promise.reject(data.error);
                        }
                    }
                    else {
                        return Promise.reject(_this.translate.instant('core.login.invalidaccount'));
                    }
                }
            }
        }, function () {
            return Promise.reject(_this.translate.instant('core.cannotconnect'));
        });
    };
    /**
     * Add a new site to the site list and authenticate the user in this site.
     *
     * @param {string} siteUrl The site url.
     * @param {string} token User's token.
     * @param {string} [privateToken=''] User's private token.
     * @param {boolean} [login=true] Whether to login the user in the site. Defaults to true.
     * @return {Promise<string>} A promise resolved with siteId when the site is added and the user is authenticated.
     */
    CoreSitesProvider.prototype.newSite = function (siteUrl, token, privateToken, login) {
        var _this = this;
        if (privateToken === void 0) { privateToken = ''; }
        if (login === void 0) { login = true; }
        if (typeof login != 'boolean') {
            login = true;
        }
        // Create a "candidate" site to fetch the site info.
        var candidateSite = this.sitesFactory.makeSite(undefined, siteUrl, token, undefined, privateToken), isNewSite = true;
        return candidateSite.fetchSiteInfo().then(function (info) {
            var result = _this.isValidMoodleVersion(info);
            if (result == _this.VALID_VERSION) {
                var siteId_1 = _this.createSiteID(info.siteurl, info.username);
                // Check if the site already exists.
                return _this.getSite(siteId_1).catch(function () {
                    // Not exists.
                }).then(function (site) {
                    if (site) {
                        // Site already exists, update its data and use it.
                        isNewSite = false;
                        candidateSite = site;
                        candidateSite.setToken(token);
                        candidateSite.setPrivateToken(privateToken);
                        candidateSite.setInfo(info);
                    }
                    else {
                        // New site, set site ID and info.
                        isNewSite = true;
                        candidateSite.setId(siteId_1);
                        candidateSite.setInfo(info);
                        // Create database tables before login and before any WS call.
                        return _this.migrateSiteSchemas(candidateSite);
                    }
                }).then(function () {
                    // Try to get the site config.
                    return _this.getSiteConfig(candidateSite).catch(function (error) {
                        // Ignore errors if it's not a new site, we'll use the config already stored.
                        if (isNewSite) {
                            return Promise.reject(error);
                        }
                    }).then(function (config) {
                        if (typeof config != 'undefined') {
                            candidateSite.setConfig(config);
                        }
                        // Add site to sites list.
                        _this.addSite(siteId_1, siteUrl, token, info, privateToken, config);
                        _this.sites[siteId_1] = candidateSite;
                        if (login) {
                            // Turn candidate site into current site.
                            _this.currentSite = candidateSite;
                            // Store session.
                            _this.login(siteId_1);
                        }
                        _this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_4__events__["a" /* CoreEventsProvider */].SITE_ADDED, info, siteId_1);
                        return siteId_1;
                    });
                });
            }
            return _this.treatInvalidAppVersion(result, siteUrl);
        });
    };
    /**
     * Having the result of isValidMoodleVersion, it treats the error message to be shown.
     *
     * @param {number} result Result returned by isValidMoodleVersion function.
     * @param {string} siteUrl The site url.
     * @param  {string} siteId If site is already added, it will invalidate the token.
     * @return {Promise<any>} A promise rejected with the error info.
     */
    CoreSitesProvider.prototype.treatInvalidAppVersion = function (result, siteUrl, siteId) {
        var _this = this;
        var errorCode, errorKey, errorExtra = '', errorKeyParams;
        switch (result) {
            case this.LEGACY_APP_VERSION:
                errorKey = 'core.login.legacymoodleversion';
                errorCode = 'legacymoodleversion';
                if (this.appProvider.isDesktop()) {
                    errorKey += 'desktop';
                    errorKeyParams = { $a: siteUrl };
                }
                if (this.appProvider.isWindows() || this.appProvider.isLinux()) {
                    errorExtra = this.translate.instant('core.login.legacymoodleversiondesktopdownloadold');
                }
                break;
            case this.MOODLE_APP:
                errorKey = 'core.login.connecttomoodleapp';
                errorCode = 'connecttomoodleapp';
                break;
            case this.WORKPLACE_APP:
                errorKey = 'core.login.connecttoworkplaceapp';
                errorCode = 'connecttoworkplaceapp';
                break;
            default:
                errorCode = 'invalidmoodleversion';
                errorKey = 'core.login.invalidmoodleversion';
        }
        var promise;
        if (siteId) {
            promise = this.setSiteLoggedOut(siteId, true);
        }
        else {
            promise = Promise.resolve();
        }
        return promise.then(function () {
            return Promise.reject({
                error: _this.translate.instant(errorKey, errorKeyParams) + errorExtra,
                errorcode: errorCode,
                loggedout: true
            });
        });
    };
    /**
     * Create a site ID based on site URL and username.
     *
     * @param {string} siteUrl The site url.
     * @param {string} username Username.
     * @return {string} Site ID.
     */
    CoreSitesProvider.prototype.createSiteID = function (siteUrl, username) {
        return __WEBPACK_IMPORTED_MODULE_14_ts_md5_dist_md5__["Md5"].hashAsciiStr(siteUrl + username);
    };
    /**
     * Function for determine which service we should use (default or extended plugin).
     *
     * @param {string} siteUrl The site URL.
     * @return {string} The service shortname.
     */
    CoreSitesProvider.prototype.determineService = function (siteUrl) {
        // We need to try siteUrl in both https or http (due to loginhttps setting).
        // First http://
        siteUrl = siteUrl.replace('https://', 'http://');
        if (this.services[siteUrl]) {
            return this.services[siteUrl];
        }
        // Now https://
        siteUrl = siteUrl.replace('http://', 'https://');
        if (this.services[siteUrl]) {
            return this.services[siteUrl];
        }
        // Return default service.
        return __WEBPACK_IMPORTED_MODULE_12__configconstants__["a" /* CoreConfigConstants */].wsservice;
    };
    /**
     * Check for the minimum required version.
     *
     * @param {any} info Site info.
     * @return {number} Either VALID_VERSION, LEGACY_APP_VERSION, WORKPLACE_APP, MOODLE_APP or INVALID_VERSION.
     */
    CoreSitesProvider.prototype.isValidMoodleVersion = function (info) {
        if (!info) {
            return this.INVALID_VERSION;
        }
        var version24 = 2012120300, // Moodle 2.4 version.
        release24 = '2.4', version31 = 2016052300, release31 = '3.1';
        // Try to validate by version.
        if (info.version) {
            var version = parseInt(info.version, 10);
            if (!isNaN(version)) {
                if (version >= version31) {
                    return this.validateWorkplaceVersion(info);
                }
                else if (version >= version24) {
                    return this.LEGACY_APP_VERSION;
                }
            }
        }
        // We couldn't validate by version number. Let's try to validate by release number.
        var release = this.getReleaseNumber(info.release || '');
        if (release) {
            if (release >= release31) {
                return this.validateWorkplaceVersion(info);
            }
            if (release >= release24) {
                return this.LEGACY_APP_VERSION;
            }
        }
        // Couldn't validate it.
        return this.INVALID_VERSION;
    };
    /**
     * Check if needs to be redirected to specific Workplace App or general Moodle App.
     *
     * @param {any} info Site info.
     * @return {number} Either VALID_VERSION, WORKPLACE_APP or MOODLE_APP.
     */
    CoreSitesProvider.prototype.validateWorkplaceVersion = function (info) {
        var isWorkplace = !!info.functions && info.functions.some(function (func) {
            return func.name == 'tool_program_get_user_programs';
        });
        if (typeof this.isWPApp == 'undefined') {
            this.isWPApp = !!__WEBPACK_IMPORTED_MODULE_15__app_app_module__["c" /* WP_PROVIDER */] && __WEBPACK_IMPORTED_MODULE_15__app_app_module__["c" /* WP_PROVIDER */].name == 'AddonBlockProgramsOverviewModule' &&
                !!this.injector.get(__WEBPACK_IMPORTED_MODULE_15__app_app_module__["c" /* WP_PROVIDER */], false);
        }
        if (!this.isWPApp && isWorkplace) {
            return this.WORKPLACE_APP;
        }
        if (this.isWPApp && !isWorkplace) {
            return this.MOODLE_APP;
        }
        return this.VALID_VERSION;
    };
    /**
     * Returns the release number from site release info.
     *
     * @param  {string}  rawRelease Raw release info text.
     * @return {string}   Release number or empty.
     */
    CoreSitesProvider.prototype.getReleaseNumber = function (rawRelease) {
        var matches = rawRelease.match(/^\d(\.\d(\.\d+)?)?/);
        if (matches) {
            return matches[0];
        }
        return '';
    };
    /**
     * Check if site info is valid. If it's not, return error message.
     *
     * @param {any} info Site info.
     * @return {any} True if valid, object with error message to show and its params if not valid.
     */
    CoreSitesProvider.prototype.validateSiteInfo = function (info) {
        if (!info.firstname || !info.lastname) {
            var moodleLink = "<a core-link href=\"" + info.siteurl + "\">" + info.siteurl + "</a>";
            return { error: 'core.requireduserdatamissing', params: { $a: moodleLink } };
        }
        return true;
    };
    /**
     * Saves a site in local DB.
     *
     * @param {string} id Site ID.
     * @param {string} siteUrl Site URL.
     * @param {string} token User's token in the site.
     * @param {any} info Site's info.
     * @param {string} [privateToken=''] User's private token.
     * @param {any} [config] Site config (from tool_mobile_get_config).
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreSitesProvider.prototype.addSite = function (id, siteUrl, token, info, privateToken, config) {
        if (privateToken === void 0) { privateToken = ''; }
        var entry = {
            id: id,
            siteUrl: siteUrl,
            token: token,
            info: info ? JSON.stringify(info) : info,
            privateToken: privateToken,
            config: config ? JSON.stringify(config) : config,
            loggedOut: 0
        };
        return this.appDB.insertRecord(this.SITES_TABLE, entry);
    };
    /**
     * Login a user to a site from the list of sites.
     *
     * @param {string} siteId ID of the site to load.
     * @param {string} [pageName] Name of the page to go once authenticated if logged out. If not defined, site initial page.
     * @param {any} [params] Params of the page to go once authenticated if logged out.
     * @return {Promise<boolean>} Promise resolved with true if site is loaded, resolved with false if cannot login.
     */
    CoreSitesProvider.prototype.loadSite = function (siteId, pageName, params) {
        var _this = this;
        this.logger.debug("Load site " + siteId);
        return this.getSite(siteId).then(function (site) {
            _this.currentSite = site;
            if (site.isLoggedOut()) {
                // Logged out, trigger session expired event and stop.
                _this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_4__events__["a" /* CoreEventsProvider */].SESSION_EXPIRED, {
                    pageName: pageName,
                    params: params
                }, site.getId());
                return false;
            }
            // Check if local_mobile was installed to Moodle.
            return site.checkIfLocalMobileInstalledAndNotUsed().then(function () {
                // Local mobile was added. Throw invalid session to force reconnect and create a new token.
                _this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_4__events__["a" /* CoreEventsProvider */].SESSION_EXPIRED, {
                    pageName: pageName,
                    params: params
                }, siteId);
                return false;
            }, function () {
                _this.login(siteId);
                // Update site info. We don't block the UI.
                _this.updateSiteInfo(siteId);
                return true;
            });
        });
    };
    /**
     * Get current site.
     *
     * @return {CoreSite} Current site.
     */
    CoreSitesProvider.prototype.getCurrentSite = function () {
        return this.currentSite;
    };
    /**
     * Get the site home ID of the current site.
     *
     * @return {number} Current site home ID.
     */
    CoreSitesProvider.prototype.getCurrentSiteHomeId = function () {
        if (this.currentSite) {
            return this.currentSite.getSiteHomeId();
        }
        else {
            return 1;
        }
    };
    /**
     * Get current site ID.
     *
     * @return {string} Current site ID.
     */
    CoreSitesProvider.prototype.getCurrentSiteId = function () {
        if (this.currentSite) {
            return this.currentSite.getId();
        }
        else {
            return '';
        }
    };
    /**
     * Get current site User ID.
     *
     * @return {number} Current site User ID.
     */
    CoreSitesProvider.prototype.getCurrentSiteUserId = function () {
        if (this.currentSite) {
            return this.currentSite.getUserId();
        }
        else {
            return 0;
        }
    };
    /**
     * Check if the user is logged in a site.
     *
     * @return {boolean} Whether the user is logged in a site.
     */
    CoreSitesProvider.prototype.isLoggedIn = function () {
        return typeof this.currentSite != 'undefined' && typeof this.currentSite.token != 'undefined' &&
            this.currentSite.token != '';
    };
    /**
     * Delete a site from the sites list.
     *
     * @param {string} siteId ID of the site to delete.
     * @return {Promise<any>} Promise to be resolved when the site is deleted.
     */
    CoreSitesProvider.prototype.deleteSite = function (siteId) {
        var _this = this;
        this.logger.debug("Delete site " + siteId);
        if (typeof this.currentSite != 'undefined' && this.currentSite.id == siteId) {
            this.logout();
        }
        return this.getSite(siteId).then(function (site) {
            return site.deleteDB().then(function () {
                // Site DB deleted, now delete the app from the list of sites.
                delete _this.sites[siteId];
                return _this.appDB.deleteRecords(_this.SITES_TABLE, { id: siteId }).then(function () {
                    // Site deleted from sites list, now delete the folder.
                    return site.deleteFolder();
                }, function () {
                    // DB remove shouldn't fail, but we'll go ahead even if it does.
                    return site.deleteFolder();
                }).then(function () {
                    _this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_4__events__["a" /* CoreEventsProvider */].SITE_DELETED, site, siteId);
                });
            });
        });
    };
    /**
     * Check if there are sites stored.
     *
     * @return {Promise<boolean>} Promise resolved with true if there are sites and false if there aren't.
     */
    CoreSitesProvider.prototype.hasSites = function () {
        return this.appDB.countRecords(this.SITES_TABLE).then(function (count) {
            return count > 0;
        });
    };
    /**
     * Returns a site object.
     *
     * @param {string} [siteId] The site ID. If not defined, current site (if available).
     * @return {Promise<CoreSite>} Promise resolved with the site.
     */
    CoreSitesProvider.prototype.getSite = function (siteId) {
        var _this = this;
        if (!siteId) {
            return this.currentSite ? Promise.resolve(this.currentSite) : Promise.reject(null);
        }
        else if (this.currentSite && this.currentSite.getId() == siteId) {
            return Promise.resolve(this.currentSite);
        }
        else if (typeof this.sites[siteId] != 'undefined') {
            return Promise.resolve(this.sites[siteId]);
        }
        else {
            // Retrieve and create the site.
            return this.appDB.getRecord(this.SITES_TABLE, { id: siteId }).then(function (data) {
                return _this.makeSiteFromSiteListEntry(data);
            });
        }
    };
    /**
     * Create a site from an entry of the sites list DB. The new site is added to the list of "cached" sites: this.sites.
     *
     * @param {any} entry Site list entry.
     * @return {Promise<CoreSite>} Promised resolved with the created site.
     */
    CoreSitesProvider.prototype.makeSiteFromSiteListEntry = function (entry) {
        var _this = this;
        var site, info = entry.info, config = entry.config;
        // Parse info and config.
        info = info ? this.textUtils.parseJSON(info) : info;
        config = config ? this.textUtils.parseJSON(config) : config;
        site = this.sitesFactory.makeSite(entry.id, entry.siteUrl, entry.token, info, entry.privateToken, config, entry.loggedOut == 1);
        return this.migrateSiteSchemas(site).then(function () {
            // Set site after migrating schemas, or a call to getSite could get the site while tables are being created.
            _this.sites[entry.id] = site;
            return site;
        });
    };
    /**
     * Returns if the site is the current one.
     *
     * @param {string|CoreSite} [site] Site object or siteId to be compared. If not defined, use current site.
     * @return {boolean} Whether site or siteId is the current one.
     */
    CoreSitesProvider.prototype.isCurrentSite = function (site) {
        if (!site || !this.currentSite) {
            return !!this.currentSite;
        }
        var siteId = typeof site == 'object' ? site.getId() : site;
        return this.currentSite.getId() === siteId;
    };
    /**
     * Returns the database object of a site.
     *
     * @param {string} [siteId] The site ID. If not defined, current site (if available).
     * @return {Promise<SQLiteDB>} Promise resolved with the database.
     */
    CoreSitesProvider.prototype.getSiteDb = function (siteId) {
        return this.getSite(siteId).then(function (site) {
            return site.getDb();
        });
    };
    /**
     * Returns the site home ID of a site.
     *
     * @param  {number} [siteId] The site ID. If not defined, current site (if available).
     * @return {Promise}         Promise resolved with site home ID.
     */
    CoreSitesProvider.prototype.getSiteHomeId = function (siteId) {
        return this.getSite(siteId).then(function (site) {
            return site.getSiteHomeId();
        });
    };
    /**
     * Get the list of sites stored.
     *
     * @param {String[]} [ids] IDs of the sites to get. If not defined, return all sites.
     * @return {Promise<CoreSiteBasicInfo[]>} Promise resolved when the sites are retrieved.
     */
    CoreSitesProvider.prototype.getSites = function (ids) {
        var _this = this;
        return this.appDB.getAllRecords(this.SITES_TABLE).then(function (sites) {
            var formattedSites = [];
            sites.forEach(function (site) {
                if (!ids || ids.indexOf(site.id) > -1) {
                    // Parse info.
                    var siteInfo = site.info ? _this.textUtils.parseJSON(site.info) : site.info, basicInfo = {
                        id: site.id,
                        siteUrl: site.siteUrl,
                        fullName: siteInfo && siteInfo.fullname,
                        siteName: __WEBPACK_IMPORTED_MODULE_12__configconstants__["a" /* CoreConfigConstants */].sitename ? __WEBPACK_IMPORTED_MODULE_12__configconstants__["a" /* CoreConfigConstants */].sitename : siteInfo && siteInfo.sitename,
                        avatar: siteInfo && siteInfo.userpictureurl
                    };
                    formattedSites.push(basicInfo);
                }
            });
            return formattedSites;
        });
    };
    /**
     * Get the list of sites stored, sorted by URL and full name.
     *
     * @param {String[]} [ids] IDs of the sites to get. If not defined, return all sites.
     * @return {Promise<CoreSiteBasicInfo[]>} Promise resolved when the sites are retrieved.
     */
    CoreSitesProvider.prototype.getSortedSites = function (ids) {
        return this.getSites(ids).then(function (sites) {
            // Sort sites by url and ful lname.
            sites.sort(function (a, b) {
                // First compare by site url without the protocol.
                var compareA = a.siteUrl.replace(/^https?:\/\//, '').toLowerCase(), compareB = b.siteUrl.replace(/^https?:\/\//, '').toLowerCase();
                var compare = compareA.localeCompare(compareB);
                if (compare !== 0) {
                    return compare;
                }
                // If site url is the same, use fullname instead.
                compareA = a.fullName.toLowerCase().trim();
                compareB = b.fullName.toLowerCase().trim();
                return compareA.localeCompare(compareB);
            });
            return sites;
        });
    };
    /**
     * Get the list of IDs of sites stored and not logged out.
     *
     * @return {Promise<string[]>} Promise resolved when the sites IDs are retrieved.
     */
    CoreSitesProvider.prototype.getLoggedInSitesIds = function () {
        return this.appDB.getRecords(this.SITES_TABLE, { loggedOut: 0 }).then(function (sites) {
            return sites.map(function (site) {
                return site.id;
            });
        });
    };
    /**
     * Get the list of IDs of sites stored.
     *
     * @return {Promise<string[]>} Promise resolved when the sites IDs are retrieved.
     */
    CoreSitesProvider.prototype.getSitesIds = function () {
        return this.appDB.getAllRecords(this.SITES_TABLE).then(function (sites) {
            return sites.map(function (site) {
                return site.id;
            });
        });
    };
    /**
     * Login the user in a site.
     *
     * @param {string} siteid ID of the site the user is accessing.
     * @return {Promise<void>} Promise resolved when current site is stored.
     */
    CoreSitesProvider.prototype.login = function (siteId) {
        var _this = this;
        var entry = {
            id: 1,
            siteId: siteId
        };
        return this.appDB.insertRecord(this.CURRENT_SITE_TABLE, entry).then(function () {
            _this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_4__events__["a" /* CoreEventsProvider */].LOGIN, {}, siteId);
        });
    };
    /**
     * Logout the user.
     *
     * @return {Promise<any>} Promise resolved when the user is logged out.
     */
    CoreSitesProvider.prototype.logout = function () {
        var _this = this;
        var siteId;
        var promises = [];
        if (this.currentSite) {
            var siteConfig = this.currentSite.getStoredConfig();
            siteId = this.currentSite.getId();
            this.currentSite = undefined;
            if (siteConfig && siteConfig.tool_mobile_forcelogout == '1') {
                promises.push(this.setSiteLoggedOut(siteId, true));
            }
            promises.push(this.appDB.deleteRecords(this.CURRENT_SITE_TABLE, { id: 1 }));
        }
        return Promise.all(promises).finally(function () {
            _this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_4__events__["a" /* CoreEventsProvider */].LOGOUT, {}, siteId);
        });
    };
    /**
     * Restores the session to the previous one so the user doesn't has to login everytime the app is started.
     *
     * @return {Promise<any>} Promise resolved if a session is restored.
     */
    CoreSitesProvider.prototype.restoreSession = function () {
        var _this = this;
        if (this.sessionRestored) {
            return Promise.reject(null);
        }
        this.sessionRestored = true;
        return this.appDB.getRecord(this.CURRENT_SITE_TABLE, { id: 1 }).then(function (currentSite) {
            var siteId = currentSite.siteId;
            _this.logger.debug("Restore session in site " + siteId);
            return _this.loadSite(siteId);
        }).catch(function () {
            // No current session.
        });
    };
    /**
     * Mark or unmark a site as logged out so the user needs to authenticate again.
     *
     * @param {string} siteId ID of the site.
     * @param {boolean} loggedOut True to set the site as logged out, false otherwise.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreSitesProvider.prototype.setSiteLoggedOut = function (siteId, loggedOut) {
        var _this = this;
        return this.getSite(siteId).then(function (site) {
            var newValues = {
                token: '',
                loggedOut: loggedOut ? 1 : 0
            };
            site.setLoggedOut(loggedOut);
            return _this.appDB.updateRecords(_this.SITES_TABLE, newValues, { id: siteId });
        });
    };
    /**
     * Unset current site.
     */
    CoreSitesProvider.prototype.unsetCurrentSite = function () {
        this.currentSite = undefined;
    };
    /**
     * Updates a site's token.
     *
     * @param {string} siteUrl Site's URL.
     * @param {string} username Username.
     * @param {string} token User's new token.
     * @param {string} [privateToken=''] User's private token.
     * @return {Promise<any>} A promise resolved when the site is updated.
     */
    CoreSitesProvider.prototype.updateSiteToken = function (siteUrl, username, token, privateToken) {
        var _this = this;
        if (privateToken === void 0) { privateToken = ''; }
        var siteId = this.createSiteID(siteUrl, username);
        return this.updateSiteTokenBySiteId(siteId, token, privateToken).then(function () {
            return _this.login(siteId);
        });
    };
    /**
     * Updates a site's token using siteId.
     *
     * @param {string} siteId Site Id.
     * @param {string} token User's new token.
     * @param {string} [privateToken=''] User's private token.
     * @return {Promise<any>} A promise resolved when the site is updated.
     */
    CoreSitesProvider.prototype.updateSiteTokenBySiteId = function (siteId, token, privateToken) {
        var _this = this;
        if (privateToken === void 0) { privateToken = ''; }
        return this.getSite(siteId).then(function (site) {
            var newValues = {
                token: token,
                privateToken: privateToken,
                loggedOut: 0
            };
            site.token = token;
            site.privateToken = privateToken;
            site.setLoggedOut(false); // Token updated means the user authenticated again, not logged out anymore.
            return _this.appDB.updateRecords(_this.SITES_TABLE, newValues, { id: siteId });
        });
    };
    /**
     * Updates a site's info.
     *
     * @param {string} siteid Site's ID.
     * @return {Promise<any>} A promise resolved when the site is updated.
     */
    CoreSitesProvider.prototype.updateSiteInfo = function (siteId) {
        var _this = this;
        return this.getSite(siteId).then(function (site) {
            return site.fetchSiteInfo().then(function (info) {
                site.setInfo(info);
                var versionCheck = _this.isValidMoodleVersion(info);
                if (versionCheck != _this.VALID_VERSION) {
                    // The Moodle version is not supported, reject.
                    return _this.treatInvalidAppVersion(versionCheck, site.getURL(), site.getId());
                }
                // Try to get the site config.
                return _this.getSiteConfig(site).catch(function () {
                    // Error getting config, keep the current one.
                }).then(function (config) {
                    var newValues = {
                        info: JSON.stringify(info),
                        loggedOut: site.isLoggedOut() ? 1 : 0
                    };
                    if (typeof config != 'undefined') {
                        site.setConfig(config);
                        newValues.config = JSON.stringify(config);
                    }
                    return _this.appDB.updateRecords(_this.SITES_TABLE, newValues, { id: siteId }).finally(function () {
                        _this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_4__events__["a" /* CoreEventsProvider */].SITE_UPDATED, info, siteId);
                    });
                });
            }).catch(function (error) {
                // Ignore that we cannot fetch site info. Probably the auth token is invalid.
            });
        });
    };
    /**
     * Updates a site's info.
     *
     * @param {string} siteUrl  Site's URL.
     * @param {string} username Username.
     * @return {Promise<any>} A promise to be resolved when the site is updated.
     */
    CoreSitesProvider.prototype.updateSiteInfoByUrl = function (siteUrl, username) {
        var siteId = this.createSiteID(siteUrl, username);
        return this.updateSiteInfo(siteId);
    };
    /**
     * Get the site IDs a URL belongs to.
     * Someone can have more than one account in the same site, that's why this function returns an array of IDs.
     *
     * @param {string} url URL to check.
     * @param {boolean} [prioritize] True if it should prioritize current site. If the URL belongs to current site then it won't
     *                               check any other site, it will only return current site.
     * @param {string} [username] If set, it will return only the sites where the current user has this username.
     * @return {Promise<string[]>} Promise resolved with the site IDs (array).
     */
    CoreSitesProvider.prototype.getSiteIdsFromUrl = function (url, prioritize, username) {
        var _this = this;
        // If prioritize is true, check current site first.
        if (prioritize && this.currentSite && this.currentSite.containsUrl(url)) {
            if (!username || this.currentSite.getInfo().username == username) {
                return Promise.resolve([this.currentSite.getId()]);
            }
        }
        // Check if URL has http(s) protocol.
        if (!url.match(/^https?:\/\//i)) {
            // URL doesn't have http(s) protocol. Check if it has any protocol.
            if (this.urlUtils.isAbsoluteURL(url)) {
                // It has some protocol. Return empty array.
                return Promise.resolve([]);
            }
            else {
                // No protocol, probably a relative URL. Return current site.
                if (this.currentSite) {
                    return Promise.resolve([this.currentSite.getId()]);
                }
                else {
                    return Promise.resolve([]);
                }
            }
        }
        return this.appDB.getAllRecords(this.SITES_TABLE).then(function (siteEntries) {
            var ids = [];
            var promises = [];
            siteEntries.forEach(function (site) {
                if (!_this.sites[site.id]) {
                    promises.push(_this.makeSiteFromSiteListEntry(site));
                }
                if (_this.sites[site.id].containsUrl(url)) {
                    if (!username || _this.sites[site.id].getInfo().username == username) {
                        ids.push(site.id);
                    }
                }
            });
            return Promise.all(promises).then(function () {
                return ids;
            });
        }).catch(function () {
            // Shouldn't happen.
            return [];
        });
    };
    /**
     * Get the site ID stored in DB as current site.
     *
     * @return {Promise<string>} Promise resolved with the site ID.
     */
    CoreSitesProvider.prototype.getStoredCurrentSiteId = function () {
        return this.appDB.getRecord(this.CURRENT_SITE_TABLE, { id: 1 }).then(function (currentSite) {
            return currentSite.siteId;
        });
    };
    /**
     * Get the public config of a certain site.
     *
     * @param {string} siteUrl URL of the site.
     * @return {Promise<any>} Promise resolved with the public config.
     */
    CoreSitesProvider.prototype.getSitePublicConfig = function (siteUrl) {
        var temporarySite = this.sitesFactory.makeSite(undefined, siteUrl);
        return temporarySite.getPublicConfig();
    };
    /**
     * Get site config.
     *
     * @param {any} site The site to get the config.
     * @return {Promise<any>} Promise resolved with config if available.
     */
    CoreSitesProvider.prototype.getSiteConfig = function (site) {
        if (!site.wsAvailable('tool_mobile_get_config')) {
            // WS not available, cannot get config.
            return Promise.resolve();
        }
        return site.getConfig(undefined, true);
    };
    /**
     * Check if a certain feature is disabled in a site.
     *
     * @param {string} name Name of the feature to check.
     * @param {string} [siteId] The site ID. If not defined, current site (if available).
     * @return {Promise<boolean>} Promise resolved with true if disabled.
     */
    CoreSitesProvider.prototype.isFeatureDisabled = function (name, siteId) {
        return this.getSite(siteId).then(function (site) {
            return site.isFeatureDisabled(name);
        });
    };
    /**
     * Create a table in all the sites databases.
     *
     * @param {SQLiteDBTamableSchema} table Table schema.
     */
    CoreSitesProvider.prototype.createTableFromSchema = function (table) {
        this.createTablesFromSchema([table]);
    };
    /**
     * Create several tables in all the sites databases.
     *
     * @param {SQLiteDBTamableSchema[]} tables List of tables schema.
     */
    CoreSitesProvider.prototype.createTablesFromSchema = function (tables) {
        // Add the tables to the list of schemas. This list is to create all the tables in new sites.
        this.siteTablesSchemas = this.siteTablesSchemas.concat(tables);
        // Now create these tables in current sites.
        for (var id in this.sites) {
            this.sites[id].getDb().createTablesFromSchema(tables);
        }
    };
    /**
     * Check if a WS is available in the current site, if any.
     *
     * @param {string} method WS name.
     * @param {boolean} [checkPrefix=true] When true also checks with the compatibility prefix.
     * @return {boolean} Whether the WS is available.
     */
    CoreSitesProvider.prototype.wsAvailableInCurrentSite = function (method, checkPrefix) {
        if (checkPrefix === void 0) { checkPrefix = true; }
        var site = this.getCurrentSite();
        return site && site.wsAvailable(method, checkPrefix);
    };
    /**
     * Check if a site is a legacy site by its info.
     *
     * @param {any} info The site info.
     * @return {boolean} Whether it's a legacy Moodle.
     */
    CoreSitesProvider.prototype.isLegacyMoodleByInfo = function (info) {
        return this.isValidMoodleVersion(info) == this.LEGACY_APP_VERSION;
    };
    /**
     * Register a site schema.
     */
    CoreSitesProvider.prototype.registerSiteSchema = function (schema) {
        this.siteSchemas[schema.name] = schema;
    };
    /**
     * Install and upgrade all the registered schemas and tables.
     *
     * @param {CoreSite} site Site.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreSitesProvider.prototype.migrateSiteSchemas = function (site) {
        var _this = this;
        var db = site.getDb();
        if (this.siteSchemasMigration[site.id]) {
            return this.siteSchemasMigration[site.id];
        }
        this.logger.debug("Migrating all schemas of " + site.id);
        // First create tables not registerd with name/version.
        var promise = db.createTablesFromSchema(this.siteTablesSchemas).then(function () {
            // Fetch installed versions of the schema.
            return db.getAllRecords(_this.SCHEMA_VERSIONS_TABLE).then(function (records) {
                var versions = {};
                records.forEach(function (record) {
                    versions[record.name] = record.version;
                });
                var promises = [];
                var _loop_1 = function (name_1) {
                    var schema = _this.siteSchemas[name_1];
                    var oldVersion = versions[name_1] || 0;
                    if (oldVersion >= schema.version) {
                        return "continue";
                    }
                    _this.logger.debug("Migrating schema '" + name_1 + "' of " + site.id + " from version " + oldVersion + " to " + schema.version);
                    var promise_1 = Promise.resolve();
                    if (schema.tables) {
                        promise_1 = promise_1.then(function () { return db.createTablesFromSchema(schema.tables); });
                    }
                    if (schema.migrate) {
                        promise_1 = promise_1.then(function () { return schema.migrate(db, oldVersion, site.id); });
                    }
                    // Set installed version.
                    promise_1 = promise_1.then(function () { return db.insertRecord(_this.SCHEMA_VERSIONS_TABLE, { name: name_1, version: schema.version }); });
                    promises.push(promise_1);
                };
                for (var name_1 in _this.siteSchemas) {
                    _loop_1(name_1);
                }
                return Promise.all(promises);
            });
        });
        this.siteSchemasMigration[site.id] = promise;
        return promise.finally(function () {
            delete _this.siteSchemasMigration[site.id];
        });
    };
    /**
     * Check if a URL is the root URL of any of the stored sites.
     *
     * @param {string} url URL to check.
     * @param {string} [username] Username to check.
     * @return {Promise<{site: CoreSite, siteIds: string[]}>} Promise resolved with site to use and the list of sites that have
     *                                   the URL. Site will be undefined if it isn't the root URL of any stored site.
     */
    CoreSitesProvider.prototype.isStoredRootURL = function (url, username) {
        var _this = this;
        // Check if the site is stored.
        return this.getSiteIdsFromUrl(url, true, username).then(function (siteIds) {
            var result = {
                siteIds: siteIds,
                site: undefined
            };
            if (siteIds.length > 0) {
                // If more than one site is returned it usually means there are different users stored. Use any of them.
                return _this.getSite(siteIds[0]).then(function (site) {
                    var siteUrl = _this.textUtils.removeEndingSlash(_this.urlUtils.removeProtocolAndWWW(site.getURL())), treatedUrl = _this.textUtils.removeEndingSlash(_this.urlUtils.removeProtocolAndWWW(url));
                    if (siteUrl == treatedUrl) {
                        result.site = site;
                    }
                    return result;
                });
            }
            return result;
        });
    };
    /**
     * Returns the Site Schema names that can be cleared on space storage.
     *
     * @return {string[]} Name of the site schemas.
     */
    CoreSitesProvider.prototype.getSiteTableSchemasToClear = function () {
        var reset = [];
        for (var name_2 in this.siteSchemas) {
            if (this.siteSchemas[name_2].canBeCleared) {
                reset = reset.concat(this.siteSchemas[name_2].canBeCleared);
            }
        }
        return reset;
    };
    CoreSitesProvider = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_5__logger__["a" /* CoreLoggerProvider */], __WEBPACK_IMPORTED_MODULE_1__angular_common_http__["c" /* HttpClient */], __WEBPACK_IMPORTED_MODULE_6__sites_factory__["a" /* CoreSitesFactoryProvider */],
            __WEBPACK_IMPORTED_MODULE_3__app__["a" /* CoreAppProvider */], __WEBPACK_IMPORTED_MODULE_2__ngx_translate_core__["c" /* TranslateService */], __WEBPACK_IMPORTED_MODULE_8__utils_url__["a" /* CoreUrlUtilsProvider */],
            __WEBPACK_IMPORTED_MODULE_4__events__["a" /* CoreEventsProvider */], __WEBPACK_IMPORTED_MODULE_7__utils_text__["a" /* CoreTextUtilsProvider */],
            __WEBPACK_IMPORTED_MODULE_9__utils_utils__["a" /* CoreUtilsProvider */], __WEBPACK_IMPORTED_MODULE_0__angular_core__["C" /* Injector */], __WEBPACK_IMPORTED_MODULE_10__ws__["a" /* CoreWSProvider */]])
    ], CoreSitesProvider);
    return CoreSitesProvider;
}());

//# sourceMappingURL=sites.js.map

/***/ }),
/* 2 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreUtilsProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ionic_native_in_app_browser__ = __webpack_require__(433);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__ionic_native_clipboard__ = __webpack_require__(434);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__ionic_native_file_opener__ = __webpack_require__(435);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__ionic_native_web_intent__ = __webpack_require__(564);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__app__ = __webpack_require__(9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__dom__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__mimetype__ = __webpack_require__(66);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__text__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__events__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__logger__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__ngx_translate_core__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__lang__ = __webpack_require__(170);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14__ws__ = __webpack_require__(202);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};















/*
 * "Utils" service with helper functions.
 */
var CoreUtilsProvider = /** @class */ (function () {
    function CoreUtilsProvider(iab, appProvider, clipboard, domUtils, logger, translate, platform, langProvider, eventsProvider, fileOpener, mimetypeUtils, webIntent, wsProvider, zone, textUtils) {
        this.iab = iab;
        this.appProvider = appProvider;
        this.clipboard = clipboard;
        this.domUtils = domUtils;
        this.translate = translate;
        this.platform = platform;
        this.langProvider = langProvider;
        this.eventsProvider = eventsProvider;
        this.fileOpener = fileOpener;
        this.mimetypeUtils = mimetypeUtils;
        this.webIntent = webIntent;
        this.wsProvider = wsProvider;
        this.zone = zone;
        this.textUtils = textUtils;
        this.DONT_CLONE = ['[object FileEntry]', '[object DirectoryEntry]', '[object DOMFileSystem]'];
        this.uniqueIds = {};
        this.logger = logger.getInstance('CoreUtilsProvider');
    }
    /**
     * Given an error, add an extra warning to the error message and return the new error message.
     *
     * @param {any} error Error object or message.
     * @param {any} [defaultError] Message to show if the error is not a string.
     * @return {string} New error message.
     */
    CoreUtilsProvider.prototype.addDataNotDownloadedError = function (error, defaultError) {
        var errorMessage = error;
        if (error && typeof error != 'string') {
            errorMessage = this.textUtils.getErrorMessageFromError(error);
        }
        if (typeof errorMessage != 'string') {
            errorMessage = defaultError || '';
        }
        if (!this.isWebServiceError(error)) {
            // Local error. Add an extra warning.
            errorMessage += '<br><br>' + this.translate.instant('core.errorsomedatanotdownloaded');
        }
        return errorMessage;
    };
    /**
     * Similar to Promise.all, but if a promise fails this function's promise won't be rejected until ALL promises have finished.
     *
     * @param {Promise<any>[]} promises Promises.
     * @return {Promise<any>} Promise resolved if all promises are resolved and rejected if at least 1 promise fails.
     */
    CoreUtilsProvider.prototype.allPromises = function (promises) {
        if (!promises || !promises.length) {
            return Promise.resolve();
        }
        return new Promise(function (resolve, reject) {
            var total = promises.length;
            var count = 0, hasFailed = false, error;
            promises.forEach(function (promise) {
                promise.catch(function (err) {
                    hasFailed = true;
                    error = err;
                }).finally(function () {
                    count++;
                    if (count === total) {
                        // All promises have finished, reject/resolve.
                        if (hasFailed) {
                            reject(error);
                        }
                        else {
                            resolve();
                        }
                    }
                });
            });
        });
    };
    /**
     * Converts an array of objects to an object, using a property of each entry as the key.
     * E.g. [{id: 10, name: 'A'}, {id: 11, name: 'B'}] => {10: {id: 10, name: 'A'}, 11: {id: 11, name: 'B'}}
     *
     * @param {any[]} array The array to convert.
     * @param {string} propertyName The name of the property to use as the key.
     * @param {any} [result] Object where to put the properties. If not defined, a new object will be created.
     * @return {any} The object.
     */
    CoreUtilsProvider.prototype.arrayToObject = function (array, propertyName, result) {
        result = result || {};
        array.forEach(function (entry) {
            result[entry[propertyName]] = entry;
        });
        return result;
    };
    /**
     * Compare two objects. This function won't compare functions and proto properties, it's a basic compare.
     * Also, this will only check if itemA's properties are in itemB with same value. This function will still
     * return true if itemB has more properties than itemA.
     *
     * @param {any} itemA First object.
     * @param {any} itemB Second object.
     * @param {number} [maxLevels=0] Number of levels to reach if 2 objects are compared.
     * @param {number} [level=0] Current deep level (when comparing objects).
     * @param {boolean} [undefinedIsNull=true] True if undefined is equal to null. Defaults to true.
     * @return {boolean} Whether both items are equal.
     */
    CoreUtilsProvider.prototype.basicLeftCompare = function (itemA, itemB, maxLevels, level, undefinedIsNull) {
        if (maxLevels === void 0) { maxLevels = 0; }
        if (level === void 0) { level = 0; }
        if (undefinedIsNull === void 0) { undefinedIsNull = true; }
        if (typeof itemA == 'function' || typeof itemB == 'function') {
            return true; // Don't compare functions.
        }
        else if (typeof itemA == 'object' && typeof itemB == 'object') {
            if (level >= maxLevels) {
                return true; // Max deep reached.
            }
            var equal = true;
            for (var name_1 in itemA) {
                var value = itemA[name_1];
                if (name_1 == '$$hashKey') {
                    // Ignore $$hashKey property since it's a "calculated" property.
                    return;
                }
                if (!this.basicLeftCompare(value, itemB[name_1], maxLevels, level + 1)) {
                    equal = false;
                }
            }
            return equal;
        }
        else {
            if (undefinedIsNull && ((typeof itemA == 'undefined' && itemB === null) || (itemA === null && typeof itemB == 'undefined'))) {
                return true;
            }
            // We'll treat "2" and 2 as the same value.
            var floatA = parseFloat(itemA), floatB = parseFloat(itemB);
            if (!isNaN(floatA) && !isNaN(floatB)) {
                return floatA == floatB;
            }
            return itemA === itemB;
        }
    };
    /**
     * Blocks leaving a view.
     * @deprecated, use ionViewCanLeave instead.
     */
    CoreUtilsProvider.prototype.blockLeaveView = function () {
        return;
    };
    /**
     * Check if a URL has a redirect.
     *
     * @param {string} url The URL to check.
     * @return {Promise<boolean>} Promise resolved with boolean_ whether there is a redirect.
     */
    CoreUtilsProvider.prototype.checkRedirect = function (url) {
        if (window.fetch) {
            var win = window, // Convert to <any> to be able to use AbortController (not supported by our TS version).
            initOptions = {
                redirect: 'follow'
            };
            var controller_1;
            // Some browsers implement fetch but no AbortController.
            if (win.AbortController) {
                controller_1 = new win.AbortController();
                initOptions.signal = controller_1.signal;
            }
            return this.timeoutPromise(window.fetch(url, initOptions), this.wsProvider.getRequestTimeout())
                .then(function (response) {
                return response.redirected;
            }).catch(function (error) {
                if (error.timeout && controller_1) {
                    // Timeout, abort the request.
                    controller_1.abort();
                }
                // There was a timeout, cannot determine if there's a redirect. Assume it's false.
                return false;
            });
        }
        else {
            // Cannot check if there is a redirect, assume it's false.
            return Promise.resolve(false);
        }
    };
    /**
     * Close the InAppBrowser window.
     *
     * @param {boolean} [closeAll] Desktop only. True to close all secondary windows, false to close only the "current" one.
     */
    CoreUtilsProvider.prototype.closeInAppBrowser = function (closeAll) {
        if (this.iabInstance) {
            this.iabInstance.close();
            if (closeAll && this.appProvider.isDesktop()) {
                __webpack_require__(127).ipcRenderer.send('closeSecondaryWindows');
            }
        }
    };
    /**
     * Clone a variable. It should be an object, array or primitive type.
     *
     * @param {any} source The variable to clone.
     * @param {number} [level=0] Depth we are right now inside a cloned object. It's used to prevent reaching max call stack size.
     * @return {any} Cloned variable.
     */
    CoreUtilsProvider.prototype.clone = function (source, level) {
        if (level === void 0) { level = 0; }
        if (level >= 20) {
            // Max 20 levels.
            this.logger.error('Max depth reached when cloning object.', source);
            return source;
        }
        if (Array.isArray(source)) {
            // Clone the array and all the entries.
            var newArray = [];
            for (var i = 0; i < source.length; i++) {
                newArray[i] = this.clone(source[i], level + 1);
            }
            return newArray;
        }
        else if (typeof source == 'object' && source !== null) {
            // Check if the object shouldn't be copied.
            if (source && source.toString && this.DONT_CLONE.indexOf(source.toString()) != -1) {
                // Object shouldn't be copied, return it as it is.
                return source;
            }
            // Clone the object and all the subproperties.
            var newObject = {};
            for (var name_2 in source) {
                newObject[name_2] = this.clone(source[name_2], level + 1);
            }
            return newObject;
        }
        else {
            // Primitive type or unknown, return it as it is.
            return source;
        }
    };
    /**
     * Copy properties from one object to another.
     *
     * @param {any} from Object to copy the properties from.
     * @param {any} to Object where to store the properties.
     * @param {boolean} [clone=true] Whether the properties should be cloned (so they are different instances).
     */
    CoreUtilsProvider.prototype.copyProperties = function (from, to, clone) {
        if (clone === void 0) { clone = true; }
        for (var name_3 in from) {
            if (clone) {
                to[name_3] = this.clone(from[name_3]);
            }
            else {
                to[name_3] = from[name_3];
            }
        }
    };
    /**
     * Copies a text to clipboard and shows a toast message.
     *
     * @param {string} text Text to be copied
     * @return {Promise<any>} Promise resolved when text is copied.
     */
    CoreUtilsProvider.prototype.copyToClipboard = function (text) {
        var _this = this;
        return this.clipboard.copy(text).then(function () {
            // Show toast using ionicLoading.
            return _this.domUtils.showToast('core.copiedtoclipboard', true);
        }).catch(function () {
            // Ignore errors.
        });
    };
    /**
     * Create a "fake" WS error for local errors.
     *
     * @param {string} message The message to include in the error.
     * @param {boolean} [needsTranslate] If the message needs to be translated.
     * @return {CoreWSError} Fake WS error.
     */
    CoreUtilsProvider.prototype.createFakeWSError = function (message, needsTranslate) {
        return this.wsProvider.createFakeWSError(message, needsTranslate);
    };
    /**
     * Empties an array without losing its reference.
     *
     * @param {any[]} array Array to empty.
     */
    CoreUtilsProvider.prototype.emptyArray = function (array) {
        array.length = 0; // Empty array without losing its reference.
    };
    /**
     * Removes all properties from an object without losing its reference.
     *
     * @param {object} object Object to remove the properties.
     */
    CoreUtilsProvider.prototype.emptyObject = function (object) {
        for (var key in object) {
            if (object.hasOwnProperty(key)) {
                delete object[key];
            }
        }
    };
    /**
     * Execute promises one depending on the previous.
     *
     * @param {any[]} orderedPromisesData Data to be executed including the following values:
     *                                 - func: Function to be executed.
     *                                 - context: Context to pass to the function. This allows using "this" inside the function.
     *                                 - params: Array of data to be sent to the function.
     *                                 - blocking: Boolean. If promise should block the following.
     * @return {Promise<any>} Promise resolved when all promises are resolved.
     */
    CoreUtilsProvider.prototype.executeOrderedPromises = function (orderedPromisesData) {
        var _this = this;
        var promises = [];
        var dependency = Promise.resolve();
        var _loop_1 = function (i) {
            var data = orderedPromisesData[i];
            var promise = void 0;
            // Add the process to the dependency stack.
            promise = dependency.finally(function () {
                var prom;
                try {
                    prom = data.func.apply(data.context, data.params || []);
                }
                catch (e) {
                    _this.logger.error(e.message);
                    return;
                }
                return prom;
            });
            promises.push(promise);
            // If the new process is blocking, we set it as the dependency.
            if (data.blocking) {
                dependency = promise;
            }
        };
        // Execute all the processes in order.
        for (var i in orderedPromisesData) {
            _loop_1(i);
        }
        // Return when all promises are done.
        return this.allPromises(promises);
    };
    /**
     * Flatten an object, moving subobjects' properties to the first level.
     * It supports 2 notations: dot notation and square brackets.
     * E.g.: {a: {b: 1, c: 2}, d: 3} -> {'a.b': 1, 'a.c': 2, d: 3}
     *
     * @param {object} obj Object to flatten.
     * @param {boolean} [useDotNotation] Whether to use dot notation '.' or square brackets '['.
     * @return {object} Flattened object.
     */
    CoreUtilsProvider.prototype.flattenObject = function (obj, useDotNotation) {
        var toReturn = {};
        for (var name_4 in obj) {
            if (!obj.hasOwnProperty(name_4)) {
                continue;
            }
            var value = obj[name_4];
            if (typeof value == 'object' && !Array.isArray(value)) {
                var flatObject = this.flattenObject(value);
                for (var subName in flatObject) {
                    if (!flatObject.hasOwnProperty(subName)) {
                        continue;
                    }
                    var newName = useDotNotation ? name_4 + '.' + subName : name_4 + '[' + subName + ']';
                    toReturn[newName] = flatObject[subName];
                }
            }
            else {
                toReturn[name_4] = value;
            }
        }
        return toReturn;
    };
    /**
     * Given an array of strings, return only the ones that match a regular expression.
     *
     * @param {string[]} array Array to filter.
     * @param {RegExp} regex RegExp to apply to each string.
     * @return {string[]} Filtered array.
     */
    CoreUtilsProvider.prototype.filterByRegexp = function (array, regex) {
        if (!array || !array.length) {
            return [];
        }
        return array.filter(function (entry) {
            var matches = entry.match(regex);
            return matches && matches.length;
        });
    };
    /**
     * Filter the list of site IDs based on a isEnabled function.
     *
     * @param {string[]} siteIds Site IDs to filter.
     * @param {Function} isEnabledFn Function to call for each site. Must return true or a promise resolved with true if enabled.
     *                    It receives a siteId param and all the params sent to this function after 'checkAll'.
     * @param {boolean} [checkAll] True if it should check all the sites, false if it should check only 1 and treat them all
     *                   depending on this result.
     * @param {any} ...args All the params sent after checkAll will be passed to isEnabledFn.
     * @return {Promise<string[]>} Promise resolved with the list of enabled sites.
     */
    CoreUtilsProvider.prototype.filterEnabledSites = function (siteIds, isEnabledFn, checkAll) {
        var args = [];
        for (var _i = 3; _i < arguments.length; _i++) {
            args[_i - 3] = arguments[_i];
        }
        var promises = [], enabledSites = [];
        var _loop_2 = function (i) {
            var siteId = siteIds[i];
            if (checkAll || !promises.length) {
                promises.push(Promise.resolve(isEnabledFn.apply(isEnabledFn, [siteId].concat(args))).then(function (enabled) {
                    if (enabled) {
                        enabledSites.push(siteId);
                    }
                }));
            }
        };
        for (var i in siteIds) {
            _loop_2(i);
        }
        return this.allPromises(promises).catch(function () {
            // Ignore errors.
        }).then(function () {
            if (!checkAll) {
                // Checking 1 was enough, so it will either return all the sites or none.
                return enabledSites.length ? siteIds : [];
            }
            else {
                return enabledSites;
            }
        });
    };
    /**
     * Given a float, prints it nicely. Localized floats must not be used in calculations!
     * Based on Moodle's format_float.
     *
     * @param {any} float The float to print.
     * @return {string} Locale float.
     */
    CoreUtilsProvider.prototype.formatFloat = function (float) {
        if (typeof float == 'undefined' || float === null || typeof float == 'boolean') {
            return '';
        }
        var localeSeparator = this.translate.instant('core.decsep');
        // Convert float to string.
        float += '';
        return float.replace('.', localeSeparator);
    };
    /**
     * Returns a tree formatted from a plain list.
     * List has to be sorted by depth to allow this function to work correctly. Errors can be thrown if a child node is
     * processed before a parent node.
     *
     * @param {any[]} list List to format.
     * @param {string} [parentFieldName=parent] Name of the parent field to match with children.
     * @param {string} [idFieldName=id] Name of the children field to match with parent.
     * @param {number} [rootParentId=0] The id of the root.
     * @param {number} [maxDepth=5] Max Depth to convert to tree. Children found will be in the last level of depth.
     * @return {any[]} Array with the formatted tree, children will be on each node under children field.
     */
    CoreUtilsProvider.prototype.formatTree = function (list, parentFieldName, idFieldName, rootParentId, maxDepth) {
        if (parentFieldName === void 0) { parentFieldName = 'parent'; }
        if (idFieldName === void 0) { idFieldName = 'id'; }
        if (rootParentId === void 0) { rootParentId = 0; }
        if (maxDepth === void 0) { maxDepth = 5; }
        var map = {}, mapDepth = {}, tree = [];
        var parent, id;
        list.forEach(function (node, index) {
            id = node[idFieldName];
            parent = node[parentFieldName];
            node.children = [];
            // Use map to look-up the parents.
            map[id] = index;
            if (parent != rootParentId) {
                var parentNode = list[map[parent]];
                if (parentNode) {
                    if (mapDepth[parent] == maxDepth) {
                        // Reached max level of depth. Proceed with flat order. Find parent object of the current node.
                        var parentOfParent = parentNode[parentFieldName];
                        if (parentOfParent) {
                            // This element will be the child of the node that is two levels up the hierarchy
                            // (i.e. the child of node.parent.parent).
                            list[map[parentOfParent]].children.push(node);
                            // Assign depth level to the same depth as the parent (i.e. max depth level).
                            mapDepth[id] = mapDepth[parent];
                            // Change the parent to be the one that is two levels up the hierarchy.
                            node.parent = parentOfParent;
                        }
                    }
                    else {
                        parentNode.children.push(node);
                        // Increase the depth level.
                        mapDepth[id] = mapDepth[parent] + 1;
                    }
                }
            }
            else {
                tree.push(node);
                // Root elements are the first elements in the tree structure, therefore have the depth level 1.
                mapDepth[id] = 1;
            }
        });
        return tree;
    };
    /**
     * Get country name based on country code.
     *
     * @param {string} code Country code (AF, ES, US, ...).
     * @return {string} Country name. If the country is not found, return the country code.
     */
    CoreUtilsProvider.prototype.getCountryName = function (code) {
        var countryKey = 'assets.countries.' + code, countryName = this.translate.instant(countryKey);
        return countryName !== countryKey ? countryName : code;
    };
    /**
     * Get list of countries with their code and translated name.
     *
     * @return {Promise<any>} Promise resolved with the list of countries.
     */
    CoreUtilsProvider.prototype.getCountryList = function () {
        var _this = this;
        // Get the keys of the countries.
        return this.getCountryKeysList().then(function (keys) {
            // Now get the code and the translated name.
            var countries = {};
            keys.forEach(function (key) {
                if (key.indexOf('assets.countries.') === 0) {
                    var code = key.replace('assets.countries.', '');
                    countries[code] = _this.translate.instant(key);
                }
            });
            return countries;
        });
    };
    /**
     * Get the list of language keys of the countries.
     *
     * @return {Promise<string[]>} Promise resolved with the countries list. Rejected if not translated.
     */
    CoreUtilsProvider.prototype.getCountryKeysList = function () {
        var _this = this;
        // It's possible that the current language isn't translated, so try with default language first.
        var defaultLang = this.langProvider.getDefaultLanguage();
        return this.getCountryKeysListForLanguage(defaultLang).catch(function () {
            // Not translated, try to use the fallback language.
            var fallbackLang = _this.langProvider.getFallbackLanguage();
            if (fallbackLang === defaultLang) {
                // Same language, just reject.
                return Promise.reject('Countries not found.');
            }
            return _this.getCountryKeysListForLanguage(fallbackLang);
        });
    };
    /**
     * Get the list of language keys of the countries, based on the translation table for a certain language.
     *
     * @param {string} lang Language to check.
     * @return {Promise<string[]>} Promise resolved with the countries list. Rejected if not translated.
     */
    CoreUtilsProvider.prototype.getCountryKeysListForLanguage = function (lang) {
        // Get the translation table for the language.
        return this.langProvider.getTranslationTable(lang).then(function (table) {
            // Gather all the keys for countries,
            var keys = [];
            for (var name_5 in table) {
                if (name_5.indexOf('assets.countries.') === 0) {
                    keys.push(name_5);
                }
            }
            if (keys.length === 0) {
                // Not translated, reject.
                return Promise.reject('Countries not found.');
            }
            return keys;
        });
    };
    /**
     * Get the mimetype of a file given its URL. It'll try to guess it using the URL, if that fails then it'll
     * perform a HEAD request to get it. It's done in this order because pluginfile.php can return wrong mimetypes.
     * This function is in here instead of MimetypeUtils to prevent circular dependencies.
     *
     * @param {string} url The URL of the file.
     * @return {Promise<string>} Promise resolved with the mimetype.
     */
    CoreUtilsProvider.prototype.getMimeTypeFromUrl = function (url) {
        // First check if it can be guessed from the URL.
        var extension = this.mimetypeUtils.guessExtensionFromUrl(url), mimetype = this.mimetypeUtils.getMimeType(extension);
        if (mimetype) {
            return Promise.resolve(mimetype);
        }
        // Can't be guessed, get the remote mimetype.
        return this.wsProvider.getRemoteFileMimeType(url).then(function (mimetype) {
            return mimetype || '';
        });
    };
    /**
     * Get a unique ID for a certain name.
     *
     * @param {string} name The name to get the ID for.
     * @return {number} Unique ID.
     */
    CoreUtilsProvider.prototype.getUniqueId = function (name) {
        if (!this.uniqueIds[name]) {
            this.uniqueIds[name] = 0;
        }
        return ++this.uniqueIds[name];
    };
    /**
     * Given a list of files, check if there are repeated names.
     *
     * @param {any[]} files List of files.
     * @return {string|boolean} String with error message if repeated, false if no repeated.
     */
    CoreUtilsProvider.prototype.hasRepeatedFilenames = function (files) {
        if (!files || !files.length) {
            return false;
        }
        var names = [];
        // Check if there are 2 files with the same name.
        for (var i = 0; i < files.length; i++) {
            var name_6 = files[i].filename || files[i].name;
            if (names.indexOf(name_6) > -1) {
                return this.translate.instant('core.filenameexist', { $a: name_6 });
            }
            else {
                names.push(name_6);
            }
        }
        return false;
    };
    /**
     * Gets the index of the first string that matches a regular expression.
     *
     * @param {string[]} array Array to search.
     * @param {RegExp} regex RegExp to apply to each string.
     * @return {number} Index of the first string that matches the RegExp. -1 if not found.
     */
    CoreUtilsProvider.prototype.indexOfRegexp = function (array, regex) {
        if (!array || !array.length) {
            return -1;
        }
        for (var i = 0; i < array.length; i++) {
            var entry = array[i], matches = entry.match(regex);
            if (matches && matches.length) {
                return i;
            }
        }
        return -1;
    };
    /**
     * Return true if the param is false (bool), 0 (number) or "0" (string).
     *
     * @param {any} value Value to check.
     * @return {boolean} Whether the value is false, 0 or "0".
     */
    CoreUtilsProvider.prototype.isFalseOrZero = function (value) {
        return typeof value != 'undefined' && (value === false || value === 'false' || parseInt(value, 10) === 0);
    };
    /**
     * Return true if the param is true (bool), 1 (number) or "1" (string).
     *
     * @param {any} value Value to check.
     * @return {boolean} Whether the value is true, 1 or "1".
     */
    CoreUtilsProvider.prototype.isTrueOrOne = function (value) {
        return typeof value != 'undefined' && (value === true || value === 'true' || parseInt(value, 10) === 1);
    };
    /**
     * Given an error returned by a WS call, check if the error is generated by the app or it has been returned by the WebSwervice.
     *
     * @param {any} error Error to check.
     * @return {boolean} Whether the error was returned by the WebService.
     */
    CoreUtilsProvider.prototype.isWebServiceError = function (error) {
        return error && (typeof error.warningcode != 'undefined' || (typeof error.errorcode != 'undefined' &&
            error.errorcode != 'invalidtoken' && error.errorcode != 'userdeleted' && error.errorcode != 'upgraderunning' &&
            error.errorcode != 'forcepasswordchangenotice' && error.errorcode != 'usernotfullysetup' &&
            error.errorcode != 'sitepolicynotagreed' && error.errorcode != 'sitemaintenance' &&
            (error.errorcode != 'accessexception' || error.message.indexOf('Invalid token - token expired') == -1)));
    };
    /**
     * Given a list (e.g. a,b,c,d,e) this function returns an array of 1->a, 2->b, 3->c etc.
     * Taken from make_menu_from_list on moodlelib.php (not the same but similar).
     *
     * @param {string} list The string to explode into array bits
     * @param {string} [defaultLabel] Element that will become default option, if not defined, it won't be added.
     * @param {string} [separator] The separator used within the list string. Default ','.
     * @param {any}  [defaultValue] Element that will become default option value. Default 0.
     * @return {any[]} The now assembled array
     */
    CoreUtilsProvider.prototype.makeMenuFromList = function (list, defaultLabel, separator, defaultValue) {
        if (separator === void 0) { separator = ','; }
        // Split and format the list.
        var split = list.split(separator).map(function (label, index) {
            return {
                label: label.trim(),
                value: index + 1
            };
        });
        if (defaultLabel) {
            split.unshift({
                label: defaultLabel,
                value: defaultValue || 0
            });
        }
        return split;
    };
    /**
     * Merge two arrays, removing duplicate values.
     *
     * @param {any[]} array1 The first array.
     * @param {any[]} array2 The second array.
     * @param [key] Key of the property that must be unique. If not specified, the whole entry.
     * @return {any[]} Merged array.
     */
    CoreUtilsProvider.prototype.mergeArraysWithoutDuplicates = function (array1, array2, key) {
        return this.uniqueArray(array1.concat(array2), key);
    };
    /**
     * Open a file using platform specific method.
     *
     * @param {string} path The local path of the file to be open.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreUtilsProvider.prototype.openFile = function (path) {
        var _this = this;
        var extension = this.mimetypeUtils.getFileExtension(path), mimetype = this.mimetypeUtils.getMimeType(extension);
        // Path needs to be decoded, the file won't be opened if the path has %20 instead of spaces and so.
        try {
            path = decodeURIComponent(path);
        }
        catch (ex) {
            // Error, use the original path.
        }
        return this.fileOpener.open(path, mimetype).catch(function (error) {
            _this.logger.error('Error opening file ' + path + ' with mimetype ' + mimetype);
            _this.logger.error('Error: ', JSON.stringify(error));
            if (!extension || extension.indexOf('/') > -1 || extension.indexOf('\\') > -1) {
                // Extension not found.
                error = _this.translate.instant('core.erroropenfilenoextension');
            }
            else {
                error = _this.translate.instant('core.erroropenfilenoapp');
            }
            return Promise.reject(error);
        });
    };
    /**
     * Open a URL using InAppBrowser.
     * Do not use for files, refer to {@link openFile}.
     *
     * @param {string} url The URL to open.
     * @param {any} [options] Override default options passed to InAppBrowser.
     * @return {InAppBrowserObject} The opened window.
     */
    CoreUtilsProvider.prototype.openInApp = function (url, options) {
        var _this = this;
        if (!url) {
            return;
        }
        options = options || {};
        if (!options.enableViewPortScale) {
            options.enableViewPortScale = 'yes'; // Enable zoom on iOS.
        }
        if (!options.location && this.platform.is('ios') && url.indexOf('file://') === 0) {
            // The URL uses file protocol, don't show it on iOS.
            // In Android we keep it because otherwise we lose the whole toolbar.
            options.location = 'no';
        }
        this.iabInstance = this.iab.create(url, '_blank', options);
        if (this.appProvider.isDesktop() || this.appProvider.isMobile()) {
            var loadStopSubscription_1;
            var loadStartUrls_1 = [];
            // Trigger global events when a url is loaded or the window is closed. This is to make it work like in Ionic 1.
            var loadStartSubscription_1 = this.iabInstance.on('loadstart').subscribe(function (event) {
                // Execute the callback in the Angular zone, so change detection doesn't stop working.
                _this.zone.run(function () {
                    // Store the last loaded URLs (max 10).
                    loadStartUrls_1.push(event.url);
                    if (loadStartUrls_1.length > 10) {
                        loadStartUrls_1.shift();
                    }
                    _this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_10__events__["a" /* CoreEventsProvider */].IAB_LOAD_START, event);
                });
            });
            if (this.platform.is('android')) {
                // Load stop is needed with InAppBrowser v3. Custom URL schemes no longer trigger load start, simulate it.
                loadStopSubscription_1 = this.iabInstance.on('loadstop').subscribe(function (event) {
                    // Execute the callback in the Angular zone, so change detection doesn't stop working.
                    _this.zone.run(function () {
                        if (loadStartUrls_1.indexOf(event.url) == -1) {
                            // The URL was stopped but not started, probably a custom URL scheme.
                            _this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_10__events__["a" /* CoreEventsProvider */].IAB_LOAD_START, event);
                        }
                    });
                });
            }
            var exitSubscription_1 = this.iabInstance.on('exit').subscribe(function (event) {
                // Execute the callback in the Angular zone, so change detection doesn't stop working.
                _this.zone.run(function () {
                    loadStartSubscription_1.unsubscribe();
                    loadStopSubscription_1 && loadStopSubscription_1.unsubscribe();
                    exitSubscription_1.unsubscribe();
                    _this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_10__events__["a" /* CoreEventsProvider */].IAB_EXIT, event);
                });
            });
        }
        return this.iabInstance;
    };
    /**
     * Open a URL using a browser.
     * Do not use for files, refer to {@link openFile}.
     *
     * @param {string} url The URL to open.
     */
    CoreUtilsProvider.prototype.openInBrowser = function (url) {
        if (this.appProvider.isDesktop()) {
            // It's a desktop app, use Electron shell library to open the browser.
            var shell = __webpack_require__(127).shell;
            if (!shell.openExternal(url)) {
                // Open browser failed, open a new window in the app.
                window.open(url, '_system');
            }
        }
        else {
            window.open(url, '_system');
        }
    };
    /**
     * Open an online file using platform specific method.
     * Specially useful for audio and video since they can be streamed.
     *
     * @param {string} url The URL of the file.
     * @return {Promise<void>} Promise resolved when opened.
     */
    CoreUtilsProvider.prototype.openOnlineFile = function (url) {
        var _this = this;
        if (this.platform.is('android')) {
            // In Android we need the mimetype to open it.
            return this.getMimeTypeFromUrl(url).catch(function () {
                // Error getting mimetype, return undefined.
            }).then(function (mimetype) {
                if (!mimetype) {
                    // Couldn't retrieve mimetype. Return error.
                    return Promise.reject(_this.translate.instant('core.erroropenfilenoextension'));
                }
                var options = {
                    action: _this.webIntent.ACTION_VIEW,
                    url: url,
                    type: mimetype
                };
                return _this.webIntent.startActivity(options).catch(function (error) {
                    _this.logger.error('Error opening online file ' + url + ' with mimetype ' + mimetype);
                    _this.logger.error('Error: ', JSON.stringify(error));
                    return Promise.reject(_this.translate.instant('core.erroropenfilenoapp'));
                });
            });
        }
        // In the rest of platforms we need to open them in InAppBrowser.
        this.openInApp(url);
        return Promise.resolve();
    };
    /**
     * Converts an object into an array, losing the keys.
     *
     * @param {object} obj Object to convert.
     * @return {any[]} Array with the values of the object but losing the keys.
     */
    CoreUtilsProvider.prototype.objectToArray = function (obj) {
        return Object.keys(obj).map(function (key) {
            return obj[key];
        });
    };
    /**
     * Converts an object into an array of objects, where each entry is an object containing
     * the key and value of the original object.
     * For example, it can convert {size: 2} into [{name: 'size', value: 2}].
     *
     * @param {object} obj Object to convert.
     * @param {string} keyName Name of the properties where to store the keys.
     * @param {string} valueName Name of the properties where to store the values.
     * @param {boolean} [sortByKey] True to sort keys alphabetically, false otherwise. Has priority over sortByValue.
     * @param {boolean} [sortByValue] True to sort values alphabetically, false otherwise.
     * @return {any[]} Array of objects with the name & value of each property.
     */
    CoreUtilsProvider.prototype.objectToArrayOfObjects = function (obj, keyName, valueName, sortByKey, sortByValue) {
        // Get the entries from an object or primitive value.
        var getEntries = function (elKey, value) {
            if (typeof value == 'undefined' || value == null) {
                // Filter undefined and null values.
                return;
            }
            else if (typeof value == 'object') {
                // It's an object, return at least an entry for each property.
                var keys = Object.keys(value);
                var entries_1 = [];
                keys.forEach(function (key) {
                    var newElKey = elKey ? elKey + '[' + key + ']' : key, subEntries = getEntries(newElKey, value[key]);
                    if (subEntries) {
                        entries_1 = entries_1.concat(subEntries);
                    }
                });
                return entries_1;
            }
            else {
                // Not an object, return a single entry.
                var entry = {};
                entry[keyName] = elKey;
                entry[valueName] = value;
                return entry;
            }
        };
        if (!obj) {
            return [];
        }
        // "obj" will always be an object, so "entries" will always be an array.
        var entries = getEntries('', obj);
        if (sortByKey || sortByValue) {
            return entries.sort(function (a, b) {
                if (sortByKey) {
                    return a[keyName] >= b[keyName] ? 1 : -1;
                }
                else {
                    return a[valueName] >= b[valueName] ? 1 : -1;
                }
            });
        }
        return entries;
    };
    /**
     * Converts an array of objects into an object with key and value. The opposite of objectToArrayOfObjects.
     * For example, it can convert [{name: 'size', value: 2}] into {size: 2}.
     *
     * @param {object[]} objects List of objects to convert.
     * @param {string} keyName Name of the properties where the keys are stored.
     * @param {string} valueName Name of the properties where the values are stored.
     * @param {string} [keyPrefix] Key prefix if neededs to delete it.
     * @return {object} Object.
     */
    CoreUtilsProvider.prototype.objectToKeyValueMap = function (objects, keyName, valueName, keyPrefix) {
        if (!objects) {
            return;
        }
        var prefixSubstr = keyPrefix ? keyPrefix.length : 0, mapped = {};
        objects.forEach(function (item) {
            var key = prefixSubstr > 0 ? item[keyName].substr(prefixSubstr) : item[keyName];
            mapped[key] = item[valueName];
        });
        return mapped;
    };
    /**
     * Convert an object to a format of GET param. E.g.: {a: 1, b: 2} -> a=1&b=2
     *
     * @param {any} object Object to convert.
     * @param {boolean} [removeEmpty=true] Whether to remove params whose value is null/undefined.
     * @return {string} GET params.
     */
    CoreUtilsProvider.prototype.objectToGetParams = function (object, removeEmpty) {
        if (removeEmpty === void 0) { removeEmpty = true; }
        // First of all, flatten the object so all properties are in the first level.
        var flattened = this.flattenObject(object);
        var result = '', joinChar = '';
        for (var name_7 in flattened) {
            var value = flattened[name_7];
            if (removeEmpty && (value === null || typeof value == 'undefined')) {
                continue;
            }
            if (typeof value == 'boolean') {
                value = value ? 1 : 0;
            }
            result += joinChar + name_7 + '=' + value;
            joinChar = '&';
        }
        return result;
    };
    /**
     * Add a prefix to all the keys in an object.
     *
     * @param {any} data Object.
     * @param {string} prefix Prefix to add.
     * @return {any} Prefixed object.
     */
    CoreUtilsProvider.prototype.prefixKeys = function (data, prefix) {
        var newObj = {}, keys = Object.keys(data);
        keys.forEach(function (key) {
            newObj[prefix + key] = data[key];
        });
        return newObj;
    };
    /**
     * Similar to AngularJS $q.defer().
     *
     * @return {PromiseDefer} The deferred promise.
     */
    CoreUtilsProvider.prototype.promiseDefer = function () {
        var deferred = {};
        deferred.promise = new Promise(function (resolve, reject) {
            deferred.resolve = resolve;
            deferred.reject = reject;
        });
        return deferred;
    };
    /**
     * Given a promise, returns true if it's rejected or false if it's resolved.
     *
     * @param {Promise<any>} promise Promise to check
     * @return {Promise<boolean>} Promise resolved with boolean: true if the promise is rejected or false if it's resolved.
     */
    CoreUtilsProvider.prototype.promiseFails = function (promise) {
        return promise.then(function () {
            return false;
        }).catch(function () {
            return true;
        });
    };
    /**
     * Given a promise, returns true if it's resolved or false if it's rejected.
     *
     * @param {Promise<any>} promise Promise to check
     * @return {Promise<boolean>} Promise resolved with boolean: true if the promise it's resolved or false if it's rejected.
     */
    CoreUtilsProvider.prototype.promiseWorks = function (promise) {
        return promise.then(function () {
            return true;
        }).catch(function () {
            return false;
        });
    };
    /**
     * Tests to see whether two arrays or objects have the same value at a particular key.
     * Missing values are replaced by '', and the values are compared with ===.
     * Booleans and numbers are cast to string before comparing.
     *
     * @param {any} obj1 The first object or array.
     * @param {any} obj2 The second object or array.
     * @param {string} key Key to check.
     * @return {boolean} Whether the two objects/arrays have the same value (or lack of one) for a given key.
     */
    CoreUtilsProvider.prototype.sameAtKeyMissingIsBlank = function (obj1, obj2, key) {
        var value1 = typeof obj1[key] != 'undefined' ? obj1[key] : '', value2 = typeof obj2[key] != 'undefined' ? obj2[key] : '';
        if (typeof value1 == 'number' || typeof value1 == 'boolean') {
            value1 = '' + value1;
        }
        if (typeof value2 == 'number' || typeof value2 == 'boolean') {
            value2 = '' + value2;
        }
        return value1 === value2;
    };
    /**
     * Stringify an object, sorting the properties. It doesn't sort arrays, only object properties. E.g.:
     * {b: 2, a: 1} -> '{"a":1,"b":2}'
     *
     * @param {object} obj Object to stringify.
     * @return {string} Stringified object.
     */
    CoreUtilsProvider.prototype.sortAndStringify = function (obj) {
        return JSON.stringify(this.sortProperties(obj));
    };
    /**
     * Given an object, sort its properties and the properties of all the nested objects.
     *
     * @param {object} obj The object to sort. If it isn't an object, the original value will be returned.
     * @return {object} Sorted object.
     */
    CoreUtilsProvider.prototype.sortProperties = function (obj) {
        var _this = this;
        if (typeof obj == 'object' && !Array.isArray(obj)) {
            // It's an object, sort it.
            return Object.keys(obj).sort().reduce(function (accumulator, key) {
                // Always call sort with the value. If it isn't an object, the original value will be returned.
                accumulator[key] = _this.sortProperties(obj[key]);
                return accumulator;
            }, {});
        }
        else {
            return obj;
        }
    };
    /**
     * Given an object, sort its values. Values need to be primitive values, it cannot have subobjects.
     *
     * @param {object} obj The object to sort. If it isn't an object, the original value will be returned.
     * @return {object} Sorted object.
     */
    CoreUtilsProvider.prototype.sortValues = function (obj) {
        if (typeof obj == 'object' && !Array.isArray(obj)) {
            // It's an object, sort it. Convert it to an array to be able to sort it and then convert it back to object.
            var array = this.objectToArrayOfObjects(obj, 'name', 'value', false, true);
            return this.objectToKeyValueMap(array, 'name', 'value');
        }
        else {
            return obj;
        }
    };
    /**
     * Sum the filesizes from a list of files checking if the size will be partial or totally calculated.
     *
     * @param {any[]} files List of files to sum its filesize.
     * @return {{size: number, total: boolean}} File size and a boolean to indicate if it is the total size or only partial.
     */
    CoreUtilsProvider.prototype.sumFileSizes = function (files) {
        var result = {
            size: 0,
            total: true
        };
        files.forEach(function (file) {
            if (typeof file.filesize == 'undefined') {
                // We don't have the file size, cannot calculate its total size.
                result.total = false;
            }
            else {
                result.size += file.filesize;
            }
        });
        return result;
    };
    /**
     * Set a timeout to a Promise. If the time passes before the Promise is resolved or rejected, it will be automatically
     * rejected.
     *
     * @param {Promise<T>} promise The promise to timeout.
     * @param {number} time Number of milliseconds of the timeout.
     * @return {Promise<T>} Promise with the timeout.
     */
    CoreUtilsProvider.prototype.timeoutPromise = function (promise, time) {
        return new Promise(function (resolve, reject) {
            var timeout = setTimeout(function () {
                reject({ timeout: true });
            }, time);
            promise.then(resolve).catch(reject).finally(function () {
                clearTimeout(timeout);
            });
        });
    };
    /**
     * Converts locale specific floating point/comma number back to standard PHP float value.
     * Do NOT try to do any math operations before this conversion on any user submitted floats!
     * Based on Moodle's unformat_float function.
     *
     * @param {any} localeFloat Locale aware float representation.
     * @param {boolean} [strict] If true, then check the input and return false if it is not a valid number.
     * @return {any} False if bad format, empty string if empty value or the parsed float if not.
     */
    CoreUtilsProvider.prototype.unformatFloat = function (localeFloat, strict) {
        // Bad format on input type number.
        if (typeof localeFloat == 'undefined') {
            return false;
        }
        // Empty (but not zero).
        if (localeFloat == null) {
            return '';
        }
        // Convert float to string.
        localeFloat += '';
        localeFloat = localeFloat.trim();
        if (localeFloat == '') {
            return '';
        }
        localeFloat = localeFloat.replace(' ', ''); // No spaces - those might be used as thousand separators.
        localeFloat = localeFloat.replace(this.translate.instant('core.decsep'), '.');
        var parsedFloat = parseFloat(localeFloat);
        // Bad format.
        if (strict && (!isFinite(localeFloat) || isNaN(parsedFloat))) {
            return false;
        }
        return parsedFloat;
    };
    /**
     * Return an array without duplicate values.
     *
     * @param {any[]} array The array to treat.
     * @param [key] Key of the property that must be unique. If not specified, the whole entry.
     * @return {any[]} Array without duplicate values.
     */
    CoreUtilsProvider.prototype.uniqueArray = function (array, key) {
        var filtered = [], unique = {}; // Use an object to make it faster to check if it's duplicate.
        array.forEach(function (entry) {
            var value = key ? entry[key] : entry;
            if (!unique[value]) {
                unique[value] = true;
                filtered.push(entry);
            }
        });
        return filtered;
    };
    CoreUtilsProvider = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_2__ionic_native_in_app_browser__["a" /* InAppBrowser */], __WEBPACK_IMPORTED_MODULE_6__app__["a" /* CoreAppProvider */], __WEBPACK_IMPORTED_MODULE_3__ionic_native_clipboard__["a" /* Clipboard */],
            __WEBPACK_IMPORTED_MODULE_7__dom__["a" /* CoreDomUtilsProvider */], __WEBPACK_IMPORTED_MODULE_11__logger__["a" /* CoreLoggerProvider */], __WEBPACK_IMPORTED_MODULE_12__ngx_translate_core__["c" /* TranslateService */],
            __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["v" /* Platform */], __WEBPACK_IMPORTED_MODULE_13__lang__["a" /* CoreLangProvider */], __WEBPACK_IMPORTED_MODULE_10__events__["a" /* CoreEventsProvider */],
            __WEBPACK_IMPORTED_MODULE_4__ionic_native_file_opener__["a" /* FileOpener */], __WEBPACK_IMPORTED_MODULE_8__mimetype__["a" /* CoreMimetypeUtilsProvider */], __WEBPACK_IMPORTED_MODULE_5__ionic_native_web_intent__["a" /* WebIntent */],
            __WEBPACK_IMPORTED_MODULE_14__ws__["a" /* CoreWSProvider */], __WEBPACK_IMPORTED_MODULE_0__angular_core__["M" /* NgZone */], __WEBPACK_IMPORTED_MODULE_9__text__["a" /* CoreTextUtilsProvider */]])
    ], CoreUtilsProvider);
    return CoreUtilsProvider;
}());

//# sourceMappingURL=utils.js.map

/***/ }),
/* 3 */,
/* 4 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreDomUtilsProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__angular_platform_browser__ = __webpack_require__(79);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__ngx_translate_core__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__text__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__app__ = __webpack_require__(9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__config__ = __webpack_require__(171);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__configconstants__ = __webpack_require__(119);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__url__ = __webpack_require__(23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__providers_file__ = __webpack_require__(53);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__core_constants__ = __webpack_require__(40);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__components_bs_tooltip_bs_tooltip__ = __webpack_require__(563);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_ts_md5_dist_md5__ = __webpack_require__(203);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_ts_md5_dist_md5___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_12_ts_md5_dist_md5__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13_rxjs__ = __webpack_require__(148);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13_rxjs___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_13_rxjs__);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};














/*
 * "Utils" service with helper functions for UI, DOM elements and HTML code.
 */
var CoreDomUtilsProvider = /** @class */ (function () {
    function CoreDomUtilsProvider(translate, loadingCtrl, toastCtrl, alertCtrl, textUtils, appProvider, platform, configProvider, urlUtils, modalCtrl, sanitizer, popoverCtrl, fileProvider) {
        var _this = this;
        this.translate = translate;
        this.loadingCtrl = loadingCtrl;
        this.toastCtrl = toastCtrl;
        this.alertCtrl = alertCtrl;
        this.textUtils = textUtils;
        this.appProvider = appProvider;
        this.platform = platform;
        this.configProvider = configProvider;
        this.urlUtils = urlUtils;
        this.modalCtrl = modalCtrl;
        this.sanitizer = sanitizer;
        this.popoverCtrl = popoverCtrl;
        this.fileProvider = fileProvider;
        // List of input types that support keyboard.
        this.INPUT_SUPPORT_KEYBOARD = ['date', 'datetime', 'datetime-local', 'email', 'month', 'number', 'password',
            'search', 'tel', 'text', 'time', 'url', 'week'];
        this.INSTANCE_ID_ATTR_NAME = 'core-instance-id';
        this.template = document.createElement('template'); // A template element to convert HTML to element.
        this.instances = {}; // Store component/directive instances by id.
        this.lastInstanceId = 0;
        this.debugDisplay = false; // Whether to display debug messages. Store it in a variable to make it synchronous.
        this.displayedAlerts = {}; // To prevent duplicated alerts.
        // Check if debug messages should be displayed.
        configProvider.get(__WEBPACK_IMPORTED_MODULE_10__core_constants__["a" /* CoreConstants */].SETTINGS_DEBUG_DISPLAY, false).then(function (debugDisplay) {
            _this.debugDisplay = !!debugDisplay;
        });
        // Set the font size based on user preference.
        configProvider.get(__WEBPACK_IMPORTED_MODULE_10__core_constants__["a" /* CoreConstants */].SETTINGS_FONT_SIZE, __WEBPACK_IMPORTED_MODULE_7__configconstants__["a" /* CoreConfigConstants */].font_sizes[0]).then(function (fontSize) {
            document.documentElement.style.fontSize = fontSize + '%';
        });
    }
    /**
     * Equivalent to element.closest(). If the browser doesn't support element.closest, it will
     * traverse the parents to achieve the same functionality.
     * Returns the closest ancestor of the current element (or the current element itself) which matches the selector.
     *
     * @param {HTMLElement} element DOM Element.
     * @param {string} selector Selector to search.
     * @return {Element} Closest ancestor.
     */
    CoreDomUtilsProvider.prototype.closest = function (element, selector) {
        var _this = this;
        // Try to use closest if the browser supports it.
        if (typeof element.closest == 'function') {
            return element.closest(selector);
        }
        if (!this.matchesFn) {
            // Find the matches function supported by the browser.
            ['matches', 'webkitMatchesSelector', 'mozMatchesSelector', 'msMatchesSelector', 'oMatchesSelector'].some(function (fn) {
                if (typeof document.body[fn] == 'function') {
                    _this.matchesFn = fn;
                    return true;
                }
                return false;
            });
            if (!this.matchesFn) {
                return;
            }
        }
        // Traverse parents.
        while (element) {
            if (element[this.matchesFn](selector)) {
                return element;
            }
            element = element.parentElement;
        }
    };
    /**
     * If the download size is higher than a certain threshold shows a confirm dialog.
     *
     * @param {any} size Object containing size to download and a boolean to indicate if its totally or partialy calculated.
     * @param {string} [message] Code of the message to show. Default: 'core.course.confirmdownload'.
     * @param {string} [unknownMessage] ID of the message to show if size is unknown.
     * @param {number} [wifiThreshold] Threshold to show confirm in WiFi connection. Default: CoreWifiDownloadThreshold.
     * @param {number} [limitedThreshold] Threshold to show confirm in limited connection. Default: CoreDownloadThreshold.
     * @param {boolean} [alwaysConfirm] True to show a confirm even if the size isn't high, false otherwise.
     * @return {Promise<void>} Promise resolved when the user confirms or if no confirm needed.
     */
    CoreDomUtilsProvider.prototype.confirmDownloadSize = function (size, message, unknownMessage, wifiThreshold, limitedThreshold, alwaysConfirm) {
        var _this = this;
        var readableSize = this.textUtils.bytesToSize(size.size, 2);
        var getAvailableBytes = new Promise(function (resolve) {
            if (_this.appProvider.isDesktop()) {
                // Free space calculation is not supported on desktop.
                resolve(null);
            }
            else {
                _this.fileProvider.calculateFreeSpace().then(function (availableBytes) {
                    if (_this.platform.is('android')) {
                        return availableBytes;
                    }
                    else {
                        // Space calculation is not accurate on iOS, but it gets more accurate when space is lower.
                        // We'll only use it when space is <500MB, or we're downloading more than twice the reported space.
                        if (availableBytes < __WEBPACK_IMPORTED_MODULE_10__core_constants__["a" /* CoreConstants */].IOS_FREE_SPACE_THRESHOLD || size.size > availableBytes / 2) {
                            return availableBytes;
                        }
                        else {
                            return null;
                        }
                    }
                }).then(function (availableBytes) {
                    resolve(availableBytes);
                });
            }
        });
        var getAvailableSpace = getAvailableBytes.then(function (availableBytes) {
            if (availableBytes === null) {
                return '';
            }
            else {
                var availableSize = _this.textUtils.bytesToSize(availableBytes, 2);
                if (_this.platform.is('android') && size.size > availableBytes - __WEBPACK_IMPORTED_MODULE_10__core_constants__["a" /* CoreConstants */].MINIMUM_FREE_SPACE) {
                    return Promise.reject(_this.translate.instant('core.course.insufficientavailablespace', { size: readableSize }));
                }
                return _this.translate.instant('core.course.availablespace', { available: availableSize });
            }
        });
        return getAvailableSpace.then(function (availableSpace) {
            wifiThreshold = typeof wifiThreshold == 'undefined' ? __WEBPACK_IMPORTED_MODULE_10__core_constants__["a" /* CoreConstants */].WIFI_DOWNLOAD_THRESHOLD : wifiThreshold;
            limitedThreshold = typeof limitedThreshold == 'undefined' ? __WEBPACK_IMPORTED_MODULE_10__core_constants__["a" /* CoreConstants */].DOWNLOAD_THRESHOLD : limitedThreshold;
            var wifiPrefix = '';
            if (_this.appProvider.isNetworkAccessLimited()) {
                wifiPrefix = _this.translate.instant('core.course.confirmlimiteddownload');
            }
            if (size.size < 0 || (size.size == 0 && !size.total)) {
                // Seems size was unable to be calculated. Show a warning.
                unknownMessage = unknownMessage || 'core.course.confirmdownloadunknownsize';
                return _this.showConfirm(wifiPrefix + _this.translate.instant(unknownMessage, { availableSpace: availableSpace }));
            }
            else if (!size.total) {
                // Filesize is only partial.
                return _this.showConfirm(wifiPrefix + _this.translate.instant('core.course.confirmpartialdownloadsize', { size: readableSize, availableSpace: availableSpace }));
            }
            else if (alwaysConfirm || size.size >= wifiThreshold ||
                (_this.appProvider.isNetworkAccessLimited() && size.size >= limitedThreshold)) {
                message = message || 'core.course.confirmdownload';
                return _this.showConfirm(wifiPrefix + _this.translate.instant(message, { size: readableSize, availableSpace: availableSpace }));
            }
            return Promise.resolve();
        });
    };
    /**
     * Convert some HTML as text into an HTMLElement. This HTML is put inside a div or a body.
     *
     * @param {string} html Text to convert.
     * @return {HTMLElement} Element.
     */
    CoreDomUtilsProvider.prototype.convertToElement = function (html) {
        // Add a div to hold the content, that's the element that will be returned.
        this.template.innerHTML = '<div>' + html + '</div>';
        return this.template.content.children[0];
    };
    /**
     * Create a "cancelled" error. These errors won't display an error message in showErrorModal functions.
     *
     * @return {any} The error object.
     */
    CoreDomUtilsProvider.prototype.createCanceledError = function () {
        return { coreCanceled: true };
    };
    /**
     * Given a list of changes for a component input detected by a KeyValueDiffers, create an object similar to the one
     * passed to the ngOnChanges functions.
     *
     * @param {any} changes Changes detected by KeyValueDiffer.
     * @return {{[name: string]: SimpleChange}} Changes in a format like ngOnChanges.
     */
    CoreDomUtilsProvider.prototype.createChangesFromKeyValueDiff = function (changes) {
        var newChanges = {};
        // Added items are considered first change.
        changes.forEachAddedItem(function (item) {
            newChanges[item.key] = new __WEBPACK_IMPORTED_MODULE_0__angular_core__["_2" /* SimpleChange */](item.previousValue, item.currentValue, true);
        });
        // Changed or removed items aren't first change.
        changes.forEachChangedItem(function (item) {
            newChanges[item.key] = new __WEBPACK_IMPORTED_MODULE_0__angular_core__["_2" /* SimpleChange */](item.previousValue, item.currentValue, false);
        });
        changes.forEachRemovedItem(function (item) {
            newChanges[item.key] = new __WEBPACK_IMPORTED_MODULE_0__angular_core__["_2" /* SimpleChange */](item.previousValue, item.currentValue, true);
        });
        return newChanges;
    };
    /**
     * Extract the downloadable URLs from an HTML code.
     *
     * @param {string} html HTML code.
     * @return {string[]} List of file urls.
     */
    CoreDomUtilsProvider.prototype.extractDownloadableFilesFromHtml = function (html) {
        var urls = [];
        var elements;
        var element = this.convertToElement(html);
        elements = element.querySelectorAll('a, img, audio, video, source, track');
        for (var i = 0; i < elements.length; i++) {
            var element_1 = elements[i];
            var url = element_1.tagName === 'A' ? element_1.href : element_1.src;
            if (url && this.urlUtils.isDownloadableUrl(url) && urls.indexOf(url) == -1) {
                urls.push(url);
            }
            // Treat video poster.
            if (element_1.tagName == 'VIDEO' && element_1.getAttribute('poster')) {
                url = element_1.getAttribute('poster');
                if (url && this.urlUtils.isDownloadableUrl(url) && urls.indexOf(url) == -1) {
                    urls.push(url);
                }
            }
        }
        return urls;
    };
    /**
     * Extract the downloadable URLs from an HTML code and returns them in fake file objects.
     *
     * @param {string} html HTML code.
     * @return {any[]} List of fake file objects with file URLs.
     */
    CoreDomUtilsProvider.prototype.extractDownloadableFilesFromHtmlAsFakeFileObjects = function (html) {
        var urls = this.extractDownloadableFilesFromHtml(html);
        // Convert them to fake file objects.
        return urls.map(function (url) {
            return {
                fileurl: url
            };
        });
    };
    /**
     * Search all the URLs in a CSS file content.
     *
     * @param {string} code CSS code.
     * @return {string[]} List of URLs.
     */
    CoreDomUtilsProvider.prototype.extractUrlsFromCSS = function (code) {
        // First of all, search all the url(...) occurrences that don't include "data:".
        var urls = [], matches = code.match(/url\(\s*["']?(?!data:)([^)]+)\)/igm);
        if (!matches) {
            return urls;
        }
        // Extract the URL form each match.
        matches.forEach(function (match) {
            var submatches = match.match(/url\(\s*['"]?([^'"]*)['"]?\s*\)/im);
            if (submatches && submatches[1]) {
                urls.push(submatches[1]);
            }
        });
        return urls;
    };
    /**
     * Fix syntax errors in HTML.
     *
     * @param {string} html HTML text.
     * @return {string} Fixed HTML text.
     */
    CoreDomUtilsProvider.prototype.fixHtml = function (html) {
        this.template.innerHTML = html;
        var attrNameRegExp = /[^\x00-\x20\x7F-\x9F"'>\/=]+/;
        var fixElement = function (element) {
            // Remove attributes with an invalid name.
            Array.from(element.attributes).forEach(function (attr) {
                if (!attrNameRegExp.test(attr.name)) {
                    element.removeAttributeNode(attr);
                }
            });
            Array.from(element.children).forEach(fixElement);
        };
        Array.from(this.template.content.children).forEach(fixElement);
        return this.template.innerHTML;
    };
    /**
     * Focus an element and open keyboard.
     *
     * @param {HTMLElement} el HTML element to focus.
     */
    CoreDomUtilsProvider.prototype.focusElement = function (el) {
        if (el && el.focus) {
            el.focus();
            if (this.platform.is('android') && this.supportsInputKeyboard(el)) {
                // On some Android versions the keyboard doesn't open automatically.
                this.appProvider.openKeyboard();
            }
        }
    };
    /**
     * Formats a size to be used as width/height of an element.
     * If the size is already valid (like '500px' or '50%') it won't be modified.
     * Returned size will have a format like '500px'.
     *
     * @param {any} size Size to format.
     * @return {string} Formatted size. If size is not valid, returns an empty string.
     */
    CoreDomUtilsProvider.prototype.formatPixelsSize = function (size) {
        if (typeof size == 'string' && (size.indexOf('px') > -1 || size.indexOf('%') > -1)) {
            // It seems to be a valid size.
            return size;
        }
        size = parseInt(size, 10);
        if (!isNaN(size)) {
            return size + 'px';
        }
        return '';
    };
    /**
     * Returns the contents of a certain selection in a DOM element.
     *
     * @param {HTMLElement} element DOM element to search in.
     * @param {string} selector Selector to search.
     * @return {string} Selection contents. Undefined if not found.
     */
    CoreDomUtilsProvider.prototype.getContentsOfElement = function (element, selector) {
        if (element) {
            var selected = element.querySelector(selector);
            if (selected) {
                return selected.innerHTML;
            }
        }
    };
    /**
     * Get the data from a form. It will only collect elements that have a name.
     *
     * @param {HTMLFormElement} form The form to get the data from.
     * @return {any} Object with the data. The keys are the names of the inputs.
     */
    CoreDomUtilsProvider.prototype.getDataFromForm = function (form) {
        if (!form || !form.elements) {
            return {};
        }
        var data = {};
        for (var i = 0; i < form.elements.length; i++) {
            var element = form.elements[i], name_1 = element.name || '';
            // Ignore submit inputs.
            if (!name_1 || element.type == 'submit' || element.tagName == 'BUTTON') {
                continue;
            }
            // Get the value.
            if (element.type == 'checkbox') {
                data[name_1] = !!element.checked;
            }
            else if (element.type == 'radio') {
                if (element.checked) {
                    data[name_1] = element.value;
                }
            }
            else {
                data[name_1] = element.value;
            }
        }
        return data;
    };
    /**
     * Returns the attribute value of a string element. Only the first element will be selected.
     *
     * @param  {string} html      HTML element in string.
     * @param  {string} attribute Attribute to get.
     * @return {string}           Attribute value.
     */
    CoreDomUtilsProvider.prototype.getHTMLElementAttribute = function (html, attribute) {
        return this.convertToElement(html).children[0].getAttribute('src');
    };
    /**
     * Returns height of an element.
     *
     * @param {any} element DOM element to measure.
     * @param {boolean} [usePadding] Whether to use padding to calculate the measure.
     * @param {boolean} [useMargin] Whether to use margin to calculate the measure.
     * @param {boolean} [useBorder] Whether to use borders to calculate the measure.
     * @param {boolean} [innerMeasure] If inner measure is needed: padding, margin or borders will be substracted.
     * @return {number} Height in pixels.
     */
    CoreDomUtilsProvider.prototype.getElementHeight = function (element, usePadding, useMargin, useBorder, innerMeasure) {
        return this.getElementMeasure(element, false, usePadding, useMargin, useBorder, innerMeasure);
    };
    /**
     * Returns height or width of an element.
     *
     * @param {any} element DOM element to measure.
     * @param {boolean} [getWidth] Whether to get width or height.
     * @param {boolean} [usePadding] Whether to use padding to calculate the measure.
     * @param {boolean} [useMargin] Whether to use margin to calculate the measure.
     * @param {boolean} [useBorder] Whether to use borders to calculate the measure.
     * @param {boolean} [innerMeasure] If inner measure is needed: padding, margin or borders will be substracted.
     * @return {number} Measure in pixels.
     */
    CoreDomUtilsProvider.prototype.getElementMeasure = function (element, getWidth, usePadding, useMargin, useBorder, innerMeasure) {
        var offsetMeasure = getWidth ? 'offsetWidth' : 'offsetHeight', measureName = getWidth ? 'width' : 'height', clientMeasure = getWidth ? 'clientWidth' : 'clientHeight', priorSide = getWidth ? 'Left' : 'Top', afterSide = getWidth ? 'Right' : 'Bottom';
        var measure = element[offsetMeasure] || element[measureName] || element[clientMeasure] || 0;
        // Measure not correctly taken.
        if (measure <= 0) {
            var style = getComputedStyle(element);
            if (style && style.display == '') {
                element.style.display = 'inline-block';
                measure = element[offsetMeasure] || element[measureName] || element[clientMeasure] || 0;
                element.style.display = '';
            }
        }
        if (usePadding || useMargin || useBorder) {
            var computedStyle = getComputedStyle(element);
            var surround = 0;
            if (usePadding) {
                surround += this.getComputedStyleMeasure(computedStyle, 'padding' + priorSide) +
                    this.getComputedStyleMeasure(computedStyle, 'padding' + afterSide);
            }
            if (useMargin) {
                surround += this.getComputedStyleMeasure(computedStyle, 'margin' + priorSide) +
                    this.getComputedStyleMeasure(computedStyle, 'margin' + afterSide);
            }
            if (useBorder) {
                surround += this.getComputedStyleMeasure(computedStyle, 'border' + priorSide + 'Width') +
                    this.getComputedStyleMeasure(computedStyle, 'border' + afterSide + 'Width');
            }
            if (innerMeasure) {
                measure = measure > surround ? measure - surround : 0;
            }
            else {
                measure += surround;
            }
        }
        return measure;
    };
    /**
     * Returns the computed style measure or 0 if not found or NaN.
     *
     * @param  {any}    style   Style from getComputedStyle.
     * @param  {string} measure Measure to get.
     * @return {number}         Result of the measure.
     */
    CoreDomUtilsProvider.prototype.getComputedStyleMeasure = function (style, measure) {
        return parseInt(style[measure], 10) || 0;
    };
    /**
     * Get the HTML code to render a connection warning icon.
     *
     * @return {string} HTML Code.
     */
    CoreDomUtilsProvider.prototype.getConnectionWarningIconHtml = function () {
        return '<div text-center><span class="core-icon-with-badge">' +
            '<ion-icon role="img" class="icon fa fa-wifi" aria-label="wifi"></ion-icon>' +
            '<ion-icon class="icon fa fa-exclamation-triangle core-icon-badge"></ion-icon>' +
            '</span></div>';
    };
    /**
     * Returns width of an element.
     *
     * @param {any} element DOM element to measure.
     * @param {boolean} [usePadding] Whether to use padding to calculate the measure.
     * @param {boolean} [useMargin] Whether to use margin to calculate the measure.
     * @param {boolean} [useBorder] Whether to use borders to calculate the measure.
     * @param {boolean} [innerMeasure] If inner measure is needed: padding, margin or borders will be substracted.
     * @return {number} Width in pixels.
     */
    CoreDomUtilsProvider.prototype.getElementWidth = function (element, usePadding, useMargin, useBorder, innerMeasure) {
        return this.getElementMeasure(element, true, usePadding, useMargin, useBorder, innerMeasure);
    };
    /**
     * Retrieve the position of a element relative to another element.
     *
     * @param {HTMLElement} container Element to search in.
     * @param {string} [selector] Selector to find the element to gets the position.
     * @param {string} [positionParentClass] Parent Class where to stop calculating the position. Default scroll-content.
     * @return {number[]} positionLeft, positionTop of the element relative to.
     */
    CoreDomUtilsProvider.prototype.getElementXY = function (container, selector, positionParentClass) {
        var element = (selector ? container.querySelector(selector) : container), offsetElement, positionTop = 0, positionLeft = 0;
        if (!positionParentClass) {
            positionParentClass = 'scroll-content';
        }
        if (!element) {
            return null;
        }
        while (element) {
            positionLeft += (element.offsetLeft - element.scrollLeft + element.clientLeft);
            positionTop += (element.offsetTop - element.scrollTop + element.clientTop);
            offsetElement = element.offsetParent;
            element = element.parentElement;
            // Every parent class has to be checked but the position has to be got form offsetParent.
            while (offsetElement != element && element) {
                // If positionParentClass element is reached, stop adding tops.
                if (element.className.indexOf(positionParentClass) != -1) {
                    element = null;
                }
                else {
                    element = element.parentElement;
                }
            }
            // Finally, check again.
            if (element && element.className.indexOf(positionParentClass) != -1) {
                element = null;
            }
        }
        return [positionLeft, positionTop];
    };
    /**
     * Given an error message, return a suitable error title.
     *
     * @param {string} message The error message.
     * @return {any} Title.
     */
    CoreDomUtilsProvider.prototype.getErrorTitle = function (message) {
        if (message == this.translate.instant('core.networkerrormsg') ||
            message == this.translate.instant('core.fileuploader.errormustbeonlinetoupload')) {
            return this.sanitizer.bypassSecurityTrustHtml(this.getConnectionWarningIconHtml());
        }
        return this.textUtils.decodeHTML(this.translate.instant('core.error'));
    };
    /**
     * Get the error message from an error, including debug data if needed.
     *
     * @param {any} error Message to show.
     * @param {boolean} [needsTranslate] Whether the error needs to be translated.
     * @return {string} Error message, null if no error should be displayed.
     */
    CoreDomUtilsProvider.prototype.getErrorMessage = function (error, needsTranslate) {
        var extraInfo = '';
        if (typeof error == 'object') {
            if (this.debugDisplay) {
                // Get the debug info. Escape the HTML so it is displayed as it is in the view.
                if (error.debuginfo) {
                    extraInfo = '<br><br>' + this.textUtils.escapeHTML(error.debuginfo);
                }
                if (error.backtrace) {
                    extraInfo += '<br><br>' + this.textUtils.replaceNewLines(this.textUtils.escapeHTML(error.backtrace), '<br>');
                }
                // tslint:disable-next-line
                console.error(error);
            }
            // We received an object instead of a string. Search for common properties.
            if (error.coreCanceled) {
                // It's a canceled error, don't display an error.
                return null;
            }
            error = this.textUtils.getErrorMessageFromError(error);
            if (!error) {
                // No common properties found, just stringify it.
                error = JSON.stringify(error);
                extraInfo = ''; // No need to add extra info because it's already in the error.
            }
            // Try to remove tokens from the contents.
            var matches = error.match(/token"?[=|:]"?(\w*)/, '');
            if (matches && matches[1]) {
                error = error.replace(new RegExp(matches[1], 'g'), 'secret');
            }
        }
        if (error == __WEBPACK_IMPORTED_MODULE_10__core_constants__["a" /* CoreConstants */].DONT_SHOW_ERROR) {
            // The error shouldn't be shown, stop.
            return null;
        }
        var message = this.textUtils.decodeHTML(needsTranslate ? this.translate.instant(error) : error);
        if (extraInfo) {
            message += extraInfo;
        }
        return message;
    };
    /**
     * Retrieve component/directive instance.
     * Please use this function only if you cannot retrieve the instance using parent/child methods: ViewChild (or similar)
     * or Angular's injection.
     *
     * @param {Element} element The root element of the component/directive.
     * @return {any} The instance, undefined if not found.
     */
    CoreDomUtilsProvider.prototype.getInstanceByElement = function (element) {
        var id = element.getAttribute(this.INSTANCE_ID_ATTR_NAME);
        return this.instances[id];
    };
    /**
     * Wait an element to exists using the findFunction.
     *
     * @param {Function} findFunction The function used to find the element.
     * @return {Promise<HTMLElement>} Resolved if found, rejected if too many tries.
     */
    CoreDomUtilsProvider.prototype.waitElementToExist = function (findFunction) {
        var promiseInterval = {
            promise: null,
            resolve: null,
            reject: null
        };
        var tries = 100;
        promiseInterval.promise = new Promise(function (resolve, reject) {
            promiseInterval.resolve = resolve;
            promiseInterval.reject = reject;
        });
        var clear = setInterval(function () {
            var element = findFunction();
            if (element) {
                clearInterval(clear);
                promiseInterval.resolve(element);
            }
            else {
                tries--;
                if (tries <= 0) {
                    clearInterval(clear);
                    promiseInterval.reject();
                }
            }
        }, 100);
        return promiseInterval.promise;
    };
    /**
     * Handle bootstrap tooltips in a certain element.
     *
     * @param {HTMLElement} element Element to check.
     */
    CoreDomUtilsProvider.prototype.handleBootstrapTooltips = function (element) {
        var _this = this;
        var els = Array.from(element.querySelectorAll('[data-toggle="tooltip"]'));
        els.forEach(function (el) {
            var content = el.getAttribute('title') || el.getAttribute('data-original-title'), trigger = el.getAttribute('data-trigger') || 'hover focus', treated = el.getAttribute('data-bstooltip-treated');
            if (!content || treated === 'true' ||
                (trigger.indexOf('hover') == -1 && trigger.indexOf('focus') == -1 && trigger.indexOf('click') == -1)) {
                return;
            }
            el.setAttribute('data-bstooltip-treated', 'true'); // Mark it as treated.
            // Store the title in data-original-title instead of title, like BS does.
            el.setAttribute('data-original-title', content);
            el.setAttribute('title', '');
            el.addEventListener('click', function (e) {
                var html = el.getAttribute('data-html');
                var popover = _this.popoverCtrl.create(__WEBPACK_IMPORTED_MODULE_11__components_bs_tooltip_bs_tooltip__["a" /* CoreBSTooltipComponent */], {
                    content: content,
                    html: html === 'true'
                });
                popover.present({
                    ev: e
                });
            });
        });
    };
    /**
     * Check if an element is outside of screen (viewport).
     *
     * @param {HTMLElement} scrollEl The element that must be scrolled.
     * @param {HTMLElement} element DOM element to check.
     * @return {boolean} Whether the element is outside of the viewport.
     */
    CoreDomUtilsProvider.prototype.isElementOutsideOfScreen = function (scrollEl, element) {
        var elementRect = element.getBoundingClientRect();
        var elementMidPoint, scrollElRect, scrollTopPos = 0;
        if (!elementRect) {
            return false;
        }
        elementMidPoint = Math.round((elementRect.bottom + elementRect.top) / 2);
        scrollElRect = scrollEl.getBoundingClientRect();
        scrollTopPos = (scrollElRect && scrollElRect.top) || 0;
        return elementMidPoint > window.innerHeight || elementMidPoint < scrollTopPos;
    };
    /**
     * Check if rich text editor is enabled.
     *
     * @return {Promise<boolean>} Promise resolved with boolean: true if enabled, false otherwise.
     */
    CoreDomUtilsProvider.prototype.isRichTextEditorEnabled = function () {
        if (this.isRichTextEditorSupported()) {
            return this.configProvider.get(__WEBPACK_IMPORTED_MODULE_10__core_constants__["a" /* CoreConstants */].SETTINGS_RICH_TEXT_EDITOR, true).then(function (enabled) {
                return !!enabled;
            });
        }
        return Promise.resolve(false);
    };
    /**
     * Check if rich text editor is supported in the platform.
     *
     * @return {boolean} Whether it's supported.
     */
    CoreDomUtilsProvider.prototype.isRichTextEditorSupported = function () {
        return true;
    };
    /**
     * Move children from one HTMLElement to another.
     *
     * @param {HTMLElement} oldParent The old parent.
     * @param {HTMLElement} newParent The new parent.
     * @param {boolean} [prepend] If true, adds the children to the beginning of the new parent.
     * @return {Node[]} List of moved children.
     */
    CoreDomUtilsProvider.prototype.moveChildren = function (oldParent, newParent, prepend) {
        var movedChildren = [];
        var referenceNode = prepend ? newParent.firstChild : null;
        while (oldParent.childNodes.length > 0) {
            var child = oldParent.childNodes[0];
            movedChildren.push(child);
            newParent.insertBefore(child, referenceNode);
        }
        return movedChildren;
    };
    /**
     * Search and remove a certain element from inside another element.
     *
     * @param {HTMLElement} element DOM element to search in.
     * @param {string} selector Selector to search.
     */
    CoreDomUtilsProvider.prototype.removeElement = function (element, selector) {
        if (element) {
            var selected = element.querySelector(selector);
            if (selected) {
                selected.remove();
            }
        }
    };
    /**
     * Search and remove a certain element from an HTML code.
     *
     * @param {string} html HTML code to change.
     * @param {string} selector Selector to search.
     * @param {boolean} [removeAll] True if it should remove all matches found, false if it should only remove the first one.
     * @return {string} HTML without the element.
     */
    CoreDomUtilsProvider.prototype.removeElementFromHtml = function (html, selector, removeAll) {
        var selected;
        var element = this.convertToElement(html);
        if (removeAll) {
            selected = element.querySelectorAll(selector);
            for (var i = 0; i < selected.length; i++) {
                selected[i].remove();
            }
        }
        else {
            selected = element.querySelector(selector);
            if (selected) {
                selected.remove();
            }
        }
        return element.innerHTML;
    };
    /**
     * Remove a component/directive instance using the DOM Element.
     *
     * @param {Element} element The root element of the component/directive.
     */
    CoreDomUtilsProvider.prototype.removeInstanceByElement = function (element) {
        var id = element.getAttribute(this.INSTANCE_ID_ATTR_NAME);
        delete this.instances[id];
    };
    /**
     * Remove a component/directive instance using the ID.
     *
     * @param {string} id The ID to remove.
     */
    CoreDomUtilsProvider.prototype.removeInstanceById = function (id) {
        delete this.instances[id];
    };
    /**
     * Search for certain classes in an element contents and replace them with the specified new values.
     *
     * @param {HTMLElement} element DOM element.
     * @param {any} map Mapping of the classes to replace. Keys must be the value to replace, values must be
     *            the new class name. Example: {'correct': 'core-question-answer-correct'}.
     */
    CoreDomUtilsProvider.prototype.replaceClassesInElement = function (element, map) {
        for (var key in map) {
            var foundElements = element.querySelectorAll('.' + key);
            for (var i = 0; i < foundElements.length; i++) {
                var foundElement = foundElements[i];
                foundElement.className = foundElement.className.replace(key, map[key]);
            }
        }
    };
    /**
     * Given an HTML, search all links and media and tries to restore original sources using the paths object.
     *
     * @param {string} html HTML code.
     * @param {object} paths Object linking URLs in the html code with the real URLs to use.
     * @param {Function} [anchorFn] Function to call with each anchor. Optional.
     * @return {string} Treated HTML code.
     */
    CoreDomUtilsProvider.prototype.restoreSourcesInHtml = function (html, paths, anchorFn) {
        var _this = this;
        var media, anchors;
        var element = this.convertToElement(html);
        // Treat elements with src (img, audio, video, ...).
        media = Array.from(element.querySelectorAll('img, video, audio, source, track'));
        media.forEach(function (media) {
            var newSrc = paths[_this.textUtils.decodeURIComponent(media.getAttribute('src'))];
            if (typeof newSrc != 'undefined') {
                media.setAttribute('src', newSrc);
            }
            // Treat video posters.
            if (media.tagName == 'VIDEO' && media.getAttribute('poster')) {
                newSrc = paths[_this.textUtils.decodeURIComponent(media.getAttribute('poster'))];
                if (typeof newSrc !== 'undefined') {
                    media.setAttribute('poster', newSrc);
                }
            }
        });
        // Now treat links.
        anchors = Array.from(element.querySelectorAll('a'));
        anchors.forEach(function (anchor) {
            var href = _this.textUtils.decodeURIComponent(anchor.getAttribute('href')), newUrl = paths[href];
            if (typeof newUrl != 'undefined') {
                anchor.setAttribute('href', newUrl);
                if (typeof anchorFn == 'function') {
                    anchorFn(anchor, href);
                }
            }
        });
        return element.innerHTML;
    };
    /**
     * Scroll to somehere in the content.
     * Checks hidden property _scroll to avoid errors if view is not active.
     *
     * @param {Content} content Content where to execute the function.
     * @param {number} x  The x-value to scroll to.
     * @param {number} y  The y-value to scroll to.
     * @param {number} [duration]  Duration of the scroll animation in milliseconds. Defaults to `300`.
     * @returns {Promise} Returns a promise which is resolved when the scroll has completed.
     */
    CoreDomUtilsProvider.prototype.scrollTo = function (content, x, y, duration, done) {
        return content && content._scroll && content.scrollTo(x, y, duration, done);
    };
    /**
     * Scroll to Bottom of the content.
     * Checks hidden property _scroll to avoid errors if view is not active.
     *
     * @param {Content} content Content where to execute the function.
     * @param {number} [duration]  Duration of the scroll animation in milliseconds. Defaults to `300`.
     * @returns {Promise} Returns a promise which is resolved when the scroll has completed.
     */
    CoreDomUtilsProvider.prototype.scrollToBottom = function (content, duration) {
        return content && content._scroll && content.scrollToBottom(duration);
    };
    /**
     * Scroll to Top of the content.
     * Checks hidden property _scroll to avoid errors if view is not active.
     *
     * @param {Content} content Content where to execute the function.
     * @param {number} [duration]  Duration of the scroll animation in milliseconds. Defaults to `300`.
     * @returns {Promise} Returns a promise which is resolved when the scroll has completed.
     */
    CoreDomUtilsProvider.prototype.scrollToTop = function (content, duration) {
        return content && content._scroll && content.scrollToTop(duration);
    };
    /**
     * Returns contentHeight of the content.
     * Checks hidden property _scroll to avoid errors if view is not active.
     *
     * @param {Content} content Content where to execute the function.
     * @return {number}         Content contentHeight or 0.
     */
    CoreDomUtilsProvider.prototype.getContentHeight = function (content) {
        return (content && content._scroll && content.contentHeight) || 0;
    };
    /**
     * Returns scrollHeight of the content.
     * Checks hidden property _scroll to avoid errors if view is not active.
     *
     * @param {Content} content Content where to execute the function.
     * @return {number}         Content scrollHeight or 0.
     */
    CoreDomUtilsProvider.prototype.getScrollHeight = function (content) {
        return (content && content._scroll && content.scrollHeight) || 0;
    };
    /**
     * Returns scrollTop of the content.
     * Checks hidden property _scroll to avoid errors if view is not active.
     *
     * @param {Content} content Content where to execute the function.
     * @return {number}         Content scrollTop or 0.
     */
    CoreDomUtilsProvider.prototype.getScrollTop = function (content) {
        return (content && content._scroll && content.scrollTop) || 0;
    };
    /**
     * Scroll to a certain element.
     *
     * @param {Content} content The content that must be scrolled.
     * @param {HTMLElement} element The element to scroll to.
     * @param {string} [scrollParentClass] Parent class where to stop calculating the position. Default scroll-content.
     * @return {boolean} True if the element is found, false otherwise.
     */
    CoreDomUtilsProvider.prototype.scrollToElement = function (content, element, scrollParentClass) {
        var position = this.getElementXY(element, undefined, scrollParentClass);
        if (!position) {
            return false;
        }
        this.scrollTo(content, position[0], position[1]);
        return true;
    };
    /**
     * Scroll to a certain element using a selector to find it.
     *
     * @param {Content} content The content that must be scrolled.
     * @param {string} selector Selector to find the element to scroll to.
     * @param {string} [scrollParentClass] Parent class where to stop calculating the position. Default scroll-content.
     * @return {boolean} True if the element is found, false otherwise.
     */
    CoreDomUtilsProvider.prototype.scrollToElementBySelector = function (content, selector, scrollParentClass) {
        var position = this.getElementXY(content.getScrollElement(), selector, scrollParentClass);
        if (!position) {
            return false;
        }
        this.scrollTo(content, position[0], position[1]);
        return true;
    };
    /**
     * Search for an input with error (core-input-error directive) and scrolls to it if found.
     *
     * @param {Content} content The content that must be scrolled.
     * @param [scrollParentClass] Parent class where to stop calculating the position. Default scroll-content.
     * @return {boolean} True if the element is found, false otherwise.
     */
    CoreDomUtilsProvider.prototype.scrollToInputError = function (content, scrollParentClass) {
        if (!content) {
            return false;
        }
        return this.scrollToElementBySelector(content, '.core-input-error', scrollParentClass);
    };
    /**
     * Set whether debug messages should be displayed.
     *
     * @param {boolean} value Whether to display or not.
     */
    CoreDomUtilsProvider.prototype.setDebugDisplay = function (value) {
        this.debugDisplay = value;
    };
    /**
     * Show an alert modal with a button to close it.
     *
     * @param {string} title Title to show.
     * @param {string} message Message to show.
     * @param {string} [buttonText] Text of the button.
     * @param {number} [autocloseTime] Number of milliseconds to wait to close the modal. If not defined, modal won't be closed.
     * @return {Promise<CoreAlert>} Promise resolved with the alert modal.
     */
    CoreDomUtilsProvider.prototype.showAlert = function (title, message, buttonText, autocloseTime) {
        var _this = this;
        var hasHTMLTags = this.textUtils.hasHTMLTags(message);
        var promise;
        if (hasHTMLTags) {
            // Format the text.
            promise = this.textUtils.formatText(message);
        }
        else {
            promise = Promise.resolve(message);
        }
        return promise.then(function (message) {
            var alertId = __WEBPACK_IMPORTED_MODULE_12_ts_md5_dist_md5__["Md5"].hashAsciiStr((title || '') + '#' + (message || ''));
            if (_this.displayedAlerts[alertId]) {
                // There's already an alert with the same message and title. Return it.
                return _this.displayedAlerts[alertId];
            }
            var alert = _this.alertCtrl.create({
                title: title,
                message: message,
                buttons: [buttonText || _this.translate.instant('core.ok')]
            });
            alert.present().then(function () {
                if (hasHTMLTags) {
                    // Treat all anchors so they don't override the app.
                    var alertMessageEl = alert.pageRef().nativeElement.querySelector('.alert-message');
                    _this.treatAnchors(alertMessageEl);
                }
            });
            // Store the alert and remove it when dismissed.
            _this.displayedAlerts[alertId] = alert;
            // Define the observables to extend the Alert class. This will allow several callbacks instead of just one.
            alert.didDismiss = new __WEBPACK_IMPORTED_MODULE_13_rxjs__["Subject"]();
            alert.willDismiss = new __WEBPACK_IMPORTED_MODULE_13_rxjs__["Subject"]();
            // Set the callbacks to trigger an observable event.
            alert.onDidDismiss(function (data, role) {
                delete _this.displayedAlerts[alertId];
                alert.didDismiss.next({ data: data, role: role });
            });
            alert.onWillDismiss(function (data, role) {
                alert.willDismiss.next({ data: data, role: role });
            });
            if (autocloseTime > 0) {
                setTimeout(function () {
                    alert.dismiss();
                }, autocloseTime);
            }
            return alert;
        });
    };
    /**
     * Show an alert modal with a button to close it, translating the values supplied.
     *
     * @param {string} title Title to show.
     * @param {string} message Message to show.
     * @param {string} [buttonText] Text of the button.
     * @param {number} [autocloseTime] Number of milliseconds to wait to close the modal. If not defined, modal won't be closed.
     * @return {Promise<Alert>} Promise resolved with the alert modal.
     */
    CoreDomUtilsProvider.prototype.showAlertTranslated = function (title, message, buttonText, autocloseTime) {
        title = title ? this.translate.instant(title) : title;
        message = message ? this.translate.instant(message) : message;
        buttonText = buttonText ? this.translate.instant(buttonText) : buttonText;
        return this.showAlert(title, message, buttonText, autocloseTime);
    };
    /**
     * Show a confirm modal.
     *
     * @param {string} message Message to show in the modal body.
     * @param {string} [title] Title of the modal.
     * @param {string} [okText] Text of the OK button.
     * @param {string} [cancelText] Text of the Cancel button.
     * @param {any} [options] More options. See https://ionicframework.com/docs/v3/api/components/alert/AlertController/
     * @return {Promise<any>} Promise resolved if the user confirms and rejected with a canceled error if he cancels.
     */
    CoreDomUtilsProvider.prototype.showConfirm = function (message, title, okText, cancelText, options) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var hasHTMLTags = _this.textUtils.hasHTMLTags(message);
            var promise;
            if (hasHTMLTags) {
                // Format the text.
                promise = _this.textUtils.formatText(message);
            }
            else {
                promise = Promise.resolve(message);
            }
            promise.then(function (message) {
                options = options || {};
                options.message = message;
                options.title = title;
                if (!title) {
                    options.cssClass = 'core-nohead';
                }
                options.buttons = [
                    {
                        text: cancelText || _this.translate.instant('core.cancel'),
                        role: 'cancel',
                        handler: function () {
                            reject(_this.createCanceledError());
                        }
                    },
                    {
                        text: okText || _this.translate.instant('core.ok'),
                        handler: function (data) {
                            resolve(data);
                        }
                    }
                ];
                var alert = _this.alertCtrl.create(options);
                alert.present().then(function () {
                    if (hasHTMLTags) {
                        // Treat all anchors so they don't override the app.
                        var alertMessageEl = alert.pageRef().nativeElement.querySelector('.alert-message');
                        _this.treatAnchors(alertMessageEl);
                    }
                });
            });
        });
    };
    /**
     * Show an alert modal with an error message.
     *
     * @param {any} error Message to show.
     * @param {boolean} [needsTranslate] Whether the error needs to be translated.
     * @param {number} [autocloseTime] Number of milliseconds to wait to close the modal. If not defined, modal won't be closed.
     * @return {Promise<Alert>} Promise resolved with the alert modal.
     */
    CoreDomUtilsProvider.prototype.showErrorModal = function (error, needsTranslate, autocloseTime) {
        var message = this.getErrorMessage(error, needsTranslate);
        if (message === null) {
            // Message doesn't need to be displayed, stop.
            return Promise.resolve(null);
        }
        return this.showAlert(this.getErrorTitle(message), message, undefined, autocloseTime);
    };
    /**
     * Show an alert modal with an error message. It uses a default message if error is not a string.
     *
     * @param {any} error Message to show.
     * @param {any} [defaultError] Message to show if the error is not a string.
     * @param {boolean} [needsTranslate] Whether the error needs to be translated.
     * @param {number} [autocloseTime] Number of milliseconds to wait to close the modal. If not defined, modal won't be closed.
     * @return {Promise<Alert>} Promise resolved with the alert modal.
     */
    CoreDomUtilsProvider.prototype.showErrorModalDefault = function (error, defaultError, needsTranslate, autocloseTime) {
        if (error && error.coreCanceled) {
            // It's a canceled error, don't display an error.
            return;
        }
        var errorMessage = error;
        if (error && typeof error != 'string') {
            errorMessage = this.textUtils.getErrorMessageFromError(error);
        }
        return this.showErrorModal(typeof errorMessage == 'string' ? error : defaultError, needsTranslate, autocloseTime);
    };
    /**
     * Show an alert modal with the first warning error message. It uses a default message if error is not a string.
     *
     * @param {any} warnings Warnings returned.
     * @param {any} [defaultError] Message to show if the error is not a string.
     * @param {boolean} [needsTranslate] Whether the error needs to be translated.
     * @param {number} [autocloseTime] Number of milliseconds to wait to close the modal. If not defined, modal won't be closed.
     * @return {Promise<Alert>} Promise resolved with the alert modal.
     */
    CoreDomUtilsProvider.prototype.showErrorModalFirstWarning = function (warnings, defaultError, needsTranslate, autocloseTime) {
        var error = warnings && warnings.length && warnings[0].message;
        return this.showErrorModalDefault(error, defaultError, needsTranslate, autocloseTime);
    };
    /**
     * Displays a loading modal window.
     *
     * @param {string} [text] The text of the modal window. Default: core.loading.
     * @param {boolean} [needsTranslate] Whether the 'text' needs to be translated.
     * @return {Loading} Loading modal instance.
     * @description
     * Usage:
     *     let modal = domUtils.showModalLoading(myText);
     *     ...
     *     modal.dismiss();
     */
    CoreDomUtilsProvider.prototype.showModalLoading = function (text, needsTranslate) {
        if (!text) {
            text = this.translate.instant('core.loading');
        }
        else if (needsTranslate) {
            text = this.translate.instant(text);
        }
        var loader = this.loadingCtrl.create({
            content: text
        }), dismiss = loader.dismiss.bind(loader);
        var isPresented = false, isDismissed = false;
        // Override dismiss to prevent dismissing a modal twice (it can throw an error and cause problems).
        loader.dismiss = function (data, role, navOptions) {
            if (!isPresented || isDismissed) {
                isDismissed = true;
                return Promise.resolve();
            }
            isDismissed = true;
            return dismiss(data, role, navOptions);
        };
        // Wait a bit before presenting the modal, to prevent it being displayed if dissmiss is called fast.
        setTimeout(function () {
            if (!isDismissed) {
                isPresented = true;
                loader.present();
            }
        }, 40);
        return loader;
    };
    /**
     * Show a prompt modal to input some data.
     *
     * @param {string} message Modal message.
     * @param {string} [title] Modal title.
     * @param {string} [placeholder] Placeholder of the input element. By default, "Password".
     * @param {string} [type] Type of the input element. By default, password.
     * @return {Promise<any>} Promise resolved with the input data if the user clicks OK, rejected if cancels.
     */
    CoreDomUtilsProvider.prototype.showPrompt = function (message, title, placeholder, type) {
        var _this = this;
        if (type === void 0) { type = 'password'; }
        return new Promise(function (resolve, reject) {
            var hasHTMLTags = _this.textUtils.hasHTMLTags(message);
            var promise;
            if (hasHTMLTags) {
                // Format the text.
                promise = _this.textUtils.formatText(message);
            }
            else {
                promise = Promise.resolve(message);
            }
            promise.then(function (message) {
                var alert = _this.alertCtrl.create({
                    message: message,
                    title: title,
                    inputs: [
                        {
                            name: 'promptinput',
                            placeholder: placeholder || _this.translate.instant('core.login.password'),
                            type: type
                        }
                    ],
                    buttons: [
                        {
                            text: _this.translate.instant('core.cancel'),
                            role: 'cancel',
                            handler: function () {
                                reject();
                            }
                        },
                        {
                            text: _this.translate.instant('core.ok'),
                            handler: function (data) {
                                resolve(data.promptinput);
                            }
                        }
                    ]
                });
                alert.present().then(function () {
                    if (hasHTMLTags) {
                        // Treat all anchors so they don't override the app.
                        var alertMessageEl = alert.pageRef().nativeElement.querySelector('.alert-message');
                        _this.treatAnchors(alertMessageEl);
                    }
                });
            });
        });
    };
    /**
     * Displays an autodimissable toast modal window.
     *
     * @param {string} text The text of the toast.
     * @param {boolean} [needsTranslate] Whether the 'text' needs to be translated.
     * @param {number} [duration=2000] Duration in ms of the dimissable toast.
     * @param {string} [cssClass=""] Class to add to the toast.
     * @param {boolean} [dismissOnPageChange=true] Dismiss the Toast on page change.
     * @return {Toast} Toast instance.
     */
    CoreDomUtilsProvider.prototype.showToast = function (text, needsTranslate, duration, cssClass, dismissOnPageChange) {
        if (duration === void 0) { duration = 2000; }
        if (cssClass === void 0) { cssClass = ''; }
        if (dismissOnPageChange === void 0) { dismissOnPageChange = true; }
        if (needsTranslate) {
            text = this.translate.instant(text);
        }
        var loader = this.toastCtrl.create({
            message: text,
            duration: duration,
            position: 'bottom',
            cssClass: cssClass,
            dismissOnPageChange: dismissOnPageChange
        });
        loader.present();
        return loader;
    };
    /**
     * Stores a component/directive instance.
     *
     * @param {Element} element The root element of the component/directive.
     * @param {any} instance The instance to store.
     * @return {string} ID to identify the instance.
     */
    CoreDomUtilsProvider.prototype.storeInstanceByElement = function (element, instance) {
        var id = String(this.lastInstanceId++);
        element.setAttribute(this.INSTANCE_ID_ATTR_NAME, id);
        this.instances[id] = instance;
        return id;
    };
    /**
     * Check if an element supports input via keyboard.
     *
     * @param {any} el HTML element to check.
     * @return {boolean} Whether it supports input using keyboard.
     */
    CoreDomUtilsProvider.prototype.supportsInputKeyboard = function (el) {
        return el && !el.disabled && (el.tagName.toLowerCase() == 'textarea' ||
            (el.tagName.toLowerCase() == 'input' && this.INPUT_SUPPORT_KEYBOARD.indexOf(el.type) != -1));
    };
    /**
     * Converts HTML formatted text to DOM element(s).
     *
     * @param {string} text HTML text.
     * @return {HTMLCollection} Same text converted to HTMLCollection.
     */
    CoreDomUtilsProvider.prototype.toDom = function (text) {
        var element = this.convertToElement(text);
        return element.children;
    };
    /**
     * Treat anchors inside alert/modals.
     *
     * @param {HTMLElement} container The HTMLElement that can contain anchors.
     */
    CoreDomUtilsProvider.prototype.treatAnchors = function (container) {
        var _this = this;
        var anchors = Array.from(container.querySelectorAll('a'));
        anchors.forEach(function (anchor) {
            anchor.addEventListener('click', function (event) {
                if (event.defaultPrevented) {
                    // Stop.
                    return;
                }
                var href = anchor.getAttribute('href');
                if (href) {
                    event.preventDefault();
                    event.stopPropagation();
                    // We cannot use CoreDomUtilsProvider.openInBrowser due to circular dependencies.
                    if (_this.appProvider.isDesktop()) {
                        // It's a desktop app, use Electron shell library to open the browser.
                        var shell = __webpack_require__(127).shell;
                        if (!shell.openExternal(href)) {
                            // Open browser failed, open a new window in the app.
                            window.open(href, '_system');
                        }
                    }
                    else {
                        window.open(href, '_system');
                    }
                }
            });
        });
    };
    /**
     * View an image in a new page or modal.
     *
     * @param {string} image URL of the image.
     * @param {string} title Title of the page or modal.
     * @param {string} [component] Component to link the image to if needed.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     */
    CoreDomUtilsProvider.prototype.viewImage = function (image, title, component, componentId) {
        if (image) {
            var params = {
                title: title,
                image: image,
                component: component,
                componentId: componentId
            }, modal = this.modalCtrl.create('CoreViewerImagePage', params);
            modal.present();
        }
    };
    /**
     * Wait for images to load.
     *
     * @param {HTMLElement} element The element to search in.
     * @return {Promise<boolean>} Promise resolved with a boolean: whether there was any image to load.
     */
    CoreDomUtilsProvider.prototype.waitForImages = function (element) {
        var imgs = Array.from(element.querySelectorAll('img')), promises = [];
        var hasImgToLoad = false;
        imgs.forEach(function (img) {
            if (img && !img.complete) {
                hasImgToLoad = true;
                // Wait for image to load or fail.
                promises.push(new Promise(function (resolve, reject) {
                    var imgLoaded = function () {
                        resolve();
                        img.removeEventListener('load', imgLoaded);
                        img.removeEventListener('error', imgLoaded);
                    };
                    img.addEventListener('load', imgLoaded);
                    img.addEventListener('error', imgLoaded);
                }));
            }
        });
        return Promise.all(promises).then(function () {
            return hasImgToLoad;
        });
    };
    /**
     * Wrap an HTMLElement with another element.
     *
     * @param {HTMLElement} el The element to wrap.
     * @param {HTMLElement} wrapper Wrapper.
     */
    CoreDomUtilsProvider.prototype.wrapElement = function (el, wrapper) {
        // Insert the wrapper before the element.
        el.parentNode.insertBefore(wrapper, el);
        // Now move the element into the wrapper.
        wrapper.appendChild(el);
    };
    CoreDomUtilsProvider = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_3__ngx_translate_core__["c" /* TranslateService */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["n" /* LoadingController */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["F" /* ToastController */],
            __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["b" /* AlertController */], __WEBPACK_IMPORTED_MODULE_4__text__["a" /* CoreTextUtilsProvider */], __WEBPACK_IMPORTED_MODULE_5__app__["a" /* CoreAppProvider */],
            __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["v" /* Platform */], __WEBPACK_IMPORTED_MODULE_6__config__["a" /* CoreConfigProvider */], __WEBPACK_IMPORTED_MODULE_8__url__["a" /* CoreUrlUtilsProvider */],
            __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["q" /* ModalController */], __WEBPACK_IMPORTED_MODULE_2__angular_platform_browser__["c" /* DomSanitizer */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["w" /* PopoverController */],
            __WEBPACK_IMPORTED_MODULE_9__providers_file__["a" /* CoreFileProvider */]])
    ], CoreDomUtilsProvider);
    return CoreDomUtilsProvider;
}());

//# sourceMappingURL=dom.js.map

/***/ }),
/* 5 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreLoggerProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_moment__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_moment___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_moment__);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};


/**
 * Helper service to display messages in the console.
 *
 * @description
 * This service is meant to improve log messages, adding a timestamp and a name to all log messages.
 *
 * In your class constructor, call getInstance to configure your class name:
 * this.logger = logger.getInstance('InitPage');
 *
 * Then you can call the log function you want to use in this logger instance.
 */
var CoreLoggerProvider = /** @class */ (function () {
    function CoreLoggerProvider() {
        /** Whether the logging is enabled. */
        this.enabled = true;
        // Nothing to do.
    }
    /**
     * Get a logger instance for a certain class, service or component.
     *
     * @param {string} className Name to use in the messages.
     * @return {ant} Instance.
     */
    CoreLoggerProvider.prototype.getInstance = function (className) {
        className = className || '';
        /* tslint:disable no-console */
        return {
            log: this.prepareLogFn(console.log.bind(console), className),
            info: this.prepareLogFn(console.info.bind(console), className),
            warn: this.prepareLogFn(console.warn.bind(console), className),
            debug: this.prepareLogFn(console.debug.bind(console), className),
            error: this.prepareLogFn(console.error.bind(console), className)
        };
    };
    /**
     * Prepare a logging function, concatenating the timestamp and class name to all messages.
     *
     * @param {Function} logFn Log function to use.
     * @param {string} className Name to use in the messages.
     * @return {Function} Prepared function.
     */
    CoreLoggerProvider.prototype.prepareLogFn = function (logFn, className) {
        var _this = this;
        // Return our own function that will call the logging function with the treated message.
        return function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            if (_this.enabled) {
                var now = __WEBPACK_IMPORTED_MODULE_1_moment__().format('l LTS');
                args[0] = now + ' ' + className + ': ' + args[0]; // Prepend timestamp and className to the original message.
                logFn.apply(null, args);
            }
        };
    };
    CoreLoggerProvider = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [])
    ], CoreLoggerProvider);
    return CoreLoggerProvider;
}());

//# sourceMappingURL=logger.js.map

/***/ }),
/* 6 */,
/* 7 */,
/* 8 */,
/* 9 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreAppProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ionic_native_keyboard__ = __webpack_require__(343);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__ionic_native_network__ = __webpack_require__(213);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__ionic_native_status_bar__ = __webpack_require__(552);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__db__ = __webpack_require__(424);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__logger__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__events__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__configconstants__ = __webpack_require__(119);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};









/**
 * Factory to provide some global functionalities, like access to the global app database.
 * @description
 * Each service or component should be responsible of creating their own database tables. Example:
 *
 * constructor(appProvider: CoreAppProvider) {
 *     this.appDB = appProvider.getDB();
 *     this.appDB.createTableFromSchema(this.tableSchema);
 * }
 */
var CoreAppProvider = /** @class */ (function () {
    function CoreAppProvider(dbProvider, platform, keyboard, appCtrl, network, logger, events, zone, menuCtrl, statusBar) {
        var _this = this;
        this.platform = platform;
        this.keyboard = keyboard;
        this.appCtrl = appCtrl;
        this.network = network;
        this.events = events;
        this.menuCtrl = menuCtrl;
        this.statusBar = statusBar;
        this.DBNAME = 'MoodleMobile';
        this.isKeyboardShown = false;
        this.backActions = [];
        this.mainMenuId = 0;
        this.forceOffline = false;
        this.logger = logger.getInstance('CoreAppProvider');
        this.db = dbProvider.getDB(this.DBNAME);
        this.keyboard.onKeyboardShow().subscribe(function (data) {
            // Execute the callback in the Angular zone, so change detection doesn't stop working.
            zone.run(function () {
                document.body.classList.add('keyboard-is-open');
                _this.isKeyboardShown = true;
                // Error on iOS calculating size.
                // More info: https://github.com/ionic-team/ionic-plugin-keyboard/issues/276 .
                events.trigger(__WEBPACK_IMPORTED_MODULE_7__events__["a" /* CoreEventsProvider */].KEYBOARD_CHANGE, data.keyboardHeight);
            });
        });
        this.keyboard.onKeyboardHide().subscribe(function (data) {
            // Execute the callback in the Angular zone, so change detection doesn't stop working.
            zone.run(function () {
                document.body.classList.remove('keyboard-is-open');
                _this.isKeyboardShown = false;
                events.trigger(__WEBPACK_IMPORTED_MODULE_7__events__["a" /* CoreEventsProvider */].KEYBOARD_CHANGE, 0);
            });
        });
        this.platform.registerBackButtonAction(function () {
            _this.backButtonAction();
        }, 100);
        // Export the app provider so Behat tests can change the forceOffline flag.
        window.appProvider = this;
    }
    /**
     * Check if the browser supports mediaDevices.getUserMedia.
     *
     * @return {boolean} Whether the function is supported.
     */
    CoreAppProvider.prototype.canGetUserMedia = function () {
        return !!(navigator && navigator.mediaDevices && navigator.mediaDevices.getUserMedia);
    };
    /**
     * Check if the browser supports MediaRecorder.
     *
     * @return {boolean} Whether the function is supported.
     */
    CoreAppProvider.prototype.canRecordMedia = function () {
        return !!window.MediaRecorder;
    };
    /**
     * Closes the keyboard.
     */
    CoreAppProvider.prototype.closeKeyboard = function () {
        if (this.isMobile()) {
            this.keyboard.hide();
        }
    };
    /**
     * Get the application global database.
     *
     * @return {SQLiteDB} App's DB.
     */
    CoreAppProvider.prototype.getDB = function () {
        return this.db;
    };
    /**
     * Get an ID for a main menu.
     *
     * @return {number} Main menu ID.
     */
    CoreAppProvider.prototype.getMainMenuId = function () {
        return this.mainMenuId++;
    };
    /**
     * Get the app's root NavController.
     *
     * @return {NavController} Root NavController.
     */
    CoreAppProvider.prototype.getRootNavController = function () {
        // Function getRootNav is deprecated. Get the first root nav, there should always be one.
        return this.appCtrl.getRootNavs()[0];
    };
    /**
     * Checks if the app is running in a 64 bits desktop environment (not browser).
     *
     * @return {boolean} Whether the app is running in a 64 bits desktop environment (not browser).
     */
    CoreAppProvider.prototype.is64Bits = function () {
        var process = window.process;
        return this.isDesktop() && process.arch == 'x64';
    };
    /**
     * Checks if the app is running in a desktop environment (not browser).
     *
     * @return {boolean} Whether the app is running in a desktop environment (not browser).
     */
    CoreAppProvider.prototype.isDesktop = function () {
        var process = window.process;
        return !!(process && process.versions && typeof process.versions.electron != 'undefined');
    };
    /**
     * Check if the keyboard is visible.
     *
     * @return {boolean} Whether keyboard is visible.
     */
    CoreAppProvider.prototype.isKeyboardVisible = function () {
        return this.isKeyboardShown;
    };
    /**
     * Check if the app is running in a Linux environment.
     *
     * @return {boolean} Whether it's running in a Linux environment.
     */
    CoreAppProvider.prototype.isLinux = function () {
        if (!this.isDesktop()) {
            return false;
        }
        try {
            return __webpack_require__(562).platform().indexOf('linux') === 0;
        }
        catch (ex) {
            return false;
        }
    };
    /**
     * Check if the app is running in a Mac OS environment.
     *
     * @return {boolean} Whether it's running in a Mac OS environment.
     */
    CoreAppProvider.prototype.isMac = function () {
        if (!this.isDesktop()) {
            return false;
        }
        try {
            return __webpack_require__(562).platform().indexOf('darwin') === 0;
        }
        catch (ex) {
            return false;
        }
    };
    /**
     * Check if the main menu is open.
     *
     * @return {boolean} Whether the main menu is open.
     */
    CoreAppProvider.prototype.isMainMenuOpen = function () {
        return typeof this.mainMenuOpen != 'undefined';
    };
    /**
     * Checks if the app is running in a mobile or tablet device (Cordova).
     *
     * @return {boolean} Whether the app is running in a mobile or tablet device.
     */
    CoreAppProvider.prototype.isMobile = function () {
        return this.platform.is('cordova');
    };
    /**
     * Checks if the current window is wider than a mobile.
     *
     * @return {boolean} Whether the app the current window is wider than a mobile.
     */
    CoreAppProvider.prototype.isWide = function () {
        return this.platform.width() > 768;
    };
    /**
     * Returns whether we are online.
     *
     * @return {boolean} Whether the app is online.
     */
    CoreAppProvider.prototype.isOnline = function () {
        if (this.forceOffline) {
            return false;
        }
        var online = this.network.type !== null && this.network.type != Connection.NONE && this.network.type != Connection.UNKNOWN;
        // Double check we are not online because we cannot rely 100% in Cordova APIs. Also, check it in browser.
        if (!online && navigator.onLine) {
            online = true;
        }
        return online;
    };
    /**
     * Check if device uses a limited connection.
     *
     * @return {boolean} Whether the device uses a limited connection.
     */
    CoreAppProvider.prototype.isNetworkAccessLimited = function () {
        var type = this.network.type;
        if (type === null) {
            // Plugin not defined, probably in browser.
            return false;
        }
        var limited = [Connection.CELL_2G, Connection.CELL_3G, Connection.CELL_4G, Connection.CELL];
        return limited.indexOf(type) > -1;
    };
    /**
     * Check if device uses a wifi connection.
     *
     * @return {boolean} Whether the device uses a wifi connection.
     */
    CoreAppProvider.prototype.isWifi = function () {
        return this.isOnline() && !this.isNetworkAccessLimited();
    };
    /**
     * Check if the app is running in a Windows environment.
     *
     * @return {boolean} Whether it's running in a Windows environment.
     */
    CoreAppProvider.prototype.isWindows = function () {
        if (!this.isDesktop()) {
            return false;
        }
        try {
            return __webpack_require__(562).platform().indexOf('win') === 0;
        }
        catch (ex) {
            return false;
        }
    };
    /**
     * Open the keyboard.
     */
    CoreAppProvider.prototype.openKeyboard = function () {
        // Open keyboard is not supported in desktop and in iOS.
        if (this.isMobile() && !this.platform.is('ios')) {
            this.keyboard.show();
        }
    };
    /**
     * Set a main menu as open or not.
     *
     * @param {number} id Main menu ID.
     * @param {boolean} open Whether it's open or not.
     */
    CoreAppProvider.prototype.setMainMenuOpen = function (id, open) {
        if (open) {
            this.mainMenuOpen = id;
            this.events.trigger(__WEBPACK_IMPORTED_MODULE_7__events__["a" /* CoreEventsProvider */].MAIN_MENU_OPEN);
        }
        else if (this.mainMenuOpen == id) {
            delete this.mainMenuOpen;
        }
    };
    /**
     * Start an SSO authentication process.
     * Please notice that this function should be called when the app receives the new token from the browser,
     * NOT when the browser is opened.
     */
    CoreAppProvider.prototype.startSSOAuthentication = function () {
        var _this = this;
        var cancelTimeout, resolvePromise;
        this.ssoAuthenticationPromise = new Promise(function (resolve, reject) {
            resolvePromise = resolve;
            // Resolve it automatically after 10 seconds (it should never take that long).
            cancelTimeout = setTimeout(function () {
                _this.finishSSOAuthentication();
            }, 10000);
        });
        // Store the resolve function in the promise itself.
        this.ssoAuthenticationPromise.resolve = resolvePromise;
        // If the promise is resolved because finishSSOAuthentication is called, stop the cancel promise.
        this.ssoAuthenticationPromise.then(function () {
            clearTimeout(cancelTimeout);
        });
    };
    /**
     * Finish an SSO authentication process.
     */
    CoreAppProvider.prototype.finishSSOAuthentication = function () {
        if (this.ssoAuthenticationPromise) {
            this.ssoAuthenticationPromise.resolve && this.ssoAuthenticationPromise.resolve();
            this.ssoAuthenticationPromise = undefined;
        }
    };
    /**
     * Check if there's an ongoing SSO authentication process.
     *
     * @return {boolean} Whether there's a SSO authentication ongoing.
     */
    CoreAppProvider.prototype.isSSOAuthenticationOngoing = function () {
        return !!this.ssoAuthenticationPromise;
    };
    /**
     * Returns a promise that will be resolved once SSO authentication finishes.
     *
     * @return {Promise<any>} Promise resolved once SSO authentication finishes.
     */
    CoreAppProvider.prototype.waitForSSOAuthentication = function () {
        return this.ssoAuthenticationPromise || Promise.resolve();
    };
    /**
     * Retrieve redirect data.
     *
     * @return {CoreRedirectData} Object with siteid, state, params and timemodified.
     */
    CoreAppProvider.prototype.getRedirect = function () {
        if (localStorage && localStorage.getItem) {
            try {
                var data = {
                    siteId: localStorage.getItem('CoreRedirectSiteId'),
                    page: localStorage.getItem('CoreRedirectState'),
                    params: localStorage.getItem('CoreRedirectParams'),
                    timemodified: parseInt(localStorage.getItem('CoreRedirectTime'), 10)
                };
                if (data.params) {
                    data.params = JSON.parse(data.params);
                }
                return data;
            }
            catch (ex) {
                this.logger.error('Error loading redirect data:', ex);
            }
        }
        return {};
    };
    /**
     * Store redirect params.
     *
     * @param {string} siteId Site ID.
     * @param {string} page Page to go.
     * @param {any} params Page params.
     */
    CoreAppProvider.prototype.storeRedirect = function (siteId, page, params) {
        if (localStorage && localStorage.setItem) {
            try {
                localStorage.setItem('CoreRedirectSiteId', siteId);
                localStorage.setItem('CoreRedirectState', page);
                localStorage.setItem('CoreRedirectParams', JSON.stringify(params));
                localStorage.setItem('CoreRedirectTime', String(Date.now()));
            }
            catch (ex) {
                // Ignore errors.
            }
        }
    };
    /**
     * Implement the backbutton actions pile.
     */
    CoreAppProvider.prototype.backButtonAction = function () {
        var x = 0;
        for (; x < this.backActions.length; x++) {
            if (this.backActions[x].priority < 1000) {
                break;
            }
            // Stop in the first action taken.
            if (this.backActions[x].fn()) {
                return;
            }
        }
        // Close open modals if any.
        if (this.menuCtrl && this.menuCtrl.isOpen()) {
            this.menuCtrl.close();
            return;
        }
        // Remaining actions will have priority less than 1000.
        for (; x < this.backActions.length; x++) {
            if (this.backActions[x].priority < 500) {
                break;
            }
            // Stop in the first action taken.
            if (this.backActions[x].fn()) {
                return;
            }
        }
        // Nothing found, go back.
        var navPromise = this.appCtrl.navPop();
        if (navPromise) {
            return;
        }
        // No views to go back to.
        // Remaining actions will have priority less than 500.
        for (; x < this.backActions.length; x++) {
            // Stop in the first action taken.
            if (this.backActions[x].fn()) {
                return;
            }
        }
        // Ionic will decide (exit the app).
        this.appCtrl.goBack();
    };
    /**
     * The back button event is triggered when the user presses the native
     * platform's back button, also referred to as the "hardware" back button.
     * This event is only used within Cordova apps running on Android and
     * Windows platforms. This event is not fired on iOS since iOS doesn't come
     * with a hardware back button in the same sense an Android or Windows device
     * does.
     *
     * Registering a hardware back button action and setting a priority allows
     * apps to control which action should be called when the hardware back
     * button is pressed. This method decides which of the registered back button
     * actions has the highest priority and should be called.
     *
     * @param {Function} fn Called when the back button is pressed,
     * if this registered action has the highest priority.
     * @param {number} priority Set the priority for this action. All actions sorted by priority will be executed since one of
     * them returns true.
     *   * Priorities higher or equal than 1000 will go before closing modals
     *   * Priorities lower than 500 will only be executed if you are in the first state of the app (before exit).
     * @returns {Function} A function that, when called, will unregister
     * the back button action.
     */
    CoreAppProvider.prototype.registerBackButtonAction = function (fn, priority) {
        var _this = this;
        if (priority === void 0) { priority = 0; }
        var action = { fn: fn, priority: priority };
        this.backActions.push(action);
        this.backActions.sort(function (a, b) {
            return b.priority - a.priority;
        });
        return function () {
            var index = _this.backActions.indexOf(action);
            return index >= 0 && !!_this.backActions.splice(index, 1);
        };
    };
    /**
     * Set StatusBar color depending on platform.
     */
    CoreAppProvider.prototype.setStatusBarColor = function () {
        if (typeof __WEBPACK_IMPORTED_MODULE_8__configconstants__["a" /* CoreConfigConstants */].statusbarbgios == 'string' && this.platform.is('ios')) {
            // IOS Status bar properties.
            this.statusBar.overlaysWebView(false);
            this.statusBar.backgroundColorByHexString(__WEBPACK_IMPORTED_MODULE_8__configconstants__["a" /* CoreConfigConstants */].statusbarbgios);
            __WEBPACK_IMPORTED_MODULE_8__configconstants__["a" /* CoreConfigConstants */].statusbarlighttextios ? this.statusBar.styleLightContent() : this.statusBar.styleDefault();
        }
        else if (typeof __WEBPACK_IMPORTED_MODULE_8__configconstants__["a" /* CoreConfigConstants */].statusbarbgandroid == 'string' && this.platform.is('android')) {
            // Android Status bar properties.
            this.statusBar.backgroundColorByHexString(__WEBPACK_IMPORTED_MODULE_8__configconstants__["a" /* CoreConfigConstants */].statusbarbgandroid);
            __WEBPACK_IMPORTED_MODULE_8__configconstants__["a" /* CoreConfigConstants */].statusbarlighttextandroid ? this.statusBar.styleLightContent() : this.statusBar.styleDefault();
        }
        else if (typeof __WEBPACK_IMPORTED_MODULE_8__configconstants__["a" /* CoreConfigConstants */].statusbarbg == 'string') {
            // Generic Status bar properties.
            this.platform.is('ios') && this.statusBar.overlaysWebView(false);
            this.statusBar.backgroundColorByHexString(__WEBPACK_IMPORTED_MODULE_8__configconstants__["a" /* CoreConfigConstants */].statusbarbg);
            __WEBPACK_IMPORTED_MODULE_8__configconstants__["a" /* CoreConfigConstants */].statusbarlighttext ? this.statusBar.styleLightContent() : this.statusBar.styleDefault();
        }
        else {
            // Default Status bar properties.
            this.platform.is('android') ? this.statusBar.styleLightContent() : this.statusBar.styleDefault();
        }
    };
    /**
     * Reset StatusBar color if any was set.
     */
    CoreAppProvider.prototype.resetStatusBarColor = function () {
        if (typeof __WEBPACK_IMPORTED_MODULE_8__configconstants__["a" /* CoreConfigConstants */].statusbarbgremotetheme == 'string' &&
            ((typeof __WEBPACK_IMPORTED_MODULE_8__configconstants__["a" /* CoreConfigConstants */].statusbarbgios == 'string' && this.platform.is('ios')) ||
                (typeof __WEBPACK_IMPORTED_MODULE_8__configconstants__["a" /* CoreConfigConstants */].statusbarbgandroid == 'string' && this.platform.is('android')) ||
                typeof __WEBPACK_IMPORTED_MODULE_8__configconstants__["a" /* CoreConfigConstants */].statusbarbg == 'string')) {
            // If the status bar has been overriden and there's a fallback color for remote themes, use it now.
            this.platform.is('ios') && this.statusBar.overlaysWebView(false);
            this.statusBar.backgroundColorByHexString(__WEBPACK_IMPORTED_MODULE_8__configconstants__["a" /* CoreConfigConstants */].statusbarbgremotetheme);
            __WEBPACK_IMPORTED_MODULE_8__configconstants__["a" /* CoreConfigConstants */].statusbarlighttextremotetheme ?
                this.statusBar.styleLightContent() : this.statusBar.styleDefault();
        }
    };
    /**
     * Set value of forceOffline flag. If true, the app will think the device is offline.
     *
     * @param {boolean} value Value to set.
     */
    CoreAppProvider.prototype.setForceOffline = function (value) {
        this.forceOffline = !!value;
    };
    CoreAppProvider = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_5__db__["a" /* CoreDbProvider */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["v" /* Platform */], __WEBPACK_IMPORTED_MODULE_2__ionic_native_keyboard__["a" /* Keyboard */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["c" /* App */],
            __WEBPACK_IMPORTED_MODULE_3__ionic_native_network__["a" /* Network */], __WEBPACK_IMPORTED_MODULE_6__logger__["a" /* CoreLoggerProvider */], __WEBPACK_IMPORTED_MODULE_7__events__["a" /* CoreEventsProvider */], __WEBPACK_IMPORTED_MODULE_0__angular_core__["M" /* NgZone */],
            __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["p" /* MenuController */], __WEBPACK_IMPORTED_MODULE_4__ionic_native_status_bar__["a" /* StatusBar */]])
    ], CoreAppProvider);
    return CoreAppProvider;
}());

//# sourceMappingURL=app.js.map

/***/ }),
/* 10 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreTextUtilsProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_platform_browser__ = __webpack_require__(79);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ionic_angular__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__ngx_translate_core__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__lang__ = __webpack_require__(170);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};





/*
 * "Utils" service with helper functions for text.
*/
var CoreTextUtilsProvider = /** @class */ (function () {
    function CoreTextUtilsProvider(translate, langProvider, modalCtrl, sanitizer, platform) {
        this.translate = translate;
        this.langProvider = langProvider;
        this.modalCtrl = modalCtrl;
        this.sanitizer = sanitizer;
        this.platform = platform;
        // List of regular expressions to convert the old nomenclature to new nomenclature for disabled features.
        this.DISABLED_FEATURES_COMPAT_REGEXPS = [
            { old: /\$mmLoginEmailSignup/g, new: 'CoreLoginEmailSignup' },
            { old: /\$mmSideMenuDelegate/g, new: 'CoreMainMenuDelegate' },
            { old: /\$mmCoursesDelegate/g, new: 'CoreCourseOptionsDelegate' },
            { old: /\$mmUserDelegate/g, new: 'CoreUserDelegate' },
            { old: /\$mmCourseDelegate/g, new: 'CoreCourseModuleDelegate' },
            { old: /_mmCourses/g, new: '_CoreCourses' },
            { old: /_mmaFrontpage/g, new: '_CoreSiteHome' },
            { old: /_mmaGrades/g, new: '_CoreGrades' },
            { old: /_mmaCompetency/g, new: '_AddonCompetency' },
            { old: /_mmaNotifications/g, new: '_AddonNotifications' },
            { old: /_mmaMessages/g, new: '_AddonMessages' },
            { old: /_mmaCalendar/g, new: '_AddonCalendar' },
            { old: /_mmaFiles/g, new: '_AddonFiles' },
            { old: /_mmaParticipants/g, new: '_CoreUserParticipants' },
            { old: /_mmaCourseCompletion/g, new: '_AddonCourseCompletion' },
            { old: /_mmaNotes/g, new: '_AddonNotes' },
            { old: /_mmaBadges/g, new: '_AddonBadges' },
            { old: /files_privatefiles/g, new: 'AddonFilesPrivateFiles' },
            { old: /files_sitefiles/g, new: 'AddonFilesSiteFiles' },
            { old: /files_upload/g, new: 'AddonFilesUpload' },
            { old: /_mmaModAssign/g, new: '_AddonModAssign' },
            { old: /_mmaModBook/g, new: '_AddonModBook' },
            { old: /_mmaModChat/g, new: '_AddonModChat' },
            { old: /_mmaModChoice/g, new: '_AddonModChoice' },
            { old: /_mmaModData/g, new: '_AddonModData' },
            { old: /_mmaModFeedback/g, new: '_AddonModFeedback' },
            { old: /_mmaModFolder/g, new: '_AddonModFolder' },
            { old: /_mmaModForum/g, new: '_AddonModForum' },
            { old: /_mmaModGlossary/g, new: '_AddonModGlossary' },
            { old: /_mmaModImscp/g, new: '_AddonModImscp' },
            { old: /_mmaModLabel/g, new: '_AddonModLabel' },
            { old: /_mmaModLesson/g, new: '_AddonModLesson' },
            { old: /_mmaModLti/g, new: '_AddonModLti' },
            { old: /_mmaModPage/g, new: '_AddonModPage' },
            { old: /_mmaModQuiz/g, new: '_AddonModQuiz' },
            { old: /_mmaModResource/g, new: '_AddonModResource' },
            { old: /_mmaModScorm/g, new: '_AddonModScorm' },
            { old: /_mmaModSurvey/g, new: '_AddonModSurvey' },
            { old: /_mmaModUrl/g, new: '_AddonModUrl' },
            { old: /_mmaModWiki/g, new: '_AddonModWiki' },
            { old: /_mmaModWorkshop/g, new: '_AddonModWorkshop' },
            { old: /remoteAddOn_/g, new: 'sitePlugin_' },
        ];
        this.template = document.createElement('template'); // A template element to convert HTML to element.
    }
    /**
     * Given an address as a string, return a URL to open the address in maps.
     *
     * @param {string} address The address.
     * @return {SafeUrl} URL to view the address.
     */
    CoreTextUtilsProvider.prototype.buildAddressURL = function (address) {
        return this.sanitizer.bypassSecurityTrustUrl((this.platform.is('android') ? 'geo:0,0?q=' : 'http://maps.google.com?q=') +
            encodeURIComponent(address));
    };
    /**
     * Given a list of sentences, build a message with all of them wrapped in <p>.
     *
     * @param {string[]} messages Messages to show.
     * @return {string} Message with all the messages.
     */
    CoreTextUtilsProvider.prototype.buildMessage = function (messages) {
        var result = '';
        messages.forEach(function (message) {
            if (message) {
                result += "<p>" + message + "</p>";
            }
        });
        return result;
    };
    /**
     * Convert size in bytes into human readable format
     *
     * @param {number} bytes Number of bytes to convert.
     * @param {number} [precision=2] Number of digits after the decimal separator.
     * @return {string} Size in human readable format.
     */
    CoreTextUtilsProvider.prototype.bytesToSize = function (bytes, precision) {
        if (precision === void 0) { precision = 2; }
        if (typeof bytes == 'undefined' || bytes === null || bytes < 0) {
            return this.translate.instant('core.notapplicable');
        }
        if (precision < 0) {
            precision = 2;
        }
        var keys = ['core.sizeb', 'core.sizekb', 'core.sizemb', 'core.sizegb', 'core.sizetb'], units = this.translate.instant(keys);
        var pos = 0;
        if (bytes >= 1024) {
            while (bytes >= 1024) {
                pos++;
                bytes = bytes / 1024;
            }
            // Round to "precision" decimals if needed.
            bytes = Number(Math.round(parseFloat(bytes + 'e+' + precision)) + 'e-' + precision);
        }
        return this.translate.instant('core.humanreadablesize', { size: bytes, unit: units[keys[pos]] });
    };
    /**
     * Clean HTML tags.
     *
     * @param {string} text The text to be cleaned.
     * @param {boolean} [singleLine] True if new lines should be removed (all the text in a single line).
     * @return {string} Clean text.
     */
    CoreTextUtilsProvider.prototype.cleanTags = function (text, singleLine) {
        if (typeof text != 'string') {
            return text;
        }
        if (!text) {
            return '';
        }
        // First, we use a regexpr.
        text = text.replace(/(<([^>]+)>)/ig, '');
        // Then, we rely on the browser. We need to wrap the text to be sure is HTML.
        var element = this.convertToElement(text);
        text = element.textContent;
        // Recover or remove new lines.
        text = this.replaceNewLines(text, singleLine ? ' ' : '<br>');
        return text;
    };
    /**
     * Concatenate two paths, adding a slash between them if needed.
     *
     * @param {string} leftPath Left path.
     * @param {string} rightPath Right path.
     * @return {string} Concatenated path.
     */
    CoreTextUtilsProvider.prototype.concatenatePaths = function (leftPath, rightPath) {
        if (!leftPath) {
            return rightPath;
        }
        else if (!rightPath) {
            return leftPath;
        }
        var lastCharLeft = leftPath.slice(-1), firstCharRight = rightPath.charAt(0);
        if (lastCharLeft === '/' && firstCharRight === '/') {
            return leftPath + rightPath.substr(1);
        }
        else if (lastCharLeft !== '/' && firstCharRight !== '/') {
            return leftPath + '/' + rightPath;
        }
        else {
            return leftPath + rightPath;
        }
    };
    /**
     * Convert some HTML as text into an HTMLElement. This HTML is put inside a div or a body.
     * This function is the same as in DomUtils, but we cannot use that one because of circular dependencies.
     *
     * @param {string} html Text to convert.
     * @return {HTMLElement} Element.
     */
    CoreTextUtilsProvider.prototype.convertToElement = function (html) {
        // Add a div to hold the content, that's the element that will be returned.
        this.template.innerHTML = '<div>' + html + '</div>';
        return this.template.content.children[0];
    };
    /**
     * Count words in a text.
     *
     * @param {string} text Text to count.
     * @return {number} Number of words.
     */
    CoreTextUtilsProvider.prototype.countWords = function (text) {
        if (!text || typeof text != 'string') {
            return 0;
        }
        var blockTags = ['address', 'article', 'aside', 'blockquote', 'br', ' details', 'dialog', 'dd', 'div', 'dl', 'dt',
            'fieldset', 'figcaption', 'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'hgroup', 'hr',
            'li', 'main', 'nav', 'ol', 'p', 'pre', 'section', 'table', 'ul'];
        // Clean HTML scripts and tags.
        text = text.replace(/<script[^>]*>([\S\s]*?)<\/script>/gmi, '');
        // Replace block tags by space to get word count aware of line break and remove inline tags.
        text = text.replace(/<(\/[ ]*)?([a-zA-Z0-9]+)[^>]*>/gi, function (str, p1, match) {
            if (blockTags.indexOf(match) >= 0) {
                return ' ';
            }
            return '';
        });
        // Decode HTML entities.
        text = this.decodeHTMLEntities(text);
        // Replace underscores (which are classed as word characters) with spaces.
        text = text.replace(/_/gi, ' ');
        // This RegEx will detect any word change including Unicode chars. Some languages without spaces won't be counted fine.
        return text.match(/\S+/gi).length;
    };
    /**
     * Decode an escaped HTML text. This implementation is based on PHP's htmlspecialchars_decode.
     *
     * @param {string|number} text Text to decode.
     * @return {string} Decoded text.
     */
    CoreTextUtilsProvider.prototype.decodeHTML = function (text) {
        if (typeof text == 'undefined' || text === null || (typeof text == 'number' && isNaN(text))) {
            return '';
        }
        else if (typeof text != 'string') {
            return '' + text;
        }
        return text
            .replace(/&amp;/g, '&')
            .replace(/&lt;/g, '<')
            .replace(/&gt;/g, '>')
            .replace(/&quot;/g, '"')
            .replace(/&#039;/g, '\'')
            .replace(/&nbsp;/g, ' ');
    };
    /**
     * Decode HTML entities in a text. Equivalent to PHP html_entity_decode.
     *
     * @param {string} text Text to decode.
     * @return {string} Decoded text.
     */
    CoreTextUtilsProvider.prototype.decodeHTMLEntities = function (text) {
        if (text) {
            var element = this.convertToElement(text);
            text = element.textContent;
        }
        return text;
    };
    /**
     * Same as Javascript's decodeURI, but if an exception is thrown it will return the original URI.
     *
     * @param {string} uri URI to decode.
     * @return {string} Decoded URI, or original URI if an exception is thrown.
     */
    CoreTextUtilsProvider.prototype.decodeURI = function (uri) {
        try {
            return decodeURI(uri);
        }
        catch (ex) {
            // Error, use the original URI.
        }
        return uri;
    };
    /**
     * Same as Javascript's decodeURIComponent, but if an exception is thrown it will return the original URI.
     *
     * @param {string} uri URI to decode.
     * @return {string} Decoded URI, or original URI if an exception is thrown.
     */
    CoreTextUtilsProvider.prototype.decodeURIComponent = function (uri) {
        try {
            return decodeURIComponent(uri);
        }
        catch (ex) {
            // Error, use the original URI.
        }
        return uri;
    };
    /**
     * Escapes some characters in a string to be used as a regular expression.
     *
     * @param {string} text Text to escape.
     * @return {string} Escaped text.
     */
    CoreTextUtilsProvider.prototype.escapeForRegex = function (text) {
        if (!text || typeof text != 'string') {
            return '';
        }
        return text.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
    };
    /**
     * Escape an HTML text. This implementation is based on PHP's htmlspecialchars.
     *
     * @param {string|number} text Text to escape.
     * @return {string} Escaped text.
     */
    CoreTextUtilsProvider.prototype.escapeHTML = function (text) {
        if (typeof text == 'undefined' || text === null || (typeof text == 'number' && isNaN(text))) {
            return '';
        }
        else if (typeof text != 'string') {
            return '' + text;
        }
        return text
            .replace(/&/g, '&amp;')
            .replace(/</g, '&lt;')
            .replace(/>/g, '&gt;')
            .replace(/"/g, '&quot;')
            .replace(/'/g, '&#039;');
    };
    /**
     * Shows a text on a new page.
     *
     * @param {string} title Title of the new state.
     * @param {string} text Content of the text to be expanded.
     * @param {string} [component] Component to link the embedded files to.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @param {any[]} [files] List of files to display along with the text.
     */
    CoreTextUtilsProvider.prototype.expandText = function (title, text, component, componentId, files) {
        if (text.length > 0) {
            var params = {
                title: title,
                content: text,
                component: component,
                componentId: componentId,
                files: files
            };
            // Open a modal with the contents.
            params.isModal = true;
            var modal = this.modalCtrl.create('CoreViewerTextPage', params);
            modal.present();
        }
    };
    /**
     * Formats a text, in HTML replacing new lines by correct html new lines.
     *
     * @param {string} text Text to format.
     * @return {string} Formatted text.
     */
    CoreTextUtilsProvider.prototype.formatHtmlLines = function (text) {
        var hasHTMLTags = this.hasHTMLTags(text);
        if (text.indexOf('<p>') == -1) {
            // Wrap the text in <p> tags.
            text = '<p>' + text + '</p>';
        }
        if (!hasHTMLTags) {
            // The text doesn't have HTML, replace new lines for <br>.
            return this.replaceNewLines(text, '<br>');
        }
        return text;
    };
    /**
     * Formats a text, treating multilang tags and cleaning HTML if needed.
     *
     * @param {string} text Text to format.
     * @param {boolean} [clean] Whether HTML tags should be removed.
     * @param {boolean} [singleLine] Whether new lines should be removed. Only valid if clean is true.
     * @param {number} [shortenLength] Number of characters to shorten the text.
     * @param {number} [highlight] Text to highlight.
     * @return {Promise<string>} Promise resolved with the formatted text.
     */
    CoreTextUtilsProvider.prototype.formatText = function (text, clean, singleLine, shortenLength, highlight) {
        var _this = this;
        return this.treatMultilangTags(text).then(function (formatted) {
            if (clean) {
                formatted = _this.cleanTags(formatted, singleLine);
            }
            if (shortenLength > 0) {
                formatted = _this.shortenText(formatted, shortenLength);
            }
            if (highlight) {
                formatted = _this.highlightText(formatted, highlight);
            }
            return formatted;
        });
    };
    /**
     * Get the error message from an error object.
     *
     * @param {any} error Error object.
     * @return {string} Error message, undefined if not found.
     */
    CoreTextUtilsProvider.prototype.getErrorMessageFromError = function (error) {
        if (typeof error == 'string') {
            return error;
        }
        return error && (error.message || error.error || error.content || error.body);
    };
    /**
     * Get the pluginfile URL to replace @@PLUGINFILE@@ wildcards.
     *
     * @param {any[]} files Files to extract the URL from. They need to have the URL in a 'url' or 'fileurl' attribute.
     * @return {string} Pluginfile URL, undefined if no files found.
     */
    CoreTextUtilsProvider.prototype.getTextPluginfileUrl = function (files) {
        if (files && files.length) {
            var fileURL = files[0].url || files[0].fileurl;
            // Remove text after last slash (encoded or not).
            return fileURL.substr(0, Math.max(fileURL.lastIndexOf('/'), fileURL.lastIndexOf('%2F')));
        }
        return undefined;
    };
    /**
     * Check if a text contains HTML tags.
     *
     * @param {string} text Text to check.
     * @return {boolean} Whether it has HTML tags.
     */
    CoreTextUtilsProvider.prototype.hasHTMLTags = function (text) {
        return /<[a-z][\s\S]*>/i.test(text);
    };
    /**
     * Highlight all occurrences of a certain text inside another text. It will add some HTML code to highlight it.
     *
     * @param {string} text Full text.
     * @param {string} searchText Text to search and highlight.
     * @return {string} Highlighted text.
     */
    CoreTextUtilsProvider.prototype.highlightText = function (text, searchText) {
        if (!text || typeof text != 'string') {
            return '';
        }
        else if (!searchText) {
            return text;
        }
        var regex = new RegExp('(' + searchText + ')', 'gi');
        return text.replace(regex, '<span class="matchtext">$1</span>');
    };
    /**
     * Check if HTML content is blank.
     *
     * @param {string} content HTML content.
     * @return {boolean} True if the string does not contain actual content: text, images, etc.
     */
    CoreTextUtilsProvider.prototype.htmlIsBlank = function (content) {
        if (!content) {
            return true;
        }
        var div = document.createElement('div');
        div.innerHTML = content;
        return div.textContent === '' && div.querySelector('img, object, hr') === null;
    };
    /**
     * Check if a text contains Unicode long chars.
     * Using as threshold Hex value D800
     *
     * @param {string} text Text to check.
     * @return {boolean} True if has Unicode chars, false otherwise.
     */
    CoreTextUtilsProvider.prototype.hasUnicode = function (text) {
        for (var x = 0; x < text.length; x++) {
            if (text.charCodeAt(x) > 55295) {
                return true;
            }
        }
        return false;
    };
    /**
     * Check if an object has any long Unicode char.
     *
     * @param {object} data Object to be checked.
     * @return {boolean} If the data has any long Unicode char on it.
     */
    CoreTextUtilsProvider.prototype.hasUnicodeData = function (data) {
        for (var el in data) {
            if (typeof data[el] == 'object') {
                if (this.hasUnicodeData(data[el])) {
                    return true;
                }
            }
            else if (typeof data[el] == 'string' && this.hasUnicode(data[el])) {
                return true;
            }
        }
        return false;
    };
    /**
     * Same as Javascript's JSON.parse, but it will handle errors.
     *
     * @param {string} json JSON text.
     * @param {any} [defaultValue] Default value t oreturn if the parse fails. Defaults to the original value.
     * @param {Function} [logErrorFn] An error to call with the exception to log the error. If not supplied, no error.
     * @return {any} JSON parsed as object or what it gets.
     */
    CoreTextUtilsProvider.prototype.parseJSON = function (json, defaultValue, logErrorFn) {
        try {
            return JSON.parse(json);
        }
        catch (ex) {
            // Error, log the error if needed.
            if (logErrorFn) {
                logErrorFn(ex);
            }
        }
        // Error parsing, return the default value or the original value.
        return typeof defaultValue != 'undefined' ? defaultValue : json;
    };
    /**
     * Remove ending slash from a path or URL.
     *
     * @param {string} text Text to treat.
     * @return {string} Treated text.
     */
    CoreTextUtilsProvider.prototype.removeEndingSlash = function (text) {
        if (!text) {
            return '';
        }
        if (text.slice(-1) == '/') {
            return text.substr(0, text.length - 1);
        }
        return text;
    };
    /**
     * Replace all characters that cause problems with files in Android and iOS.
     *
     * @param {string} text Text to treat.
     * @return {string} Treated text.
     */
    CoreTextUtilsProvider.prototype.removeSpecialCharactersForFiles = function (text) {
        if (!text || typeof text != 'string') {
            return '';
        }
        return text.replace(/[#:\/\?\\]+/g, '_');
    };
    /**
     * Replace all the new lines on a certain text.
     *
     * @param {string} text The text to be treated.
     * @param {string} newValue Text to use instead of new lines.
     * @return {string} Treated text.
     */
    CoreTextUtilsProvider.prototype.replaceNewLines = function (text, newValue) {
        if (!text || typeof text != 'string') {
            return '';
        }
        return text.replace(/(?:\r\n|\r|\n)/g, newValue);
    };
    /**
     * Replace @@PLUGINFILE@@ wildcards with the real URL in a text.
     *
     * @param {string} Text to treat.
     * @param {any[]} files Files to extract the pluginfile URL from. They need to have the URL in a url or fileurl attribute.
     * @return {string} Treated text.
     */
    CoreTextUtilsProvider.prototype.replacePluginfileUrls = function (text, files) {
        if (text && typeof text == 'string') {
            var fileURL = this.getTextPluginfileUrl(files);
            if (fileURL) {
                return text.replace(/@@PLUGINFILE@@/g, fileURL);
            }
        }
        return text;
    };
    /**
     * Replace pluginfile URLs with @@PLUGINFILE@@ wildcards.
     *
     * @param {string} text Text to treat.
     * @param {any[]} files Files to extract the pluginfile URL from. They need to have the URL in a url or fileurl attribute.
     * @return {string} Treated text.
     */
    CoreTextUtilsProvider.prototype.restorePluginfileUrls = function (text, files) {
        if (text && typeof text == 'string') {
            var fileURL = this.getTextPluginfileUrl(files);
            if (fileURL) {
                return text.replace(new RegExp(this.escapeForRegex(fileURL), 'g'), '@@PLUGINFILE@@');
            }
        }
        return text;
    };
    /**
     * Rounds a number to use a certain amout of decimals or less.
     * Difference between this function and float's toFixed:
     * 7.toFixed(2) -> 7.00
     * roundToDecimals(7, 2) -> 7
     *
     * @param {number} num Number to round.
     * @param {number} [decimals=2] Number of decimals. By default, 2.
     * @return {number} Rounded number.
     */
    CoreTextUtilsProvider.prototype.roundToDecimals = function (num, decimals) {
        if (decimals === void 0) { decimals = 2; }
        var multiplier = Math.pow(10, decimals);
        return Math.round(num * multiplier) / multiplier;
    };
    /**
     * Add quotes to HTML characters.
     *
     * Returns text with HTML characters (like "<", ">", etc.) properly quoted.
     * Based on Moodle's s() function.
     *
     * @param {string} text Text to treat.
     * @return {string} Treated text.
     */
    CoreTextUtilsProvider.prototype.s = function (text) {
        if (!text) {
            return '';
        }
        return this.escapeHTML(text).replace(/&amp;#(\d+|x[0-9a-f]+);/i, '&#$1;');
    };
    /**
     * Shortens a text to length and adds an ellipsis.
     *
     * @param {string} text The text to be shortened.
     * @param {number} length The desired length.
     * @return {string} Shortened text.
     */
    CoreTextUtilsProvider.prototype.shortenText = function (text, length) {
        if (text.length > length) {
            text = text.substr(0, length);
            // Now, truncate at the last word boundary (if exists).
            var lastWordPos = text.lastIndexOf(' ');
            if (lastWordPos > 0) {
                text = text.substr(0, lastWordPos);
            }
            text += '&hellip;';
        }
        return text;
    };
    /**
     * Strip Unicode long char of a given text.
     * Using as threshold Hex value D800
     *
     * @param {string} text Text to check.
     * @return {string} Without the Unicode chars.
     */
    CoreTextUtilsProvider.prototype.stripUnicode = function (text) {
        var stripped = '';
        for (var x = 0; x < text.length; x++) {
            if (text.charCodeAt(x) <= 55295) {
                stripped += text.charAt(x);
            }
        }
        return stripped;
    };
    /**
     * Treat the list of disabled features, replacing old nomenclature with the new one.
     *
     * @param {string} features List of disabled features.
     * @return {string} Treated list.
     */
    CoreTextUtilsProvider.prototype.treatDisabledFeatures = function (features) {
        if (!features) {
            return '';
        }
        for (var i = 0; i < this.DISABLED_FEATURES_COMPAT_REGEXPS.length; i++) {
            var entry = this.DISABLED_FEATURES_COMPAT_REGEXPS[i];
            features = features.replace(entry.old, entry.new);
        }
        return features;
    };
    /**
     * Treat the multilang tags from a HTML code, leaving only the current language.
     *
     * @param {string} text The text to be treated.
     * @return {Promise<string>} Promise resolved with the formatted text.
     */
    CoreTextUtilsProvider.prototype.treatMultilangTags = function (text) {
        if (!text || typeof text != 'string') {
            return Promise.resolve('');
        }
        return this.langProvider.getCurrentLanguage().then(function (language) {
            // Match the current language.
            var anyLangRegEx = /<(?:lang|span)[^>]+lang="[a-zA-Z0-9_-]+"[^>]*>(.*?)<\/(?:lang|span)>/g;
            var currentLangRegEx = new RegExp('<(?:lang|span)[^>]+lang="' + language + '"[^>]*>(.*?)<\/(?:lang|span)>', 'g');
            if (!text.match(currentLangRegEx)) {
                // Current lang not found. Try to find the first language.
                var matches = text.match(anyLangRegEx);
                if (matches && matches[0]) {
                    language = matches[0].match(/lang="([a-zA-Z0-9_-]+)"/)[1];
                    currentLangRegEx = new RegExp('<(?:lang|span)[^>]+lang="' + language + '"[^>]*>(.*?)<\/(?:lang|span)>', 'g');
                }
                else {
                    // No multi-lang tag found, stop.
                    return text;
                }
            }
            // Extract contents of current language.
            text = text.replace(currentLangRegEx, '$1');
            // Delete the rest of languages
            text = text.replace(anyLangRegEx, '');
            return text;
        });
    };
    /**
     * If a number has only 1 digit, add a leading zero to it.
     *
     * @param {string|number} num Number to convert.
     * @return {string} Number with leading zeros.
     */
    CoreTextUtilsProvider.prototype.twoDigits = function (num) {
        if (num < 10) {
            return '0' + num;
        }
        else {
            return '' + num; // Convert to string for coherence.
        }
    };
    /**
     * Make a string's first character uppercase.
     *
     * @param {string} text Text to treat.
     * @return {string} Treated text.
     */
    CoreTextUtilsProvider.prototype.ucFirst = function (text) {
        return text.charAt(0).toUpperCase() + text.slice(1);
    };
    /**
     * Unserialize Array from PHP.
     * Taken from: https://github.com/kvz/locutus/blob/master/src/php/var/unserialize.js
     *
     * @param  {string} data String to unserialize.
     * @param {Function} [logErrorFn] An error to call with the exception to log the error. If not supplied, no error.
     * @return {any}         Unserialized data.
     */
    CoreTextUtilsProvider.prototype.unserialize = function (data, logErrorFn) {
        //  Discuss at: http://locutus.io/php/unserialize/
        // Original by: Arpad Ray (mailto:arpad@php.net)
        // Improved by: Pedro Tainha (http://www.pedrotainha.com)
        // Improved by: Kevin van Zonneveld (http://kvz.io)
        // Improved by: Kevin van Zonneveld (http://kvz.io)
        // Improved by: Chris
        // Improved by: James
        // Improved by: Le Torbi
        // Improved by: Eli Skeggs
        // Bugfixed by: dptr1988
        // Bugfixed by: Kevin van Zonneveld (http://kvz.io)
        // Bugfixed by: Brett Zamir (http://brett-zamir.me)
        // Bugfixed by: philippsimon (https://github.com/philippsimon/)
        //  Revised by: d3x
        //    Input by: Brett Zamir (http://brett-zamir.me)
        //    Input by: Martin (http://www.erlenwiese.de/)
        //    Input by: kilops
        //    Input by: Jaroslaw Czarniak
        //    Input by: lovasoa (https://github.com/lovasoa/)
        //      Note 1: We feel the main purpose of this function should be
        //      Note 1: to ease the transport of data between php & js
        //      Note 1: Aiming for PHP-compatibility, we have to translate objects to arrays
        //   Example 1: unserialize('a:3:{i:0;s:5:"Kevin";i:1;s:3:"van";i:2;s:9:"Zonneveld";}')
        //   Returns 1: ['Kevin', 'van', 'Zonneveld']
        //   Example 2: unserialize('a:2:{s:9:"firstName";s:5:"Kevin";s:7:"midName";s:3:"van";}')
        //   Returns 2: {firstName: 'Kevin', midName: 'van'}
        //   Example 3: unserialize('a:3:{s:2:"ü";s:2:"ü";s:3:"四";s:3:"四";s:4:"𠜎";s:4:"𠜎";}')
        //   Returns 3: {'ü': 'ü', '四': '四', '𠜎': '𠜎'}
        var utf8Overhead = function (str) {
            var s = str.length;
            for (var i = str.length - 1; i >= 0; i--) {
                var code = str.charCodeAt(i);
                if (code > 0x7f && code <= 0x7ff) {
                    s++;
                }
                else if (code > 0x7ff && code <= 0xffff) {
                    s += 2;
                }
                // Trail surrogate.
                if (code >= 0xDC00 && code <= 0xDFFF) {
                    i--;
                }
            }
            return s - 1;
        };
        var error = function (type, msg) {
            if (logErrorFn) {
                logErrorFn(type + msg);
            }
        };
        var readUntil = function (data, offset, stopchr) {
            var i = 2;
            var buf = [];
            var chr = data.slice(offset, offset + 1);
            while (chr !== stopchr) {
                if ((i + offset) > data.length) {
                    error('Error', 'Invalid');
                }
                buf.push(chr);
                chr = data.slice(offset + (i - 1), offset + i);
                i += 1;
            }
            return [buf.length, buf.join('')];
        };
        var readChrs = function (data, offset, length) {
            var chr;
            var buf = [];
            for (var i = 0; i < length; i++) {
                chr = data.slice(offset + (i - 1), offset + i);
                buf.push(chr);
                length -= utf8Overhead(chr);
            }
            return [buf.length, buf.join('')];
        };
        var _unserialize = function (data, offset) {
            var dtype, dataoffset, keyandchrs, keys, contig, length, array, readdata, readData, ccount, stringlength, i, key, kprops, kchrs, vprops, vchrs, value, chrs = 0, typeconvert = function (x) {
                return x;
            };
            if (!offset) {
                offset = 0;
            }
            dtype = (data.slice(offset, offset + 1)).toLowerCase();
            dataoffset = offset + 2;
            switch (dtype) {
                case 'i':
                    typeconvert = function (x) {
                        return parseInt(x, 10);
                    };
                    readData = readUntil(data, dataoffset, ';');
                    chrs = readData[0];
                    readdata = readData[1];
                    dataoffset += chrs + 1;
                    break;
                case 'b':
                    typeconvert = function (x) {
                        return parseInt(x, 10) !== 0;
                    };
                    readData = readUntil(data, dataoffset, ';');
                    chrs = readData[0];
                    readdata = readData[1];
                    dataoffset += chrs + 1;
                    break;
                case 'd':
                    typeconvert = function (x) {
                        return parseFloat(x);
                    };
                    readData = readUntil(data, dataoffset, ';');
                    chrs = readData[0];
                    readdata = readData[1];
                    dataoffset += chrs + 1;
                    break;
                case 'n':
                    readdata = null;
                    break;
                case 's':
                    ccount = readUntil(data, dataoffset, ':');
                    chrs = ccount[0];
                    stringlength = ccount[1];
                    dataoffset += chrs + 2;
                    readData = readChrs(data, dataoffset + 1, parseInt(stringlength, 10));
                    chrs = readData[0];
                    readdata = readData[1];
                    dataoffset += chrs + 2;
                    if (chrs !== parseInt(stringlength, 10) && chrs !== readdata.length) {
                        error('SyntaxError', 'String length mismatch');
                    }
                    break;
                case 'a':
                    readdata = {};
                    keyandchrs = readUntil(data, dataoffset, ':');
                    chrs = keyandchrs[0];
                    keys = keyandchrs[1];
                    dataoffset += chrs + 2;
                    length = parseInt(keys, 10);
                    contig = true;
                    for (var i_1 = 0; i_1 < length; i_1++) {
                        kprops = _unserialize(data, dataoffset);
                        kchrs = kprops[1];
                        key = kprops[2];
                        dataoffset += kchrs;
                        vprops = _unserialize(data, dataoffset);
                        vchrs = vprops[1];
                        value = vprops[2];
                        dataoffset += vchrs;
                        if (key !== i_1) {
                            contig = false;
                        }
                        readdata[key] = value;
                    }
                    if (contig) {
                        array = new Array(length);
                        for (i = 0; i < length; i++) {
                            array[i] = readdata[i];
                        }
                        readdata = array;
                    }
                    dataoffset += 1;
                    break;
                default:
                    error('SyntaxError', 'Unknown / Unhandled data type(s): ' + dtype);
                    break;
            }
            return [dtype, dataoffset - offset, typeconvert(readdata)];
        };
        return _unserialize((data + ''), 0)[2];
    };
    CoreTextUtilsProvider = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_3__ngx_translate_core__["c" /* TranslateService */], __WEBPACK_IMPORTED_MODULE_4__lang__["a" /* CoreLangProvider */], __WEBPACK_IMPORTED_MODULE_2_ionic_angular__["q" /* ModalController */],
            __WEBPACK_IMPORTED_MODULE_1__angular_platform_browser__["c" /* DomSanitizer */], __WEBPACK_IMPORTED_MODULE_2_ionic_angular__["v" /* Platform */]])
    ], CoreTextUtilsProvider);
    return CoreTextUtilsProvider;
}());

//# sourceMappingURL=text.js.map

/***/ }),
/* 11 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreEventsProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_rxjs__ = __webpack_require__(148);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_rxjs___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_rxjs__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__providers_logger__ = __webpack_require__(5);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};



/*
 * Service to send and listen to events.
 */
var CoreEventsProvider = /** @class */ (function () {
    function CoreEventsProvider(logger) {
        this.observables = {};
        this.uniqueEvents = {};
        this.logger = logger.getInstance('CoreEventsProvider');
    }
    /**
     * Listen for a certain event. To stop listening to the event:
     * let observer = eventsProvider.on('something', myCallBack);
     * ...
     * observer.off();
     *
     * @param {string} eventName Name of the event to listen to.
     * @param {Function} callBack Function to call when the event is triggered.
     * @param {string} [siteId] Site where to trigger the event. Undefined won't check the site.
     * @return {CoreEventObserver} Observer to stop listening.
     */
    CoreEventsProvider.prototype.on = function (eventName, callBack, siteId) {
        var _this = this;
        // If it's a unique event and has been triggered already, call the callBack.
        // We don't need to create an observer because the event won't be triggered again.
        if (this.uniqueEvents[eventName]) {
            callBack(this.uniqueEvents[eventName].data);
            // Return a fake observer to prevent errors.
            return {
                off: function () {
                    // Nothing to do.
                }
            };
        }
        this.logger.debug("New observer listening to event '" + eventName + "'");
        if (typeof this.observables[eventName] == 'undefined') {
            // No observable for this event, create a new one.
            this.observables[eventName] = new __WEBPACK_IMPORTED_MODULE_1_rxjs__["Subject"]();
        }
        var subscription = this.observables[eventName].subscribe(function (value) {
            if (!siteId || value.siteId == siteId) {
                callBack(value);
            }
        });
        // Create and return a CoreEventObserver.
        return {
            off: function () {
                _this.logger.debug("Stop listening to event '" + eventName + "'");
                subscription.unsubscribe();
            }
        };
    };
    /**
     * Triggers an event, notifying all the observers.
     *
     * @param {string} event Name of the event to trigger.
     * @param {any} [data] Data to pass to the observers.
     * @param {string} [siteId] Site where to trigger the event. Undefined means no Site.
     */
    CoreEventsProvider.prototype.trigger = function (eventName, data, siteId) {
        this.logger.debug("Event '" + eventName + "' triggered.");
        if (this.observables[eventName]) {
            if (siteId) {
                if (!data) {
                    data = {};
                }
                data.siteId = siteId;
            }
            this.observables[eventName].next(data);
        }
    };
    /**
     * Triggers a unique event, notifying all the observers. If the event has already been triggered, don't do anything.
     *
     * @param {string} event Name of the event to trigger.
     * @param {any} data Data to pass to the observers.
     * @param {string} [siteId] Site where to trigger the event. Undefined means no Site.
     */
    CoreEventsProvider.prototype.triggerUnique = function (eventName, data, siteId) {
        if (this.uniqueEvents[eventName]) {
            this.logger.debug("Unique event '" + eventName + "' ignored because it was already triggered.");
        }
        else {
            this.logger.debug("Unique event '" + eventName + "' triggered.");
            if (siteId) {
                if (!data) {
                    data = {};
                }
                data.siteId = siteId;
            }
            // Store the data so it can be passed to observers that register from now on.
            this.uniqueEvents[eventName] = {
                data: data
            };
            // Now pass the data to observers.
            if (this.observables[eventName]) {
                this.observables[eventName].next(data);
            }
        }
    };
    CoreEventsProvider.SESSION_EXPIRED = 'session_expired';
    CoreEventsProvider.PASSWORD_CHANGE_FORCED = 'password_change_forced';
    CoreEventsProvider.USER_NOT_FULLY_SETUP = 'user_not_fully_setup';
    CoreEventsProvider.SITE_POLICY_NOT_AGREED = 'site_policy_not_agreed';
    CoreEventsProvider.LOGIN = 'login';
    CoreEventsProvider.LOGOUT = 'logout';
    CoreEventsProvider.LANGUAGE_CHANGED = 'language_changed';
    CoreEventsProvider.NOTIFICATION_SOUND_CHANGED = 'notification_sound_changed';
    CoreEventsProvider.SITE_ADDED = 'site_added';
    CoreEventsProvider.SITE_UPDATED = 'site_updated';
    CoreEventsProvider.SITE_DELETED = 'site_deleted';
    CoreEventsProvider.COMPLETION_MODULE_VIEWED = 'completion_module_viewed';
    CoreEventsProvider.USER_DELETED = 'user_deleted';
    CoreEventsProvider.PACKAGE_STATUS_CHANGED = 'package_status_changed';
    CoreEventsProvider.COURSE_STATUS_CHANGED = 'course_status_changed';
    CoreEventsProvider.SECTION_STATUS_CHANGED = 'section_status_changed';
    CoreEventsProvider.SITE_PLUGINS_LOADED = 'site_plugins_loaded';
    CoreEventsProvider.SITE_PLUGINS_COURSE_RESTRICT_UPDATED = 'site_plugins_course_restrict_updated';
    CoreEventsProvider.LOGIN_SITE_CHECKED = 'login_site_checked';
    CoreEventsProvider.LOGIN_SITE_UNCHECKED = 'login_site_unchecked';
    CoreEventsProvider.IAB_LOAD_START = 'inappbrowser_load_start';
    CoreEventsProvider.IAB_EXIT = 'inappbrowser_exit';
    CoreEventsProvider.APP_LAUNCHED_URL = 'app_launched_url'; // App opened with a certain URL (custom URL scheme).
    CoreEventsProvider.FILE_SHARED = 'file_shared';
    CoreEventsProvider.KEYBOARD_CHANGE = 'keyboard_change';
    CoreEventsProvider.CORE_LOADING_CHANGED = 'core_loading_changed';
    CoreEventsProvider.ORIENTATION_CHANGE = 'orientation_change';
    CoreEventsProvider.LOAD_PAGE_MAIN_MENU = 'load_page_main_menu';
    CoreEventsProvider.SEND_ON_ENTER_CHANGED = 'send_on_enter_changed';
    CoreEventsProvider.MAIN_MENU_OPEN = 'main_menu_open';
    CoreEventsProvider.SELECT_COURSE_TAB = 'select_course_tab';
    CoreEventsProvider = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_2__providers_logger__["a" /* CoreLoggerProvider */]])
    ], CoreEventsProvider);
    return CoreEventsProvider;
}());

//# sourceMappingURL=events.js.map

/***/ }),
/* 12 */,
/* 13 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreContentLinksHelperProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__ngx_translate_core__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__providers_app__ = __webpack_require__(9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_events__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__providers_init__ = __webpack_require__(145);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__providers_logger__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__providers_sites__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__providers_utils_dom__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__providers_utils_text__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__providers_utils_url__ = __webpack_require__(23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__providers_utils_utils__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__core_login_providers_helper__ = __webpack_require__(122);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__delegate__ = __webpack_require__(58);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__core_constants__ = __webpack_require__(40);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14__configconstants__ = __webpack_require__(119);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15__core_siteplugins_providers_siteplugins__ = __webpack_require__(54);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_16__core_mainmenu_providers_mainmenu__ = __webpack_require__(487);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};

















/**
 * Service that provides some features regarding content links.
 */
var CoreContentLinksHelperProvider = /** @class */ (function () {
    function CoreContentLinksHelperProvider(logger, sitesProvider, loginHelper, contentLinksDelegate, appProvider, domUtils, urlUtils, translate, initDelegate, eventsProvider, textUtils, sitePluginsProvider, zone, utils, mainMenuProvider) {
        this.sitesProvider = sitesProvider;
        this.loginHelper = loginHelper;
        this.contentLinksDelegate = contentLinksDelegate;
        this.appProvider = appProvider;
        this.domUtils = domUtils;
        this.urlUtils = urlUtils;
        this.translate = translate;
        this.initDelegate = initDelegate;
        this.textUtils = textUtils;
        this.sitePluginsProvider = sitePluginsProvider;
        this.zone = zone;
        this.utils = utils;
        this.mainMenuProvider = mainMenuProvider;
        this.logger = logger.getInstance('CoreContentLinksHelperProvider');
    }
    /**
     * Check whether a link can be handled by the app.
     *
     * @param {string} url URL to handle.
     * @param {number} [courseId] Course ID related to the URL. Optional but recommended.
     * @param {string} [username] Username to use to filter sites.
     * @param {boolean} [checkRoot] Whether to check if the URL is the root URL of a site.
     * @return {Promise<boolean>} Promise resolved with a boolean: whether the URL can be handled.
     */
    CoreContentLinksHelperProvider.prototype.canHandleLink = function (url, courseId, username, checkRoot) {
        var _this = this;
        var promise;
        if (checkRoot) {
            promise = this.sitesProvider.isStoredRootURL(url, username);
        }
        else {
            promise = Promise.resolve({});
        }
        return promise.then(function (data) {
            if (data.site) {
                // URL is the root of the site, can handle it.
                return true;
            }
            return _this.contentLinksDelegate.getActionsFor(url, undefined, username).then(function (actions) {
                return !!_this.getFirstValidAction(actions);
            });
        }).catch(function () {
            return false;
        });
    };
    /**
     * Get the first valid action in a list of actions.
     *
     * @param {CoreContentLinksAction[]} actions List of actions.
     * @return {CoreContentLinksAction} First valid action. Returns undefined if no valid action found.
     */
    CoreContentLinksHelperProvider.prototype.getFirstValidAction = function (actions) {
        if (actions) {
            for (var i = 0; i < actions.length; i++) {
                var action = actions[i];
                if (action && action.sites && action.sites.length) {
                    return action;
                }
            }
        }
    };
    /**
     * Goes to a certain page in a certain site. If the site is current site it will perform a regular navigation,
     * otherwise it will 'redirect' to the other site.
     *
     * @param {NavController} navCtrl The NavController instance to use.
     * @param {string} pageName Name of the page to go.
     * @param {any} [pageParams] Params to send to the page.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @param {boolean} [checkMenu] If true, check if the root page of a main menu tab. Only the page name will be checked.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreContentLinksHelperProvider.prototype.goInSite = function (navCtrl, pageName, pageParams, siteId, checkMenu) {
        var _this = this;
        siteId = siteId || this.sitesProvider.getCurrentSiteId();
        var deferred = this.utils.promiseDefer();
        // Execute the code in the Angular zone, so change detection doesn't stop working.
        this.zone.run(function () {
            if (navCtrl && siteId == _this.sitesProvider.getCurrentSiteId()) {
                if (checkMenu) {
                    // Check if the page is in the main menu.
                    _this.mainMenuProvider.isCurrentMainMenuHandler(pageName, pageParams).catch(function () {
                        return false; // Shouldn't happen.
                    }).then(function (isInMenu) {
                        if (isInMenu) {
                            // Just select the tab.
                            _this.loginHelper.loadPageInMainMenu(pageName, pageParams);
                            deferred.resolve();
                        }
                        else {
                            navCtrl.push(pageName, pageParams).then(deferred.resolve, deferred.reject);
                        }
                    });
                }
                else {
                    navCtrl.push(pageName, pageParams).then(deferred.resolve, deferred.reject);
                }
            }
            else {
                _this.loginHelper.redirect(pageName, pageParams, siteId).then(deferred.resolve, deferred.reject);
            }
        });
        return deferred.promise;
    };
    /**
     * Go to the page to choose a site.
     *
     * @param {string} url URL to treat.
     */
    CoreContentLinksHelperProvider.prototype.goToChooseSite = function (url) {
        this.appProvider.getRootNavController().setRoot('CoreContentLinksChooseSitePage', { url: url });
    };
    /**
     * Handle a URL received by Custom URL Scheme.
     *
     * @param {string} url URL to handle.
     * @return {boolean} True if the URL should be handled by this component, false otherwise.
     * @deprecated Please use CoreCustomURLSchemesProvider.handleCustomURL instead.
     */
    CoreContentLinksHelperProvider.prototype.handleCustomUrl = function (url) {
        var _this = this;
        var contentLinksScheme = __WEBPACK_IMPORTED_MODULE_14__configconstants__["a" /* CoreConfigConstants */].customurlscheme + '://link';
        if (url.indexOf(contentLinksScheme) == -1) {
            return false;
        }
        var modal = this.domUtils.showModalLoading();
        var username;
        url = this.textUtils.decodeURIComponent(url);
        // App opened using custom URL scheme.
        this.logger.debug('Treating custom URL scheme: ' + url);
        // Delete the scheme from the URL.
        url = url.replace(contentLinksScheme + '=', '');
        // Detect if there's a user specified.
        username = this.urlUtils.getUsernameFromUrl(url);
        if (username) {
            url = url.replace(username + '@', ''); // Remove the username from the URL.
        }
        // Wait for the app to be ready.
        this.initDelegate.ready().then(function () {
            // Check if it's the root URL.
            return _this.sitesProvider.isStoredRootURL(url, username);
        }).then(function (data) {
            if (data.site) {
                // Root URL.
                modal.dismiss();
                return _this.handleRootURL(data.site, false);
            }
            else if (data.siteIds.length > 0) {
                modal.dismiss(); // Dismiss modal so it doesn't collide with confirms.
                return _this.handleLink(url, username).then(function (treated) {
                    if (!treated) {
                        _this.domUtils.showErrorModal('core.contentlinks.errornoactions', true);
                    }
                });
            }
            else {
                // Get the site URL.
                var siteUrl = _this.contentLinksDelegate.getSiteUrl(url), urlToOpen_1 = url;
                if (!siteUrl) {
                    // Site URL not found, use the original URL since it could be the root URL of the site.
                    siteUrl = url;
                    urlToOpen_1 = undefined;
                }
                // Check that site exists.
                return _this.sitesProvider.checkSite(siteUrl).then(function (result) {
                    // Site exists. We'll allow to add it.
                    var ssoNeeded = _this.loginHelper.isSSOLoginNeeded(result.code), pageName = 'CoreLoginCredentialsPage', pageParams = {
                        siteUrl: result.siteUrl,
                        username: username,
                        urlToOpen: urlToOpen_1,
                        siteConfig: result.config
                    };
                    var promise, hasSitePluginsLoaded = false;
                    modal.dismiss(); // Dismiss modal so it doesn't collide with confirms.
                    if (!_this.sitesProvider.isLoggedIn()) {
                        // Not logged in, no need to confirm. If SSO the confirm will be shown later.
                        promise = Promise.resolve();
                    }
                    else {
                        // Ask the user before changing site.
                        var confirmMsg = _this.translate.instant('core.contentlinks.confirmurlothersite');
                        promise = _this.domUtils.showConfirm(confirmMsg).then(function () {
                            if (!ssoNeeded) {
                                hasSitePluginsLoaded = _this.sitePluginsProvider.hasSitePluginsLoaded;
                                if (hasSitePluginsLoaded) {
                                    // Store the redirect since logout will restart the app.
                                    _this.appProvider.storeRedirect(__WEBPACK_IMPORTED_MODULE_13__core_constants__["a" /* CoreConstants */].NO_SITE_ID, pageName, pageParams);
                                }
                                return _this.sitesProvider.logout().catch(function () {
                                    // Ignore errors (shouldn't happen).
                                });
                            }
                        });
                    }
                    return promise.then(function () {
                        if (ssoNeeded) {
                            _this.loginHelper.confirmAndOpenBrowserForSSOLogin(result.siteUrl, result.code, result.service, result.config && result.config.launchurl);
                        }
                        else if (!hasSitePluginsLoaded) {
                            return _this.loginHelper.goToNoSitePage(undefined, pageName, pageParams);
                        }
                    });
                }).catch(function (error) {
                    _this.domUtils.showErrorModalDefault(error, _this.translate.instant('core.login.invalidsite'));
                });
            }
        }).finally(function () {
            modal.dismiss();
        });
        return true;
    };
    /**
     * Handle a link.
     *
     * @param {string} url URL to handle.
     * @param {string} [username] Username related with the URL. E.g. in 'http://myuser@m.com', url would be 'http://m.com' and
     *                            the username 'myuser'. Don't use it if you don't want to filter by username.
     * @param {NavController} [navCtrl] Nav Controller to use to navigate.
     * @param {boolean} [checkRoot] Whether to check if the URL is the root URL of a site.
     * @param {boolean} [openBrowserRoot] Whether to open in browser if it's root URL and it belongs to current site.
     * @return {Promise<boolean>} Promise resolved with a boolean: true if URL was treated, false otherwise.
     */
    CoreContentLinksHelperProvider.prototype.handleLink = function (url, username, navCtrl, checkRoot, openBrowserRoot) {
        var _this = this;
        var promise;
        if (checkRoot) {
            promise = this.sitesProvider.isStoredRootURL(url, username);
        }
        else {
            promise = Promise.resolve({});
        }
        return promise.then(function (data) {
            if (data.site) {
                // URL is the root of the site.
                _this.handleRootURL(data.site, openBrowserRoot);
                return true;
            }
            // Check if the link should be treated by some component/addon.
            return _this.contentLinksDelegate.getActionsFor(url, undefined, username).then(function (actions) {
                var action = _this.getFirstValidAction(actions);
                if (action) {
                    if (!_this.sitesProvider.isLoggedIn()) {
                        // No current site. Perform the action if only 1 site found, choose the site otherwise.
                        if (action.sites.length == 1) {
                            action.action(action.sites[0], navCtrl);
                        }
                        else {
                            _this.goToChooseSite(url);
                        }
                    }
                    else if (action.sites.length == 1 && action.sites[0] == _this.sitesProvider.getCurrentSiteId()) {
                        // Current site.
                        action.action(action.sites[0], navCtrl);
                    }
                    else {
                        // Not current site or more than one site. Ask for confirmation.
                        _this.domUtils.showConfirm(_this.translate.instant('core.contentlinks.confirmurlothersite')).then(function () {
                            if (action.sites.length == 1) {
                                action.action(action.sites[0], navCtrl);
                            }
                            else {
                                _this.goToChooseSite(url);
                            }
                        }).catch(function () {
                            // User canceled.
                        });
                    }
                    return true;
                }
                return false;
            }).catch(function () {
                return false;
            });
        });
    };
    /**
     * Handle a root URL of a site.
     *
     * @param {CoreSite} site Site to handle.
     * @param {boolean} [openBrowserRoot] Whether to open in browser if it's root URL and it belongs to current site.
     * @param {boolean} [checkToken] Whether to check that token is the same to verify it's current site. If false or not defined,
     *                               only the URL will be checked.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreContentLinksHelperProvider.prototype.handleRootURL = function (site, openBrowserRoot, checkToken) {
        var currentSite = this.sitesProvider.getCurrentSite();
        if (currentSite && currentSite.getURL() == site.getURL() && (!checkToken || currentSite.getToken() == site.getToken())) {
            // Already logged in.
            if (openBrowserRoot) {
                return site.openInBrowserWithAutoLogin(site.getURL());
            }
            return Promise.resolve();
        }
        else {
            // Login in the site.
            return this.loginHelper.redirect('', {}, site.getId());
        }
    };
    CoreContentLinksHelperProvider = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_5__providers_logger__["a" /* CoreLoggerProvider */], __WEBPACK_IMPORTED_MODULE_6__providers_sites__["a" /* CoreSitesProvider */], __WEBPACK_IMPORTED_MODULE_11__core_login_providers_helper__["a" /* CoreLoginHelperProvider */],
            __WEBPACK_IMPORTED_MODULE_12__delegate__["a" /* CoreContentLinksDelegate */], __WEBPACK_IMPORTED_MODULE_2__providers_app__["a" /* CoreAppProvider */],
            __WEBPACK_IMPORTED_MODULE_7__providers_utils_dom__["a" /* CoreDomUtilsProvider */], __WEBPACK_IMPORTED_MODULE_9__providers_utils_url__["a" /* CoreUrlUtilsProvider */], __WEBPACK_IMPORTED_MODULE_1__ngx_translate_core__["c" /* TranslateService */],
            __WEBPACK_IMPORTED_MODULE_4__providers_init__["a" /* CoreInitDelegate */], __WEBPACK_IMPORTED_MODULE_3__providers_events__["a" /* CoreEventsProvider */], __WEBPACK_IMPORTED_MODULE_8__providers_utils_text__["a" /* CoreTextUtilsProvider */],
            __WEBPACK_IMPORTED_MODULE_15__core_siteplugins_providers_siteplugins__["a" /* CoreSitePluginsProvider */], __WEBPACK_IMPORTED_MODULE_0__angular_core__["M" /* NgZone */], __WEBPACK_IMPORTED_MODULE_10__providers_utils_utils__["a" /* CoreUtilsProvider */],
            __WEBPACK_IMPORTED_MODULE_16__core_mainmenu_providers_mainmenu__["a" /* CoreMainMenuProvider */]])
    ], CoreContentLinksHelperProvider);
    return CoreContentLinksHelperProvider;
}());

//# sourceMappingURL=helper.js.map

/***/ }),
/* 14 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreCourseProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__ngx_translate_core__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__providers_app__ = __webpack_require__(9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_events__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__providers_logger__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__providers_sites__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__providers_utils_dom__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__providers_utils_time__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__providers_utils_utils__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__classes_site__ = __webpack_require__(52);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__constants__ = __webpack_require__(40);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__course_offline__ = __webpack_require__(347);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__core_siteplugins_providers_siteplugins__ = __webpack_require__(54);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__format_delegate__ = __webpack_require__(175);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14__core_pushnotifications_providers_pushnotifications__ = __webpack_require__(130);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};















/**
 * Service that provides some features regarding a course.
 */
var CoreCourseProvider = /** @class */ (function () {
    function CoreCourseProvider(logger, sitesProvider, eventsProvider, utils, timeUtils, translate, courseOffline, appProvider, courseFormatDelegate, sitePluginsProvider, domUtils, pushNotificationsProvider) {
        this.sitesProvider = sitesProvider;
        this.eventsProvider = eventsProvider;
        this.utils = utils;
        this.timeUtils = timeUtils;
        this.translate = translate;
        this.courseOffline = courseOffline;
        this.appProvider = appProvider;
        this.courseFormatDelegate = courseFormatDelegate;
        this.sitePluginsProvider = sitePluginsProvider;
        this.domUtils = domUtils;
        this.pushNotificationsProvider = pushNotificationsProvider;
        this.ROOT_CACHE_KEY = 'mmCourse:';
        // Variables for database.
        this.COURSE_STATUS_TABLE = 'course_status';
        this.siteSchema = {
            name: 'CoreCourseProvider',
            version: 1,
            tables: [
                {
                    name: this.COURSE_STATUS_TABLE,
                    columns: [
                        {
                            name: 'id',
                            type: 'INTEGER',
                            primaryKey: true
                        },
                        {
                            name: 'status',
                            type: 'TEXT',
                            notNull: true
                        },
                        {
                            name: 'previous',
                            type: 'TEXT'
                        },
                        {
                            name: 'updated',
                            type: 'INTEGER'
                        },
                        {
                            name: 'downloadTime',
                            type: 'INTEGER'
                        },
                        {
                            name: 'previousDownloadTime',
                            type: 'INTEGER'
                        }
                    ]
                }
            ]
        };
        this.CORE_MODULES = [
            'assign', 'assignment', 'book', 'chat', 'choice', 'data', 'database', 'date', 'external-tool',
            'feedback', 'file', 'folder', 'forum', 'glossary', 'ims', 'imscp', 'label', 'lesson', 'lti', 'page', 'quiz',
            'resource', 'scorm', 'survey', 'url', 'wiki', 'workshop'
        ];
        this.logger = logger.getInstance('CoreCourseProvider');
        this.sitesProvider.registerSiteSchema(this.siteSchema);
    }
    CoreCourseProvider_1 = CoreCourseProvider;
    /**
     * Check if the get course blocks WS is available in current site.
     *
     * @return {boolean} Whether it's available.
     * @since 3.7
     */
    CoreCourseProvider.prototype.canGetCourseBlocks = function () {
        return this.sitesProvider.getCurrentSite().isVersionGreaterEqualThan('3.7') &&
            this.sitesProvider.wsAvailableInCurrentSite('core_block_get_course_blocks');
    };
    /**
     * Check whether the site supports requesting stealth modules.
     *
     * @param {CoreSite} [site] Site. If not defined, current site.
     * @return {boolean} Whether the site supports requesting stealth modules.
     * @since 3.4.6, 3.5.3, 3.6
     */
    CoreCourseProvider.prototype.canRequestStealthModules = function (site) {
        site = site || this.sitesProvider.getCurrentSite();
        return site.isVersionGreaterEqualThan(['3.4.6', '3.5.3']);
    };
    /**
     * Check if module completion could have changed. If it could have, trigger event. This function must be used,
     * for example, after calling a "module_view" WS since it can change the module completion.
     *
     * @param {number} courseId Course ID.
     * @param {any} completion Completion status of the module.
     */
    CoreCourseProvider.prototype.checkModuleCompletion = function (courseId, completion) {
        var _this = this;
        if (completion && completion.tracking === 2 && completion.state === 0) {
            this.invalidateSections(courseId).finally(function () {
                _this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_3__providers_events__["a" /* CoreEventsProvider */].COMPLETION_MODULE_VIEWED, { courseId: courseId });
            });
        }
    };
    /**
     * Clear all courses status in a site.
     *
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<void>} Promise resolved when all status are cleared.
     */
    CoreCourseProvider.prototype.clearAllCoursesStatus = function (siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            _this.logger.debug('Clear all course status for site ' + site.id);
            return site.getDb().deleteRecords(_this.COURSE_STATUS_TABLE).then(function () {
                _this.triggerCourseStatusChanged(CoreCourseProvider_1.ALL_COURSES_CLEARED, __WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].NOT_DOWNLOADED, site.id);
            });
        });
    };
    /**
     * Check if the current view in a NavController is a certain course initial page.
     *
     * @param {NavController} navCtrl NavController.
     * @param {number} courseId Course ID.
     * @return {boolean} Whether the current view is a certain course.
     */
    CoreCourseProvider.prototype.currentViewIsCourse = function (navCtrl, courseId) {
        if (navCtrl) {
            var view = navCtrl.getActive();
            return view && view.id == 'CoreCourseSectionPage' && view.data && view.data.course && view.data.course.id == courseId;
        }
        return false;
    };
    /**
     * Get completion status of all the activities in a course for a certain user.
     *
     * @param {number} courseId Course ID.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @param {number} [userId] User ID. If not defined, current user.
     * @param {boolean} [forceCache] True if it should return cached data. Has priority over ignoreCache.
     * @param {boolean} [ignoreCache] True if it should ignore cached data (it will always fail in offline or server down).
     * @param {boolean} [includeOffline=true] True if it should load offline data in the completion status.
     * @return {Promise<any>} Promise resolved with the completion statuses: object where the key is module ID.
     */
    CoreCourseProvider.prototype.getActivitiesCompletionStatus = function (courseId, siteId, userId, forceCache, ignoreCache, includeOffline) {
        var _this = this;
        if (forceCache === void 0) { forceCache = false; }
        if (ignoreCache === void 0) { ignoreCache = false; }
        if (includeOffline === void 0) { includeOffline = true; }
        return this.sitesProvider.getSite(siteId).then(function (site) {
            userId = userId || site.getUserId();
            _this.logger.debug("Getting completion status for user " + userId + " in course " + courseId);
            var params = {
                courseid: courseId,
                userid: userId
            }, preSets = {
                cacheKey: _this.getActivitiesCompletionCacheKey(courseId, userId)
            };
            if (forceCache) {
                preSets.omitExpires = true;
            }
            else if (ignoreCache) {
                preSets.getFromCache = false;
                preSets.emergencyCache = false;
            }
            return site.read('core_completion_get_activities_completion_status', params, preSets).then(function (data) {
                if (data && data.statuses) {
                    return _this.utils.arrayToObject(data.statuses, 'cmid');
                }
                return Promise.reject(null);
            }).then(function (completionStatus) {
                if (!includeOffline) {
                    return completionStatus;
                }
                // Now get the offline completion (if any).
                return _this.courseOffline.getCourseManualCompletions(courseId, site.id).then(function (offlineCompletions) {
                    offlineCompletions.forEach(function (offlineCompletion) {
                        if (offlineCompletion && typeof completionStatus[offlineCompletion.cmid] != 'undefined') {
                            var onlineCompletion = completionStatus[offlineCompletion.cmid];
                            // If the activity uses manual completion, override the value with the offline one.
                            if (onlineCompletion.tracking === 1) {
                                onlineCompletion.state = offlineCompletion.completed;
                                onlineCompletion.offline = true;
                            }
                        }
                    });
                    return completionStatus;
                }).catch(function () {
                    // Ignore errors.
                    return completionStatus;
                });
            });
        });
    };
    /**
     * Get cache key for activities completion WS calls.
     *
     * @param {number} courseId Course ID.
     * @param {number} userId User ID.
     * @return {string} Cache key.
     */
    CoreCourseProvider.prototype.getActivitiesCompletionCacheKey = function (courseId, userId) {
        return this.ROOT_CACHE_KEY + 'activitiescompletion:' + courseId + ':' + userId;
    };
    /**
     * Get course blocks.
     *
     * @param {number} courseId Course ID.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any[]>} Promise resolved with the list of blocks.
     * @since 3.7
     */
    CoreCourseProvider.prototype.getCourseBlocks = function (courseId, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var params = {
                courseid: courseId,
                returncontents: 1
            }, preSets = {
                cacheKey: _this.getCourseBlocksCacheKey(courseId),
                updateFrequency: __WEBPACK_IMPORTED_MODULE_9__classes_site__["a" /* CoreSite */].FREQUENCY_RARELY
            };
            return site.read('core_block_get_course_blocks', params, preSets).then(function (result) {
                return result.blocks || [];
            });
        });
    };
    /**
     * Get cache key for course blocks WS calls.
     *
     * @param {number} courseId Course ID.
     * @return {string} Cache key.
     */
    CoreCourseProvider.prototype.getCourseBlocksCacheKey = function (courseId) {
        return this.ROOT_CACHE_KEY + 'courseblocks:' + courseId;
    };
    /**
     * Get the data stored for a course.
     *
     * @param {number} courseId Course ID.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved with the data.
     */
    CoreCourseProvider.prototype.getCourseStatusData = function (courseId, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.getDb().getRecord(_this.COURSE_STATUS_TABLE, { id: courseId }).then(function (entry) {
                if (!entry) {
                    return Promise.reject(null);
                }
                return entry;
            });
        });
    };
    /**
     * Get a course status.
     *
     * @param {number} courseId Course ID.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<string>} Promise resolved with the status.
     */
    CoreCourseProvider.prototype.getCourseStatus = function (courseId, siteId) {
        return this.getCourseStatusData(courseId, siteId).then(function (entry) {
            return entry.status || __WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].NOT_DOWNLOADED;
        }).catch(function () {
            return __WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].NOT_DOWNLOADED;
        });
    };
    /**
     * Get a module from Moodle.
     *
     * @param {number} moduleId The module ID.
     * @param {number} [courseId] The course ID. Recommended to speed up the process and minimize data usage.
     * @param {number} [sectionId] The section ID.
     * @param {boolean} [preferCache] True if shouldn't call WS if data is cached, false otherwise.
     * @param {boolean} [ignoreCache] True if it should ignore cached data (it will always fail in offline or server down).
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @param {string} [modName] If set, the app will retrieve all modules of this type with a single WS call. This reduces the
     *                           number of WS calls, but it isn't recommended for modules that can return a lot of contents.
     * @return {Promise<any>} Promise resolved with the module.
     */
    CoreCourseProvider.prototype.getModule = function (moduleId, courseId, sectionId, preferCache, ignoreCache, siteId, modName) {
        var _this = this;
        siteId = siteId || this.sitesProvider.getCurrentSiteId();
        // Helper function to do the WS request without processing the result.
        var doRequest = function (site, moduleId, modName, includeStealth, preferCache) {
            var params = {
                courseid: courseId,
                options: []
            };
            var preSets = {
                omitExpires: preferCache,
                updateFrequency: __WEBPACK_IMPORTED_MODULE_9__classes_site__["a" /* CoreSite */].FREQUENCY_RARELY
            };
            if (includeStealth) {
                params.options.push({
                    name: 'includestealthmodules',
                    value: 1
                });
            }
            // If modName is set, retrieve all modules of that type. Otherwise get only the module.
            if (modName) {
                params.options.push({
                    name: 'modname',
                    value: modName
                });
                preSets.cacheKey = _this.getModuleByModNameCacheKey(modName);
            }
            else {
                params.options.push({
                    name: 'cmid',
                    value: moduleId
                });
                preSets.cacheKey = _this.getModuleCacheKey(moduleId);
            }
            if (!preferCache && ignoreCache) {
                preSets.getFromCache = false;
                preSets.emergencyCache = false;
            }
            return site.read('core_course_get_contents', params, preSets).catch(function () {
                // The module might still be cached by a request with different parameters.
                if (!ignoreCache && !_this.appProvider.isOnline()) {
                    if (includeStealth) {
                        // Older versions didn't include the includestealthmodules option.
                        return doRequest(site, moduleId, modName, false, true);
                    }
                    else if (modName) {
                        // Falback to the request for the given moduleId only.
                        return doRequest(site, moduleId, undefined, _this.canRequestStealthModules(site), true);
                    }
                }
                return Promise.reject(null);
            });
        };
        var promise;
        if (!courseId) {
            // No courseId passed, try to retrieve it.
            promise = this.getModuleBasicInfo(moduleId, siteId).then(function (module) {
                courseId = module.course;
            });
        }
        else {
            promise = Promise.resolve();
        }
        return promise.then(function () {
            return _this.sitesProvider.getSite(siteId);
        }).then(function (site) {
            // We have courseId, we can use core_course_get_contents for compatibility.
            _this.logger.debug("Getting module " + moduleId + " in course " + courseId);
            return doRequest(site, moduleId, modName, _this.canRequestStealthModules(site), preferCache);
        }).catch(function () {
            // Error getting the module. Try to get all contents (without filtering by module).
            var preSets = {
                omitExpires: preferCache
            };
            if (!preferCache && ignoreCache) {
                preSets.getFromCache = false;
                preSets.emergencyCache = false;
            }
            return _this.getSections(courseId, false, false, preSets, siteId);
        }).then(function (sections) {
            for (var i = 0; i < sections.length; i++) {
                var section = sections[i];
                if (sectionId != null && !isNaN(sectionId) && section.id != CoreCourseProvider_1.STEALTH_MODULES_SECTION_ID &&
                    sectionId != section.id) {
                    continue;
                }
                for (var j = 0; j < section.modules.length; j++) {
                    var module_1 = section.modules[j];
                    if (module_1.id == moduleId) {
                        module_1.course = courseId;
                        return module_1;
                    }
                }
            }
            return Promise.reject(null);
        });
    };
    /**
     * Gets a module basic info by module ID.
     *
     * @param {number} moduleId Module ID.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved with the module's info.
     */
    CoreCourseProvider.prototype.getModuleBasicInfo = function (moduleId, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var params = {
                cmid: moduleId
            }, preSets = {
                cacheKey: _this.getModuleCacheKey(moduleId),
                updateFrequency: __WEBPACK_IMPORTED_MODULE_9__classes_site__["a" /* CoreSite */].FREQUENCY_RARELY
            };
            return site.read('core_course_get_course_module', params, preSets).then(function (response) {
                if (response.warnings && response.warnings.length) {
                    return Promise.reject(response.warnings[0]);
                }
                else if (response.cm) {
                    return response.cm;
                }
                return Promise.reject(null);
            });
        });
    };
    /**
     * Gets a module basic grade info by module ID.
     *
     * If the user does not have permision to manage the activity false is returned.
     *
     * @param {number} moduleId Module ID.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved with the module's grade info.
     */
    CoreCourseProvider.prototype.getModuleBasicGradeInfo = function (moduleId, siteId) {
        return this.getModuleBasicInfo(moduleId, siteId).then(function (info) {
            var grade = {
                advancedgrading: info.advancedgrading || false,
                grade: info.grade || false,
                gradecat: info.gradecat || false,
                gradepass: info.gradepass || false,
                outcomes: info.outcomes || false,
                scale: info.scale || false
            };
            if (grade.grade !== false || grade.advancedgrading !== false || grade.outcomes !== false) {
                return grade;
            }
            return false;
        });
    };
    /**
     * Gets a module basic info by instance.
     *
     * @param {number} id Instance ID.
     * @param {string} module Name of the module. E.g. 'glossary'.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved with the module's info.
     */
    CoreCourseProvider.prototype.getModuleBasicInfoByInstance = function (id, module, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var params = {
                instance: id,
                module: module
            }, preSets = {
                cacheKey: _this.getModuleBasicInfoByInstanceCacheKey(id, module),
                updateFrequency: __WEBPACK_IMPORTED_MODULE_9__classes_site__["a" /* CoreSite */].FREQUENCY_RARELY
            };
            return site.read('core_course_get_course_module_by_instance', params, preSets).then(function (response) {
                if (response.warnings && response.warnings.length) {
                    return Promise.reject(response.warnings[0]);
                }
                else if (response.cm) {
                    return response.cm;
                }
                return Promise.reject(null);
            });
        });
    };
    /**
     * Get cache key for get module by instance WS calls.
     *
     * @param {number} id Instance ID.
     * @param {string} module Name of the module. E.g. 'glossary'.
     * @return {string} Cache key.
     */
    CoreCourseProvider.prototype.getModuleBasicInfoByInstanceCacheKey = function (id, module) {
        return this.ROOT_CACHE_KEY + 'moduleByInstance:' + module + ':' + id;
    };
    /**
     * Get cache key for module WS calls.
     *
     * @param {number} moduleId Module ID.
     * @return {string} Cache key.
     */
    CoreCourseProvider.prototype.getModuleCacheKey = function (moduleId) {
        return this.ROOT_CACHE_KEY + 'module:' + moduleId;
    };
    /**
     * Get cache key for module by modname WS calls.
     *
     * @param {string} modName Name of the module.
     * @return {string} Cache key.
     */
    CoreCourseProvider.prototype.getModuleByModNameCacheKey = function (modName) {
        return this.ROOT_CACHE_KEY + 'module:modName:' + modName;
    };
    /**
     * Returns the source to a module icon.
     *
     * @param {string} moduleName The module name.
     * @param {string} [modicon] The mod icon string to use in case we are not using a core activity.
     * @return {string} The IMG src.
     */
    CoreCourseProvider.prototype.getModuleIconSrc = function (moduleName, modicon) {
        // @TODO: Check modicon url theme to apply other theme icons.
        // Use default icon on core themes.
        if (this.CORE_MODULES.indexOf(moduleName) < 0) {
            if (modicon) {
                return modicon;
            }
            moduleName = 'external-tool';
        }
        return 'assets/img/mod/' + moduleName + '.svg';
    };
    /**
     * Get the section ID a module belongs to.
     *
     * @param {number} moduleId The module ID.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<number>} Promise resolved with the section ID.
     */
    CoreCourseProvider.prototype.getModuleSectionId = function (moduleId, siteId) {
        // Try to get the section using getModuleBasicInfo.
        return this.getModuleBasicInfo(moduleId, siteId).then(function (module) {
            return module.section;
        });
    };
    /**
     * Return a specific section.
     *
     * @param {number} courseId The course ID.
     * @param {number} sectionId The section ID.
     * @param {boolean} [excludeModules] Do not return modules, return only the sections structure.
     * @param {boolean} [excludeContents] Do not return module contents (i.e: files inside a resource).
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved with the section.
     */
    CoreCourseProvider.prototype.getSection = function (courseId, sectionId, excludeModules, excludeContents, siteId) {
        if (sectionId < 0) {
            return Promise.reject('Invalid section ID');
        }
        return this.getSections(courseId, excludeModules, excludeContents, undefined, siteId).then(function (sections) {
            for (var i = 0; i < sections.length; i++) {
                if (sections[i].id == sectionId) {
                    return sections[i];
                }
            }
            return Promise.reject('Unkown section');
        });
    };
    /**
     * Get the course sections.
     *
     * @param {number} courseId The course ID.
     * @param {boolean} [excludeModules] Do not return modules, return only the sections structure.
     * @param {boolean} [excludeContents] Do not return module contents (i.e: files inside a resource).
     * @param {CoreSiteWSPreSets} [preSets] Presets to use.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @param {boolean} [includeStealthModules] Whether to include stealth modules. Defaults to true.
     * @return {Promise}                The reject contains the error message, else contains the sections.
     */
    CoreCourseProvider.prototype.getSections = function (courseId, excludeModules, excludeContents, preSets, siteId, includeStealthModules) {
        var _this = this;
        if (includeStealthModules === void 0) { includeStealthModules = true; }
        return this.sitesProvider.getSite(siteId).then(function (site) {
            preSets = preSets || {};
            preSets.cacheKey = _this.getSectionsCacheKey(courseId);
            preSets.updateFrequency = preSets.updateFrequency || __WEBPACK_IMPORTED_MODULE_9__classes_site__["a" /* CoreSite */].FREQUENCY_RARELY;
            var params = {
                courseid: courseId,
                options: [
                    {
                        name: 'excludemodules',
                        value: excludeModules ? 1 : 0
                    },
                    {
                        name: 'excludecontents',
                        value: excludeContents ? 1 : 0
                    }
                ]
            };
            if (_this.canRequestStealthModules(site)) {
                params.options.push({
                    name: 'includestealthmodules',
                    value: includeStealthModules ? 1 : 0
                });
            }
            return site.read('core_course_get_contents', params, preSets).catch(function () {
                // Error getting the data, it could fail because we added a new parameter and the call isn't cached.
                // Retry without the new parameter and forcing cache.
                preSets.omitExpires = true;
                params.options.splice(-1, 1);
                return site.read('core_course_get_contents', params, preSets);
            }).then(function (sections) {
                var siteHomeId = site.getSiteHomeId();
                var showSections = true;
                if (courseId == siteHomeId) {
                    showSections = site.getStoredConfig('numsections');
                }
                if (typeof showSections != 'undefined' && !showSections && sections.length > 0) {
                    // Get only the last section (Main menu block section).
                    sections.pop();
                }
                return sections;
            });
        });
    };
    /**
     * Get cache key for section WS call.
     *
     * @param {number} courseId Course ID.
     * @return {string} Cache key.
     */
    CoreCourseProvider.prototype.getSectionsCacheKey = function (courseId) {
        return this.ROOT_CACHE_KEY + 'sections:' + courseId;
    };
    /**
     * Given a list of sections, returns the list of modules in the sections.
     *
     * @param {any[]} sections Sections.
     * @return {any[]} Modules.
     */
    CoreCourseProvider.prototype.getSectionsModules = function (sections) {
        if (!sections || !sections.length) {
            return [];
        }
        var modules = [];
        sections.forEach(function (section) {
            if (section.modules) {
                modules = modules.concat(section.modules);
            }
        });
        return modules;
    };
    /**
     * Invalidates course blocks WS call.
     *
     * @param {number} courseId Course ID.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreCourseProvider.prototype.invalidateCourseBlocks = function (courseId, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.invalidateWsCacheForKey(_this.getCourseBlocksCacheKey(courseId));
        });
    };
    /**
     * Invalidates module WS call.
     *
     * @param {number} moduleId Module ID.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @param {string} [modName] Module name. E.g. 'label', 'url', ...
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreCourseProvider.prototype.invalidateModule = function (moduleId, siteId, modName) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var promises = [];
            if (modName) {
                promises.push(site.invalidateWsCacheForKey(_this.getModuleByModNameCacheKey(modName)));
            }
            promises.push(site.invalidateWsCacheForKey(_this.getModuleCacheKey(moduleId)));
            return Promise.all(promises);
        });
    };
    /**
     * Invalidates module WS call.
     *
     * @param {number} id Instance ID.
     * @param {string} module Name of the module. E.g. 'glossary'.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreCourseProvider.prototype.invalidateModuleByInstance = function (id, module, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.invalidateWsCacheForKey(_this.getModuleBasicInfoByInstanceCacheKey(id, module));
        });
    };
    /**
     * Invalidates sections WS call.
     *
     * @param {number} courseId Course ID.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @param {number} [userId] User ID. If not defined, current user.
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreCourseProvider.prototype.invalidateSections = function (courseId, siteId, userId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var promises = [], siteHomeId = site.getSiteHomeId();
            userId = userId || site.getUserId();
            promises.push(site.invalidateWsCacheForKey(_this.getSectionsCacheKey(courseId)));
            promises.push(site.invalidateWsCacheForKey(_this.getActivitiesCompletionCacheKey(courseId, userId)));
            if (courseId == siteHomeId) {
                promises.push(site.invalidateConfig());
            }
            return Promise.all(promises);
        });
    };
    /**
     * Load module contents into module.contents if they aren't loaded already.
     *
     * @param {any} module Module to load the contents.
     * @param {number} [courseId] The course ID. Recommended to speed up the process and minimize data usage.
     * @param {number} [sectionId] The section ID.
     * @param {boolean} [preferCache] True if shouldn't call WS if data is cached, false otherwise.
     * @param {boolean} [ignoreCache] True if it should ignore cached data (it will always fail in offline or server down).
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @param {string} [modName] If set, the app will retrieve all modules of this type with a single WS call. This reduces the
     *                           number of WS calls, but it isn't recommended for modules that can return a lot of contents.
     * @return {Promise<void>} Promise resolved when loaded.
     */
    CoreCourseProvider.prototype.loadModuleContents = function (module, courseId, sectionId, preferCache, ignoreCache, siteId, modName) {
        if (!ignoreCache && module.contents && module.contents.length) {
            // Already loaded.
            return Promise.resolve();
        }
        return this.getModule(module.id, courseId, sectionId, preferCache, ignoreCache, siteId, modName).then(function (mod) {
            module.contents = mod.contents;
        });
    };
    /**
     * Report a course and section as being viewed.
     *
     * @param {number} courseId  Course ID.
     * @param {number} [sectionNumber] Section number.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @param {string} [name] Name of the course.
     * @return {Promise<void>} Promise resolved when the WS call is successful.
     */
    CoreCourseProvider.prototype.logView = function (courseId, sectionNumber, siteId, name) {
        var _this = this;
        var params = {
            courseid: courseId
        }, wsName = 'core_course_view_course';
        if (typeof sectionNumber != 'undefined') {
            params.sectionnumber = sectionNumber;
        }
        return this.sitesProvider.getSite(siteId).then(function (site) {
            _this.pushNotificationsProvider.logViewEvent(courseId, name, 'course', wsName, { sectionnumber: sectionNumber }, siteId);
            return site.write('core_course_view_course', params).then(function (response) {
                if (!response.status) {
                    return Promise.reject(null);
                }
            });
        });
    };
    /**
     * Offline version for manually marking a module as completed.
     *
     * @param {number} cmId The module ID.
     * @param {number} completed Whether the module is completed or not.
     * @param {number} courseId Course ID the module belongs to.
     * @param {string} [courseName] Course name. Recommended, it is used to display a better warning message.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved when completion is successfully sent or stored.
     */
    CoreCourseProvider.prototype.markCompletedManually = function (cmId, completed, courseId, courseName, siteId) {
        var _this = this;
        siteId = siteId || this.sitesProvider.getCurrentSiteId();
        // Convenience function to store a completion to be synchronized later.
        var storeOffline = function () {
            return _this.courseOffline.markCompletedManually(cmId, completed, courseId, courseName, siteId);
        };
        // The offline function requires a courseId and it could be missing because it's a calculated field.
        if (!this.appProvider.isOnline() && courseId) {
            // App is offline, store the action.
            return storeOffline();
        }
        // Try to send it to server.
        return this.markCompletedManuallyOnline(cmId, completed, siteId).then(function (result) {
            // Data sent to server, if there is some offline data delete it now.
            return _this.courseOffline.deleteManualCompletion(cmId, siteId).catch(function () {
                // Ignore errors, shouldn't happen.
            }).then(function () {
                return result;
            });
        }).catch(function (error) {
            if (_this.utils.isWebServiceError(error) || !courseId) {
                // The WebService has thrown an error, this means that responses cannot be submitted.
                return Promise.reject(error);
            }
            else {
                // Couldn't connect to server, store it offline.
                return storeOffline();
            }
        });
    };
    /**
     * Offline version for manually marking a module as completed.
     *
     * @param {number} cmId The module ID.
     * @param {number} completed Whether the module is completed or not.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved when completion is successfully sent.
     */
    CoreCourseProvider.prototype.markCompletedManuallyOnline = function (cmId, completed, siteId) {
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var params = {
                cmid: cmId,
                completed: completed
            };
            return site.write('core_completion_update_activity_completion_status_manually', params);
        });
    };
    /**
     * Check if a module has a view page. E.g. labels don't have a view page.
     *
     * @param {any} module The module object.
     * @return {boolean} Whether the module has a view page.
     */
    CoreCourseProvider.prototype.moduleHasView = function (module) {
        return !!module.url;
    };
    /**
     * Wait for any course format plugin to load, and open the course page.
     *
     * If the plugin's promise is resolved, the course page will be opened.  If it is rejected, they will see an error.
     * If the promise for the plugin is still in progress when the user tries to open the course, a loader
     * will be displayed until it is complete, before the course page is opened.  If the promise is already complete,
     * they will see the result immediately.
     *
     * This function must be in here instead of course helper to prevent circular dependencies.
     *
     * @param {NavController} navCtrl The nav controller to use. If not defined, the course will be opened in main menu.
     * @param {any} course Course to open
     * @param {any} [params] Other params to pass to the course page.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreCourseProvider.prototype.openCourse = function (navCtrl, course, params) {
        var _this = this;
        var loading = this.domUtils.showModalLoading();
        // Wait for site plugins to be fetched.
        return this.sitePluginsProvider.waitFetchPlugins().then(function () {
            if (_this.sitePluginsProvider.sitePluginPromiseExists('format_' + course.format)) {
                // This course uses a custom format plugin, wait for the format plugin to finish loading.
                return _this.sitePluginsProvider.sitePluginLoaded('format_' + course.format).then(function () {
                    // The format loaded successfully, but the handlers wont be registered until all site plugins have loaded.
                    if (_this.sitePluginsProvider.sitePluginsFinishedLoading) {
                        return _this.courseFormatDelegate.openCourse(navCtrl, course, params);
                    }
                    else {
                        // Wait for plugins to be loaded.
                        var deferred_1 = _this.utils.promiseDefer(), observer_1 = _this.eventsProvider.on(__WEBPACK_IMPORTED_MODULE_3__providers_events__["a" /* CoreEventsProvider */].SITE_PLUGINS_LOADED, function () {
                            observer_1 && observer_1.off();
                            _this.courseFormatDelegate.openCourse(navCtrl, course, params).then(function (response) {
                                deferred_1.resolve(response);
                            }).catch(function (error) {
                                deferred_1.reject(error);
                            });
                        });
                        return deferred_1.promise;
                    }
                }).catch(function () {
                    // The site plugin failed to load. The user needs to restart the app to try loading it again.
                    var message = _this.translate.instant('core.courses.errorloadplugins');
                    var reload = _this.translate.instant('core.courses.reload');
                    var ignore = _this.translate.instant('core.courses.ignore');
                    _this.domUtils.showConfirm(message, '', reload, ignore).then(function () {
                        window.location.reload();
                    });
                });
            }
            else {
                // No custom format plugin. We don't need to wait for anything.
                return _this.courseFormatDelegate.openCourse(navCtrl, course, params);
            }
        }).finally(function () {
            loading.dismiss();
        });
    };
    /**
     * Select a certain tab in the course. Please use currentViewIsCourse() first to verify user is viewing the course.
     *
     * @param {string} [name] Name of the tab. If not provided, course contents.
     * @param {any} [params] Other params.
     */
    CoreCourseProvider.prototype.selectCourseTab = function (name, params) {
        params = params || {};
        params.name = name || '';
        this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_3__providers_events__["a" /* CoreEventsProvider */].SELECT_COURSE_TAB, params);
    };
    /**
     * Change the course status, setting it to the previous status.
     *
     * @param {number} courseId Course ID.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<string>} Promise resolved when the status is changed. Resolve param: new status.
     */
    CoreCourseProvider.prototype.setCoursePreviousStatus = function (courseId, siteId) {
        var _this = this;
        siteId = siteId || this.sitesProvider.getCurrentSiteId();
        this.logger.debug("Set previous status for course " + courseId + " in site " + siteId);
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var db = site.getDb(), newData = {};
            // Get current stored data.
            return _this.getCourseStatusData(courseId, siteId).then(function (entry) {
                _this.logger.debug("Set previous status '" + entry.status + "' for course " + courseId);
                newData.status = entry.previous || __WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].NOT_DOWNLOADED;
                newData.updated = Date.now();
                if (entry.status == __WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].DOWNLOADING) {
                    // Going back from downloading to previous status, restore previous download time.
                    newData.downloadTime = entry.previousDownloadTime;
                }
                return db.updateRecords(_this.COURSE_STATUS_TABLE, newData, { id: courseId }).then(function () {
                    // Success updating, trigger event.
                    _this.triggerCourseStatusChanged(courseId, newData.status, siteId);
                    return newData.status;
                });
            });
        });
    };
    /**
     * Store course status.
     *
     * @param {number} courseId Course ID.
     * @param {string} status New course status.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<void>} Promise resolved when the status is stored.
     */
    CoreCourseProvider.prototype.setCourseStatus = function (courseId, status, siteId) {
        var _this = this;
        siteId = siteId || this.sitesProvider.getCurrentSiteId();
        this.logger.debug("Set status '" + status + "' for course " + courseId + " in site " + siteId);
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var downloadTime, previousDownloadTime;
            if (status == __WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].DOWNLOADING) {
                // Set download time if course is now downloading.
                downloadTime = _this.timeUtils.timestamp();
            }
            // Search current status to set it as previous status.
            return _this.getCourseStatusData(courseId, siteId).then(function (entry) {
                if (typeof downloadTime == 'undefined') {
                    // Keep previous download time.
                    downloadTime = entry.downloadTime;
                    previousDownloadTime = entry.previousDownloadTime;
                }
                else {
                    // The downloadTime will be updated, store current time as previous.
                    previousDownloadTime = entry.downloadTime;
                }
                return entry.status;
            }).catch(function () {
                // No previous status.
            }).then(function (previousStatus) {
                if (previousStatus != status) {
                    // Status has changed, update it.
                    var data = {
                        id: courseId,
                        status: status,
                        previous: previousStatus,
                        updated: new Date().getTime(),
                        downloadTime: downloadTime,
                        previousDownloadTime: previousDownloadTime
                    };
                    return site.getDb().insertRecord(_this.COURSE_STATUS_TABLE, data);
                }
            }).then(function () {
                // Success inserting, trigger event.
                _this.triggerCourseStatusChanged(courseId, status, siteId);
            });
        });
    };
    /**
     * Translate a module name to current language.
     *
     * @param {string} moduleName The module name.
     * @return {string} Translated name.
     */
    CoreCourseProvider.prototype.translateModuleName = function (moduleName) {
        if (this.CORE_MODULES.indexOf(moduleName) < 0) {
            moduleName = 'external-tool';
        }
        var langKey = 'core.mod_' + moduleName, translated = this.translate.instant(langKey);
        return translated !== langKey ? translated : moduleName;
    };
    /**
     * Trigger COURSE_STATUS_CHANGED with the right data.
     *
     * @param {number} courseId Course ID.
     * @param {string} status New course status.
     * @param {string} [siteId] Site ID. If not defined, current site.
     */
    CoreCourseProvider.prototype.triggerCourseStatusChanged = function (courseId, status, siteId) {
        this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_3__providers_events__["a" /* CoreEventsProvider */].COURSE_STATUS_CHANGED, {
            courseId: courseId,
            status: status
        }, siteId);
    };
    CoreCourseProvider.ALL_SECTIONS_ID = -2;
    CoreCourseProvider.STEALTH_MODULES_SECTION_ID = -1;
    CoreCourseProvider.ACCESS_GUEST = 'courses_access_guest';
    CoreCourseProvider.ACCESS_DEFAULT = 'courses_access_default';
    CoreCourseProvider.ALL_COURSES_CLEARED = -1;
    CoreCourseProvider.COMPLETION_TRACKING_NONE = 0;
    CoreCourseProvider.COMPLETION_TRACKING_MANUAL = 1;
    CoreCourseProvider.COMPLETION_TRACKING_AUTOMATIC = 2;
    CoreCourseProvider.COMPLETION_INCOMPLETE = 0;
    CoreCourseProvider.COMPLETION_COMPLETE = 1;
    CoreCourseProvider.COMPLETION_COMPLETE_PASS = 2;
    CoreCourseProvider.COMPLETION_COMPLETE_FAIL = 3;
    CoreCourseProvider.COMPONENT = 'CoreCourse';
    CoreCourseProvider = CoreCourseProvider_1 = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_4__providers_logger__["a" /* CoreLoggerProvider */], __WEBPACK_IMPORTED_MODULE_5__providers_sites__["a" /* CoreSitesProvider */], __WEBPACK_IMPORTED_MODULE_3__providers_events__["a" /* CoreEventsProvider */],
            __WEBPACK_IMPORTED_MODULE_8__providers_utils_utils__["a" /* CoreUtilsProvider */], __WEBPACK_IMPORTED_MODULE_7__providers_utils_time__["a" /* CoreTimeUtilsProvider */], __WEBPACK_IMPORTED_MODULE_1__ngx_translate_core__["c" /* TranslateService */],
            __WEBPACK_IMPORTED_MODULE_11__course_offline__["a" /* CoreCourseOfflineProvider */], __WEBPACK_IMPORTED_MODULE_2__providers_app__["a" /* CoreAppProvider */],
            __WEBPACK_IMPORTED_MODULE_13__format_delegate__["a" /* CoreCourseFormatDelegate */], __WEBPACK_IMPORTED_MODULE_12__core_siteplugins_providers_siteplugins__["a" /* CoreSitePluginsProvider */],
            __WEBPACK_IMPORTED_MODULE_6__providers_utils_dom__["a" /* CoreDomUtilsProvider */], __WEBPACK_IMPORTED_MODULE_14__core_pushnotifications_providers_pushnotifications__["a" /* CorePushNotificationsProvider */]])
    ], CoreCourseProvider);
    return CoreCourseProvider;
    var CoreCourseProvider_1;
}());

//# sourceMappingURL=course.js.map

/***/ }),
/* 15 */,
/* 16 */,
/* 17 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreFilepoolProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__ionic_native_network__ = __webpack_require__(213);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__app__ = __webpack_require__(9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__events__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__file__ = __webpack_require__(53);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__init__ = __webpack_require__(145);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__logger__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__plugin_file_delegate__ = __webpack_require__(264);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__sites__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__ws__ = __webpack_require__(202);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__utils_dom__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__utils_mimetype__ = __webpack_require__(66);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__utils_text__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__utils_time__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14__utils_url__ = __webpack_require__(23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15__utils_utils__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_16__core_constants__ = __webpack_require__(40);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_17_ts_md5_dist_md5__ = __webpack_require__(203);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_17_ts_md5_dist_md5___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_17_ts_md5_dist_md5__);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};


















/*
 * Factory for handling downloading files and retrieve downloaded files.
 *
 * @description
 * This factory is responsible for handling downloading files.
 *
 * The two main goals of this is to keep the content available offline, and improve the user experience by caching
 * the content locally.
 */
var CoreFilepoolProvider = /** @class */ (function () {
    function CoreFilepoolProvider(logger, appProvider, fileProvider, sitesProvider, wsProvider, textUtils, utils, mimeUtils, urlUtils, timeUtils, eventsProvider, initDelegate, network, pluginFileDelegate, domUtils, zone) {
        var _this = this;
        this.appProvider = appProvider;
        this.fileProvider = fileProvider;
        this.sitesProvider = sitesProvider;
        this.wsProvider = wsProvider;
        this.textUtils = textUtils;
        this.utils = utils;
        this.mimeUtils = mimeUtils;
        this.urlUtils = urlUtils;
        this.timeUtils = timeUtils;
        this.eventsProvider = eventsProvider;
        this.pluginFileDelegate = pluginFileDelegate;
        this.domUtils = domUtils;
        // Constants.
        this.QUEUE_PROCESS_INTERVAL = 0;
        this.FOLDER = 'filepool';
        this.WIFI_DOWNLOAD_THRESHOLD = 20971520; // 20MB.
        this.DOWNLOAD_THRESHOLD = 2097152; // 2MB.
        this.QUEUE_RUNNING = 'CoreFilepool:QUEUE_RUNNING';
        this.QUEUE_PAUSED = 'CoreFilepool:QUEUE_PAUSED';
        this.ERR_QUEUE_IS_EMPTY = 'CoreFilepoolError:ERR_QUEUE_IS_EMPTY';
        this.ERR_FS_OR_NETWORK_UNAVAILABLE = 'CoreFilepoolError:ERR_FS_OR_NETWORK_UNAVAILABLE';
        this.ERR_QUEUE_ON_PAUSE = 'CoreFilepoolError:ERR_QUEUE_ON_PAUSE';
        // Variables for database.
        this.QUEUE_TABLE = 'filepool_files_queue'; // Queue of files to download.
        this.FILES_TABLE = 'filepool_files'; // Downloaded files.
        this.LINKS_TABLE = 'filepool_files_links'; // Links between downloaded files and components.
        this.PACKAGES_TABLE = 'filepool_packages'; // Downloaded packages (sets of files).
        this.appTablesSchema = [
            {
                name: this.QUEUE_TABLE,
                columns: [
                    {
                        name: 'siteId',
                        type: 'TEXT'
                    },
                    {
                        name: 'fileId',
                        type: 'TEXT'
                    },
                    {
                        name: 'added',
                        type: 'INTEGER'
                    },
                    {
                        name: 'priority',
                        type: 'INTEGER'
                    },
                    {
                        name: 'url',
                        type: 'TEXT'
                    },
                    {
                        name: 'revision',
                        type: 'INTEGER'
                    },
                    {
                        name: 'timemodified',
                        type: 'INTEGER'
                    },
                    {
                        name: 'isexternalfile',
                        type: 'INTEGER'
                    },
                    {
                        name: 'repositorytype',
                        type: 'TEXT'
                    },
                    {
                        name: 'path',
                        type: 'TEXT'
                    },
                    {
                        name: 'links',
                        type: 'TEXT'
                    }
                ],
                primaryKeys: ['siteId', 'fileId']
            }
        ];
        this.siteSchema = {
            name: 'CoreFilepoolProvider',
            version: 1,
            tables: [
                {
                    name: this.FILES_TABLE,
                    columns: [
                        {
                            name: 'fileId',
                            type: 'TEXT',
                            primaryKey: true
                        },
                        {
                            name: 'url',
                            type: 'TEXT',
                            notNull: true
                        },
                        {
                            name: 'revision',
                            type: 'INTEGER'
                        },
                        {
                            name: 'timemodified',
                            type: 'INTEGER'
                        },
                        {
                            name: 'stale',
                            type: 'INTEGER'
                        },
                        {
                            name: 'downloadTime',
                            type: 'INTEGER'
                        },
                        {
                            name: 'isexternalfile',
                            type: 'INTEGER'
                        },
                        {
                            name: 'repositorytype',
                            type: 'TEXT'
                        },
                        {
                            name: 'path',
                            type: 'TEXT'
                        },
                        {
                            name: 'extension',
                            type: 'TEXT'
                        }
                    ]
                },
                {
                    name: this.LINKS_TABLE,
                    columns: [
                        {
                            name: 'fileId',
                            type: 'TEXT'
                        },
                        {
                            name: 'component',
                            type: 'TEXT'
                        },
                        {
                            name: 'componentId',
                            type: 'TEXT'
                        }
                    ],
                    primaryKeys: ['fileId', 'component', 'componentId']
                },
                {
                    name: this.PACKAGES_TABLE,
                    columns: [
                        {
                            name: 'id',
                            type: 'TEXT',
                            primaryKey: true
                        },
                        {
                            name: 'component',
                            type: 'TEXT'
                        },
                        {
                            name: 'componentId',
                            type: 'TEXT'
                        },
                        {
                            name: 'status',
                            type: 'TEXT'
                        },
                        {
                            name: 'previous',
                            type: 'TEXT'
                        },
                        {
                            name: 'updated',
                            type: 'INTEGER'
                        },
                        {
                            name: 'downloadTime',
                            type: 'INTEGER'
                        },
                        {
                            name: 'previousDownloadTime',
                            type: 'INTEGER'
                        },
                        {
                            name: 'extra',
                            type: 'TEXT'
                        }
                    ]
                }
            ]
        };
        this.tokenRegex = new RegExp('(\\?|&)token=([A-Za-z0-9]*)');
        this.urlAttributes = [
            this.tokenRegex,
            new RegExp('(\\?|&)forcedownload=[0-1]'),
            new RegExp('(\\?|&)preview=[A-Za-z0-9]+'),
            new RegExp('(\\?|&)offline=[0-1]', 'g')
        ];
        this.queueDeferreds = {}; // To handle file downloads using the queue.
        this.sizeCache = {}; // A "cache" to store file sizes to prevent performing too many HEAD requests.
        // Variables to prevent downloading packages/files twice at the same time.
        this.packagesPromises = {};
        this.filePromises = {};
        this.logger = logger.getInstance('CoreFilepoolProvider');
        this.appDB = this.appProvider.getDB();
        this.appDB.createTablesFromSchema(this.appTablesSchema);
        this.sitesProvider.registerSiteSchema(this.siteSchema);
        initDelegate.ready().then(function () {
            // Waiting for the app to be ready to start processing the queue.
            _this.checkQueueProcessing();
            // Start queue when device goes online.
            network.onConnect().subscribe(function () {
                // Execute the callback in the Angular zone, so change detection doesn't stop working.
                zone.run(function () {
                    _this.checkQueueProcessing();
                });
            });
        });
    }
    /**
     * Link a file with a component.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileId The file ID.
     * @param {string} component The component to link the file to.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @return {Promise<any>} Promise resolved on success.
     */
    CoreFilepoolProvider.prototype.addFileLink = function (siteId, fileId, component, componentId) {
        var _this = this;
        if (!component) {
            return Promise.reject(null);
        }
        componentId = this.fixComponentId(componentId);
        return this.sitesProvider.getSiteDb(siteId).then(function (db) {
            var newEntry = {
                fileId: fileId,
                component: component,
                componentId: componentId || ''
            };
            return db.insertRecord(_this.LINKS_TABLE, newEntry);
        });
    };
    /**
     * Link a file with a component by URL.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileUrl The file Url.
     * @param {string} component The component to link the file to.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @return {Promise<any>} Promise resolved on success.
     * @description
     * Use this method to create a link between a URL and a component. You usually do not need to call this manually since
     * downloading a file automatically does this. Note that this method does not check if the file exists in the pool.
     */
    CoreFilepoolProvider.prototype.addFileLinkByUrl = function (siteId, fileUrl, component, componentId) {
        var _this = this;
        return this.fixPluginfileURL(siteId, fileUrl).then(function (fileUrl) {
            var fileId = _this.getFileIdByUrl(fileUrl);
            return _this.addFileLink(siteId, fileId, component, componentId);
        });
    };
    /**
     * Link a file with several components.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileId The file ID.
     * @param {any[]} links Array of objects containing the component and optionally componentId.
     * @return {Promise<any>} Promise resolved on success.
     */
    CoreFilepoolProvider.prototype.addFileLinks = function (siteId, fileId, links) {
        var _this = this;
        var promises = [];
        links.forEach(function (link) {
            promises.push(_this.addFileLink(siteId, fileId, link.component, link.componentId));
        });
        return Promise.all(promises);
    };
    /**
     * Add files to queue using a URL.
     *
     * @param {string} siteId The site ID.
     * @param {any[]} files Array of files to add.
     * @param {string} [component] The component to link the file to.
     * @param {string|number} [componentId] An ID to use in conjunction with the component (optional).
     * @return {Promise<any>} Resolved on success.
     */
    CoreFilepoolProvider.prototype.addFilesToQueue = function (siteId, files, component, componentId) {
        return this.downloadOrPrefetchFiles(siteId, files, true, false, component, componentId);
    };
    /**
     * Add a file to the pool.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileId The file ID.
     * @param {any} data Additional information to store about the file (timemodified, url, ...). See FILES_TABLE schema.
     * @return {Promise<any>} Promise resolved on success.
     */
    CoreFilepoolProvider.prototype.addFileToPool = function (siteId, fileId, data) {
        var _this = this;
        var values = Object.assign({}, data);
        values.fileId = fileId;
        return this.sitesProvider.getSiteDb(siteId).then(function (db) {
            return db.insertRecord(_this.FILES_TABLE, values);
        });
    };
    /**
     * Adds a hash to a filename if needed.
     *
     * @param {string} url The URL of the file, already treated (decoded, without revision, etc.).
     * @param {string} filename The filename.
     * @return {string} The filename with the hash.
     */
    CoreFilepoolProvider.prototype.addHashToFilename = function (url, filename) {
        // Check if the file already has a hash. If a file is downloaded and re-uploaded with the app it will have a hash already.
        var matches = filename.match(/_[a-f0-9]{32}/g);
        if (matches && matches.length) {
            // There is at least 1 match. Get the last one.
            var hash = matches[matches.length - 1], treatedUrl = url.replace(hash, ''); // Remove the hash from the URL.
            // Check that the hash is valid.
            if ('_' + __WEBPACK_IMPORTED_MODULE_17_ts_md5_dist_md5__["Md5"].hashAsciiStr('url:' + treatedUrl) == hash) {
                // The data found is a hash of the URL, don't need to add it again.
                return filename;
            }
        }
        return filename + '_' + __WEBPACK_IMPORTED_MODULE_17_ts_md5_dist_md5__["Md5"].hashAsciiStr('url:' + url);
    };
    /**
     * Add a file to the queue.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileId The file ID.
     * @param {string} url The absolute URL to the file.
     * @param {number} priority The priority this file should get in the queue (range 0-999).
     * @param {number} revision The revision of the file.
     * @param {number} timemodified The time this file was modified. Can be used to check file state.
     * @param {string} [filePath] Filepath to download the file to. If not defined, download to the filepool folder.
     * @param {any} options Extra options (isexternalfile, repositorytype).
     * @param {any} [link] The link to add for the file.
     * @return {Promise<any>} Promise resolved when the file is downloaded.
     */
    CoreFilepoolProvider.prototype.addToQueue = function (siteId, fileId, url, priority, revision, timemodified, filePath, onProgress, options, link) {
        var _this = this;
        if (options === void 0) { options = {}; }
        this.logger.debug("Adding " + fileId + " to the queue");
        return this.appDB.insertRecord(this.QUEUE_TABLE, {
            siteId: siteId,
            fileId: fileId,
            url: url,
            priority: priority,
            revision: revision,
            timemodified: timemodified,
            path: filePath,
            isexternalfile: options.isexternalfile ? 1 : 0,
            repositorytype: options.repositorytype,
            links: JSON.stringify(link ? [link] : []),
            added: Date.now()
        }).then(function () {
            // Check if the queue is running.
            _this.checkQueueProcessing();
            _this.notifyFileDownloading(siteId, fileId);
            return _this.getQueuePromise(siteId, fileId, true, onProgress);
        });
    };
    /**
     * Add an entry to queue using a URL.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileUrl The absolute URL to the file.
     * @param {string} [component] The component to link the file to.
     * @param {string|number} [componentId] An ID to use in conjunction with the component (optional).
     * @param {number} [timemodified=0] The time this file was modified. Can be used to check file state.
     * @param {string} [filePath] Filepath to download the file to. If not defined, download to the filepool folder.
     * @param {Function} [onProgress] Function to call on progress.
     * @param {number} [priority=0] The priority this file should get in the queue (range 0-999).
     * @param {any} [options] Extra options (isexternalfile, repositorytype).
     * @param {number} [revision] File revision. If not defined, it will be calculated using the URL.
     * @return {Promise} Resolved on success.
     */
    CoreFilepoolProvider.prototype.addToQueueByUrl = function (siteId, fileUrl, component, componentId, timemodified, filePath, onProgress, priority, options, revision) {
        var _this = this;
        if (timemodified === void 0) { timemodified = 0; }
        if (priority === void 0) { priority = 0; }
        if (options === void 0) { options = {}; }
        var fileId, link, queueDeferred;
        if (!this.fileProvider.isAvailable()) {
            return Promise.reject(null);
        }
        return this.sitesProvider.getSite(siteId).then(function (site) {
            if (!site.canDownloadFiles()) {
                return Promise.reject(null);
            }
            return _this.fixPluginfileURL(siteId, fileUrl).then(function (fileUrl) {
                var primaryKey = { siteId: siteId, fileId: fileId };
                revision = revision || _this.getRevisionFromUrl(fileUrl);
                fileId = _this.getFileIdByUrl(fileUrl);
                // Set up the component.
                if (typeof component != 'undefined') {
                    link = {
                        component: component,
                        componentId: _this.fixComponentId(componentId)
                    };
                }
                // Retrieve the queue deferred now if it exists.
                // This is to prevent errors if file is removed from queue while we're checking if the file is in queue.
                queueDeferred = _this.getQueueDeferred(siteId, fileId, false, onProgress);
                return _this.hasFileInQueue(siteId, fileId).then(function (entry) {
                    var newData = {};
                    var foundLink = false;
                    if (entry) {
                        // We already have the file in queue, we update the priority and links.
                        if (entry.priority < priority) {
                            newData.priority = priority;
                        }
                        if (revision && entry.revision !== revision) {
                            newData.revision = revision;
                        }
                        if (timemodified && entry.timemodified !== timemodified) {
                            newData.timemodified = timemodified;
                        }
                        if (filePath && entry.path !== filePath) {
                            newData.path = filePath;
                        }
                        if (entry.isexternalfile !== options.isexternalfile && (entry.isexternalfile || options.isexternalfile)) {
                            newData.isexternalfile = options.isexternalfile;
                        }
                        if (entry.repositorytype !== options.repositorytype && (entry.repositorytype || options.repositorytype)) {
                            newData.repositorytype = options.repositorytype;
                        }
                        if (link) {
                            // We need to add the new link if it does not exist yet.
                            if (entry.links && entry.links.length) {
                                for (var i in entry.links) {
                                    var fileLink = entry.links[i];
                                    if (fileLink.component == link.component && fileLink.componentId == link.componentId) {
                                        foundLink = true;
                                        break;
                                    }
                                }
                            }
                            if (!foundLink) {
                                newData.links = entry.links || [];
                                newData.links.push(link);
                                newData.links = JSON.stringify(entry.links);
                            }
                        }
                        if (Object.keys(newData).length) {
                            // Update only when required.
                            _this.logger.debug("Updating file " + fileId + " which is already in queue");
                            return _this.appDB.updateRecords(_this.QUEUE_TABLE, newData, primaryKey).then(function () {
                                return _this.getQueuePromise(siteId, fileId, true, onProgress);
                            });
                        }
                        _this.logger.debug("File " + fileId + " already in queue and does not require update");
                        if (queueDeferred) {
                            // If we were able to retrieve the queue deferred before, we use that one.
                            return queueDeferred.promise;
                        }
                        else {
                            // Create a new deferred and return its promise.
                            return _this.getQueuePromise(siteId, fileId, true, onProgress);
                        }
                    }
                    else {
                        return _this.addToQueue(siteId, fileId, fileUrl, priority, revision, timemodified, filePath, onProgress, options, link);
                    }
                }, function () {
                    // Unsure why we could not get the record, let's add to the queue anyway.
                    return _this.addToQueue(siteId, fileId, fileUrl, priority, revision, timemodified, filePath, onProgress, options, link);
                });
            });
        });
    };
    /**
     * Adds a file to the queue if the size is allowed to be downloaded.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileUrl The absolute URL to the file.
     * @param {string} component The component to link the file to.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @param {number} [timemodified=0] The time this file was modified.
     * @param {boolean} [checkSize=true] True if we shouldn't download files if their size is big, false otherwise.
     * @param {boolean} [downloadUnknown] True to download file in WiFi if their size is unknown, false otherwise.
     *                                    Ignored if checkSize=false.
     * @param {any} [options] Extra options (isexternalfile, repositorytype).
     * @param {number} [revision] File revision. If not defined, it will be calculated using the URL.
     * @return {Promise<any>} Promise resolved when the file is downloaded.
     */
    CoreFilepoolProvider.prototype.addToQueueIfNeeded = function (siteId, fileUrl, component, componentId, timemodified, checkSize, downloadUnknown, options, revision) {
        var _this = this;
        if (timemodified === void 0) { timemodified = 0; }
        if (checkSize === void 0) { checkSize = true; }
        if (options === void 0) { options = {}; }
        var promise;
        if (checkSize) {
            if (typeof this.sizeCache[fileUrl] != 'undefined') {
                promise = Promise.resolve(this.sizeCache[fileUrl]);
            }
            else {
                if (!this.appProvider.isOnline()) {
                    // Cannot check size in offline, stop.
                    return Promise.reject(null);
                }
                promise = this.wsProvider.getRemoteFileSize(fileUrl);
            }
            // Calculate the size of the file.
            return promise.then(function (size) {
                var isWifi = _this.appProvider.isWifi(), sizeUnknown = size <= 0;
                if (!sizeUnknown) {
                    // Store the size in the cache.
                    _this.sizeCache[fileUrl] = size;
                }
                // Check if the file should be downloaded.
                if (sizeUnknown) {
                    if (downloadUnknown && isWifi) {
                        return _this.addToQueueByUrl(siteId, fileUrl, component, componentId, timemodified, undefined, undefined, 0, options, revision);
                    }
                }
                else if (size <= _this.DOWNLOAD_THRESHOLD || (isWifi && size <= _this.WIFI_DOWNLOAD_THRESHOLD)) {
                    return _this.addToQueueByUrl(siteId, fileUrl, component, componentId, timemodified, undefined, undefined, 0, options, revision);
                }
            });
        }
        else {
            // No need to check size, just add it to the queue.
            return this.addToQueueByUrl(siteId, fileUrl, component, componentId, timemodified, undefined, undefined, 0, options, revision);
        }
    };
    /**
     * Check the queue processing.
     *
     * @description
     * In mose cases, this will enable the queue processing if it was paused.
     * Though, this will disable the queue if we are missing network or if the file system
     * is not accessible. Also, this will have no effect if the queue is already running.
     */
    CoreFilepoolProvider.prototype.checkQueueProcessing = function () {
        if (!this.fileProvider.isAvailable() || !this.appProvider.isOnline()) {
            this.queueState = this.QUEUE_PAUSED;
            return;
        }
        else if (this.queueState === this.QUEUE_RUNNING) {
            return;
        }
        this.queueState = this.QUEUE_RUNNING;
        this.processQueue();
    };
    /**
     * Clear all packages status in a site.
     *
     * @param {string} siteId Site ID.
     * @return {Promise<any>} Promise resolved when all status are cleared.
     */
    CoreFilepoolProvider.prototype.clearAllPackagesStatus = function (siteId) {
        var _this = this;
        this.logger.debug('Clear all packages status for site ' + siteId);
        return this.sitesProvider.getSite(siteId).then(function (site) {
            // Get all the packages to be able to "notify" the change in the status.
            return site.getDb().getAllRecords(_this.PACKAGES_TABLE).then(function (entries) {
                // Delete all the entries.
                return site.getDb().deleteRecords(_this.PACKAGES_TABLE).then(function () {
                    entries.forEach(function (entry) {
                        // Trigger module status changed, setting it as not downloaded.
                        _this.triggerPackageStatusChanged(siteId, __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].NOT_DOWNLOADED, entry.component, entry.componentId);
                    });
                });
            });
        });
    };
    /**
     * Clears the filepool. Use it only when all the files from a site are deleted.
     *
     * @param  {string} siteId ID of the site to clear.
     * @return {Promise<any>} Promise resolved when the filepool is cleared.
     */
    CoreFilepoolProvider.prototype.clearFilepool = function (siteId) {
        var _this = this;
        return this.sitesProvider.getSiteDb(siteId).then(function (db) {
            return Promise.all([
                db.deleteRecords(_this.FILES_TABLE),
                db.deleteRecords(_this.LINKS_TABLE)
            ]);
        });
    };
    /**
     * Returns whether a component has files in the pool.
     *
     * @param {string} siteId The site ID.
     * @param {string} component The component to link the file to.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @return {Promise<void>} Resolved means yes, rejected means no.
     */
    CoreFilepoolProvider.prototype.componentHasFiles = function (siteId, component, componentId) {
        var _this = this;
        return this.sitesProvider.getSiteDb(siteId).then(function (db) {
            var conditions = {
                component: component,
                componentId: componentId || ''
            };
            return db.countRecords(_this.LINKS_TABLE, conditions).then(function (count) {
                if (count <= 0) {
                    return Promise.reject(null);
                }
            });
        });
    };
    /**
     * Given the current status of a list of packages and the status of one of the packages,
     * determine the new status for the list of packages. The status of a list of packages is:
     *     - CoreConstants.NOT_DOWNLOADABLE if there are no downloadable packages.
     *     - CoreConstants.NOT_DOWNLOADED if at least 1 package has status CoreConstants.NOT_DOWNLOADED.
     *     - CoreConstants.DOWNLOADED if ALL the downloadable packages have status CoreConstants.DOWNLOADED.
     *     - CoreConstants.DOWNLOADING if ALL the downloadable packages have status CoreConstants.DOWNLOADING or
     *                                     CoreConstants.DOWNLOADED, with at least 1 package with CoreConstants.DOWNLOADING.
     *     - CoreConstants.OUTDATED if ALL the downloadable packages have status CoreConstants.OUTDATED or CoreConstants.DOWNLOADED
     *                                     or CoreConstants.DOWNLOADING, with at least 1 package with CoreConstants.OUTDATED.
     *
     * @param {string} current Current status of the list of packages.
     * @param {string} packagestatus Status of one of the packages.
     * @return {string} New status for the list of packages;
     */
    CoreFilepoolProvider.prototype.determinePackagesStatus = function (current, packageStatus) {
        if (!current) {
            current = __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].NOT_DOWNLOADABLE;
        }
        if (packageStatus === __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].NOT_DOWNLOADED) {
            // If 1 package is not downloaded the status of the whole list will always be not downloaded.
            return __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].NOT_DOWNLOADED;
        }
        else if (packageStatus === __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].DOWNLOADED && current === __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].NOT_DOWNLOADABLE) {
            // If all packages are downloaded or not downloadable with at least 1 downloaded, status will be downloaded.
            return __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].DOWNLOADED;
        }
        else if (packageStatus === __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].DOWNLOADING &&
            (current === __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].NOT_DOWNLOADABLE || current === __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].DOWNLOADED)) {
            // If all packages are downloading/downloaded/notdownloadable with at least 1 downloading, status will be downloading.
            return __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].DOWNLOADING;
        }
        else if (packageStatus === __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].OUTDATED && current !== __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].NOT_DOWNLOADED) {
            // If there are no packages notdownloaded and there is at least 1 outdated, status will be outdated.
            return __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].OUTDATED;
        }
        // Status remains the same.
        return current;
    };
    /**
     * Downloads a URL and update or add it to the pool.
     *
     * This uses the file system, you should always make sure that it is accessible before calling this method.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileUrl The file URL.
     * @param {any} [options] Extra options (revision, timemodified, isexternalfile, repositorytype).
     * @param {string} [filePath] Filepath to download the file to. If defined, no extension will be added.
     * @param {Function} [onProgress] Function to call on progress.
     * @param {CoreFilepoolFileEntry} [poolFileObject] When set, the object will be updated, a new entry will not be created.
     * @return {Promise<any>} Resolved with internal URL on success, rejected otherwise.
     */
    CoreFilepoolProvider.prototype.downloadForPoolByUrl = function (siteId, fileUrl, options, filePath, onProgress, poolFileObject) {
        var _this = this;
        if (options === void 0) { options = {}; }
        var fileId = this.getFileIdByUrl(fileUrl), extension = this.mimeUtils.guessExtensionFromUrl(fileUrl), addExtension = typeof filePath == 'undefined', pathPromise = filePath ? filePath : this.getFilePath(siteId, fileId, extension);
        return Promise.resolve(pathPromise).then(function (filePath) {
            if (poolFileObject && poolFileObject.fileId !== fileId) {
                _this.logger.error('Invalid object to update passed');
                return Promise.reject(null);
            }
            var downloadId = _this.getFileDownloadId(fileUrl, filePath);
            if (_this.filePromises[siteId] && _this.filePromises[siteId][downloadId]) {
                // There's already a download ongoing for this file in this location, return the promise.
                return _this.filePromises[siteId][downloadId];
            }
            else if (!_this.filePromises[siteId]) {
                _this.filePromises[siteId] = {};
            }
            _this.filePromises[siteId][downloadId] = _this.sitesProvider.getSite(siteId).then(function (site) {
                if (!site.canDownloadFiles()) {
                    return Promise.reject(null);
                }
                return _this.wsProvider.downloadFile(fileUrl, filePath, addExtension, onProgress).then(function (fileEntry) {
                    var data = poolFileObject || {};
                    data.downloadTime = Date.now();
                    data.stale = 0;
                    data.url = fileUrl;
                    data.revision = options.revision;
                    data.timemodified = options.timemodified;
                    data.isexternalfile = options.isexternalfile ? 1 : 0;
                    data.repositorytype = options.repositorytype;
                    data.path = fileEntry.path;
                    data.extension = fileEntry.extension;
                    return _this.addFileToPool(siteId, fileId, data).then(function () {
                        return fileEntry.toURL();
                    });
                });
            }).finally(function () {
                // Download finished, delete the promise.
                delete _this.filePromises[siteId][downloadId];
            });
            return _this.filePromises[siteId][downloadId];
        });
    };
    /**
     * Download or prefetch several files into the filepool folder.
     *
     * @param {string} siteId The site ID.
     * @param {any[]} files Array of files to download.
     * @param {boolean} prefetch True if should prefetch the contents (queue), false if they should be downloaded right now.
     * @param {boolean} [ignoreStale] True if 'stale' should be ignored. Only if prefetch=false.
     * @param {string} [component] The component to link the file to.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @param {string} [dirPath] Name of the directory where to store the files (inside filepool dir). If not defined, store
     *                           the files directly inside the filepool folder.
     * @return {Promise<any>} Resolved on success.
     */
    CoreFilepoolProvider.prototype.downloadOrPrefetchFiles = function (siteId, files, prefetch, ignoreStale, component, componentId, dirPath) {
        var _this = this;
        var promises = [];
        // Download files.
        files.forEach(function (file) {
            var url = file.url || file.fileurl, timemodified = file.timemodified, options = {
                isexternalfile: file.isexternalfile,
                repositorytype: file.repositorytype
            };
            var path;
            if (dirPath) {
                // Calculate the path to the file.
                path = file.filename;
                if (file.filepath !== '/') {
                    path = file.filepath.substr(1) + path;
                }
                path = _this.textUtils.concatenatePaths(dirPath, path);
            }
            if (prefetch) {
                promises.push(_this.addToQueueByUrl(siteId, url, component, componentId, timemodified, path, undefined, 0, options));
            }
            else {
                promises.push(_this.downloadUrl(siteId, url, ignoreStale, component, componentId, timemodified, path, undefined, options));
            }
        });
        return this.utils.allPromises(promises);
    };
    /**
     * Downloads or prefetches a list of files as a "package".
     *
     * @param {string} siteId The site ID.
     * @param {any[]} fileList List of files to download.
     * @param {boolean} [prefetch] True if should prefetch the contents (queue), false if they should be downloaded right now.
     * @param {string} [component] The component to link the file to.
     * @param {string|number} [componentId]  An ID to use in conjunction with the component.
     * @param {string} [extra] Extra data to store for the package.
     * @param {string} [dirPath] Name of the directory where to store the files (inside filepool dir). If not defined, store
     *                           the files directly inside the filepool folder.
     * @param {Function} [onProgress] Function to call on progress.
     * @return {Promise<any>} Promise resolved when the package is downloaded.
     */
    CoreFilepoolProvider.prototype.downloadOrPrefetchPackage = function (siteId, fileList, prefetch, component, componentId, extra, dirPath, onProgress) {
        var _this = this;
        var packageId = this.getPackageId(component, componentId);
        var promise;
        if (this.packagesPromises[siteId] && this.packagesPromises[siteId][packageId]) {
            // There's already a download ongoing for this package, return the promise.
            return this.packagesPromises[siteId][packageId];
        }
        else if (!this.packagesPromises[siteId]) {
            this.packagesPromises[siteId] = {};
        }
        // Set package as downloading.
        promise = this.storePackageStatus(siteId, __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].DOWNLOADING, component, componentId).then(function () {
            var promises = [];
            var packageLoaded = 0;
            fileList.forEach(function (file) {
                var fileUrl = file.url || file.fileurl, options = {
                    isexternalfile: file.isexternalfile,
                    repositorytype: file.repositorytype
                };
                var path, promise, fileLoaded = 0, onFileProgress;
                if (onProgress) {
                    // There's a onProgress event, create a function to receive file download progress events.
                    onFileProgress = function (progress) {
                        if (progress && progress.loaded) {
                            // Add the new size loaded to the package loaded.
                            packageLoaded = packageLoaded + (progress.loaded - fileLoaded);
                            fileLoaded = progress.loaded;
                            onProgress({
                                packageDownload: true,
                                loaded: packageLoaded,
                                fileProgress: progress
                            });
                        }
                    };
                }
                if (dirPath) {
                    // Calculate the path to the file.
                    path = file.filename;
                    if (file.filepath !== '/') {
                        path = file.filepath.substr(1) + path;
                    }
                    path = _this.textUtils.concatenatePaths(dirPath, path);
                }
                if (prefetch) {
                    promise = _this.addToQueueByUrl(siteId, fileUrl, component, componentId, file.timemodified, path, undefined, 0, options);
                }
                else {
                    promise = _this.downloadUrl(siteId, fileUrl, false, component, componentId, file.timemodified, onFileProgress, path, options);
                }
                // Using undefined for success & fail will pass the success/failure to the parent promise.
                promises.push(promise);
            });
            return Promise.all(promises).then(function () {
                // Success prefetching, store package as downloaded.
                return _this.storePackageStatus(siteId, __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].DOWNLOADED, component, componentId, extra);
            }).catch(function (error) {
                // Error downloading, go back to previous status and reject the promise.
                return _this.setPackagePreviousStatus(siteId, component, componentId).then(function () {
                    return Promise.reject(error);
                });
            });
        }).finally(function () {
            // Download finished, delete the promise.
            delete _this.packagesPromises[siteId][packageId];
        });
        this.packagesPromises[siteId][packageId] = promise;
        return promise;
    };
    /**
     * Downloads a list of files.
     *
     * @param {string} siteId The site ID.
     * @param {any[]} fileList List of files to download.
     * @param {string} component The component to link the file to.
     * @param {string|number} [componentId] An ID to identify the download.
     * @param {string} [extra] Extra data to store for the package.
     * @param {string} [dirPath] Name of the directory where to store the files (inside filepool dir). If not defined, store
     *                           the files directly inside the filepool folder.
     * @param {Function} [onProgress] Function to call on progress.
     * @return {Promise<any>}  Promise resolved when all files are downloaded.
     */
    CoreFilepoolProvider.prototype.downloadPackage = function (siteId, fileList, component, componentId, extra, dirPath, onProgress) {
        return this.downloadOrPrefetchPackage(siteId, fileList, false, component, componentId, extra, dirPath, onProgress);
    };
    /**
     * Downloads a file on the spot.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileUrl The file URL.
     * @param {boolean} [ignoreStale] Whether 'stale' should be ignored.
     * @param {string} [component] The component to link the file to.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @param {number} [timemodified=0] The time this file was modified. Can be used to check file state.
     * @param {string} [filePath] Filepath to download the file to. If not defined, download to the filepool folder.
     * @param {any} [options] Extra options (isexternalfile, repositorytype).
     * @param {number} [revision] File revision. If not defined, it will be calculated using the URL.
     * @return {Promise<any>} Resolved with internal URL on success, rejected otherwise.
     * @description
     * Downloads a file on the spot.
     *
     * This will also take care of adding the file to the pool if it's missing. However, please note that this will
     * not force a file to be re-downloaded if it is already part of the pool. You should mark a file as stale using
     * invalidateFileByUrl to trigger a download.
     */
    CoreFilepoolProvider.prototype.downloadUrl = function (siteId, fileUrl, ignoreStale, component, componentId, timemodified, onProgress, filePath, options, revision) {
        var _this = this;
        if (timemodified === void 0) { timemodified = 0; }
        if (options === void 0) { options = {}; }
        var fileId, promise;
        if (this.fileProvider.isAvailable()) {
            return this.fixPluginfileURL(siteId, fileUrl).then(function (fixedUrl) {
                fileUrl = fixedUrl;
                options = Object.assign({}, options); // Create a copy to prevent modifying the original object.
                options.timemodified = timemodified || 0;
                options.revision = revision || _this.getRevisionFromUrl(fileUrl);
                fileId = _this.getFileIdByUrl(fileUrl);
                return _this.hasFileInPool(siteId, fileId).then(function (fileObject) {
                    if (typeof fileObject === 'undefined') {
                        // We do not have the file, download and add to pool.
                        _this.notifyFileDownloading(siteId, fileId);
                        return _this.downloadForPoolByUrl(siteId, fileUrl, options, filePath, onProgress);
                    }
                    else if (_this.isFileOutdated(fileObject, options.revision, options.timemodified) &&
                        _this.appProvider.isOnline() && !ignoreStale) {
                        // The file is outdated, force the download and update it.
                        _this.notifyFileDownloading(siteId, fileId);
                        return _this.downloadForPoolByUrl(siteId, fileUrl, options, filePath, onProgress, fileObject);
                    }
                    // Everything is fine, return the file on disk.
                    if (filePath) {
                        promise = _this.getInternalUrlByPath(filePath);
                    }
                    else {
                        promise = _this.getInternalUrlById(siteId, fileId);
                    }
                    return promise.then(function (response) {
                        return response;
                    }, function () {
                        // The file was not found in the pool, weird.
                        _this.notifyFileDownloading(siteId, fileId);
                        return _this.downloadForPoolByUrl(siteId, fileUrl, options, filePath, onProgress, fileObject);
                    });
                }, function () {
                    // The file is not in the pool just yet.
                    _this.notifyFileDownloading(siteId, fileId);
                    return _this.downloadForPoolByUrl(siteId, fileUrl, options, filePath, onProgress);
                }).then(function (response) {
                    if (typeof component != 'undefined') {
                        _this.addFileLink(siteId, fileId, component, componentId).catch(function () {
                            // Ignore errors.
                        });
                    }
                    _this.notifyFileDownloaded(siteId, fileId);
                    return response;
                }, function (err) {
                    _this.notifyFileDownloadError(siteId, fileId);
                    return Promise.reject(err);
                });
            });
        }
        else {
            return Promise.reject(null);
        }
    };
    /**
     * Fill Missing Extension In the File Object if needed.
     * This is to migrate from old versions.
     *
     * @param {CoreFilepoolFileEntry} fileObject File object to be migrated.
     * @param {string} siteId SiteID to get migrated.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreFilepoolProvider.prototype.fillExtensionInFile = function (entry, siteId) {
        var _this = this;
        if (typeof entry.extension != 'undefined') {
            // Already filled.
            return Promise.resolve();
        }
        return this.sitesProvider.getSiteDb(siteId).then(function (db) {
            var extension = _this.mimeUtils.getFileExtension(entry.path);
            if (!extension) {
                // Files does not have extension. Invalidate file (stale = true).
                // Minor problem: file will remain in the filesystem once downloaded again.
                _this.logger.debug('Staled file with no extension ' + entry.fileId);
                return db.updateRecords(_this.FILES_TABLE, { stale: 1 }, { fileId: entry.fileId });
            }
            // File has extension. Save extension, and add extension to path.
            var fileId = entry.fileId;
            entry.fileId = _this.mimeUtils.removeExtension(fileId);
            entry.extension = extension;
            return db.updateRecords(_this.FILES_TABLE, entry, { fileId: fileId }).then(function () {
                if (entry.fileId == fileId) {
                    // File ID hasn't changed, we're done.
                    _this.logger.debug('Removed extesion ' + extension + ' from file ' + entry.fileId);
                    return;
                }
                // Now update the links.
                return db.updateRecords(_this.LINKS_TABLE, { fileId: entry.fileId }, { fileId: fileId });
            });
        });
    };
    /**
     * Fill Missing Extension In Files, used to migrate from previous file handling.
     * Reserved for core use, please do not call.
     *
     * @param {string} siteId SiteID to get migrated
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreFilepoolProvider.prototype.fillMissingExtensionInFiles = function (siteId) {
        var _this = this;
        this.logger.debug('Fill missing extensions in files of ' + siteId);
        return this.sitesProvider.getSiteDb(siteId).then(function (db) {
            return db.getAllRecords(_this.FILES_TABLE).then(function (entries) {
                var promises = [];
                entries.forEach(function (entry) {
                    promises.push(_this.fillExtensionInFile(entry, siteId));
                });
                return Promise.all(promises);
            });
        });
    };
    /**
     * Fix a component ID to always be a Number if possible.
     *
     * @param {string|number} componentId The component ID.
     * @return {string|number} The normalised component ID. -1 when undefined was passed.
     */
    CoreFilepoolProvider.prototype.fixComponentId = function (componentId) {
        if (typeof componentId == 'number') {
            return componentId;
        }
        // Try to convert it to a number.
        var id = parseInt(componentId, 10);
        if (isNaN(id)) {
            // Not a number.
            if (typeof componentId == 'undefined' || componentId === null) {
                return -1;
            }
            else {
                return componentId;
            }
        }
        return id;
    };
    /**
     * Add the wstoken url and points to the correct script.
     *
     * @param {string} siteId  The site ID.
     * @param {string} fileUrl The file URL.
     * @return {Promise}       Resolved with fixed URL on success, rejected otherwise.
     */
    CoreFilepoolProvider.prototype.fixPluginfileURL = function (siteId, fileUrl) {
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.fixPluginfileURL(fileUrl);
        });
    };
    /**
     * Convenience function to get component files.
     *
     * @param {SQLiteDB} db Site's DB.
     * @param {string} component The component to get.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @return {Promise<any[]>} Promise resolved with the files.
     */
    CoreFilepoolProvider.prototype.getComponentFiles = function (db, component, componentId) {
        var conditions = {
            component: component,
            componentId: componentId || ''
        };
        return db.getRecords(this.LINKS_TABLE, conditions);
    };
    /**
     * Returns the local URL of a directory.
     *
     * @param {string} siteId  The site ID.
     * @param {string} fileUrl The file URL.
     * @return {Promise}       Resolved with the URL. Rejected otherwise.
     */
    CoreFilepoolProvider.prototype.getDirectoryUrlByUrl = function (siteId, fileUrl) {
        var _this = this;
        if (this.fileProvider.isAvailable()) {
            return this.fixPluginfileURL(siteId, fileUrl).then(function (fileUrl) {
                var fileId = _this.getFileIdByUrl(fileUrl), filePath = _this.getFilePath(siteId, fileId, ''); // No extension, the function will return a string.
                return _this.fileProvider.getDir(filePath).then(function (dirEntry) {
                    return dirEntry.toURL();
                });
            });
        }
        return Promise.reject(null);
    };
    /**
     * Get the ID of a file download. Used to keep track of filePromises.
     *
     * @param {string} fileUrl  The file URL.
     * @param {string} filePath The file destination path.
     * @return {string}         File download ID.
     */
    CoreFilepoolProvider.prototype.getFileDownloadId = function (fileUrl, filePath) {
        return __WEBPACK_IMPORTED_MODULE_17_ts_md5_dist_md5__["Md5"].hashAsciiStr(fileUrl + '###' + filePath);
    };
    /**
     * Get the name of the event used to notify download events (CoreEventsProvider).
     *
     * @param {string} siteId The site ID.
     * @param {string} fileId The file ID.
     * @return {string} Event name.
     */
    CoreFilepoolProvider.prototype.getFileEventName = function (siteId, fileId) {
        return 'CoreFilepoolFile:' + siteId + ':' + fileId;
    };
    /**
     * Get the name of the event used to notify download events (CoreEventsProvider).
     *
     * @param {string} siteId  The site ID.
     * @param {string} fileUrl The absolute URL to the file.
     * @return {Promise}       Promise resolved with event name.
     */
    CoreFilepoolProvider.prototype.getFileEventNameByUrl = function (siteId, fileUrl) {
        var _this = this;
        return this.fixPluginfileURL(siteId, fileUrl).then(function (fileUrl) {
            var fileId = _this.getFileIdByUrl(fileUrl);
            return _this.getFileEventName(siteId, fileId);
        });
    };
    /**
     * Creates a unique ID based on a URL.
     *
     * This has a minimal handling of pluginfiles in order to generate a clean file ID which will not change if
     * pointing to the same pluginfile URL even if the token or extra attributes have changed.
     *
     * @param {string} fileUrl The absolute URL to the file.
     * @return {string} The file ID.
     */
    CoreFilepoolProvider.prototype.getFileIdByUrl = function (fileUrl) {
        var url = this.removeRevisionFromUrl(fileUrl), filename;
        // Decode URL.
        url = this.textUtils.decodeHTML(this.textUtils.decodeURIComponent(url));
        if (url.indexOf('/webservice/pluginfile') !== -1) {
            // Remove attributes that do not matter.
            this.urlAttributes.forEach(function (regex) {
                url = url.replace(regex, '');
            });
        }
        // Try to guess the filename the target file should have.
        // We want to keep the original file name so people can easily identify the files after the download.
        filename = this.guessFilenameFromUrl(url);
        return this.addHashToFilename(url, filename);
    };
    /**
     * Get the links of a file.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileId The file ID.
     * @return {Promise<any[]>} Promise resolved with the links.
     */
    CoreFilepoolProvider.prototype.getFileLinks = function (siteId, fileId) {
        var _this = this;
        return this.sitesProvider.getSiteDb(siteId).then(function (db) {
            return db.getRecords(_this.LINKS_TABLE, { fileId: fileId });
        });
    };
    /**
     * Get the path to a file. This does not check if the file exists or not.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileId The file ID.
     * @param {string} [extension] Previously calculated extension. Empty to not add any. Undefined to calculate it.
     * @return {string|Promise<string>} The path to the file relative to storage root.
     */
    CoreFilepoolProvider.prototype.getFilePath = function (siteId, fileId, extension) {
        var path = this.getFilepoolFolderPath(siteId) + '/' + fileId;
        if (typeof extension == 'undefined') {
            // We need the extension to be able to open files properly.
            return this.hasFileInPool(siteId, fileId).then(function (entry) {
                if (entry.extension) {
                    path += '.' + entry.extension;
                }
                return path;
            }).catch(function () {
                // If file not found, use the path without extension.
                return path;
            });
        }
        else {
            if (extension) {
                path += '.' + extension;
            }
            return path;
        }
    };
    /**
     * Get the path to a file from its URL. This does not check if the file exists or not.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileUrl The file URL.
     * @return {Promise<string>} Promise resolved with the path to the file relative to storage root.
     */
    CoreFilepoolProvider.prototype.getFilePathByUrl = function (siteId, fileUrl) {
        var _this = this;
        return this.fixPluginfileURL(siteId, fileUrl).then(function (fileUrl) {
            var fileId = _this.getFileIdByUrl(fileUrl);
            return _this.getFilePath(siteId, fileId);
        });
    };
    /**
     * Get site Filepool Folder Path
     *
     * @param {string} siteId The site ID.
     * @return {string} The root path to the filepool of the site.
     */
    CoreFilepoolProvider.prototype.getFilepoolFolderPath = function (siteId) {
        return this.fileProvider.getSiteFolder(siteId) + '/' + this.FOLDER;
    };
    /**
     * Get all the matching files from a component. Returns objects containing properties like path, extension and url.
     *
     * @param {string} siteId The site ID.
     * @param {string} component The component to get.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @return {Promise<any[]>} Promise resolved with the files on success.
     */
    CoreFilepoolProvider.prototype.getFilesByComponent = function (siteId, component, componentId) {
        var _this = this;
        return this.sitesProvider.getSiteDb(siteId).then(function (db) {
            return _this.getComponentFiles(db, component, componentId).then(function (items) {
                var promises = [], files = [];
                items.forEach(function (item) {
                    promises.push(db.getRecord(_this.FILES_TABLE, { fileId: item.fileId }).then(function (fileEntry) {
                        if (!fileEntry) {
                            return;
                        }
                        files.push({
                            url: fileEntry.url,
                            path: fileEntry.path,
                            extension: fileEntry.extension,
                            revision: fileEntry.revision,
                            timemodified: fileEntry.timemodified
                        });
                    }).catch(function () {
                        // File not found, ignore error.
                    }));
                });
                return Promise.all(promises).then(function () {
                    return files;
                });
            });
        });
    };
    /**
     * Get the size of all the files from a component.
     *
     * @param {string} siteId The site ID.
     * @param {string} component    The component to get.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @return {Promise<number>} Promise resolved with the size on success.
     */
    CoreFilepoolProvider.prototype.getFilesSizeByComponent = function (siteId, component, componentId) {
        var _this = this;
        return this.getFilesByComponent(siteId, component, componentId).then(function (files) {
            var promises = [];
            var size = 0;
            files.forEach(function (file) {
                promises.push(_this.fileProvider.getFileSize(file.path).then(function (fs) {
                    size += fs;
                }).catch(function () {
                    // Ignore failures, maybe some file was deleted.
                }));
            });
            return Promise.all(promises).then(function () {
                return size;
            });
        });
    };
    /**
     * Returns the file state: mmCoreDownloaded, mmCoreDownloading, mmCoreNotDownloaded or mmCoreOutdated.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileUrl File URL.
     * @param {number} [timemodified=0] The time this file was modified.
     * @param {string} [filePath] Filepath to download the file to. If defined, no extension will be added.
     * @param {number} [revision] File revision. If not defined, it will be calculated using the URL.
     * @return {Promise<string>} Promise resolved with the file state.
     */
    CoreFilepoolProvider.prototype.getFileStateByUrl = function (siteId, fileUrl, timemodified, filePath, revision) {
        var _this = this;
        if (timemodified === void 0) { timemodified = 0; }
        var fileId;
        return this.fixPluginfileURL(siteId, fileUrl).then(function (fixedUrl) {
            fileUrl = fixedUrl;
            revision = revision || _this.getRevisionFromUrl(fileUrl);
            fileId = _this.getFileIdByUrl(fileUrl);
            // Check if the file is in queue (waiting to be downloaded).
            return _this.hasFileInQueue(siteId, fileId).then(function () {
                return __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].DOWNLOADING;
            }).catch(function () {
                // Check if the file is being downloaded right now.
                var extension = _this.mimeUtils.guessExtensionFromUrl(fileUrl), path = filePath ? filePath : _this.getFilePath(siteId, fileId, extension);
                return Promise.resolve(path).then(function (filePath) {
                    var downloadId = _this.getFileDownloadId(fileUrl, filePath);
                    if (_this.filePromises[siteId] && _this.filePromises[siteId][downloadId]) {
                        return __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].DOWNLOADING;
                    }
                    // File is not being downloaded. Check if it's downloaded and if it's outdated.
                    return _this.hasFileInPool(siteId, fileId).then(function (entry) {
                        if (_this.isFileOutdated(entry, revision, timemodified)) {
                            return __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].OUTDATED;
                        }
                        else {
                            return __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].DOWNLOADED;
                        }
                    }).catch(function () {
                        return __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].NOT_DOWNLOADED;
                    });
                });
            });
        });
    };
    /**
     * Returns an absolute URL to access the file URL.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileUrl The absolute URL to the file.
     * @param {string} [mode=url] The type of URL to return. Accepts 'url' or 'src'.
     * @param {string} component The component to link the file to.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @param {number} [timemodified=0] The time this file was modified.
     * @param {boolean} [checkSize=true] True if we shouldn't download files if their size is big, false otherwise.
     * @param {boolean} [downloadUnknown] True to download file in WiFi if their size is unknown, false otherwise.
     *                                    Ignored if checkSize=false.
     * @param {any} [options] Extra options (isexternalfile, repositorytype).
     * @param {number} [revision] File revision. If not defined, it will be calculated using the URL.
     * @return {Promise<string>} Resolved with the URL to use.
     * @description
     * This will return a URL pointing to the content of the requested URL.
     *
     * This handles the queue and validity of the file. If there is a local file and it's valid, return the local URL.
     * If the file isn't downloaded or it's outdated, return the online URL and add it to the queue to be downloaded later.
     */
    CoreFilepoolProvider.prototype.getFileUrlByUrl = function (siteId, fileUrl, component, componentId, mode, timemodified, checkSize, downloadUnknown, options, revision) {
        var _this = this;
        if (mode === void 0) { mode = 'url'; }
        if (timemodified === void 0) { timemodified = 0; }
        if (checkSize === void 0) { checkSize = true; }
        if (options === void 0) { options = {}; }
        var fileId;
        var addToQueue = function (fileUrl) {
            // Add the file to queue if needed and ignore errors.
            _this.addToQueueIfNeeded(siteId, fileUrl, component, componentId, timemodified, checkSize, downloadUnknown, options, revision).catch(function () {
                // Ignore errors.
            });
        };
        return this.fixPluginfileURL(siteId, fileUrl).then(function (fixedUrl) {
            fileUrl = fixedUrl;
            revision = revision || _this.getRevisionFromUrl(fileUrl);
            fileId = _this.getFileIdByUrl(fileUrl);
            return _this.hasFileInPool(siteId, fileId).then(function (entry) {
                var response;
                if (typeof entry === 'undefined') {
                    // We do not have the file, add it to the queue, and return real URL.
                    addToQueue(fileUrl);
                    response = fileUrl;
                }
                else if (_this.isFileOutdated(entry, revision, timemodified) && _this.appProvider.isOnline()) {
                    // The file is outdated, we add to the queue and return real URL.
                    addToQueue(fileUrl);
                    response = fileUrl;
                }
                else {
                    // We found the file entry, now look for the file on disk.
                    if (mode === 'src') {
                        response = _this.getInternalSrcById(siteId, fileId);
                    }
                    else {
                        response = _this.getInternalUrlById(siteId, fileId);
                    }
                    response = response.then(function (internalUrl) {
                        // The file is on disk.
                        return internalUrl;
                    }).catch(function () {
                        // We could not retrieve the file, delete the entries associated with that ID.
                        _this.logger.debug('File ' + fileId + ' not found on disk');
                        _this.removeFileById(siteId, fileId);
                        addToQueue(fileUrl);
                        if (_this.appProvider.isOnline()) {
                            // We still have a chance to serve the right content.
                            return fileUrl;
                        }
                        return Promise.reject(null);
                    });
                }
                return response;
            }, function () {
                // We do not have the file in store yet. Add to queue and return the fixed URL.
                addToQueue(fileUrl);
                return fileUrl;
            });
        });
    };
    /**
     * Returns the internal SRC of a file.
     *
     * The returned URL from this method is typically used with IMG tags.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileId The file ID.
     * @return {Promise<string>} Resolved with the internal URL. Rejected otherwise.
     */
    CoreFilepoolProvider.prototype.getInternalSrcById = function (siteId, fileId) {
        var _this = this;
        if (this.fileProvider.isAvailable()) {
            return Promise.resolve(this.getFilePath(siteId, fileId)).then(function (path) {
                return _this.fileProvider.getFile(path).then(function (fileEntry) {
                    // We use toInternalURL so images are loaded in iOS8 using img HTML tags.
                    return _this.fileProvider.getInternalURL(fileEntry);
                });
            });
        }
        return Promise.reject(null);
    };
    /**
     * Returns the local URL of a file.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileId The file ID.
     * @return {Promise<string>} Resolved with the URL. Rejected otherwise.
     */
    CoreFilepoolProvider.prototype.getInternalUrlById = function (siteId, fileId) {
        var _this = this;
        if (this.fileProvider.isAvailable()) {
            return Promise.resolve(this.getFilePath(siteId, fileId)).then(function (path) {
                return _this.fileProvider.getFile(path).then(function (fileEntry) {
                    // This URL is usually used to launch files or put them in HTML. In desktop we need the internal URL.
                    if (_this.appProvider.isDesktop()) {
                        return fileEntry.toInternalURL();
                    }
                    else {
                        return fileEntry.toURL();
                    }
                });
            });
        }
        return Promise.reject(null);
    };
    /**
     * Returns the local URL of a file.
     *
     * @param {string} filePath The file path.
     * @return {Promise<string>} Resolved with the URL.
     */
    CoreFilepoolProvider.prototype.getInternalUrlByPath = function (filePath) {
        if (this.fileProvider.isAvailable()) {
            return this.fileProvider.getFile(filePath).then(function (fileEntry) {
                return fileEntry.toURL();
            });
        }
        return Promise.reject(null);
    };
    /**
     * Returns the local URL of a file.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileUrl The file URL.
     * @return {Promise<string>} Resolved with the URL. Rejected otherwise.
     */
    CoreFilepoolProvider.prototype.getInternalUrlByUrl = function (siteId, fileUrl) {
        var _this = this;
        if (this.fileProvider.isAvailable()) {
            return this.fixPluginfileURL(siteId, fileUrl).then(function (fileUrl) {
                var fileId = _this.getFileIdByUrl(fileUrl);
                return _this.getInternalUrlById(siteId, fileId);
            });
        }
        return Promise.reject(null);
    };
    /**
     * Get the data stored for a package.
     *
     * @param {string} siteId Site ID.
     * @param {string} component Package's component.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @return {Promise<CoreFilepoolPackageEntry>} Promise resolved with the data.
     */
    CoreFilepoolProvider.prototype.getPackageData = function (siteId, component, componentId) {
        var _this = this;
        componentId = this.fixComponentId(componentId);
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var packageId = _this.getPackageId(component, componentId);
            return site.getDb().getRecord(_this.PACKAGES_TABLE, { id: packageId });
        });
    };
    /**
     * Creates the name for a package directory (hash).
     *
     * @param {string} url An URL to identify the package.
     * @return {string} The directory name.
     */
    CoreFilepoolProvider.prototype.getPackageDirNameByUrl = function (url) {
        var candidate, extension = '';
        url = this.removeRevisionFromUrl(url);
        if (url.indexOf('/webservice/pluginfile') !== -1) {
            // Remove attributes that do not matter.
            this.urlAttributes.forEach(function (regex) {
                url = url.replace(regex, '');
            });
            // Guess the extension of the URL. This is for backwards compatibility.
            candidate = this.mimeUtils.guessExtensionFromUrl(url);
            if (candidate && candidate !== 'php') {
                extension = '.' + candidate;
            }
        }
        return __WEBPACK_IMPORTED_MODULE_17_ts_md5_dist_md5__["Md5"].hashAsciiStr('url:' + url) + extension;
    };
    /**
     * Get the path to a directory to store a package files. This does not check if the file exists or not.
     *
     * @param {string} siteId The site ID.
     * @param {string} url An URL to identify the package.
     * @return {Promise<string>} Promise resolved with the path of the package.
     */
    CoreFilepoolProvider.prototype.getPackageDirPathByUrl = function (siteId, url) {
        var _this = this;
        return this.fixPluginfileURL(siteId, url).then(function (fixedUrl) {
            var dirName = _this.getPackageDirNameByUrl(fixedUrl);
            return _this.getFilePath(siteId, dirName, '');
        });
    };
    /**
     * Returns the local URL of a package directory.
     *
     * @param {string} siteId The site ID.
     * @param {string} url An URL to identify the package.
     * @return {Promise<string>} Resolved with the URL.
     */
    CoreFilepoolProvider.prototype.getPackageDirUrlByUrl = function (siteId, url) {
        var _this = this;
        if (this.fileProvider.isAvailable()) {
            return this.fixPluginfileURL(siteId, url).then(function (fixedUrl) {
                var dirName = _this.getPackageDirNameByUrl(fixedUrl), dirPath = _this.getFilePath(siteId, dirName, ''); // No extension, the function will return a string.
                return _this.fileProvider.getDir(dirPath).then(function (dirEntry) {
                    return dirEntry.toURL();
                });
            });
        }
        return Promise.reject(null);
    };
    /**
     * Get a download promise. If the promise is not set, return undefined.
     *
     * @param {string} siteId Site ID.
     * @param {string} component The component of the package.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @return {Promise<any>} Download promise or undefined.
     */
    CoreFilepoolProvider.prototype.getPackageDownloadPromise = function (siteId, component, componentId) {
        var packageId = this.getPackageId(component, componentId);
        if (this.packagesPromises[siteId] && this.packagesPromises[siteId][packageId]) {
            return this.packagesPromises[siteId][packageId];
        }
    };
    /**
     * Get a package extra data.
     *
     * @param {string} siteId Site ID.
     * @param {string} component Package's component.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @return {Promise<string>} Promise resolved with the extra data.
     */
    CoreFilepoolProvider.prototype.getPackageExtra = function (siteId, component, componentId) {
        return this.getPackageData(siteId, component, componentId).then(function (entry) {
            return entry.extra;
        });
    };
    /**
     * Get the ID of a package.
     *
     * @param {string} component Package's component.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @return {string} Package ID.
     */
    CoreFilepoolProvider.prototype.getPackageId = function (component, componentId) {
        return __WEBPACK_IMPORTED_MODULE_17_ts_md5_dist_md5__["Md5"].hashAsciiStr(component + '#' + this.fixComponentId(componentId));
    };
    /**
     * Get a package previous status.
     *
     * @param {string} siteId Site ID.
     * @param {string} component Package's component.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @return {Promise<string>} Promise resolved with the status.
     */
    CoreFilepoolProvider.prototype.getPackagePreviousStatus = function (siteId, component, componentId) {
        return this.getPackageData(siteId, component, componentId).then(function (entry) {
            return entry.previous || __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].NOT_DOWNLOADED;
        }).catch(function () {
            return __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].NOT_DOWNLOADED;
        });
    };
    /**
     * Get a package status.
     *
     * @param {string} siteId Site ID.
     * @param {string} component Package's component.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @return {Promise<string>} Promise resolved with the status.
     */
    CoreFilepoolProvider.prototype.getPackageStatus = function (siteId, component, componentId) {
        return this.getPackageData(siteId, component, componentId).then(function (entry) {
            return entry.status || __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].NOT_DOWNLOADED;
        }).catch(function () {
            return __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].NOT_DOWNLOADED;
        });
    };
    /**
     * Return the array of arguments of the pluginfile url.
     *
     * @param {string} url URL to get the args.
     * @return {string[]} The args found, undefined if not a pluginfile.
     */
    CoreFilepoolProvider.prototype.getPluginFileArgs = function (url) {
        if (!this.urlUtils.isPluginFileUrl(url)) {
            // Not pluginfile, return.
            return;
        }
        var relativePath = url.substr(url.indexOf('/pluginfile.php') + 16), args = relativePath.split('/');
        if (args.length < 3) {
            // To be a plugin file it should have at least contextId, Component and Filearea.
            return;
        }
        return args;
    };
    /**
     * Get the deferred object for a file in the queue.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileId The file ID.
     * @param {boolean} [create=true] True if it should create a new deferred if it doesn't exist.
     * @param {Function} [onProgress] Function to call on progress.
     * @return {any} Deferred.
     */
    CoreFilepoolProvider.prototype.getQueueDeferred = function (siteId, fileId, create, onProgress) {
        if (create === void 0) { create = true; }
        if (!this.queueDeferreds[siteId]) {
            if (!create) {
                return;
            }
            this.queueDeferreds[siteId] = {};
        }
        if (!this.queueDeferreds[siteId][fileId]) {
            if (!create) {
                return;
            }
            this.queueDeferreds[siteId][fileId] = this.utils.promiseDefer();
        }
        if (onProgress) {
            this.queueDeferreds[siteId][fileId].onProgress = onProgress;
        }
        return this.queueDeferreds[siteId][fileId];
    };
    /**
     * Get the on progress for a file in the queue.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileId The file ID.
     * @return {Function} On progress function, undefined if not found.
     */
    CoreFilepoolProvider.prototype.getQueueOnProgress = function (siteId, fileId) {
        var deferred = this.getQueueDeferred(siteId, fileId, false);
        if (deferred) {
            return deferred.onProgress;
        }
    };
    /**
     * Get the promise for a file in the queue.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileId The file ID.
     * @param {boolean} [create=true] True if it should create a new promise if it doesn't exist.
     * @param {Function} [onProgress] Function to call on progress.
     * @return {Promise<any>} Promise.
     */
    CoreFilepoolProvider.prototype.getQueuePromise = function (siteId, fileId, create, onProgress) {
        if (create === void 0) { create = true; }
        return this.getQueueDeferred(siteId, fileId, create, onProgress).promise;
    };
    /**
     * Get a revision number from a list of files (highest revision).
     *
     * @param {any[]} files Package files.
     * @return {number} Highest revision.
     */
    CoreFilepoolProvider.prototype.getRevisionFromFileList = function (files) {
        var _this = this;
        var revision = 0;
        files.forEach(function (file) {
            if (file.url || file.fileurl) {
                var r = _this.getRevisionFromUrl(file.url || file.fileurl);
                if (r > revision) {
                    revision = r;
                }
            }
        });
        return revision;
    };
    /**
     * Get the revision number from a file URL.
     *
     * @param {string} url URL to get the revision number.
     * @return {number} Revision number.
     */
    CoreFilepoolProvider.prototype.getRevisionFromUrl = function (url) {
        var args = this.getPluginFileArgs(url);
        if (!args) {
            // Not a pluginfile, no revision will be found.
            return 0;
        }
        var revisionRegex = this.pluginFileDelegate.getComponentRevisionRegExp(args);
        if (!revisionRegex) {
            return 0;
        }
        var matches = url.match(revisionRegex);
        if (matches && typeof matches[1] != 'undefined') {
            return parseInt(matches[1], 10);
        }
        return 0;
    };
    /**
     * Returns an absolute URL to use in IMG tags.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileUrl The absolute URL to the file.
     * @param {string} [mode=url] The type of URL to return. Accepts 'url' or 'src'.
     * @param {string} component The component to link the file to.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @param {number} [timemodified=0] The time this file was modified.
     * @param {boolean} [checkSize=true] True if we shouldn't download files if their size is big, false otherwise.
     * @param {boolean} [downloadUnknown] True to download file in WiFi if their size is unknown, false otherwise.
     *                                    Ignored if checkSize=false.
     * @param {any} [options] Extra options (isexternalfile, repositorytype).
     * @param {number} [revision] File revision. If not defined, it will be calculated using the URL.
     * @return {Promise<string>} Resolved with the URL to use.
     * @description
     * This will return a URL pointing to the content of the requested URL.
     * The URL returned is compatible to use with IMG tags.
     */
    CoreFilepoolProvider.prototype.getSrcByUrl = function (siteId, fileUrl, component, componentId, timemodified, checkSize, downloadUnknown, options, revision) {
        if (timemodified === void 0) { timemodified = 0; }
        if (checkSize === void 0) { checkSize = true; }
        if (options === void 0) { options = {}; }
        return this.getFileUrlByUrl(siteId, fileUrl, component, componentId, 'src', timemodified, checkSize, downloadUnknown, options, revision);
    };
    /**
     * Get time modified from a list of files.
     *
     * @param {any[]} files List of files.
     * @return {number} Time modified.
     */
    CoreFilepoolProvider.prototype.getTimemodifiedFromFileList = function (files) {
        var timemodified = 0;
        files.forEach(function (file) {
            if (file.timemodified > timemodified) {
                timemodified = file.timemodified;
            }
        });
        return timemodified;
    };
    /**
     * Returns an absolute URL to access the file.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileUrl The absolute URL to the file.
     * @param {string} [mode=url] The type of URL to return. Accepts 'url' or 'src'.
     * @param {string} component The component to link the file to.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @param {number} [timemodified=0] The time this file was modified.
     * @param {boolean} [checkSize=true] True if we shouldn't download files if their size is big, false otherwise.
     * @param {boolean} [downloadUnknown] True to download file in WiFi if their size is unknown, false otherwise.
     *                                    Ignored if checkSize=false.
     * @param {any} [options] Extra options (isexternalfile, repositorytype).
     * @param {number} [revision] File revision. If not defined, it will be calculated using the URL.
     * @return {Promise<string>} Resolved with the URL to use.
     * @description
     * This will return a URL pointing to the content of the requested URL.
     * The URL returned is compatible to use with a local browser.
     */
    CoreFilepoolProvider.prototype.getUrlByUrl = function (siteId, fileUrl, component, componentId, timemodified, checkSize, downloadUnknown, options, revision) {
        if (timemodified === void 0) { timemodified = 0; }
        if (checkSize === void 0) { checkSize = true; }
        if (options === void 0) { options = {}; }
        return this.getFileUrlByUrl(siteId, fileUrl, component, componentId, 'url', timemodified, checkSize, downloadUnknown, options, revision);
    };
    /**
     * Guess the filename of a file from its URL. This is very weak and unreliable.
     *
     * @param {string} fileUrl The file URL.
     * @return {string}        The filename treated so it doesn't have any special character.
     */
    CoreFilepoolProvider.prototype.guessFilenameFromUrl = function (fileUrl) {
        var filename = '';
        if (fileUrl.indexOf('/webservice/pluginfile') !== -1) {
            // It's a pluginfile URL. Search for the 'file' param to extract the name.
            var params = this.urlUtils.extractUrlParams(fileUrl);
            if (params.file) {
                filename = params.file.substr(params.file.lastIndexOf('/') + 1);
            }
            else {
                // 'file' param not found. Extract what's after the last '/' without params.
                filename = this.urlUtils.getLastFileWithoutParams(fileUrl);
            }
        }
        else if (this.urlUtils.isGravatarUrl(fileUrl)) {
            // Extract gravatar ID.
            filename = 'gravatar_' + this.urlUtils.getLastFileWithoutParams(fileUrl);
        }
        else if (this.urlUtils.isThemeImageUrl(fileUrl)) {
            // Extract user ID.
            var matches = fileUrl.match(/\/core\/([^\/]*)\//);
            if (matches && matches[1]) {
                filename = matches[1];
            }
            // Attach a constant and the image type.
            filename = 'default_' + filename + '_' + this.urlUtils.getLastFileWithoutParams(fileUrl);
        }
        else {
            // Another URL. Just get what's after the last /.
            filename = this.urlUtils.getLastFileWithoutParams(fileUrl);
        }
        // If there are hashes in the URL, extract them.
        var index = filename.indexOf('#');
        var hashes;
        if (index != -1) {
            hashes = filename.split('#');
            // Remove the URL from the array.
            hashes.shift();
            filename = filename.substr(0, index);
        }
        // Remove the extension from the filename.
        filename = this.mimeUtils.removeExtension(filename);
        if (hashes) {
            // Add hashes to the name.
            filename += '_' + hashes.join('_');
        }
        return this.textUtils.removeSpecialCharactersForFiles(filename);
    };
    /**
     * Check if the file is already in the pool. This does not check if the file is on the disk.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileUrl The file URL.
     * @return {Promise<CoreFilepoolFileEntry>} Resolved with file object from DB on success, rejected otherwise.
     */
    CoreFilepoolProvider.prototype.hasFileInPool = function (siteId, fileId) {
        var _this = this;
        return this.sitesProvider.getSiteDb(siteId).then(function (db) {
            return db.getRecord(_this.FILES_TABLE, { fileId: fileId }).then(function (entry) {
                if (typeof entry === 'undefined') {
                    return Promise.reject(null);
                }
                return entry;
            });
        });
    };
    /**
     * Check if the file is in the queue.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileUrl The file URL.
     * @return {Promise} Resolved with file object from DB on success, rejected otherwise.
     */
    CoreFilepoolProvider.prototype.hasFileInQueue = function (siteId, fileId) {
        var _this = this;
        return this.appDB.getRecord(this.QUEUE_TABLE, { siteId: siteId, fileId: fileId }).then(function (entry) {
            if (typeof entry === 'undefined') {
                return Promise.reject(null);
            }
            // Convert the links to an object.
            entry.links = _this.textUtils.parseJSON(entry.links, []);
            return entry;
        });
    };
    /**
     * Invalidate all the files in a site.
     *
     * @param {string} siteId The site ID.
     * @param {boolean} [onlyUnknown=true] True to only invalidate files from external repos or without revision/timemodified.
     *                                     It is advised to set it to true to reduce the performance and data usage of the app.
     * @return {Promise<any>} Resolved on success.
     */
    CoreFilepoolProvider.prototype.invalidateAllFiles = function (siteId, onlyUnknown) {
        var _this = this;
        if (onlyUnknown === void 0) { onlyUnknown = true; }
        return this.sitesProvider.getSiteDb(siteId).then(function (db) {
            var where, whereParams;
            if (onlyUnknown) {
                where = 'isexternalfile = ? OR (revision < ? AND timemodified = ?)';
                whereParams = [0, 1, 0];
            }
            return db.updateRecordsWhere(_this.FILES_TABLE, { stale: 1 }, where, whereParams);
        });
    };
    /**
     * Invalidate a file by URL.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileUrl The file URL.
     * @return {Promise<any>} Resolved on success.
     * @description
     * Invalidates a file by marking it stale. It will not be added to the queue automatically, but the next time this file
     * is requested it will be added to the queue.
     * You can manully call addToQueueByUrl to add this file to the queue immediately.
     * Please note that, if a file is stale, the user will be presented the stale file if there is no network access.
     */
    CoreFilepoolProvider.prototype.invalidateFileByUrl = function (siteId, fileUrl) {
        var _this = this;
        return this.fixPluginfileURL(siteId, fileUrl).then(function (fileUrl) {
            var fileId = _this.getFileIdByUrl(fileUrl);
            return _this.sitesProvider.getSiteDb(siteId).then(function (db) {
                return db.updateRecords(_this.FILES_TABLE, { stale: 1 }, { fileId: fileId });
            });
        });
    };
    /**
     * Invalidate all the matching files from a component.
     *
     * @param {string} siteId The site ID.
     * @param {string} component The component to invalidate.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @param {boolean} [onlyUnknown=true] True to only invalidate files from external repos or without revision/timemodified.
     *                                     It is advised to set it to true to reduce the performance and data usage of the app.
     * @return {Promise<any>} Resolved when done.
     */
    CoreFilepoolProvider.prototype.invalidateFilesByComponent = function (siteId, component, componentId, onlyUnknown) {
        var _this = this;
        if (onlyUnknown === void 0) { onlyUnknown = true; }
        return this.sitesProvider.getSiteDb(siteId).then(function (db) {
            return _this.getComponentFiles(db, component, componentId).then(function (items) {
                var fileIds = items.map(function (item) {
                    return item.fileId;
                }), whereAndParams = db.getInOrEqual(fileIds);
                whereAndParams[0] = 'fileId ' + whereAndParams[0];
                if (onlyUnknown) {
                    whereAndParams[0] += ' AND (isexternalfile = ? OR (revision < ? AND timemodified = ?))';
                    whereAndParams[1] = whereAndParams[1].concat([0, 1, 0]);
                }
                return db.updateRecordsWhere(_this.FILES_TABLE, { stale: 1 }, whereAndParams[0], whereAndParams[1]);
            });
        });
    };
    /**
     * Check if a file is downloading.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileUrl File URL.
     * @param {Promise<any>} Promise resolved if file is downloading, rejected otherwise.
     */
    CoreFilepoolProvider.prototype.isFileDownloadingByUrl = function (siteId, fileUrl) {
        var _this = this;
        return this.fixPluginfileURL(siteId, fileUrl).then(function (fileUrl) {
            var fileId = _this.getFileIdByUrl(fileUrl);
            return _this.hasFileInQueue(siteId, fileId);
        });
    };
    /**
     * Check if a file is outdated.
     *
     * @param {CoreFilepoolFileEntry} entry Filepool entry.
     * @param {number} [revision]  File revision number.
     * @param {number} [timemodified] The time this file was modified.
     * @param {boolean} Whether the file is outdated.
     */
    CoreFilepoolProvider.prototype.isFileOutdated = function (entry, revision, timemodified) {
        return !!entry.stale || revision > entry.revision || timemodified > entry.timemodified;
    };
    /**
     * Check if cannot determine if a file has been updated.
     *
     * @param {CoreFilepoolFileEntry} entry Filepool entry.
     * @return {boolean} Whether it cannot determine updates.
     */
    CoreFilepoolProvider.prototype.isFileUpdateUnknown = function (entry) {
        return !!entry.isexternalfile || (entry.revision < 1 && !entry.timemodified);
    };
    /**
     * Notify a file has been deleted.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileId The file ID.
     */
    CoreFilepoolProvider.prototype.notifyFileDeleted = function (siteId, fileId) {
        this.eventsProvider.trigger(this.getFileEventName(siteId, fileId), { action: 'deleted' });
    };
    /**
     * Notify a file has been downloaded.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileId The file ID.
     */
    CoreFilepoolProvider.prototype.notifyFileDownloaded = function (siteId, fileId) {
        this.eventsProvider.trigger(this.getFileEventName(siteId, fileId), { action: 'download', success: true });
    };
    /**
     * Notify error occurred while downloading a file.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileId The file ID.
     */
    CoreFilepoolProvider.prototype.notifyFileDownloadError = function (siteId, fileId) {
        this.eventsProvider.trigger(this.getFileEventName(siteId, fileId), { action: 'download', success: false });
    };
    /**
     * Notify a file starts being downloaded or added to queue.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileId The file ID.
     */
    CoreFilepoolProvider.prototype.notifyFileDownloading = function (siteId, fileId) {
        this.eventsProvider.trigger(this.getFileEventName(siteId, fileId), { action: 'downloading' });
    };
    /**
     * Notify a file has been outdated.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileId The file ID.
     */
    CoreFilepoolProvider.prototype.notifyFileOutdated = function (siteId, fileId) {
        this.eventsProvider.trigger(this.getFileEventName(siteId, fileId), { action: 'outdated' });
    };
    /**
     * Prefetches a list of files.
     *
     * @param {string} siteId The site ID.
     * @param {any[]} fileList List of files to download.
     * @param {string} component The component to link the file to.
     * @param {string|number} [componentId] An ID to identify the download.
     * @param {string} [extra] Extra data to store for the package.
     * @param {string} [dirPath] Name of the directory where to store the files (inside filepool dir). If not defined, store
     *                           the files directly inside the filepool folder.
     * @param {Function} [onProgress] Function to call on progress.
     * @return {Promise<any>}  Promise resolved when all files are downloaded.
     */
    CoreFilepoolProvider.prototype.prefetchPackage = function (siteId, fileList, component, componentId, extra, dirPath, onProgress) {
        return this.downloadOrPrefetchPackage(siteId, fileList, true, component, componentId, extra, dirPath, onProgress);
    };
    /**
     * Process the queue.
     *
     * @description
     * This loops over itself to keep on processing the queue in the background.
     * The queue process is site agnostic.
     */
    CoreFilepoolProvider.prototype.processQueue = function () {
        var _this = this;
        var promise;
        if (this.queueState !== this.QUEUE_RUNNING) {
            // Silently ignore, the queue is on pause.
            promise = Promise.reject(this.ERR_QUEUE_ON_PAUSE);
        }
        else if (!this.fileProvider.isAvailable() || !this.appProvider.isOnline()) {
            promise = Promise.reject(this.ERR_FS_OR_NETWORK_UNAVAILABLE);
        }
        else {
            promise = this.processImportantQueueItem();
        }
        promise.then(function () {
            // All good, we schedule next execution.
            setTimeout(function () {
                _this.processQueue();
            }, _this.QUEUE_PROCESS_INTERVAL);
        }, function (error) {
            // We had an error, in which case we pause the processing.
            if (error === _this.ERR_FS_OR_NETWORK_UNAVAILABLE) {
                _this.logger.debug('Filesysem or network unavailable, pausing queue processing.');
            }
            else if (error === _this.ERR_QUEUE_IS_EMPTY) {
                _this.logger.debug('Queue is empty, pausing queue processing.');
            }
            _this.queueState = _this.QUEUE_PAUSED;
        });
    };
    /**
     * Process the most important queue item.
     *
     * @return {Promise} Resolved on success. Rejected on failure.
     */
    CoreFilepoolProvider.prototype.processImportantQueueItem = function () {
        var _this = this;
        return this.appDB.getRecords(this.QUEUE_TABLE, undefined, 'priority DESC, added ASC', undefined, 0, 1).then(function (items) {
            var item = items.pop();
            if (!item) {
                return Promise.reject(_this.ERR_QUEUE_IS_EMPTY);
            }
            // Convert the links to an object.
            item.links = _this.textUtils.parseJSON(item.links, []);
            return _this.processQueueItem(item);
        }, function () {
            return Promise.reject(_this.ERR_QUEUE_IS_EMPTY);
        });
    };
    /**
     * Process a queue item.
     *
     * @param {CoreFilepoolQueueEntry} item The object from the queue store.
     * @return {Promise<any>} Resolved on success. Rejected on failure.
     */
    CoreFilepoolProvider.prototype.processQueueItem = function (item) {
        var _this = this;
        // Cast optional fields to undefined instead of null.
        var siteId = item.siteId, fileId = item.fileId, fileUrl = item.url, options = {
            revision: item.revision || undefined,
            timemodified: item.timemodified || undefined,
            isexternalfile: item.isexternalfile || undefined,
            repositorytype: item.repositorytype || undefined
        }, filePath = item.path || undefined, links = item.links || [];
        this.logger.debug('Processing queue item: ' + siteId + ', ' + fileId);
        // Check if the file is already in pool.
        return this.hasFileInPool(siteId, fileId).catch(function () {
            // File not in pool.
        }).then(function (entry) {
            if (entry && !options.isexternalfile && !_this.isFileOutdated(entry, options.revision, options.timemodified)) {
                // We have the file, it is not stale, we can update links and remove from queue.
                _this.logger.debug('Queued file already in store, ignoring...');
                _this.addFileLinks(siteId, fileId, links).catch(function () {
                    // Ignore errors.
                });
                _this.removeFromQueue(siteId, fileId).catch(function () {
                    // Ignore errors.
                }).finally(function () {
                    _this.treatQueueDeferred(siteId, fileId, true);
                });
                _this.notifyFileDownloaded(siteId, fileId);
                return;
            }
            // The file does not exist, or is stale, ... download it.
            var onProgress = _this.getQueueOnProgress(siteId, fileId);
            return _this.downloadForPoolByUrl(siteId, fileUrl, options, filePath, onProgress, entry).then(function () {
                // Success, we add links and remove from queue.
                _this.addFileLinks(siteId, fileId, links).catch(function () {
                    // Ignore errors.
                });
                _this.treatQueueDeferred(siteId, fileId, true);
                _this.notifyFileDownloaded(siteId, fileId);
                // Wait for the item to be removed from queue before resolving the promise.
                // If the item could not be removed from queue we still resolve the promise.
                return _this.removeFromQueue(siteId, fileId).catch(function () {
                    // Ignore errors.
                });
            }, function (errorObject) {
                // Whoops, we have an error...
                var dropFromQueue = false;
                if (errorObject && errorObject.source === fileUrl) {
                    // This is most likely a FileTransfer error.
                    if (errorObject.code === 1) {
                        // The file was not found, most likely a 404, we remove from queue.
                        dropFromQueue = true;
                    }
                    else if (errorObject.code === 2) {
                        // The URL is invalid, we drop the file from the queue.
                        dropFromQueue = true;
                    }
                    else if (errorObject.code === 3) {
                        // If there was an HTTP status, then let's remove from the queue.
                        dropFromQueue = true;
                    }
                    else if (errorObject.code === 4) {
                        // The transfer was aborted, we will keep the file in queue.
                    }
                    else if (errorObject.code === 5) {
                        // We have the latest version of the file, HTTP 304 status.
                        dropFromQueue = true;
                    }
                    else {
                        // Unknown error, let's remove the file from the queue to avoi locking down the queue.
                        dropFromQueue = true;
                    }
                }
                else {
                    dropFromQueue = true;
                }
                var errorMessage = null;
                // Some Android devices restrict the amount of usable storage using quotas.
                // If this quota would be exceeded by the download, it throws an exception.
                // We catch this exception here, and report a meaningful error message to the user.
                if (errorObject instanceof FileTransferError && errorObject.exception && errorObject.exception.includes('EDQUOT')) {
                    errorMessage = 'core.course.insufficientavailablequota';
                }
                if (dropFromQueue) {
                    _this.logger.debug('Item dropped from queue due to error: ' + fileUrl, errorObject);
                    return _this.removeFromQueue(siteId, fileId).catch(function () {
                        // Consider this as a silent error, never reject the promise here.
                    }).then(function () {
                        _this.treatQueueDeferred(siteId, fileId, false, errorMessage);
                        _this.notifyFileDownloadError(siteId, fileId);
                    });
                }
                else {
                    // We considered the file as legit but did not get it, failure.
                    _this.treatQueueDeferred(siteId, fileId, false, errorMessage);
                    _this.notifyFileDownloadError(siteId, fileId);
                    return Promise.reject(errorObject);
                }
            });
        });
    };
    /**
     * Remove a file from the queue.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileId The file ID.
     * @return {Promise<any>} Resolved on success. Rejected on failure. It is advised to silently ignore failures.
     */
    CoreFilepoolProvider.prototype.removeFromQueue = function (siteId, fileId) {
        return this.appDB.deleteRecords(this.QUEUE_TABLE, { siteId: siteId, fileId: fileId });
    };
    /**
     * Remove a file from the pool.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileId The file ID.
     * @return {Promise<any>} Resolved on success.
     */
    CoreFilepoolProvider.prototype.removeFileById = function (siteId, fileId) {
        var _this = this;
        return this.sitesProvider.getSiteDb(siteId).then(function (db) {
            // Get the path to the file first since it relies on the file object stored in the pool.
            return Promise.resolve(_this.getFilePath(siteId, fileId)).then(function (path) {
                var promises = [];
                // Remove entry from filepool store.
                promises.push(db.deleteRecords(_this.FILES_TABLE, { fileId: fileId }));
                // Remove links.
                promises.push(db.deleteRecords(_this.LINKS_TABLE, { fileId: fileId }));
                // Remove the file.
                if (_this.fileProvider.isAvailable()) {
                    promises.push(_this.fileProvider.removeFile(path).catch(function (error) {
                        if (error && error.code == 1) {
                            // Not found, ignore error since maybe it was deleted already.
                        }
                        else {
                            return Promise.reject(error);
                        }
                    }));
                }
                return Promise.all(promises).then(function () {
                    _this.notifyFileDeleted(siteId, fileId);
                });
            });
        });
    };
    /**
     * Delete all the matching files from a component.
     *
     * @param {string} siteId The site ID.
     * @param {string} component The component to link the file to.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @return {Promise<any>} Resolved on success.
     */
    CoreFilepoolProvider.prototype.removeFilesByComponent = function (siteId, component, componentId) {
        var _this = this;
        return this.sitesProvider.getSiteDb(siteId).then(function (db) {
            return _this.getComponentFiles(db, component, componentId);
        }).then(function (items) {
            return Promise.all(items.map(function (item) {
                return _this.removeFileById(siteId, item.fileId);
            }));
        });
    };
    /**
     * Remove a file from the pool.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileUrl The file URL.
     * @return {Promise<any>} Resolved on success, rejected on failure.
     */
    CoreFilepoolProvider.prototype.removeFileByUrl = function (siteId, fileUrl) {
        var _this = this;
        return this.fixPluginfileURL(siteId, fileUrl).then(function (fileUrl) {
            var fileId = _this.getFileIdByUrl(fileUrl);
            return _this.removeFileById(siteId, fileId);
        });
    };
    /**
     * Removes the revision number from a file URL.
     *
     * @param {string} url URL to remove the revision number.
     * @return {string} URL without revision number.
     * @description
     * The revision is used to know if a file has changed. We remove it from the URL to prevent storing a file per revision.
     */
    CoreFilepoolProvider.prototype.removeRevisionFromUrl = function (url) {
        var args = this.getPluginFileArgs(url);
        if (!args) {
            // Not a pluginfile, no revision will be found.
            return url;
        }
        return this.pluginFileDelegate.removeRevisionFromUrl(url, args);
    };
    /**
     * Change the package status, setting it to the previous status.
     *
     * @param {string} siteId Site ID.
     * @param {string} component Package's component.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @return {Promise<string>} Promise resolved when the status is changed. Resolve param: new status.
     */
    CoreFilepoolProvider.prototype.setPackagePreviousStatus = function (siteId, component, componentId) {
        var _this = this;
        componentId = this.fixComponentId(componentId);
        this.logger.debug("Set previous status for package " + component + " " + componentId);
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var packageId = _this.getPackageId(component, componentId);
            // Get current stored data, we'll only update 'status' and 'updated' fields.
            return site.getDb().getRecord(_this.PACKAGES_TABLE, { id: packageId }).then(function (entry) {
                var newData = {};
                if (entry.status == __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].DOWNLOADING) {
                    // Going back from downloading to previous status, restore previous download time.
                    newData.downloadTime = entry.previousDownloadTime;
                }
                newData.status = entry.previous || __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].NOT_DOWNLOADED;
                newData.updated = Date.now();
                _this.logger.debug("Set previous status '" + entry.status + "' for package " + component + " " + componentId);
                return site.getDb().updateRecords(_this.PACKAGES_TABLE, newData, { id: packageId }).then(function () {
                    // Success updating, trigger event.
                    _this.triggerPackageStatusChanged(site.id, newData.status, component, componentId);
                    return newData.status;
                });
            });
        });
    };
    /**
     * Convenience function to check if a file should be downloaded before opening it.
     *
     * @param {string} url File online URL.
     * @param {number} size File size.
     * @return {Promise}     Promise resolved if should download before open, rejected otherwise.
     * @description
     * Convenience function to check if a file should be downloaded before opening it.
     *
     * The default behaviour in the app is to download first and then open the local file in the following cases:
     *     - The file is small (less than DOWNLOAD_THRESHOLD).
     *     - The file cannot be streamed.
     * If the file is big and can be streamed, the promise returned by this function will be rejected.
     */
    CoreFilepoolProvider.prototype.shouldDownloadBeforeOpen = function (url, size) {
        if (size >= 0 && size <= this.DOWNLOAD_THRESHOLD) {
            // The file is small, download it.
            return Promise.resolve();
        }
        if (this.appProvider.isDesktop()) {
            // In desktop always download first.
            return Promise.resolve();
        }
        return this.utils.getMimeTypeFromUrl(url).then(function (mimetype) {
            // If the file is streaming (audio or video) we reject.
            if (mimetype.indexOf('video') != -1 || mimetype.indexOf('audio') != -1) {
                return Promise.reject(null);
            }
        });
    };
    /**
     * Store package status.
     *
     * @param {string} siteId Site ID.
     * @param {string} status New package status.
     * @param {string} component Package's component.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @param {string} [extra] Extra data to store for the package. If you want to store more than 1 value, use JSON.stringify.
     * @return {Promise<any>} Promise resolved when status is stored.
     */
    CoreFilepoolProvider.prototype.storePackageStatus = function (siteId, status, component, componentId, extra) {
        var _this = this;
        this.logger.debug("Set status '" + status + "' for package " + component + " " + componentId);
        componentId = this.fixComponentId(componentId);
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var packageId = _this.getPackageId(component, componentId);
            var downloadTime, previousDownloadTime;
            if (status == __WEBPACK_IMPORTED_MODULE_16__core_constants__["a" /* CoreConstants */].DOWNLOADING) {
                // Set download time if package is now downloading.
                downloadTime = _this.timeUtils.timestamp();
            }
            // Search current status to set it as previous status.
            return site.getDb().getRecord(_this.PACKAGES_TABLE, { id: packageId }).then(function (entry) {
                if (typeof extra == 'undefined' || extra === null) {
                    extra = entry.extra;
                }
                if (typeof downloadTime == 'undefined') {
                    // Keep previous download time.
                    downloadTime = entry.downloadTime;
                    previousDownloadTime = entry.previousDownloadTime;
                }
                else {
                    // The downloadTime will be updated, store current time as previous.
                    previousDownloadTime = entry.downloadTime;
                }
                return entry.status;
            }).catch(function () {
                // No previous status.
            }).then(function (previousStatus) {
                var packageEntry = {
                    id: packageId,
                    component: component,
                    componentId: componentId,
                    status: status,
                    previous: previousStatus,
                    updated: Date.now(),
                    downloadTime: downloadTime,
                    previousDownloadTime: previousDownloadTime,
                    extra: extra
                };
                var promise;
                if (previousStatus === status) {
                    // The package already has this status, no need to change it.
                    promise = Promise.resolve();
                }
                else {
                    promise = site.getDb().insertRecord(_this.PACKAGES_TABLE, packageEntry);
                }
                return promise.then(function () {
                    // Success inserting, trigger event.
                    _this.triggerPackageStatusChanged(siteId, status, component, componentId);
                });
            });
        });
    };
    /**
     * Search for files in a CSS code and try to download them. Once downloaded, replace their URLs
     * and store the result in the CSS file.
     *
     * @param {string} siteId  Site ID.
     * @param {string} fileUrl CSS file URL.
     * @param {string} cssCode CSS code.
     * @param {string} [component] The component to link the file to.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @param {number} [revision] Revision to use in all files. If not defined, it will be calculated using the URL of each file.
     * @return {Promise<string>} Promise resolved with the CSS code.
     */
    CoreFilepoolProvider.prototype.treatCSSCode = function (siteId, fileUrl, cssCode, component, componentId, revision) {
        var _this = this;
        var urls = this.domUtils.extractUrlsFromCSS(cssCode), promises = [];
        var filePath, updated = false;
        // Get the path of the CSS file.
        promises.push(this.getFilePathByUrl(siteId, fileUrl).then(function (path) {
            filePath = path;
        }));
        urls.forEach(function (url) {
            // Download the file only if it's an online URL.
            if (url.indexOf('http') == 0) {
                promises.push(_this.downloadUrl(siteId, url, false, component, componentId, 0, undefined, undefined, undefined, revision).then(function (fileUrl) {
                    if (fileUrl != url) {
                        cssCode = cssCode.replace(new RegExp(_this.textUtils.escapeForRegex(url), 'g'), fileUrl);
                        updated = true;
                    }
                }).catch(function (error) {
                    // It shouldn't happen. Ignore errors.
                    _this.logger.warn('Error treating file ', url, error);
                }));
            }
        });
        return Promise.all(promises).then(function () {
            // All files downloaded. Store the result if it has changed.
            if (updated) {
                return _this.fileProvider.writeFile(filePath, cssCode);
            }
        }).then(function () {
            return cssCode;
        });
    };
    /**
     * Remove extension from fileId in queue, used to migrate from previous file handling.
     *
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreFilepoolProvider.prototype.treatExtensionInQueue = function () {
        var _this = this;
        this.logger.debug('Treat extensions in queue');
        return this.appDB.getAllRecords(this.QUEUE_TABLE).then(function (entries) {
            var promises = [];
            entries.forEach(function (entry) {
                // For files in the queue, we only need to remove the extension from the fileId.
                // After downloading, additional info will be added.
                var fileId = entry.fileId;
                entry.fileId = _this.mimeUtils.removeExtension(fileId);
                if (fileId == entry.fileId) {
                    return;
                }
                promises.push(_this.appDB.updateRecords(_this.QUEUE_TABLE, { fileId: entry.fileId }, { fileId: fileId }));
            });
            return Promise.all(promises);
        });
    };
    /**
     * Resolves or rejects a queue deferred and removes it from the list.
     *
     * @param {string} siteId The site ID.
     * @param {string} fileId The file ID.
     * @param {boolean} resolve True if promise should be resolved, false if it should be rejected.
     * @param {string} error String identifier for error message, if rejected.
     */
    CoreFilepoolProvider.prototype.treatQueueDeferred = function (siteId, fileId, resolve, error) {
        if (this.queueDeferreds[siteId] && this.queueDeferreds[siteId][fileId]) {
            if (resolve) {
                this.queueDeferreds[siteId][fileId].resolve();
            }
            else {
                this.queueDeferreds[siteId][fileId].reject(error);
            }
            delete this.queueDeferreds[siteId][fileId];
        }
    };
    /**
     * Trigger mmCoreEventPackageStatusChanged with the right data.
     *
     * @param {string} siteId Site ID.
     * @param {string} status New package status.
     * @param {string} component  Package's component.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     */
    CoreFilepoolProvider.prototype.triggerPackageStatusChanged = function (siteId, status, component, componentId) {
        var data = {
            component: component,
            componentId: this.fixComponentId(componentId),
            status: status
        };
        this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_3__events__["a" /* CoreEventsProvider */].PACKAGE_STATUS_CHANGED, data, siteId);
    };
    /**
     * Update the download time of a package. This doesn't modify the previous download time.
     * This function should be used if a package generates some new data during a download. Calling this function
     * right after generating the data in the download will prevent detecting this data as an update.
     *
     * @param {string} siteId Site ID.
     * @param {string} component Package's component.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @return {Promise<any>} Promise resolved when status is stored.
     */
    CoreFilepoolProvider.prototype.updatePackageDownloadTime = function (siteId, component, componentId) {
        var _this = this;
        componentId = this.fixComponentId(componentId);
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var packageId = _this.getPackageId(component, componentId);
            return site.getDb().updateRecords(_this.PACKAGES_TABLE, { downloadTime: _this.timeUtils.timestamp() }, { id: packageId });
        });
    };
    CoreFilepoolProvider = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_6__logger__["a" /* CoreLoggerProvider */], __WEBPACK_IMPORTED_MODULE_2__app__["a" /* CoreAppProvider */], __WEBPACK_IMPORTED_MODULE_4__file__["a" /* CoreFileProvider */],
            __WEBPACK_IMPORTED_MODULE_8__sites__["a" /* CoreSitesProvider */], __WEBPACK_IMPORTED_MODULE_9__ws__["a" /* CoreWSProvider */], __WEBPACK_IMPORTED_MODULE_12__utils_text__["a" /* CoreTextUtilsProvider */],
            __WEBPACK_IMPORTED_MODULE_15__utils_utils__["a" /* CoreUtilsProvider */], __WEBPACK_IMPORTED_MODULE_11__utils_mimetype__["a" /* CoreMimetypeUtilsProvider */], __WEBPACK_IMPORTED_MODULE_14__utils_url__["a" /* CoreUrlUtilsProvider */],
            __WEBPACK_IMPORTED_MODULE_13__utils_time__["a" /* CoreTimeUtilsProvider */], __WEBPACK_IMPORTED_MODULE_3__events__["a" /* CoreEventsProvider */], __WEBPACK_IMPORTED_MODULE_5__init__["a" /* CoreInitDelegate */],
            __WEBPACK_IMPORTED_MODULE_1__ionic_native_network__["a" /* Network */], __WEBPACK_IMPORTED_MODULE_7__plugin_file_delegate__["a" /* CorePluginFileDelegate */], __WEBPACK_IMPORTED_MODULE_10__utils_dom__["a" /* CoreDomUtilsProvider */],
            __WEBPACK_IMPORTED_MODULE_0__angular_core__["M" /* NgZone */]])
    ], CoreFilepoolProvider);
    return CoreFilepoolProvider;
}());

//# sourceMappingURL=filepool.js.map

/***/ }),
/* 18 */,
/* 19 */,
/* 20 */,
/* 21 */,
/* 22 */,
/* 23 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreUrlUtilsProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__lang__ = __webpack_require__(170);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__text__ = __webpack_require__(10);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};



/*
 * "Utils" service with helper functions for URLs.
 */
var CoreUrlUtilsProvider = /** @class */ (function () {
    function CoreUrlUtilsProvider(langProvider, textUtils) {
        this.langProvider = langProvider;
        this.textUtils = textUtils;
    }
    /**
     * Add or remove 'www' from a URL. The url needs to have http or https protocol.
     *
     * @param {string} url URL to modify.
     * @return {string} Modified URL.
     */
    CoreUrlUtilsProvider.prototype.addOrRemoveWWW = function (url) {
        if (url) {
            if (url.match(/http(s)?:\/\/www\./)) {
                // Already has www. Remove it.
                url = url.replace('www.', '');
            }
            else {
                url = url.replace('https://', 'https://www.');
                url = url.replace('http://', 'http://www.');
            }
        }
        return url;
    };
    /**
     * Given a URL and a text, return an HTML link.
     *
     * @param {string} url URL.
     * @param {string} text Text of the link.
     * @return {string} Link.
     */
    CoreUrlUtilsProvider.prototype.buildLink = function (url, text) {
        return '<a href="' + url + '">' + text + '</a>';
    };
    /**
     * Extracts the parameters from a URL and stores them in an object.
     *
     * @param {string} url URL to treat.
     * @return {any} Object with the params.
     */
    CoreUrlUtilsProvider.prototype.extractUrlParams = function (url) {
        var _this = this;
        var regex = /[?&]+([^=&]+)=?([^&]*)?/gi, subParamsPlaceholder = '@@@SUBPARAMS@@@', params = {}, urlAndHash = url.split('#'), questionMarkSplit = urlAndHash[0].split('?');
        var subParams;
        if (questionMarkSplit.length > 2) {
            // There is more than one question mark in the URL. This can happen if any of the params is a URL with params.
            // We only want to treat the first level of params, so we'll remove this second list of params and restore it later.
            questionMarkSplit.splice(0, 2);
            subParams = '?' + questionMarkSplit.join('?');
            urlAndHash[0] = urlAndHash[0].replace(subParams, subParamsPlaceholder);
        }
        urlAndHash[0].replace(regex, function (match, key, value) {
            params[key] = typeof value != 'undefined' ? _this.textUtils.decodeURIComponent(value) : '';
            if (subParams) {
                params[key] = params[key].replace(subParamsPlaceholder, subParams);
            }
            return match;
        });
        if (urlAndHash.length > 1) {
            // Remove the URL from the array.
            urlAndHash.shift();
            // Add the hash as a param with a special name. Use a join in case there is more than one #.
            params.urlHash = urlAndHash.join('#');
        }
        return params;
    };
    /**
     * Generic function for adding the wstoken to Moodle urls and for pointing to the correct script.
     * For download remote files from Moodle we need to use the special /webservice/pluginfile passing
     * the ws token as a get parameter.
     *
     * @param {string} url The url to be fixed.
     * @param {string} token Token to use.
     * @param {string} siteUrl The URL of the site the URL belongs to.
     * @return {string} Fixed URL.
     */
    CoreUrlUtilsProvider.prototype.fixPluginfileURL = function (url, token, siteUrl) {
        if (!url) {
            return '';
        }
        url = url.replace(/&amp;/g, '&');
        // First check if we need to fix this url or is already fixed.
        if (url.indexOf('token=') != -1) {
            return url;
        }
        // Check if is a valid URL (contains the pluginfile endpoint).
        if (!this.isPluginFileUrl(url)) {
            return url;
        }
        // Check if the URL already has params.
        if (url.match(/\?[^=]+=/)) {
            url += '&';
        }
        else {
            url += '?';
        }
        // Always send offline=1 (for external repositories). It shouldn't cause problems for local files or old Moodles.
        url += 'token=' + token + '&offline=1';
        // Some webservices returns directly the correct download url, others not.
        if (url.indexOf(this.textUtils.concatenatePaths(siteUrl, 'pluginfile.php')) === 0) {
            url = url.replace('/pluginfile', '/webservice/pluginfile');
        }
        return url;
    };
    /**
     * Formats a URL, trim, lowercase, etc...
     *
     * @param {string} url The url to be formatted.
     * @return {string} Fromatted url.
     */
    CoreUrlUtilsProvider.prototype.formatURL = function (url) {
        url = url.trim();
        // Check if the URL starts by http or https.
        if (!/^http(s)?\:\/\/.*/i.test(url)) {
            // Test first allways https.
            url = 'https://' + url;
        }
        // http allways in lowercase.
        url = url.replace(/^http/i, 'http');
        url = url.replace(/^https/i, 'https');
        // Replace last slash.
        url = url.replace(/\/$/, '');
        return url;
    };
    /**
     * Returns the URL to the documentation of the app, based on Moodle version and current language.
     *
     * @param {string} [release] Moodle release.
     * @param {string} [page=Mobile_app] Docs page to go to.
     * @return {Promise<string>} Promise resolved with the Moodle docs URL.
     */
    CoreUrlUtilsProvider.prototype.getDocsUrl = function (release, page) {
        if (page === void 0) { page = 'Mobile_app'; }
        var docsUrl = 'https://docs.moodle.org/en/' + page;
        if (typeof release != 'undefined') {
            var version = release.substr(0, 3).replace('.', '');
            // Check is a valid number.
            if (parseInt(version) >= 24) {
                // Append release number.
                docsUrl = docsUrl.replace('https://docs.moodle.org/', 'https://docs.moodle.org/' + version + '/');
            }
        }
        return this.langProvider.getCurrentLanguage().then(function (lang) {
            return docsUrl.replace('/en/', '/' + lang + '/');
        }).catch(function () {
            return docsUrl;
        });
    };
    /**
     * Given a URL, returns what's after the last '/' without params.
     * Example:
     * http://mysite.com/a/course.html?id=1 -> course.html
     *
     * @param {string} url URL to treat.
     * @return {string} Last file without params.
     */
    CoreUrlUtilsProvider.prototype.getLastFileWithoutParams = function (url) {
        var filename = url.substr(url.lastIndexOf('/') + 1);
        if (filename.indexOf('?') != -1) {
            filename = filename.substr(0, filename.indexOf('?'));
        }
        return filename;
    };
    /**
     * Get the protocol from a URL.
     * E.g. http://www.google.com returns 'http'.
     *
     * @param {string} url URL to treat.
     * @return {string} Protocol, undefined if no protocol found.
     */
    CoreUrlUtilsProvider.prototype.getUrlProtocol = function (url) {
        if (!url) {
            return;
        }
        var matches = url.match(/^([^\/:\.\?]*):\/\//);
        if (matches && matches[1]) {
            return matches[1];
        }
    };
    /**
     * Get the scheme from a URL. Please notice that, if a URL has protocol, it will return the protocol.
     * E.g. javascript:doSomething() returns 'javascript'.
     *
     * @param {string} url URL to treat.
     * @return {string} Scheme, undefined if no scheme found.
     */
    CoreUrlUtilsProvider.prototype.getUrlScheme = function (url) {
        if (!url) {
            return;
        }
        var matches = url.match(/^([a-z][a-z0-9+\-.]*):/);
        if (matches && matches[1]) {
            return matches[1];
        }
    };
    /*
     * Gets a username from a URL like: user@mysite.com.
     *
     * @param {string} url URL to treat.
     * @return {string} Username. Undefined if no username found.
     */
    CoreUrlUtilsProvider.prototype.getUsernameFromUrl = function (url) {
        if (url.indexOf('@') > -1) {
            // Get URL without protocol.
            var withoutProtocol = url.replace(/^[^?@\/]*:\/\//, ''), matches = withoutProtocol.match(/[^@]*/);
            // Make sure that @ is at the start of the URL, not in a param at the end.
            if (matches && matches.length && !matches[0].match(/[\/|?]/)) {
                return matches[0];
            }
        }
    };
    /**
     * Returns if a URL has any protocol (not a relative URL).
     *
     * @param {string} url The url to test against the pattern.
     * @return {boolean} Whether the url is absolute.
     */
    CoreUrlUtilsProvider.prototype.isAbsoluteURL = function (url) {
        return /^[^:]{2,}:\/\//i.test(url) || /^(tel:|mailto:|geo:)/.test(url);
    };
    /**
     * Returns if a URL is downloadable: plugin file OR theme/image.php OR gravatar.
     *
     * @param {string} url The URL to test.
     * @return {boolean} Whether the URL is downloadable.
     */
    CoreUrlUtilsProvider.prototype.isDownloadableUrl = function (url) {
        return this.isPluginFileUrl(url) || this.isThemeImageUrl(url) || this.isGravatarUrl(url);
    };
    /**
     * Returns if a URL is a gravatar URL.
     *
     * @param {string} url The URL to test.
     * @return {boolean} Whether the URL is a gravatar URL.
     */
    CoreUrlUtilsProvider.prototype.isGravatarUrl = function (url) {
        return url && url.indexOf('gravatar.com/avatar') !== -1;
    };
    /**
     * Check if a URL uses http or https protocol.
     *
     * @param {string} url The url to test.
     * @return {boolean} Whether the url uses http or https protocol.
     */
    CoreUrlUtilsProvider.prototype.isHttpURL = function (url) {
        return /^https?\:\/\/.+/i.test(url);
    };
    /**
     * Returns if a URL is a pluginfile URL.
     *
     * @param {string} url The URL to test.
     * @return {boolean} Whether the URL is a pluginfile URL.
     */
    CoreUrlUtilsProvider.prototype.isPluginFileUrl = function (url) {
        return url && url.indexOf('/pluginfile.php') !== -1;
    };
    /**
     * Returns if a URL is a theme image URL.
     *
     * @param {string} url The URL to test.
     * @return {boolean} Whether the URL is a theme image URL.
     */
    CoreUrlUtilsProvider.prototype.isThemeImageUrl = function (url) {
        return url && url.indexOf('/theme/image.php') !== -1;
    };
    /**
     * Remove protocol and www from a URL.
     *
     * @param {string} url URL to treat.
     * @return {string} Treated URL.
     */
    CoreUrlUtilsProvider.prototype.removeProtocolAndWWW = function (url) {
        // Remove protocol.
        url = url.replace(/.*?:\/\//g, '');
        // Remove www.
        url = url.replace(/^www./, '');
        return url;
    };
    /**
     * Remove the parameters from a URL, returning the URL without them.
     *
     * @param {string} url URL to treat.
     * @return {string} URL without params.
     */
    CoreUrlUtilsProvider.prototype.removeUrlParams = function (url) {
        var matches = url.match(/^[^\?]+/);
        return matches && matches[0];
    };
    CoreUrlUtilsProvider = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_1__lang__["a" /* CoreLangProvider */], __WEBPACK_IMPORTED_MODULE_2__text__["a" /* CoreTextUtilsProvider */]])
    ], CoreUrlUtilsProvider);
    return CoreUrlUtilsProvider;
}());

//# sourceMappingURL=url.js.map

/***/ }),
/* 24 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreTimeUtilsProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__ngx_translate_core__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_moment__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_moment___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_moment__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__core_constants__ = __webpack_require__(40);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};




/*
 * "Utils" service with helper functions for date and time.
*/
var CoreTimeUtilsProvider = /** @class */ (function () {
    function CoreTimeUtilsProvider(translate) {
        this.translate = translate;
        this.FORMAT_REPLACEMENTS = {
            '%a': 'ddd',
            '%A': 'dddd',
            '%d': 'DD',
            '%e': 'D',
            '%j': 'DDDD',
            '%u': 'E',
            '%w': 'e',
            '%U': 'ww',
            '%V': 'WW',
            '%W': 'ww',
            '%b': 'MMM',
            '%B': 'MMMM',
            '%h': 'MMM',
            '%m': 'MM',
            '%C': '',
            '%g': 'GG',
            '%G': 'GGGG',
            '%y': 'YY',
            '%Y': 'YYYY',
            '%H': 'HH',
            '%k': 'H',
            '%I': 'hh',
            '%l': 'h',
            '%M': 'mm',
            '%p': 'A',
            '%P': 'a',
            '%r': 'hh:mm:ss A',
            '%R': 'HH:mm',
            '%S': 'ss',
            '%T': 'HH:mm:ss',
            '%X': 'LTS',
            '%z': 'ZZ',
            '%Z': 'ZZ',
            '%c': 'LLLL',
            '%D': 'MM/DD/YY',
            '%F': 'YYYY-MM-DD',
            '%s': 'X',
            '%x': 'L',
            '%n': '\n',
            '%t': '\t',
            '%%': '%'
        };
    }
    /**
     * Convert a PHP format to a Moment format.
     *
     * @param {string} format PHP format.
     * @return {string} Converted format.
     */
    CoreTimeUtilsProvider.prototype.convertPHPToMoment = function (format) {
        if (typeof format != 'string') {
            // Not valid.
            return '';
        }
        var converted = '', escaping = false;
        for (var i = 0; i < format.length; i++) {
            var char = format[i];
            if (char == '%') {
                // It's a PHP format, try to convert it.
                i++;
                char += format[i] || '';
                if (escaping) {
                    // We were escaping some characters, stop doing it now.
                    escaping = false;
                    converted += ']';
                }
                converted += typeof this.FORMAT_REPLACEMENTS[char] != 'undefined' ? this.FORMAT_REPLACEMENTS[char] : char;
            }
            else {
                // Not a PHP format. We need to escape them, otherwise the letters could be confused with Moment formats.
                if (!escaping) {
                    escaping = true;
                    converted += '[';
                }
                converted += char;
            }
        }
        if (escaping) {
            // Finish escaping.
            converted += ']';
        }
        return converted;
    };
    /**
     * Fix format to use in an ion-datetime.
     *
     * @param {string} format Format to use.
     * @return {string} Fixed format.
     */
    CoreTimeUtilsProvider.prototype.fixFormatForDatetime = function (format) {
        if (!format) {
            return '';
        }
        // The component ion-datetime doesn't support escaping characters ([]), so we remove them.
        var fixed = format.replace(/[\[\]]/g, '');
        if (fixed.indexOf('A') != -1) {
            // Do not use am/pm format because there is a bug in ion-datetime.
            fixed = fixed.replace(/ ?A/g, '');
            fixed = fixed.replace(/h/g, 'H');
        }
        return fixed;
    };
    /**
     * Returns hours, minutes and seconds in a human readable format
     *
     * @param {number} seconds A number of seconds
     * @return {string} Seconds in a human readable format.
     */
    CoreTimeUtilsProvider.prototype.formatTime = function (seconds) {
        var totalSecs, years, days, hours, mins, secs, remainder;
        totalSecs = Math.abs(seconds);
        years = Math.floor(totalSecs / __WEBPACK_IMPORTED_MODULE_3__core_constants__["a" /* CoreConstants */].SECONDS_YEAR);
        remainder = totalSecs - (years * __WEBPACK_IMPORTED_MODULE_3__core_constants__["a" /* CoreConstants */].SECONDS_YEAR);
        days = Math.floor(remainder / __WEBPACK_IMPORTED_MODULE_3__core_constants__["a" /* CoreConstants */].SECONDS_DAY);
        remainder = totalSecs - (days * __WEBPACK_IMPORTED_MODULE_3__core_constants__["a" /* CoreConstants */].SECONDS_DAY);
        hours = Math.floor(remainder / __WEBPACK_IMPORTED_MODULE_3__core_constants__["a" /* CoreConstants */].SECONDS_HOUR);
        remainder = remainder - (hours * __WEBPACK_IMPORTED_MODULE_3__core_constants__["a" /* CoreConstants */].SECONDS_HOUR);
        mins = Math.floor(remainder / __WEBPACK_IMPORTED_MODULE_3__core_constants__["a" /* CoreConstants */].SECONDS_MINUTE);
        secs = remainder - (mins * __WEBPACK_IMPORTED_MODULE_3__core_constants__["a" /* CoreConstants */].SECONDS_MINUTE);
        var ss = this.translate.instant('core.' + (secs == 1 ? 'sec' : 'secs')), sm = this.translate.instant('core.' + (mins == 1 ? 'min' : 'mins')), sh = this.translate.instant('core.' + (hours == 1 ? 'hour' : 'hours')), sd = this.translate.instant('core.' + (days == 1 ? 'day' : 'days')), sy = this.translate.instant('core.' + (years == 1 ? 'year' : 'years'));
        var oyears = '', odays = '', ohours = '', omins = '', osecs = '';
        if (years) {
            oyears = years + ' ' + sy;
        }
        if (days) {
            odays = days + ' ' + sd;
        }
        if (hours) {
            ohours = hours + ' ' + sh;
        }
        if (mins) {
            omins = mins + ' ' + sm;
        }
        if (secs) {
            osecs = secs + ' ' + ss;
        }
        if (years) {
            return oyears + ' ' + odays;
        }
        if (days) {
            return odays + ' ' + ohours;
        }
        if (hours) {
            return ohours + ' ' + omins;
        }
        if (mins) {
            return omins + ' ' + osecs;
        }
        if (secs) {
            return osecs;
        }
        return this.translate.instant('core.now');
    };
    /**
     * Returns hours, minutes and seconds in a human readable format.
     *
     * @param {number} duration Duration in seconds
     * @param {number} [precision] Number of elements to have in precission. 0 or undefined to full precission.
     * @return {string} Duration in a human readable format.
     */
    CoreTimeUtilsProvider.prototype.formatDuration = function (duration, precision) {
        precision = precision || 5;
        var eventDuration = __WEBPACK_IMPORTED_MODULE_2_moment__["duration"](duration, 'seconds');
        var durationString = '';
        if (precision && eventDuration.years() > 0) {
            durationString += ' ' + __WEBPACK_IMPORTED_MODULE_2_moment__["duration"](eventDuration.years(), 'years').humanize();
            precision--;
        }
        if (precision && eventDuration.months() > 0) {
            durationString += ' ' + __WEBPACK_IMPORTED_MODULE_2_moment__["duration"](eventDuration.months(), 'months').humanize();
            precision--;
        }
        if (precision && eventDuration.days() > 0) {
            durationString += ' ' + __WEBPACK_IMPORTED_MODULE_2_moment__["duration"](eventDuration.days(), 'days').humanize();
            precision--;
        }
        if (precision && eventDuration.hours() > 0) {
            durationString += ' ' + __WEBPACK_IMPORTED_MODULE_2_moment__["duration"](eventDuration.hours(), 'hours').humanize();
            precision--;
        }
        if (precision && eventDuration.minutes() > 0) {
            durationString += ' ' + __WEBPACK_IMPORTED_MODULE_2_moment__["duration"](eventDuration.minutes(), 'minutes').humanize();
            precision--;
        }
        return durationString.trim();
    };
    /**
     * Return the current timestamp in a "readable" format: YYYYMMDDHHmmSS.
     *
     * @return {string} The readable timestamp.
     */
    CoreTimeUtilsProvider.prototype.readableTimestamp = function () {
        return __WEBPACK_IMPORTED_MODULE_2_moment__(Date.now()).format('YYYYMMDDHHmmSS');
    };
    /**
     * Return the current timestamp (UNIX format, seconds).
     *
     * @return {number} The current timestamp in seconds.
     */
    CoreTimeUtilsProvider.prototype.timestamp = function () {
        return Math.round(Date.now() / 1000);
    };
    /**
     * Convert a timestamp into a readable date.
     *
     * @param {number} timestamp Timestamp in milliseconds.
     * @param {string} [format] The format to use (lang key). Defaults to core.strftimedaydatetime.
     * @param {boolean} [convert=true] If true (default), convert the format from PHP to Moment. Set it to false for Moment formats.
     * @param {boolean} [fixDay=true] If true (default) then the leading zero from %d is removed.
     * @param {boolean} [fixHour=true] If true (default) then the leading zero from %I is removed.
     * @return {string} Readable date.
     */
    CoreTimeUtilsProvider.prototype.userDate = function (timestamp, format, convert, fixDay, fixHour) {
        if (convert === void 0) { convert = true; }
        if (fixDay === void 0) { fixDay = true; }
        if (fixHour === void 0) { fixHour = true; }
        format = this.translate.instant(format ? format : 'core.strftimedaydatetime');
        if (fixDay) {
            format = format.replace(/%d/g, '%e');
        }
        if (fixHour) {
            format = format.replace('%I', '%l');
        }
        // Format could be in PHP format, convert it to moment.
        if (convert) {
            format = this.convertPHPToMoment(format);
        }
        return __WEBPACK_IMPORTED_MODULE_2_moment__(timestamp).format(format);
    };
    /**
     * Convert a timestamp to the format to set to a datetime input.
     *
     * @param {number} [timestamp] Timestamp to convert (in ms). If not provided, current time.
     * @return {string} Formatted time.
     */
    CoreTimeUtilsProvider.prototype.toDatetimeFormat = function (timestamp) {
        timestamp = timestamp || Date.now();
        return this.userDate(timestamp, 'YYYY-MM-DDTHH:mm:ss.SSS', false) + 'Z';
    };
    /**
     * Convert a text into user timezone timestamp.
     *
     * @param {number} date To convert to timestamp.
     * @return {number} Converted timestamp.
     */
    CoreTimeUtilsProvider.prototype.convertToTimestamp = function (date) {
        if (typeof date == 'string' && date.slice(-1) == 'Z') {
            return __WEBPACK_IMPORTED_MODULE_2_moment__(date).unix() - (__WEBPACK_IMPORTED_MODULE_2_moment__().utcOffset() * 60);
        }
        return __WEBPACK_IMPORTED_MODULE_2_moment__(date).unix();
    };
    /**
     * Return the localized ISO format (i.e DDMMYY) from the localized moment format. Useful for translations.
     * DO NOT USE this function for ion-datetime format. Moment escapes characters with [], but ion-datetime doesn't support it.
     *
     * @param {any} localizedFormat Format to use.
     * @return {string} Localized ISO format
     */
    CoreTimeUtilsProvider.prototype.getLocalizedDateFormat = function (localizedFormat) {
        return __WEBPACK_IMPORTED_MODULE_2_moment__["localeData"]().longDateFormat(localizedFormat);
    };
    /**
     * For a given timestamp get the midnight value in the user's timezone.
     *
     * The calculation is performed relative to the user's midnight timestamp
     * for today to ensure that timezones are preserved.
     *
     * @param {number} [timestamp] The timestamp to calculate from. If not defined, return today's midnight.
     * @return {number} The midnight value of the user's timestamp.
     */
    CoreTimeUtilsProvider.prototype.getMidnightForTimestamp = function (timestamp) {
        if (timestamp) {
            return __WEBPACK_IMPORTED_MODULE_2_moment__(timestamp * 1000).startOf('day').unix();
        }
        else {
            return __WEBPACK_IMPORTED_MODULE_2_moment__().startOf('day').unix();
        }
    };
    CoreTimeUtilsProvider = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_1__ngx_translate_core__["c" /* TranslateService */]])
    ], CoreTimeUtilsProvider);
    return CoreTimeUtilsProvider;
}());

//# sourceMappingURL=time.js.map

/***/ }),
/* 25 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreSplitViewComponent; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ngx_translate_core__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__core_fileuploader_providers_fileuploader__ = __webpack_require__(68);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
// Code based on https://github.com/martinpritchardelevate/ionic-split-pane-demo




/**
 * Directive to create a split view layout.
 *
 * @description
 * To init/change the right pane contents (content pane), inject this component in the master page.
 * @ViewChild(CoreSplitViewComponent) splitviewCtrl: CoreSplitViewComponent;
 * Then use the push function to load.
 *
 * Accepts the following params:
 *
 * @param {string|boolean} [when] When the split-pane should be shown. Can be a CSS media query expression, or a shortcut
 * expression. Can also be a boolean expression. Check split-pane component documentation for more information.
 *
 * Example:
 *
 * <core-split-view [when]="lg">
 *     <ion-content><!-- CONTENT TO SHOW ON THE LEFT PANEL (MENU) --></ion-content>
 * </core-split-view>
 */
var CoreSplitViewComponent = /** @class */ (function () {
    function CoreSplitViewComponent(masterNav, element, fileUploaderProvider, platform, translate) {
        var _this = this;
        this.masterNav = masterNav;
        this.when = 'md';
        this.masterPageName = '';
        this.masterPageIndex = 0;
        this.loadDetailPage = false;
        this.masterCanLeaveOverridden = false;
        this.ignoreSplitChanged = false;
        // Empty placeholder for the 'detail' page.
        this.detailPage = null;
        this.element = element.nativeElement;
        this.audioCaptureSubscription = fileUploaderProvider.onAudioCapture.subscribe(function (starting) {
            _this.ignoreSplitChanged = starting;
        });
        // Change the side when the language changes.
        this.languageChangedSubscription = translate.onLangChange.subscribe(function (event) {
            setTimeout(function () {
                _this.side = platform.isRTL ? 'right' : 'left';
                _this.menu.setElementAttribute('side', _this.side);
            });
        });
    }
    /**
     * Component being initialized.
     */
    CoreSplitViewComponent.prototype.ngOnInit = function () {
        // Get the master page name and set an empty page as a placeholder.
        this.masterPageName = this.masterNav.getActive().component.name;
        this.masterPageIndex = this.masterNav.indexOf(this.masterNav.getActive());
        this.emptyDetails();
        this.handleCanLeave();
    };
    /**
     * Get the details NavController. If split view is not enabled, it will return the master nav.
     *
     * @return {NavController} Details NavController.
     */
    CoreSplitViewComponent.prototype.getDetailsNav = function () {
        if (this.isEnabled) {
            return this.detailNav;
        }
        else {
            return this.masterNav;
        }
    };
    /**
     * Get the master NavController.
     *
     * @return {NavController} Master NavController.
     */
    CoreSplitViewComponent.prototype.getMasterNav = function () {
        return this.masterNav;
    };
    /**
     * Handle ionViewCanLeave functions in details page. By default, this function isn't captured by Ionic when
     * clicking the back button, it only uses the one in the master page.
     */
    CoreSplitViewComponent.prototype.handleCanLeave = function () {
        var _this = this;
        // Listen for the didEnter event on the details nav to detect everytime a page is loaded.
        this.detailsDidEnterSubscription = this.detailNav.viewDidEnter.subscribe(function (detailsViewController) {
            if (!_this.isOn()) {
                return;
            }
            var masterViewController = _this.masterNav.getActive();
            if (_this.masterCanLeaveOverridden) {
                // We've overridden the can leave of the master page for a previous details page. Restore it.
                masterViewController.instance.ionViewCanLeave = _this.originalMasterCanLeave;
                _this.originalMasterCanLeave = undefined;
                _this.masterCanLeaveOverridden = false;
            }
            if (detailsViewController && detailsViewController.instance && detailsViewController.instance.ionViewCanLeave) {
                // The details page defines a canLeave function. Check if the master page also defines one.
                if (masterViewController.instance.ionViewCanLeave) {
                    // Master page also defines a canLeave function, store it because it will be overridden.
                    _this.originalMasterCanLeave = masterViewController.instance.ionViewCanLeave;
                }
                // Override the master canLeave function so it also calls the details canLeave.
                _this.masterCanLeaveOverridden = true;
                masterViewController.instance.ionViewCanLeave = function () {
                    // Always return a Promise.
                    return Promise.resolve().then(function () {
                        if (_this.originalMasterCanLeave) {
                            // First call the master canLeave.
                            var result = _this.originalMasterCanLeave.apply(masterViewController.instance);
                            if (typeof result == 'boolean' && !result) {
                                // User cannot leave, return a rejected promise so the details canLeave isn't executed.
                                return Promise.reject(null);
                            }
                            else {
                                return result;
                            }
                        }
                    }).then(function () {
                        // User can leave the master page. Check if he can also leave the details page.
                        return detailsViewController.instance.ionViewCanLeave();
                    });
                };
            }
        });
    };
    /**
     * Check if both panels are shown. It depends on screen width.
     *
     * @return {boolean} If split view is enabled.
     */
    CoreSplitViewComponent.prototype.isOn = function () {
        return !!this.isEnabled;
    };
    /**
     * Push a page to the navigation stack. It will decide where to load it depending on the size of the screen.
     *
     * @param {any} page   The component class or deeplink name you want to push onto the navigation stack.
     * @param {any} params Any NavParams you want to pass along to the next view.
     * @param {boolean} [retrying] Whether it's retrying.
     */
    CoreSplitViewComponent.prototype.push = function (page, params, retrying) {
        var _this = this;
        // Check there's no ongoing push.
        if (!this.pushOngoing) {
            if (typeof this.isEnabled == 'undefined' && !retrying) {
                // Hasn't calculated if it's enabled yet. Wait a bit and try again.
                setTimeout(function () {
                    _this.push(page, params, true);
                }, 200);
            }
            else {
                this.pushOngoing = true;
                var promise = void 0;
                if (this.isEnabled) {
                    promise = this.detailNav.setRoot(page, params);
                }
                else {
                    this.loadDetailPage = {
                        component: page,
                        data: params
                    };
                    promise = this.masterNav.push(page, params);
                }
                promise.finally(function () {
                    _this.pushOngoing = false;
                });
            }
        }
    };
    /**
     * Set the details panel to default info.
     */
    CoreSplitViewComponent.prototype.emptyDetails = function () {
        this.loadDetailPage = false;
        this.detailNav.setRoot('CoreSplitViewPlaceholderPage');
    };
    /**
     * Splitpanel visibility has changed.
     *
     * @param {Boolean} isOn If it fits both panels at the same time.
     */
    CoreSplitViewComponent.prototype.onSplitPaneChanged = function (isOn) {
        if (this.ignoreSplitChanged) {
            return;
        }
        this.isEnabled = isOn;
        if (this.masterNav && this.detailNav) {
            (isOn) ? this.activateSplitView() : this.deactivateSplitView();
        }
    };
    /**
     * Enable the split view, show both panels and do some magical navigation.
     */
    CoreSplitViewComponent.prototype.activateSplitView = function () {
        var currentView = this.masterNav.getActive(), currentPageName = currentView.component.name;
        if (this.masterNav.getPrevious() && this.masterNav.getPrevious().component.name == this.masterPageName) {
            if (currentPageName != this.masterPageName) {
                // CurrentView is a 'Detail' page remove it from the 'master' nav stack.
                this.masterNav.pop();
                // And add it to the 'detail' nav stack.
                this.detailNav.setRoot(currentView.component, currentView.data);
            }
            else if (this.loadDetailPage) {
                // MasterPage is shown, load the last detail page if found.
                this.detailNav.setRoot(this.loadDetailPage.component, this.loadDetailPage.data);
            }
            this.loadDetailPage = false;
        }
    };
    /**
     * Disabled the split view, show only one panel and do some magical navigation.
     */
    CoreSplitViewComponent.prototype.deactivateSplitView = function () {
        var detailView = this.detailNav.getActive(), currentPageName = detailView.component.name;
        if (currentPageName != 'CoreSplitViewPlaceholderPage') {
            // Current detail view is a 'Detail' page so, not the placeholder page, push it on 'master' nav stack.
            this.masterNav.insert(this.masterPageIndex + 1, detailView.component, detailView.data);
        }
    };
    /**
     * Component being destroyed.
     */
    CoreSplitViewComponent.prototype.ngOnDestroy = function () {
        this.detailsDidEnterSubscription && this.detailsDidEnterSubscription.unsubscribe();
        this.audioCaptureSubscription.unsubscribe();
        this.languageChangedSubscription.unsubscribe();
    };
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["_9" /* ViewChild */])('detailNav'),
        __metadata("design:type", __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["r" /* Nav */])
    ], CoreSplitViewComponent.prototype, "detailNav", void 0);
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["_9" /* ViewChild */])('menu'),
        __metadata("design:type", __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["o" /* Menu */])
    ], CoreSplitViewComponent.prototype, "menu", void 0);
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["D" /* Input */])(),
        __metadata("design:type", Object)
    ], CoreSplitViewComponent.prototype, "when", void 0);
    CoreSplitViewComponent = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: 'core-split-view',
            templateUrl: 'core-split-view.html'
        }),
        __param(0, Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["N" /* Optional */])()),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_1_ionic_angular__["s" /* NavController */], __WEBPACK_IMPORTED_MODULE_0__angular_core__["t" /* ElementRef */], __WEBPACK_IMPORTED_MODULE_3__core_fileuploader_providers_fileuploader__["a" /* CoreFileUploaderProvider */],
            __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["v" /* Platform */], __WEBPACK_IMPORTED_MODULE_2__ngx_translate_core__["c" /* TranslateService */]])
    ], CoreSplitViewComponent);
    return CoreSplitViewComponent;
}());

//# sourceMappingURL=split-view.js.map

/***/ }),
/* 26 */,
/* 27 */,
/* 28 */,
/* 29 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreComponentsModule; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ngx_translate_core__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__directives_directives_module__ = __webpack_require__(31);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__pipes_pipes_module__ = __webpack_require__(109);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__loading_loading__ = __webpack_require__(47);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__mark_required_mark_required__ = __webpack_require__(80);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__input_errors_input_errors__ = __webpack_require__(89);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__show_password_show_password__ = __webpack_require__(373);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__split_view_split_view__ = __webpack_require__(25);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__iframe_iframe__ = __webpack_require__(281);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__progress_bar_progress_bar__ = __webpack_require__(315);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__empty_box_empty_box__ = __webpack_require__(110);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__search_box_search_box__ = __webpack_require__(485);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14__file_file__ = __webpack_require__(181);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15__icon_icon__ = __webpack_require__(94);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_16__context_menu_context_menu__ = __webpack_require__(74);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_17__context_menu_context_menu_item__ = __webpack_require__(78);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_18__context_menu_context_menu_popover__ = __webpack_require__(567);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_19__course_picker_menu_course_picker_menu_popover__ = __webpack_require__(568);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_20__chart_chart__ = __webpack_require__(441);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_21__chrono_chrono__ = __webpack_require__(1528);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_22__download_refresh_download_refresh__ = __webpack_require__(391);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_23__local_file_local_file__ = __webpack_require__(279);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_24__site_picker_site_picker__ = __webpack_require__(1529);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_25__tabs_tabs__ = __webpack_require__(172);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_26__tabs_tab__ = __webpack_require__(72);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_27__rich_text_editor_rich_text_editor__ = __webpack_require__(247);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_28__navbar_buttons_navbar_buttons__ = __webpack_require__(87);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_29__dynamic_component_dynamic_component__ = __webpack_require__(194);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_30__send_message_form_send_message_form__ = __webpack_require__(1505);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_31__timer_timer__ = __webpack_require__(1506);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_32__recaptcha_recaptcha__ = __webpack_require__(1507);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_33__recaptcha_recaptchamodal__ = __webpack_require__(569);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_34__navigation_bar_navigation_bar__ = __webpack_require__(392);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_35__attachments_attachments__ = __webpack_require__(314);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_36__ion_tabs_ion_tabs__ = __webpack_require__(719);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_37__ion_tabs_ion_tab__ = __webpack_require__(1530);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_38__infinite_loading_infinite_loading__ = __webpack_require__(271);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_39__user_avatar_user_avatar__ = __webpack_require__(179);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_40__style_style__ = __webpack_require__(491);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_41__bs_tooltip_bs_tooltip__ = __webpack_require__(563);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};










































var CoreComponentsModule = /** @class */ (function () {
    function CoreComponentsModule() {
    }
    CoreComponentsModule = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["I" /* NgModule */])({
            declarations: [
                __WEBPACK_IMPORTED_MODULE_5__loading_loading__["a" /* CoreLoadingComponent */],
                __WEBPACK_IMPORTED_MODULE_6__mark_required_mark_required__["a" /* CoreMarkRequiredComponent */],
                __WEBPACK_IMPORTED_MODULE_7__input_errors_input_errors__["a" /* CoreInputErrorsComponent */],
                __WEBPACK_IMPORTED_MODULE_8__show_password_show_password__["a" /* CoreShowPasswordComponent */],
                __WEBPACK_IMPORTED_MODULE_9__split_view_split_view__["a" /* CoreSplitViewComponent */],
                __WEBPACK_IMPORTED_MODULE_10__iframe_iframe__["a" /* CoreIframeComponent */],
                __WEBPACK_IMPORTED_MODULE_11__progress_bar_progress_bar__["a" /* CoreProgressBarComponent */],
                __WEBPACK_IMPORTED_MODULE_12__empty_box_empty_box__["a" /* CoreEmptyBoxComponent */],
                __WEBPACK_IMPORTED_MODULE_13__search_box_search_box__["a" /* CoreSearchBoxComponent */],
                __WEBPACK_IMPORTED_MODULE_14__file_file__["a" /* CoreFileComponent */],
                __WEBPACK_IMPORTED_MODULE_15__icon_icon__["a" /* CoreIconComponent */],
                __WEBPACK_IMPORTED_MODULE_16__context_menu_context_menu__["a" /* CoreContextMenuComponent */],
                __WEBPACK_IMPORTED_MODULE_17__context_menu_context_menu_item__["a" /* CoreContextMenuItemComponent */],
                __WEBPACK_IMPORTED_MODULE_18__context_menu_context_menu_popover__["a" /* CoreContextMenuPopoverComponent */],
                __WEBPACK_IMPORTED_MODULE_19__course_picker_menu_course_picker_menu_popover__["a" /* CoreCoursePickerMenuPopoverComponent */],
                __WEBPACK_IMPORTED_MODULE_20__chart_chart__["a" /* CoreChartComponent */],
                __WEBPACK_IMPORTED_MODULE_21__chrono_chrono__["a" /* CoreChronoComponent */],
                __WEBPACK_IMPORTED_MODULE_22__download_refresh_download_refresh__["a" /* CoreDownloadRefreshComponent */],
                __WEBPACK_IMPORTED_MODULE_23__local_file_local_file__["a" /* CoreLocalFileComponent */],
                __WEBPACK_IMPORTED_MODULE_24__site_picker_site_picker__["a" /* CoreSitePickerComponent */],
                __WEBPACK_IMPORTED_MODULE_25__tabs_tabs__["a" /* CoreTabsComponent */],
                __WEBPACK_IMPORTED_MODULE_26__tabs_tab__["a" /* CoreTabComponent */],
                __WEBPACK_IMPORTED_MODULE_27__rich_text_editor_rich_text_editor__["a" /* CoreRichTextEditorComponent */],
                __WEBPACK_IMPORTED_MODULE_28__navbar_buttons_navbar_buttons__["a" /* CoreNavBarButtonsComponent */],
                __WEBPACK_IMPORTED_MODULE_29__dynamic_component_dynamic_component__["a" /* CoreDynamicComponent */],
                __WEBPACK_IMPORTED_MODULE_30__send_message_form_send_message_form__["a" /* CoreSendMessageFormComponent */],
                __WEBPACK_IMPORTED_MODULE_31__timer_timer__["a" /* CoreTimerComponent */],
                __WEBPACK_IMPORTED_MODULE_32__recaptcha_recaptcha__["a" /* CoreRecaptchaComponent */],
                __WEBPACK_IMPORTED_MODULE_33__recaptcha_recaptchamodal__["a" /* CoreRecaptchaModalComponent */],
                __WEBPACK_IMPORTED_MODULE_34__navigation_bar_navigation_bar__["a" /* CoreNavigationBarComponent */],
                __WEBPACK_IMPORTED_MODULE_35__attachments_attachments__["a" /* CoreAttachmentsComponent */],
                __WEBPACK_IMPORTED_MODULE_36__ion_tabs_ion_tabs__["a" /* CoreIonTabsComponent */],
                __WEBPACK_IMPORTED_MODULE_37__ion_tabs_ion_tab__["a" /* CoreIonTabComponent */],
                __WEBPACK_IMPORTED_MODULE_38__infinite_loading_infinite_loading__["a" /* CoreInfiniteLoadingComponent */],
                __WEBPACK_IMPORTED_MODULE_39__user_avatar_user_avatar__["a" /* CoreUserAvatarComponent */],
                __WEBPACK_IMPORTED_MODULE_40__style_style__["a" /* CoreStyleComponent */],
                __WEBPACK_IMPORTED_MODULE_41__bs_tooltip_bs_tooltip__["a" /* CoreBSTooltipComponent */]
            ],
            entryComponents: [
                __WEBPACK_IMPORTED_MODULE_18__context_menu_context_menu_popover__["a" /* CoreContextMenuPopoverComponent */],
                __WEBPACK_IMPORTED_MODULE_19__course_picker_menu_course_picker_menu_popover__["a" /* CoreCoursePickerMenuPopoverComponent */],
                __WEBPACK_IMPORTED_MODULE_33__recaptcha_recaptchamodal__["a" /* CoreRecaptchaModalComponent */],
                __WEBPACK_IMPORTED_MODULE_41__bs_tooltip_bs_tooltip__["a" /* CoreBSTooltipComponent */]
            ],
            imports: [
                __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["k" /* IonicModule */],
                __WEBPACK_IMPORTED_MODULE_2__ngx_translate_core__["b" /* TranslateModule */].forChild(),
                __WEBPACK_IMPORTED_MODULE_3__directives_directives_module__["a" /* CoreDirectivesModule */],
                __WEBPACK_IMPORTED_MODULE_4__pipes_pipes_module__["a" /* CorePipesModule */]
            ],
            exports: [
                __WEBPACK_IMPORTED_MODULE_5__loading_loading__["a" /* CoreLoadingComponent */],
                __WEBPACK_IMPORTED_MODULE_6__mark_required_mark_required__["a" /* CoreMarkRequiredComponent */],
                __WEBPACK_IMPORTED_MODULE_7__input_errors_input_errors__["a" /* CoreInputErrorsComponent */],
                __WEBPACK_IMPORTED_MODULE_8__show_password_show_password__["a" /* CoreShowPasswordComponent */],
                __WEBPACK_IMPORTED_MODULE_9__split_view_split_view__["a" /* CoreSplitViewComponent */],
                __WEBPACK_IMPORTED_MODULE_10__iframe_iframe__["a" /* CoreIframeComponent */],
                __WEBPACK_IMPORTED_MODULE_11__progress_bar_progress_bar__["a" /* CoreProgressBarComponent */],
                __WEBPACK_IMPORTED_MODULE_12__empty_box_empty_box__["a" /* CoreEmptyBoxComponent */],
                __WEBPACK_IMPORTED_MODULE_13__search_box_search_box__["a" /* CoreSearchBoxComponent */],
                __WEBPACK_IMPORTED_MODULE_14__file_file__["a" /* CoreFileComponent */],
                __WEBPACK_IMPORTED_MODULE_15__icon_icon__["a" /* CoreIconComponent */],
                __WEBPACK_IMPORTED_MODULE_16__context_menu_context_menu__["a" /* CoreContextMenuComponent */],
                __WEBPACK_IMPORTED_MODULE_17__context_menu_context_menu_item__["a" /* CoreContextMenuItemComponent */],
                __WEBPACK_IMPORTED_MODULE_20__chart_chart__["a" /* CoreChartComponent */],
                __WEBPACK_IMPORTED_MODULE_21__chrono_chrono__["a" /* CoreChronoComponent */],
                __WEBPACK_IMPORTED_MODULE_22__download_refresh_download_refresh__["a" /* CoreDownloadRefreshComponent */],
                __WEBPACK_IMPORTED_MODULE_23__local_file_local_file__["a" /* CoreLocalFileComponent */],
                __WEBPACK_IMPORTED_MODULE_24__site_picker_site_picker__["a" /* CoreSitePickerComponent */],
                __WEBPACK_IMPORTED_MODULE_25__tabs_tabs__["a" /* CoreTabsComponent */],
                __WEBPACK_IMPORTED_MODULE_26__tabs_tab__["a" /* CoreTabComponent */],
                __WEBPACK_IMPORTED_MODULE_27__rich_text_editor_rich_text_editor__["a" /* CoreRichTextEditorComponent */],
                __WEBPACK_IMPORTED_MODULE_28__navbar_buttons_navbar_buttons__["a" /* CoreNavBarButtonsComponent */],
                __WEBPACK_IMPORTED_MODULE_29__dynamic_component_dynamic_component__["a" /* CoreDynamicComponent */],
                __WEBPACK_IMPORTED_MODULE_30__send_message_form_send_message_form__["a" /* CoreSendMessageFormComponent */],
                __WEBPACK_IMPORTED_MODULE_31__timer_timer__["a" /* CoreTimerComponent */],
                __WEBPACK_IMPORTED_MODULE_32__recaptcha_recaptcha__["a" /* CoreRecaptchaComponent */],
                __WEBPACK_IMPORTED_MODULE_34__navigation_bar_navigation_bar__["a" /* CoreNavigationBarComponent */],
                __WEBPACK_IMPORTED_MODULE_35__attachments_attachments__["a" /* CoreAttachmentsComponent */],
                __WEBPACK_IMPORTED_MODULE_36__ion_tabs_ion_tabs__["a" /* CoreIonTabsComponent */],
                __WEBPACK_IMPORTED_MODULE_37__ion_tabs_ion_tab__["a" /* CoreIonTabComponent */],
                __WEBPACK_IMPORTED_MODULE_38__infinite_loading_infinite_loading__["a" /* CoreInfiniteLoadingComponent */],
                __WEBPACK_IMPORTED_MODULE_39__user_avatar_user_avatar__["a" /* CoreUserAvatarComponent */],
                __WEBPACK_IMPORTED_MODULE_40__style_style__["a" /* CoreStyleComponent */],
                __WEBPACK_IMPORTED_MODULE_41__bs_tooltip_bs_tooltip__["a" /* CoreBSTooltipComponent */]
            ]
        })
    ], CoreComponentsModule);
    return CoreComponentsModule;
}());

//# sourceMappingURL=components.module.js.map

/***/ }),
/* 30 */,
/* 31 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXTERNAL MODULE: ./node_modules/@angular/core/esm5/core.js
var core = __webpack_require__(0);

// EXTERNAL MODULE: ./src/directives/auto-focus.ts
var auto_focus = __webpack_require__(372);

// EXTERNAL MODULE: ./src/providers/file-helper.ts
var file_helper = __webpack_require__(135);

// EXTERNAL MODULE: ./src/providers/utils/dom.ts
var dom = __webpack_require__(4);

// CONCATENATED MODULE: ./src/directives/download-file.ts
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};



/**
 * Directive to allow downloading and open a file. When the item with this directive is clicked, the file will be
 * downloaded (if needed) and opened.
 */
var download_file_CoreDownloadFileDirective = /** @class */ (function () {
    function CoreDownloadFileDirective(element, domUtils, fileHelper) {
        this.domUtils = domUtils;
        this.fileHelper = fileHelper;
        this.element = element.nativeElement || element;
    }
    /**
     * Component being initialized.
     */
    CoreDownloadFileDirective.prototype.ngOnInit = function () {
        var _this = this;
        this.element.addEventListener('click', function (ev) {
            if (!_this.file) {
                return;
            }
            ev.preventDefault();
            ev.stopPropagation();
            var modal = _this.domUtils.showModalLoading();
            _this.fileHelper.downloadAndOpenFile(_this.file, _this.component, _this.componentId).catch(function (error) {
                _this.domUtils.showErrorModalDefault(error, 'core.errordownloading', true);
            }).finally(function () {
                modal.dismiss();
            });
        });
    };
    __decorate([
        Object(core["D" /* Input */])('core-download-file'),
        __metadata("design:type", Object)
    ], CoreDownloadFileDirective.prototype, "file", void 0);
    __decorate([
        Object(core["D" /* Input */])(),
        __metadata("design:type", String)
    ], CoreDownloadFileDirective.prototype, "component", void 0);
    __decorate([
        Object(core["D" /* Input */])(),
        __metadata("design:type", Object)
    ], CoreDownloadFileDirective.prototype, "componentId", void 0);
    CoreDownloadFileDirective = __decorate([
        Object(core["s" /* Directive */])({
            selector: '[core-download-file]'
        }),
        __metadata("design:paramtypes", [core["t" /* ElementRef */], dom["a" /* CoreDomUtilsProvider */], file_helper["a" /* CoreFileHelperProvider */]])
    ], CoreDownloadFileDirective);
    return CoreDownloadFileDirective;
}());

//# sourceMappingURL=download-file.js.map
// EXTERNAL MODULE: ./src/directives/external-content.ts
var external_content = __webpack_require__(215);

// EXTERNAL MODULE: ./src/directives/fab.ts
var fab = __webpack_require__(252);

// EXTERNAL MODULE: ./src/directives/format-text.ts
var format_text = __webpack_require__(41);

// EXTERNAL MODULE: ./src/directives/link.ts
var directives_link = __webpack_require__(182);

// EXTERNAL MODULE: ./src/providers/utils/utils.ts
var utils = __webpack_require__(2);

// CONCATENATED MODULE: ./src/directives/keep-keyboard.ts
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var keep_keyboard___decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var keep_keyboard___metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};



/**
 * IMPORTANT: This directive is deprecated because it causes a weird effect (the keyboard closes and opens again).
 * We recommend using core-suppress-events directive for a better user experience.
 *
 * Directive to keep the keyboard open when clicking a certain element (usually a button).
 *
 * @description
 *
 * This directive needs to be applied to an input or textarea. The value of the directive needs to be a selector
 * to identify the element to listen for clicks (usually a button).
 *
 * When that element is clicked, the input that has this directive will keep the focus if it has it already and the keyboard
 * won't be closed.
 *
 * Example usage:
 *
 * <textarea [core-keep-keyboard]="'#mma-messages-send-message-button'"></textarea>
 * <button id="mma-messages-send-message-button">Send</button>
 *
 * Alternatively, this directive can be applied to the button. The value of the directive needs to be a selector to identify
 * the input element. In this case, you need to set [inButton]="true".
 *
 * Example usage:
 *
 * <textarea id="send-message-input"></textarea>
 * <button [core-keep-keyboard]="'#send-message-input'" [inButton]="true">Send</button>
 *
 * @deprecated v3.5.2
 */
var keep_keyboard_CoreKeepKeyboardDirective = /** @class */ (function () {
    function CoreKeepKeyboardDirective(element, domUtils, utils) {
        this.domUtils = domUtils;
        this.utils = utils;
        this.lastFocusOut = 0; // Last time the input was focused out.
        this.element = element.nativeElement;
    }
    /**
     * View has been initialized.
     */
    CoreKeepKeyboardDirective.prototype.ngAfterViewInit = function () {
        var _this = this;
        // Use a setTimeout because to make sure that child components have been treated.
        setTimeout(function () {
            var inButton = _this.utils.isTrueOrOne(_this.inButton);
            var candidateEls, selectedEl;
            if (typeof _this.selector != 'string' || !_this.selector) {
                // Not a valid selector, stop.
                return;
            }
            // Get the selected element. Get the last one found.
            candidateEls = document.querySelectorAll(_this.selector);
            selectedEl = candidateEls[candidateEls.length - 1];
            if (!selectedEl) {
                // Element not found.
                return;
            }
            if (inButton) {
                // The directive is applied to the button.
                _this.button = _this.element;
                _this.input = selectedEl;
            }
            else {
                // The directive is applied to the input.
                _this.button = selectedEl;
                if (_this.element.tagName == 'ION-INPUT') {
                    // Search the inner input.
                    _this.input = _this.element.querySelector('input');
                }
                else if (_this.element.tagName == 'ION-TEXTAREA') {
                    // Search the inner textarea.
                    _this.input = _this.element.querySelector('textarea');
                }
                else {
                    _this.input = _this.element;
                }
                if (!_this.input) {
                    // Input not found, stop.
                    return;
                }
            }
            // Listen for focusout event. This is to be able to check if previous focus was on this element.
            _this.focusOutListener = _this.focusOut.bind(_this);
            _this.input.addEventListener('focusout', _this.focusOutListener);
            // Listen for clicks in the button.
            _this.clickListener = _this.buttonClicked.bind(_this);
            _this.button.addEventListener('click', _this.clickListener);
        });
    };
    /**
     * Component destroyed.
     */
    CoreKeepKeyboardDirective.prototype.ngOnDestroy = function () {
        if (this.button && this.clickListener) {
            this.button.removeEventListener('click', this.clickListener);
        }
        if (this.input && this.focusOutListener) {
            this.input.removeEventListener('focusout', this.focusOutListener);
        }
    };
    /**
     * The button we're interested in was clicked.
     */
    CoreKeepKeyboardDirective.prototype.buttonClicked = function () {
        if (document.activeElement == this.input) {
            // Directive's element is focused at the time the button is clicked. Listen for focusout to focus it again.
            this.focusAgainListener = this.focusElementAgain.bind(this);
            this.input.addEventListener('focusout', this.focusAgainListener);
        }
        else if (document.activeElement == this.button && Date.now() - this.lastFocusOut < 200) {
            // Last focused element was the directive's element, focus it again.
            setTimeout(this.focusElementAgain.bind(this), 0);
        }
    };
    /**
     * If keyboard is open, focus the input again and stop listening focusout to focus again if needed.
     */
    CoreKeepKeyboardDirective.prototype.focusElementAgain = function () {
        var _this = this;
        this.domUtils.focusElement(this.input);
        if (this.focusAgainListener) {
            // Sometimes we can receive more than 1 focus out event.
            // If we spend 1 second without receiving any, stop listening for them.
            var listener_1 = this.focusAgainListener; // Store it in a local variable, in case it changes.
            clearTimeout(this.stopFocusAgainTimeout);
            this.stopFocusAgainTimeout = setTimeout(function () {
                _this.input.removeEventListener('focusout', listener_1);
                if (listener_1 == _this.focusAgainListener) {
                    delete _this.focusAgainListener;
                }
            }, 1000);
        }
    };
    /**
     * Input was focused out, save the time it was done.
     */
    CoreKeepKeyboardDirective.prototype.focusOut = function () {
        this.lastFocusOut = Date.now();
    };
    keep_keyboard___decorate([
        Object(core["D" /* Input */])('core-keep-keyboard'),
        keep_keyboard___metadata("design:type", String)
    ], CoreKeepKeyboardDirective.prototype, "selector", void 0);
    keep_keyboard___decorate([
        Object(core["D" /* Input */])(),
        keep_keyboard___metadata("design:type", Object)
    ], CoreKeepKeyboardDirective.prototype, "inButton", void 0);
    CoreKeepKeyboardDirective = keep_keyboard___decorate([
        Object(core["s" /* Directive */])({
            selector: '[core-keep-keyboard]'
        }),
        keep_keyboard___metadata("design:paramtypes", [core["t" /* ElementRef */], dom["a" /* CoreDomUtilsProvider */], utils["a" /* CoreUtilsProvider */]])
    ], CoreKeepKeyboardDirective);
    return CoreKeepKeyboardDirective;
}());

//# sourceMappingURL=keep-keyboard.js.map
// EXTERNAL MODULE: ./src/directives/user-link.ts
var user_link = __webpack_require__(477);

// EXTERNAL MODULE: ./src/directives/auto-rows.ts
var auto_rows = __webpack_require__(378);

// EXTERNAL MODULE: ./src/directives/long-press.ts
var long_press = __webpack_require__(756);

// EXTERNAL MODULE: ./src/directives/back-button.ts
var back_button = __webpack_require__(471);

// EXTERNAL MODULE: ./src/directives/supress-events.ts
var supress_events = __webpack_require__(490);

// CONCATENATED MODULE: ./src/directives/directives.module.ts
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return directives_module_CoreDirectivesModule; });
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var directives_module___decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};













var directives_module_CoreDirectivesModule = /** @class */ (function () {
    function CoreDirectivesModule() {
    }
    CoreDirectivesModule = directives_module___decorate([
        Object(core["I" /* NgModule */])({
            declarations: [
                auto_focus["a" /* CoreAutoFocusDirective */],
                download_file_CoreDownloadFileDirective,
                external_content["a" /* CoreExternalContentDirective */],
                fab["a" /* CoreFabDirective */],
                format_text["a" /* CoreFormatTextDirective */],
                keep_keyboard_CoreKeepKeyboardDirective,
                directives_link["a" /* CoreLinkDirective */],
                user_link["a" /* CoreUserLinkDirective */],
                auto_rows["a" /* CoreAutoRowsDirective */],
                long_press["a" /* CoreLongPressDirective */],
                back_button["a" /* CoreBackButtonDirective */],
                supress_events["a" /* CoreSupressEventsDirective */]
            ],
            imports: [],
            exports: [
                auto_focus["a" /* CoreAutoFocusDirective */],
                download_file_CoreDownloadFileDirective,
                external_content["a" /* CoreExternalContentDirective */],
                fab["a" /* CoreFabDirective */],
                format_text["a" /* CoreFormatTextDirective */],
                keep_keyboard_CoreKeepKeyboardDirective,
                directives_link["a" /* CoreLinkDirective */],
                user_link["a" /* CoreUserLinkDirective */],
                auto_rows["a" /* CoreAutoRowsDirective */],
                long_press["a" /* CoreLongPressDirective */],
                back_button["a" /* CoreBackButtonDirective */],
                supress_events["a" /* CoreSupressEventsDirective */]
            ]
        })
    ], CoreDirectivesModule);
    return CoreDirectivesModule;
}());

//# sourceMappingURL=directives.module.js.map

/***/ }),
/* 32 */,
/* 33 */,
/* 34 */,
/* 35 */,
/* 36 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreCourseHelperProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__ngx_translate_core__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__providers_app__ = __webpack_require__(9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_events__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__providers_file__ = __webpack_require__(53);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__providers_filepool__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__providers_file_helper__ = __webpack_require__(135);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__providers_sites__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__providers_utils_dom__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__providers_utils_text__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__providers_utils_time__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__providers_utils_utils__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__options_delegate__ = __webpack_require__(96);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__core_sitehome_providers_sitehome__ = __webpack_require__(227);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14__core_courses_providers_courses__ = __webpack_require__(51);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15__course__ = __webpack_require__(14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_16__course_offline__ = __webpack_require__(347);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_17__module_delegate__ = __webpack_require__(57);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_18__module_prefetch_delegate__ = __webpack_require__(48);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_19__core_login_providers_helper__ = __webpack_require__(122);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_20__core_constants__ = __webpack_require__(40);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_21__providers_logger__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_22_moment__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_22_moment___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_22_moment__);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};























/**
 * Helper to gather some common course functions.
 */
var CoreCourseHelperProvider = /** @class */ (function () {
    function CoreCourseHelperProvider(courseProvider, domUtils, moduleDelegate, prefetchDelegate, filepoolProvider, sitesProvider, textUtils, timeUtils, utils, translate, loginHelper, courseOptionsDelegate, siteHomeProvider, eventsProvider, fileHelper, appProvider, fileProvider, injector, coursesProvider, courseOffline, loggerProvider) {
        this.courseProvider = courseProvider;
        this.domUtils = domUtils;
        this.moduleDelegate = moduleDelegate;
        this.prefetchDelegate = prefetchDelegate;
        this.filepoolProvider = filepoolProvider;
        this.sitesProvider = sitesProvider;
        this.textUtils = textUtils;
        this.timeUtils = timeUtils;
        this.utils = utils;
        this.translate = translate;
        this.loginHelper = loginHelper;
        this.courseOptionsDelegate = courseOptionsDelegate;
        this.siteHomeProvider = siteHomeProvider;
        this.eventsProvider = eventsProvider;
        this.fileHelper = fileHelper;
        this.appProvider = appProvider;
        this.fileProvider = fileProvider;
        this.injector = injector;
        this.coursesProvider = coursesProvider;
        this.courseOffline = courseOffline;
        this.courseDwnPromises = {};
        this.logger = loggerProvider.getInstance('CoreCourseHelperProvider');
    }
    /**
     * This function treats every module on the sections provided to load the handler data, treat completion
     * and navigate to a module page if required. It also returns if sections has content.
     *
     * @param {any[]} sections List of sections to treat modules.
     * @param {number} courseId Course ID of the modules.
     * @param {any[]} [completionStatus] List of completion status.
     * @param {string} [courseName] Course name. Recommended if completionStatus is supplied.
     * @return {boolean} Whether the sections have content.
     */
    CoreCourseHelperProvider.prototype.addHandlerDataForModules = function (sections, courseId, completionStatus, courseName) {
        var _this = this;
        var hasContent = false;
        sections.forEach(function (section) {
            if (!section || !_this.sectionHasContent(section) || !section.modules) {
                return;
            }
            hasContent = true;
            section.modules.forEach(function (module) {
                module.handlerData = _this.moduleDelegate.getModuleDataFor(module.modname, module, courseId, section.id);
                if (module.completiondata && module.completion > 0) {
                    module.completiondata.courseId = courseId;
                    module.completiondata.courseName = courseName;
                    module.completiondata.tracking = module.completion;
                    module.completiondata.cmid = module.id;
                    // Use of completionstatus is deprecated, use completiondata instead.
                    module.completionstatus = module.completiondata;
                }
                else if (completionStatus && typeof completionStatus[module.id] != 'undefined') {
                    // Should not happen on > 3.6. Check if activity has completions and if it's marked.
                    module.completiondata = completionStatus[module.id];
                    module.completiondata.courseId = courseId;
                    module.completiondata.courseName = courseName;
                    // Use of completionstatus is deprecated, use completiondata instead.
                    module.completionstatus = module.completiondata;
                }
                // Check if the module is stealth.
                module.isStealth = module.visibleoncoursepage === 0 || (module.visible && !section.visible);
            });
        });
        return hasContent;
    };
    /**
     * Calculate the status of a section.
     *
     * @param {any} section Section to calculate its status. It can't be "All sections".
     * @param {number} courseId Course ID the section belongs to.
     * @param {boolean} [refresh] True if it shouldn't use module status cache (slower).
     * @param {boolean} [checkUpdates=true] Whether to use the WS to check updates. Defaults to true.
     * @return {Promise<any>} Promise resolved when the status is calculated.
     */
    CoreCourseHelperProvider.prototype.calculateSectionStatus = function (section, courseId, refresh, checkUpdates) {
        var _this = this;
        if (checkUpdates === void 0) { checkUpdates = true; }
        if (section.id == __WEBPACK_IMPORTED_MODULE_15__course__["a" /* CoreCourseProvider */].ALL_SECTIONS_ID) {
            return Promise.reject(null);
        }
        // Get the status of this section.
        return this.prefetchDelegate.getModulesStatus(section.modules, courseId, section.id, refresh, true, checkUpdates)
            .then(function (result) {
            // Check if it's being downloaded.
            var downloadId = _this.getSectionDownloadId(section);
            if (_this.prefetchDelegate.isBeingDownloaded(downloadId)) {
                result.status = __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].DOWNLOADING;
            }
            section.downloadStatus = result.status;
            section.canCheckUpdates = _this.prefetchDelegate.canCheckUpdates();
            // Set this section data.
            if (result.status !== __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].DOWNLOADING || !_this.prefetchDelegate.isBeingDownloaded(section.id)) {
                section.isDownloading = false;
                section.total = 0;
            }
            else {
                // Section is being downloaded.
                section.isDownloading = true;
                _this.prefetchDelegate.setOnProgress(downloadId, function (data) {
                    section.count = data.count;
                    section.total = data.total;
                });
            }
            return result;
        });
    };
    /**
     * Calculate the status of a list of sections, setting attributes to determine the icons/data to be shown.
     *
     * @param {any[]} sections Sections to calculate their status.
     * @param {number} courseId Course ID the sections belong to.
     * @param {boolean} [refresh] True if it shouldn't use module status cache (slower).
     * @param {boolean} [checkUpdates=true] Whether to use the WS to check updates. Defaults to true.
     * @return {Promise<void>} Promise resolved when the states are calculated.
     */
    CoreCourseHelperProvider.prototype.calculateSectionsStatus = function (sections, courseId, refresh, checkUpdates) {
        var _this = this;
        if (checkUpdates === void 0) { checkUpdates = true; }
        var promises = [];
        var allSectionsSection, allSectionsStatus;
        sections.forEach(function (section) {
            if (section.id === __WEBPACK_IMPORTED_MODULE_15__course__["a" /* CoreCourseProvider */].ALL_SECTIONS_ID) {
                // "All sections" section status is calculated using the status of the rest of sections.
                allSectionsSection = section;
                section.isCalculating = true;
            }
            else {
                section.isCalculating = true;
                promises.push(_this.calculateSectionStatus(section, courseId, refresh, checkUpdates).then(function (result) {
                    // Calculate "All sections" status.
                    allSectionsStatus = _this.filepoolProvider.determinePackagesStatus(allSectionsStatus, result.status);
                }).finally(function () {
                    section.isCalculating = false;
                }));
            }
        });
        return Promise.all(promises).then(function () {
            if (allSectionsSection) {
                // Set "All sections" data.
                allSectionsSection.downloadStatus = allSectionsStatus;
                allSectionsSection.canCheckUpdates = _this.prefetchDelegate.canCheckUpdates();
                allSectionsSection.isDownloading = allSectionsStatus === __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].DOWNLOADING;
            }
        }).finally(function () {
            if (allSectionsSection) {
                allSectionsSection.isCalculating = false;
            }
        });
    };
    /**
     * Show a confirm and prefetch a course. It will retrieve the sections and the course options if not provided.
     * This function will set the icon to "spinner" when starting and it will also set it back to the initial icon if the
     * user cancels. All the other updates of the icon should be made when CoreEventsProvider.COURSE_STATUS_CHANGED is received.
     *
     * @param {any} data An object where to store the course icon and title: "prefetchCourseIcon", "title" and "downloadSucceeded".
     * @param {any} course Course to prefetch.
     * @param {any[]} [sections] List of course sections.
     * @param {CoreCourseOptionsHandlerToDisplay[]} courseHandlers List of course handlers.
     * @param {CoreCourseOptionsMenuHandlerToDisplay[]} menuHandlers List of course menu handlers.
     * @return {Promise<boolean>} Promise resolved when the download finishes, rejected if an error occurs or the user cancels.
     */
    CoreCourseHelperProvider.prototype.confirmAndPrefetchCourse = function (data, course, sections, courseHandlers, menuHandlers) {
        var _this = this;
        var initialIcon = data.prefetchCourseIcon, initialTitle = data.title, siteId = this.sitesProvider.getCurrentSiteId();
        var promise;
        data.downloadSucceeded = false;
        data.prefetchCourseIcon = 'spinner';
        data.title = 'core.downloading';
        // Get the sections first if needed.
        if (sections) {
            promise = Promise.resolve(sections);
        }
        else {
            promise = this.courseProvider.getSections(course.id, false, true);
        }
        return promise.then(function (sections) {
            // Confirm the download.
            return _this.confirmDownloadSizeSection(course.id, undefined, sections, true).then(function () {
                // User confirmed, get the course handlers if needed.
                var subPromises = [];
                if (!courseHandlers) {
                    subPromises.push(_this.courseOptionsDelegate.getHandlersToDisplay(_this.injector, course)
                        .then(function (cHandlers) {
                        courseHandlers = cHandlers;
                    }));
                }
                if (!menuHandlers) {
                    subPromises.push(_this.courseOptionsDelegate.getMenuHandlersToDisplay(_this.injector, course)
                        .then(function (mHandlers) {
                        menuHandlers = mHandlers;
                    }));
                }
                return Promise.all(subPromises).then(function () {
                    // Now we have all the data, download the course.
                    return _this.prefetchCourse(course, sections, courseHandlers, menuHandlers, siteId);
                }).then(function () {
                    // Download successful.
                    data.downloadSucceeded = true;
                    return true;
                });
            }, function (error) {
                // User cancelled or there was an error calculating the size.
                data.prefetchCourseIcon = initialIcon;
                data.title = initialTitle;
                return Promise.reject(error);
            });
        });
    };
    /**
     * Confirm and prefetches a list of courses.
     *
     * @param {any[]} courses List of courses to download.
     * @param {Function} [onProgress] Function to call everytime a course is downloaded.
     * @return {Promise<boolean>} Resolved when downloaded, rejected if error or canceled.
     */
    CoreCourseHelperProvider.prototype.confirmAndPrefetchCourses = function (courses, onProgress) {
        var _this = this;
        var siteId = this.sitesProvider.getCurrentSiteId();
        // Confirm the download without checking size because it could take a while.
        return this.domUtils.showConfirm(this.translate.instant('core.areyousure')).then(function () {
            var promises = [], total = courses.length;
            var count = 0;
            courses.forEach(function (course) {
                var subPromises = [];
                var sections, handlers, menuHandlers, success = true;
                // Get the sections and the handlers.
                subPromises.push(_this.courseProvider.getSections(course.id, false, true).then(function (courseSections) {
                    sections = courseSections;
                }));
                subPromises.push(_this.courseOptionsDelegate.getHandlersToDisplay(_this.injector, course).then(function (cHandlers) {
                    handlers = cHandlers;
                }));
                subPromises.push(_this.courseOptionsDelegate.getMenuHandlersToDisplay(_this.injector, course).then(function (mHandlers) {
                    menuHandlers = mHandlers;
                }));
                promises.push(Promise.all(subPromises).then(function () {
                    return _this.prefetchCourse(course, sections, handlers, menuHandlers, siteId);
                }).catch(function (error) {
                    success = false;
                    return Promise.reject(error);
                }).finally(function () {
                    // Course downloaded or failed, notify the progress.
                    count++;
                    if (onProgress) {
                        onProgress({ count: count, total: total, courseId: course.id, success: success });
                    }
                }));
            });
            if (onProgress) {
                // Notify the start of the download.
                onProgress({ count: 0, total: total, success: true });
            }
            return _this.utils.allPromises(promises);
        });
    };
    /**
     * Show confirmation dialog and then remove a module files.
     *
     * @param {any} module Module to remove the files.
     * @param {number} courseId Course ID the module belongs to.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreCourseHelperProvider.prototype.confirmAndRemoveFiles = function (module, courseId) {
        var _this = this;
        return this.domUtils.showConfirm(this.translate.instant('core.course.confirmdeletemodulefiles')).then(function () {
            return _this.prefetchDelegate.removeModuleFiles(module, courseId);
        }).catch(function (error) {
            if (error) {
                _this.domUtils.showErrorModal(error);
            }
        });
    };
    /**
     * Calculate the size to download a section and show a confirm modal if needed.
     *
     * @param {number} courseId Course ID the section belongs to.
     * @param {any} [section] Section. If not provided, all sections.
     * @param {any[]} [sections] List of sections. Used when downloading all the sections.
     * @param {boolean} [alwaysConfirm] True to show a confirm even if the size isn't high, false otherwise.
     * @return {Promise<any>} Promise resolved if the user confirms or there's no need to confirm.
     */
    CoreCourseHelperProvider.prototype.confirmDownloadSizeSection = function (courseId, section, sections, alwaysConfirm) {
        var _this = this;
        var sizePromise, haveEmbeddedFiles = false;
        // Calculate the size of the download.
        if (section && section.id != __WEBPACK_IMPORTED_MODULE_15__course__["a" /* CoreCourseProvider */].ALL_SECTIONS_ID) {
            sizePromise = this.prefetchDelegate.getDownloadSize(section.modules, courseId);
            // Check if the section has embedded files in the description.
            haveEmbeddedFiles = this.domUtils.extractDownloadableFilesFromHtml(section.summary).length > 0;
        }
        else {
            var promises_1 = [], results_1 = {
                size: 0,
                total: true
            };
            sections.forEach(function (s) {
                if (s.id != __WEBPACK_IMPORTED_MODULE_15__course__["a" /* CoreCourseProvider */].ALL_SECTIONS_ID) {
                    promises_1.push(_this.prefetchDelegate.getDownloadSize(s.modules, courseId).then(function (sectionSize) {
                        results_1.total = results_1.total && sectionSize.total;
                        results_1.size += sectionSize.size;
                    }));
                    // Check if the section has embedded files in the description.
                    if (!haveEmbeddedFiles && _this.domUtils.extractDownloadableFilesFromHtml(s.summary).length > 0) {
                        haveEmbeddedFiles = true;
                    }
                }
            });
            sizePromise = Promise.all(promises_1).then(function () {
                return results_1;
            });
        }
        return sizePromise.then(function (size) {
            if (haveEmbeddedFiles) {
                size.total = false;
            }
            // Show confirm modal if needed.
            return _this.domUtils.confirmDownloadSize(size, undefined, undefined, undefined, undefined, alwaysConfirm);
        });
    };
    /**
     * Helper function to prefetch a module, showing a confirmation modal if the size is big.
     * This function is meant to be called from a context menu option. It will also modify some data like the prefetch icon.
     *
     * @param {any} instance The component instance that has the context menu. It should have prefetchStatusIcon and isDestroyed.
     * @param {any} module Module to be prefetched
     * @param {number} courseId Course ID the module belongs to.
     * @param {Function} [done] Function to call when done. It will close the context menu.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreCourseHelperProvider.prototype.contextMenuPrefetch = function (instance, module, courseId, done) {
        var _this = this;
        var initialIcon = instance.prefetchStatusIcon;
        instance.prefetchStatusIcon = 'spinner'; // Show spinner since this operation might take a while.
        // We need to call getDownloadSize, the package might have been updated.
        return this.prefetchDelegate.getModuleDownloadSize(module, courseId, true).then(function (size) {
            return _this.domUtils.confirmDownloadSize(size).then(function () {
                return _this.prefetchDelegate.prefetchModule(module, courseId, true);
            });
        }).then(function () {
            // Success, close menu.
            done && done();
        }).catch(function (error) {
            instance.prefetchStatusIcon = initialIcon;
            if (!instance.isDestroyed) {
                _this.domUtils.showErrorModalDefault(error, 'core.errordownloading', true);
            }
        });
    };
    /**
     * Determine the status of a list of courses.
     *
     * @param {any[]} courses Courses
     * @return {Promise<string>} Promise resolved with the status.
     */
    CoreCourseHelperProvider.prototype.determineCoursesStatus = function (courses) {
        var _this = this;
        // Get the status of each course.
        var promises = [], siteId = this.sitesProvider.getCurrentSiteId();
        courses.forEach(function (course) {
            promises.push(_this.courseProvider.getCourseStatus(course.id, siteId));
        });
        return Promise.all(promises).then(function (statuses) {
            // Now determine the status of the whole list.
            var status = statuses[0];
            for (var i = 1; i < statuses.length; i++) {
                status = _this.filepoolProvider.determinePackagesStatus(status, statuses[i]);
            }
            return status;
        });
    };
    /**
     * Convenience function to open a module main file, downloading the package if needed.
     * This is meant for modules like mod_resource.
     *
     * @param {any} module The module to download.
     * @param {number} courseId The course ID of the module.
     * @param {string} [component] The component to link the files to.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @param {any[]} [files] List of files of the module. If not provided, use module.contents.
     * @param {string} [siteId] The site ID. If not defined, current site.
     * @return {Promise<any>} Resolved on success.
     */
    CoreCourseHelperProvider.prototype.downloadModuleAndOpenFile = function (module, courseId, component, componentId, files, siteId) {
        var _this = this;
        siteId = siteId || this.sitesProvider.getCurrentSiteId();
        var promise;
        if (files) {
            promise = Promise.resolve(files);
        }
        else {
            promise = this.courseProvider.loadModuleContents(module, courseId).then(function () {
                files = module.contents;
            });
        }
        // Make sure that module contents are loaded.
        return promise.then(function () {
            if (!files || !files.length) {
                return Promise.reject(_this.utils.createFakeWSError('core.filenotfound', true));
            }
            return _this.sitesProvider.getSite(siteId);
        }).then(function (site) {
            var mainFile = files[0], fileUrl = _this.fileHelper.getFileUrl(mainFile);
            // Check if the file should be opened in browser.
            if (_this.fileHelper.shouldOpenInBrowser(mainFile)) {
                if (_this.appProvider.isOnline()) {
                    // Open in browser.
                    var fixedUrl = site.fixPluginfileURL(fileUrl).replace('&offline=1', '');
                    // Remove forcedownload when followed by another param.
                    fixedUrl = fixedUrl.replace(/forcedownload=\d+&/, '');
                    // Remove forcedownload when not followed by any param.
                    fixedUrl = fixedUrl.replace(/[\?|\&]forcedownload=\d+/, '');
                    _this.utils.openInBrowser(fixedUrl);
                    if (_this.fileProvider.isAvailable()) {
                        // Download the file if needed (file outdated or not downloaded).
                        // Download will be in background, don't return the promise.
                        _this.downloadModule(module, courseId, component, componentId, files, siteId);
                    }
                    return;
                }
                else {
                    // Not online, get the offline file. It will fail if not found.
                    return _this.filepoolProvider.getInternalUrlByUrl(siteId, fileUrl).then(function (path) {
                        return _this.utils.openFile(path);
                    }).catch(function (error) {
                        return Promise.reject(_this.translate.instant('core.networkerrormsg'));
                    });
                }
            }
            // File shouldn't be opened in browser. Download the module if it needs to be downloaded.
            return _this.downloadModuleWithMainFileIfNeeded(module, courseId, component, componentId, files, siteId)
                .then(function (result) {
                if (result.path.indexOf('http') === 0) {
                    /* In iOS, if we use the same URL in embedded browser and background download then the download only
                       downloads a few bytes (cached ones). Add a hash to the URL so both URLs are different. */
                    result.path = result.path + '#moodlemobile-embedded';
                    return _this.utils.openOnlineFile(result.path).catch(function (error) {
                        // Error opening the file, some apps don't allow opening online files.
                        if (!_this.fileProvider.isAvailable()) {
                            return Promise.reject(error);
                        }
                        else if (result.status === __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].DOWNLOADING) {
                            return Promise.reject(_this.translate.instant('core.erroropenfiledownloading'));
                        }
                        var promise;
                        if (result.status === __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].NOT_DOWNLOADED) {
                            // Not downloaded, download it now and return the local file.
                            promise = _this.downloadModule(module, courseId, component, componentId, files, siteId).then(function () {
                                return _this.filepoolProvider.getInternalUrlByUrl(siteId, fileUrl);
                            });
                        }
                        else {
                            // File is outdated or stale and can't be opened in online, return the local URL.
                            promise = _this.filepoolProvider.getInternalUrlByUrl(siteId, fileUrl);
                        }
                        return promise.then(function (path) {
                            return _this.utils.openFile(path);
                        });
                    });
                }
                else {
                    return _this.utils.openFile(result.path);
                }
            });
        });
    };
    /**
     * Convenience function to download a module that has a main file and return the local file's path and other info.
     * This is meant for modules like mod_resource.
     *
     * @param {any} module The module to download.
     * @param {number} courseId The course ID of the module.
     * @param {string} [component] The component to link the files to.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @param {any[]} [files] List of files of the module. If not provided, use module.contents.
     * @param {string} [siteId] The site ID. If not defined, current site.
     * @return {Promise<{fixedUrl: string, path: string, status: string}>} Promise resolved when done.
     */
    CoreCourseHelperProvider.prototype.downloadModuleWithMainFileIfNeeded = function (module, courseId, component, componentId, files, siteId) {
        var _this = this;
        siteId = siteId || this.sitesProvider.getCurrentSiteId();
        if (!files || !files.length) {
            // Module not valid, stop.
            return Promise.reject(null);
        }
        var mainFile = files[0], fileUrl = this.fileHelper.getFileUrl(mainFile), timemodified = this.fileHelper.getFileTimemodified(mainFile), result = {
            fixedUrl: undefined,
            path: undefined,
            status: undefined
        };
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var fixedUrl = site.fixPluginfileURL(fileUrl);
            result.fixedUrl = fixedUrl;
            if (_this.fileProvider.isAvailable()) {
                // The file system is available.
                return _this.filepoolProvider.getPackageStatus(siteId, component, componentId).then(function (status) {
                    result.status = status;
                    var isWifi = _this.appProvider.isWifi(), isOnline = _this.appProvider.isOnline();
                    if (status === __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].DOWNLOADED) {
                        // Get the local file URL.
                        return _this.filepoolProvider.getInternalUrlByUrl(siteId, fileUrl).catch(function (error) {
                            // File not found, mark the module as not downloaded and reject.
                            return _this.filepoolProvider.storePackageStatus(siteId, __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].NOT_DOWNLOADED, component, componentId).then(function () {
                                return Promise.reject(error);
                            });
                        });
                    }
                    else if (status === __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].DOWNLOADING && !_this.appProvider.isDesktop()) {
                        // Return the online URL.
                        return fixedUrl;
                    }
                    else {
                        if (!isOnline && status === __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].NOT_DOWNLOADED) {
                            // Not downloaded and we're offline, reject.
                            return Promise.reject(_this.translate.instant('core.networkerrormsg'));
                        }
                        return _this.filepoolProvider.shouldDownloadBeforeOpen(fixedUrl, mainFile.filesize).then(function () {
                            // Download and then return the local URL.
                            return _this.downloadModule(module, courseId, component, componentId, files, siteId).then(function () {
                                return _this.filepoolProvider.getInternalUrlByUrl(siteId, fileUrl);
                            });
                        }, function () {
                            // Start the download if in wifi, but return the URL right away so the file is opened.
                            if (isWifi) {
                                _this.downloadModule(module, courseId, component, componentId, files, siteId);
                            }
                            if (!_this.fileHelper.isStateDownloaded(status) || isOnline) {
                                // Not downloaded or online, return the online URL.
                                return fixedUrl;
                            }
                            else {
                                // Outdated but offline, so we return the local URL. Use getUrlByUrl so it's added to the queue.
                                return _this.filepoolProvider.getUrlByUrl(siteId, fileUrl, component, componentId, timemodified, false, false, mainFile);
                            }
                        });
                    }
                }).then(function (path) {
                    result.path = path;
                    return result;
                });
            }
            else {
                // We use the live URL.
                result.path = fixedUrl;
                return result;
            }
        });
    };
    /**
     * Convenience function to download a module.
     *
     * @param {any} module The module to download.
     * @param {number} courseId The course ID of the module.
     * @param {string} [component] The component to link the files to.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @param {any[]} [files] List of files of the module. If not provided, use module.contents.
     * @param {string} [siteId] The site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreCourseHelperProvider.prototype.downloadModule = function (module, courseId, component, componentId, files, siteId) {
        var prefetchHandler = this.prefetchDelegate.getPrefetchHandlerFor(module);
        if (prefetchHandler) {
            // Use the prefetch handler to download the module.
            if (prefetchHandler.download) {
                return prefetchHandler.download(module, courseId);
            }
            else {
                return prefetchHandler.prefetch(module, courseId, true);
            }
        }
        // There's no prefetch handler for the module, just download the files.
        files = files || module.contents;
        return this.filepoolProvider.downloadOrPrefetchFiles(siteId, files, false, false, component, componentId);
    };
    /**
     * Fill the Context Menu for a certain module.
     *
     * @param {any} instance The component instance that has the context menu.
     * @param {any} module Module to be prefetched
     * @param {number} courseId Course ID the module belongs to.
     * @param {boolean} [invalidateCache] Invalidates the cache first.
     * @param {string} [component] Component of the module.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreCourseHelperProvider.prototype.fillContextMenu = function (instance, module, courseId, invalidateCache, component) {
        var _this = this;
        return this.getModulePrefetchInfo(module, courseId, invalidateCache, component).then(function (moduleInfo) {
            instance.size = moduleInfo.size > 0 ? moduleInfo.sizeReadable : 0;
            instance.prefetchStatusIcon = moduleInfo.statusIcon;
            instance.prefetchStatus = moduleInfo.status;
            if (moduleInfo.status != __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].NOT_DOWNLOADABLE) {
                // Module is downloadable, get the text to display to prefetch.
                if (moduleInfo.downloadTime > 0) {
                    instance.prefetchText = _this.translate.instant('core.lastdownloaded') + ': ' + moduleInfo.downloadTimeReadable;
                }
                else {
                    // Module not downloaded, show a default text.
                    instance.prefetchText = _this.translate.instant('core.download');
                }
            }
            if (typeof instance.contextMenuStatusObserver == 'undefined' && component) {
                instance.contextMenuStatusObserver = _this.eventsProvider.on(__WEBPACK_IMPORTED_MODULE_3__providers_events__["a" /* CoreEventsProvider */].PACKAGE_STATUS_CHANGED, function (data) {
                    if (data.componentId == module.id && data.component == component) {
                        _this.fillContextMenu(instance, module, courseId, false, component);
                    }
                }, _this.sitesProvider.getCurrentSiteId());
            }
        });
    };
    /**
     * Get a course. It will first check the user courses, and fallback to another WS if not enrolled.
     *
     * @param {number} courseId Course ID.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<{enrolled: boolean, course: any}>} Promise resolved with the course.
     */
    CoreCourseHelperProvider.prototype.getCourse = function (courseId, siteId) {
        var _this = this;
        siteId = siteId || this.sitesProvider.getCurrentSiteId();
        // Try with enrolled courses first.
        return this.coursesProvider.getUserCourse(courseId, false, siteId).then(function (course) {
            return { enrolled: true, course: course };
        }).catch(function () {
            // Not enrolled or an error happened. Try to use another WebService.
            return _this.coursesProvider.isGetCoursesByFieldAvailableInSite(siteId).then(function (available) {
                if (available) {
                    return _this.coursesProvider.getCourseByField('id', courseId, siteId);
                }
                else {
                    return _this.coursesProvider.getCourse(courseId, siteId);
                }
            }).then(function (course) {
                return { enrolled: false, course: course };
            });
        });
    };
    /**
     * Get a course, wait for any course format plugin to load, and open the course page. It basically chains the functions
     * getCourse and openCourse.
     *
     * @param {NavController} navCtrl The nav controller to use. If not defined, the course will be opened in main menu.
     * @param {number} courseId Course ID.
     * @param {any} [params] Other params to pass to the course page.
     * @param {string} [siteId] Site ID. If not defined, current site.
     */
    CoreCourseHelperProvider.prototype.getAndOpenCourse = function (navCtrl, courseId, params, siteId) {
        var _this = this;
        var modal = this.domUtils.showModalLoading();
        return this.getCourse(courseId, siteId).then(function (data) {
            return data.course;
        }).catch(function () {
            // Cannot get course, return a "fake".
            return { id: courseId };
        }).then(function (course) {
            modal.dismiss();
            return _this.openCourse(navCtrl, course, params, siteId);
        });
    };
    /**
     * Check if the course has a block with that name.
     *
     * @param {number} courseId Course ID.
     * @param {string} name     Block name to search.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<boolean>} Promise resolved with true if the block exists or false otherwise.
     * @since 3.3
     */
    CoreCourseHelperProvider.prototype.hasABlockNamed = function (courseId, name, siteId) {
        return this.courseProvider.getCourseBlocks(courseId, siteId).then(function (blocks) {
            return blocks.some(function (block) {
                return block.name == name;
            });
        }).catch(function () {
            return false;
        });
    };
    /**
     * Initialize the prefetch icon for selected courses.
     *
     * @param  {any[]}        courses  Courses array to get info from.
     * @param  {any}          prefetch Prefetch information.
     * @param  {number}       [minCourses=2] Min course to show icon.
     * @return {Promise<any>}          Resolved with the prefetch information updated when done.
     */
    CoreCourseHelperProvider.prototype.initPrefetchCoursesIcons = function (courses, prefetch, minCourses) {
        var _this = this;
        if (minCourses === void 0) { minCourses = 2; }
        if (!courses || courses.length < minCourses) {
            // Not enough courses.
            prefetch.icon = '';
            return Promise.resolve(prefetch);
        }
        return this.determineCoursesStatus(courses).then(function (status) {
            var icon = _this.getCourseStatusIconAndTitleFromStatus(status).icon;
            if (icon == 'spinner') {
                // It seems all courses are being downloaded, show a download button instead.
                icon = 'cloud-download';
            }
            prefetch.icon = icon;
            return prefetch;
        });
    };
    /**
     * Load offline completion into a list of sections.
     * This should be used in 3.6 sites or higher, where the course contents already include the completion.
     *
     * @param {number} courseId The course to get the completion.
     * @param {any[]} sections List of sections of the course.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreCourseHelperProvider.prototype.loadOfflineCompletion = function (courseId, sections, siteId) {
        var _this = this;
        return this.courseOffline.getCourseManualCompletions(courseId, siteId).then(function (offlineCompletions) {
            if (!offlineCompletions || !offlineCompletions.length) {
                // No offline completion.
                return;
            }
            var totalOffline = offlineCompletions.length;
            var loaded = 0;
            offlineCompletions = _this.utils.arrayToObject(offlineCompletions, 'cmid');
            // Load the offline data in the modules.
            for (var i = 0; i < sections.length; i++) {
                var section = sections[i];
                if (!section.modules || !section.modules.length) {
                    // Section has no modules, ignore it.
                    continue;
                }
                for (var j = 0; j < section.modules.length; j++) {
                    var module_1 = section.modules[j], offlineCompletion = offlineCompletions[module_1.id];
                    if (offlineCompletion && typeof module_1.completiondata != 'undefined' &&
                        offlineCompletion.timecompleted >= module_1.completiondata.timecompleted * 1000) {
                        // The module has offline completion. Load it.
                        module_1.completiondata.state = offlineCompletion.completed;
                        module_1.completiondata.offline = true;
                        // If all completions have been loaded, stop.
                        loaded++;
                        if (loaded == totalOffline) {
                            break;
                        }
                    }
                }
            }
        });
    };
    /**
     * Prefetch all the courses in the array.
     *
     * @param  {any[]}        courses  Courses array to prefetch.
     * @param  {any}          prefetch Prefetch information to be updated.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreCourseHelperProvider.prototype.prefetchCourses = function (courses, prefetch) {
        prefetch.icon = 'spinner';
        prefetch.badge = '';
        return this.confirmAndPrefetchCourses(courses, function (progress) {
            prefetch.badge = progress.count + ' / ' + progress.total;
        }).then(function () {
            prefetch.icon = 'refresh';
        }).finally(function () {
            prefetch.badge = '';
        });
    };
    /**
     * Get a course download promise (if any).
     *
     * @param {number} courseId Course ID.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Download promise, undefined if not found.
     */
    CoreCourseHelperProvider.prototype.getCourseDownloadPromise = function (courseId, siteId) {
        siteId = siteId || this.sitesProvider.getCurrentSiteId();
        return this.courseDwnPromises[siteId] && this.courseDwnPromises[siteId][courseId];
    };
    /**
     * Get a course status icon and the langkey to use as a title.
     *
     * @param {number} courseId Course ID.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<{icon: string, title: string}>} Promise resolved with the icon name and the title key.
     */
    CoreCourseHelperProvider.prototype.getCourseStatusIconAndTitle = function (courseId, siteId) {
        var _this = this;
        return this.courseProvider.getCourseStatus(courseId, siteId).then(function (status) {
            return _this.getCourseStatusIconAndTitleFromStatus(status);
        });
    };
    /**
     * Get a course status icon and the langkey to use as a title from status.
     *
     * @param {string} status Course status.
     * @return {{icon: string, title: string}} Title and icon name.
     */
    CoreCourseHelperProvider.prototype.getCourseStatusIconAndTitleFromStatus = function (status) {
        if (status == __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].DOWNLOADED) {
            // Always show refresh icon, we cannot know if there's anything new in course options.
            return {
                icon: 'refresh',
                title: 'core.course.refreshcourse'
            };
        }
        else if (status == __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].DOWNLOADING) {
            return {
                icon: 'spinner',
                title: 'core.downloading'
            };
        }
        else {
            return {
                icon: 'cloud-download',
                title: 'core.course.downloadcourse'
            };
        }
    };
    /**
     * Get the course ID from a module instance ID, showing an error message if it can't be retrieved.
     *
     * @param {number} id Instance ID.
     * @param {string} module Name of the module. E.g. 'glossary'.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<number>} Promise resolved with the module's course ID.
     */
    CoreCourseHelperProvider.prototype.getModuleCourseIdByInstance = function (id, module, siteId) {
        var _this = this;
        return this.courseProvider.getModuleBasicInfoByInstance(id, module, siteId).then(function (cm) {
            return cm.course;
        }).catch(function (error) {
            _this.domUtils.showErrorModalDefault(error, 'core.course.errorgetmodule', true);
            return Promise.reject(null);
        });
    };
    /**
     * Get prefetch info for a module.
     *
     * @param {any} module Module to get the info from.
     * @param {number} courseId Course ID the section belongs to.
     * @param {boolean} [invalidateCache] Invalidates the cache first.
     * @param {string} [component] Component of the module.
     * @return {Promise<CoreCourseModulePrefetchInfo>} Promise resolved with the info.
     */
    CoreCourseHelperProvider.prototype.getModulePrefetchInfo = function (module, courseId, invalidateCache, component) {
        var _this = this;
        var moduleInfo = {}, siteId = this.sitesProvider.getCurrentSiteId(), promises = [];
        if (invalidateCache) {
            this.prefetchDelegate.invalidateModuleStatusCache(module);
        }
        promises.push(this.prefetchDelegate.getModuleDownloadedSize(module, courseId).then(function (moduleSize) {
            moduleInfo.size = moduleSize;
            moduleInfo.sizeReadable = _this.textUtils.bytesToSize(moduleSize, 2);
        }));
        promises.push(this.prefetchDelegate.getModuleStatus(module, courseId).then(function (moduleStatus) {
            moduleInfo.status = moduleStatus;
            switch (moduleStatus) {
                case __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].NOT_DOWNLOADED:
                    moduleInfo.statusIcon = 'cloud-download';
                    break;
                case __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].DOWNLOADING:
                    moduleInfo.statusIcon = 'spinner';
                    break;
                case __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].OUTDATED:
                    moduleInfo.statusIcon = 'refresh';
                    break;
                case __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].DOWNLOADED:
                    if (!_this.prefetchDelegate.canCheckUpdates()) {
                        moduleInfo.statusIcon = 'refresh';
                        break;
                    }
                default:
                    moduleInfo.statusIcon = '';
                    break;
            }
        }));
        // Get the time it was downloaded (if it was downloaded).
        promises.push(this.filepoolProvider.getPackageData(siteId, component, module.id).then(function (data) {
            if (data && data.downloadTime && (data.status == __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].OUTDATED || data.status == __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].DOWNLOADED)) {
                var now = _this.timeUtils.timestamp();
                moduleInfo.downloadTime = data.downloadTime;
                if (now - data.downloadTime < 7 * 86400) {
                    moduleInfo.downloadTimeReadable = __WEBPACK_IMPORTED_MODULE_22_moment__(data.downloadTime * 1000).fromNow();
                }
                else {
                    moduleInfo.downloadTimeReadable = __WEBPACK_IMPORTED_MODULE_22_moment__(data.downloadTime * 1000).calendar();
                }
            }
        }).catch(function () {
            // Not downloaded.
            moduleInfo.downloadTime = 0;
        }));
        return Promise.all(promises).then(function () {
            return moduleInfo;
        });
    };
    /**
     * Get the download ID of a section. It's used to interact with CoreCourseModulePrefetchDelegate.
     *
     * @param {any} section Section.
     * @return {string} Section download ID.
     */
    CoreCourseHelperProvider.prototype.getSectionDownloadId = function (section) {
        return 'Section-' + section.id;
    };
    /**
     * Navigate to a module.
     *
     * @param {number} moduleId Module's ID.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @param {number} [courseId] Course ID. If not defined we'll try to retrieve it from the site.
     * @param {number} [sectionId] Section the module belongs to. If not defined we'll try to retrieve it from the site.
     * @param {string} [modName] If set, the app will retrieve all modules of this type with a single WS call. This reduces the
     *                           number of WS calls, but it isn't recommended for modules that can return a lot of contents.
     * @param {any} [modParams] Params to pass to the module
     * @param {NavController} [navCtrl] NavController for adding new pages to the current history. Optional for legacy support, but
     *                                  generates a warning if omitted.
     * @return {Promise<void>} Promise resolved when done.
     */
    CoreCourseHelperProvider.prototype.navigateToModule = function (moduleId, siteId, courseId, sectionId, modName, modParams, navCtrl) {
        var _this = this;
        siteId = siteId || this.sitesProvider.getCurrentSiteId();
        var modal = this.domUtils.showModalLoading();
        var promise, site;
        if (courseId && sectionId) {
            // No need to retrieve more data.
            promise = Promise.resolve();
        }
        else if (!courseId) {
            // We don't have courseId.
            promise = this.courseProvider.getModuleBasicInfo(moduleId, siteId).then(function (module) {
                courseId = module.course;
                sectionId = module.section;
            });
        }
        else {
            // We don't have sectionId but we have courseId.
            promise = this.courseProvider.getModuleSectionId(moduleId, siteId).then(function (id) {
                sectionId = id;
            });
        }
        return promise.then(function () {
            // Make sure they're numbers.
            courseId = Number(courseId);
            sectionId = Number(sectionId);
            // Get the site.
            return _this.sitesProvider.getSite(siteId);
        }).then(function (s) {
            site = s;
            // Get the module.
            return _this.courseProvider.getModule(moduleId, courseId, sectionId, false, false, siteId, modName);
        }).then(function (module) {
            var params = {
                course: { id: courseId },
                module: module,
                sectionId: sectionId,
                modParams: modParams
            };
            module.handlerData = _this.moduleDelegate.getModuleDataFor(module.modname, module, courseId, sectionId);
            if (navCtrl && module.handlerData && module.handlerData.action) {
                // If the link handler for this module passed through navCtrl, we can use the module's handler to navigate cleanly.
                // Otherwise, we will redirect below.
                modal.dismiss();
                return module.handlerData.action(new Event('click'), navCtrl, module, courseId);
            }
            _this.logger.warn('navCtrl was not passed to navigateToModule by the link handler for ' + module.modname);
            if (courseId == site.getSiteHomeId()) {
                // Check if site home is available.
                return _this.siteHomeProvider.isAvailable().then(function () {
                    _this.loginHelper.redirect('CoreSiteHomeIndexPage', params, siteId);
                }).finally(function () {
                    modal.dismiss();
                });
            }
            else {
                modal.dismiss();
                return _this.getAndOpenCourse(undefined, courseId, params, siteId);
            }
        }).catch(function (error) {
            modal.dismiss();
            _this.domUtils.showErrorModalDefault(error, 'core.course.errorgetmodule', true);
        });
    };
    /**
     * Open a module.
     *
     * @param {NavController} navCtrl The NavController to use.
     * @param {any} module The module to open.
     * @param {number} courseId The course ID of the module.
     * @param {number} [sectionId] The section ID of the module.
     * @param {any} [modParams] Params to pass to the module
     * @param {boolean} True if module can be opened, false otherwise.
     */
    CoreCourseHelperProvider.prototype.openModule = function (navCtrl, module, courseId, sectionId, modParams) {
        if (!module.handlerData) {
            module.handlerData = this.moduleDelegate.getModuleDataFor(module.modname, module, courseId, sectionId);
        }
        if (module.handlerData && module.handlerData.action) {
            module.handlerData.action(new Event('click'), navCtrl, module, courseId, { animate: false }, modParams);
            return true;
        }
        return false;
    };
    /**
     * Prefetch all the activities in a course and also the course addons.
     *
     * @param {any} course The course to prefetch.
     * @param {any[]} sections List of course sections.
     * @param {CoreCourseOptionsHandlerToDisplay[]} courseHandlers List of course options handlers.
     * @param {CoreCourseOptionsMenuHandlerToDisplay[]} courseMenuHandlers List of course menu handlers.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise}                Promise resolved when the download finishes.
     */
    CoreCourseHelperProvider.prototype.prefetchCourse = function (course, sections, courseHandlers, courseMenuHandlers, siteId) {
        var _this = this;
        siteId = siteId || this.sitesProvider.getCurrentSiteId();
        if (this.courseDwnPromises[siteId] && this.courseDwnPromises[siteId][course.id]) {
            // There's already a download ongoing for this course, return the promise.
            return this.courseDwnPromises[siteId][course.id];
        }
        else if (!this.courseDwnPromises[siteId]) {
            this.courseDwnPromises[siteId] = {};
        }
        // First of all, mark the course as being downloaded.
        this.courseDwnPromises[siteId][course.id] = this.courseProvider.setCourseStatus(course.id, __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].DOWNLOADING, siteId).then(function () {
            var promises = [];
            var allSectionsSection = sections[0];
            // Prefetch all the sections. If the first section is "All sections", use it. Otherwise, use a fake "All sections".
            if (sections[0].id != __WEBPACK_IMPORTED_MODULE_15__course__["a" /* CoreCourseProvider */].ALL_SECTIONS_ID) {
                allSectionsSection = { id: __WEBPACK_IMPORTED_MODULE_15__course__["a" /* CoreCourseProvider */].ALL_SECTIONS_ID };
            }
            promises.push(_this.prefetchSection(allSectionsSection, course.id, sections));
            // Prefetch course options.
            courseHandlers.forEach(function (handler) {
                if (handler.prefetch) {
                    promises.push(handler.prefetch(course));
                }
            });
            courseMenuHandlers.forEach(function (handler) {
                if (handler.prefetch) {
                    promises.push(handler.prefetch(course));
                }
            });
            // Prefetch other data needed to render the course.
            if (_this.coursesProvider.isGetCoursesByFieldAvailable()) {
                promises.push(_this.coursesProvider.getCoursesByField('id', course.id));
            }
            var sectionWithModules = sections.find(function (section) {
                return section.modules && section.modules.length > 0;
            });
            if (!sectionWithModules || typeof sectionWithModules.modules[0].completion == 'undefined') {
                promises.push(_this.courseProvider.getActivitiesCompletionStatus(course.id));
            }
            return _this.utils.allPromises(promises);
        }).then(function () {
            // Download success, mark the course as downloaded.
            return _this.courseProvider.setCourseStatus(course.id, __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].DOWNLOADED, siteId);
        }).catch(function (error) {
            // Error, restore previous status.
            return _this.courseProvider.setCoursePreviousStatus(course.id, siteId).then(function () {
                return Promise.reject(error);
            });
        }).finally(function () {
            delete _this.courseDwnPromises[siteId][course.id];
        });
        return this.courseDwnPromises[siteId][course.id];
    };
    /**
     * Helper function to prefetch a module, showing a confirmation modal if the size is big
     * and invalidating contents if refreshing.
     *
     * @param {handler} handler Prefetch handler to use. Must implement 'prefetch' and 'invalidateContent'.
     * @param {any} module Module to download.
     * @param {any} size Object containing size to download (in bytes) and a boolean to indicate if its totally calculated.
     * @param {number} courseId Course ID of the module.
     * @param {boolean} [refresh] True if refreshing, false otherwise.
     * @return {Promise<any>} Promise resolved when downloaded.
     */
    CoreCourseHelperProvider.prototype.prefetchModule = function (handler, module, size, courseId, refresh) {
        var _this = this;
        // Show confirmation if needed.
        return this.domUtils.confirmDownloadSize(size).then(function () {
            // Invalidate content if refreshing and download the data.
            var promise = refresh ? handler.invalidateContent(module.id, courseId) : Promise.resolve();
            return promise.catch(function () {
                // Ignore errors.
            }).then(function () {
                return _this.prefetchDelegate.prefetchModule(module, courseId, true);
            });
        });
    };
    /**
     * Prefetch one section or all the sections.
     * If the section is "All sections" it will prefetch all the sections.
     *
     * @param {any} section Section.
     * @param {number} courseId Course ID the section belongs to.
     * @param {any[]} [sections] List of sections. Used when downloading all the sections.
     * @return {Promise<any>} Promise resolved when the prefetch is finished.
     */
    CoreCourseHelperProvider.prototype.prefetchSection = function (section, courseId, sections) {
        var _this = this;
        if (section.id != __WEBPACK_IMPORTED_MODULE_15__course__["a" /* CoreCourseProvider */].ALL_SECTIONS_ID) {
            // Download only this section.
            return this.prefetchSingleSectionIfNeeded(section, courseId).finally(function () {
                // Calculate the status of the section that finished.
                return _this.calculateSectionStatus(section, courseId, false, false);
            });
        }
        else {
            // Download all the sections except "All sections".
            var promises_2 = [];
            var allSectionsStatus_1;
            section.isDownloading = true;
            sections.forEach(function (section) {
                if (section.id != __WEBPACK_IMPORTED_MODULE_15__course__["a" /* CoreCourseProvider */].ALL_SECTIONS_ID) {
                    promises_2.push(_this.prefetchSingleSectionIfNeeded(section, courseId).finally(function () {
                        // Calculate the status of the section that finished.
                        return _this.calculateSectionStatus(section, courseId, false, false).then(function (result) {
                            // Calculate "All sections" status.
                            allSectionsStatus_1 = _this.filepoolProvider.determinePackagesStatus(allSectionsStatus_1, result.status);
                        });
                    }));
                }
            });
            return this.utils.allPromises(promises_2).then(function () {
                // Set "All sections" data.
                section.downloadStatus = allSectionsStatus_1;
                section.canCheckUpdates = _this.prefetchDelegate.canCheckUpdates();
                section.isDownloading = allSectionsStatus_1 === __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].DOWNLOADING;
            }).finally(function () {
                section.isDownloading = false;
            });
        }
    };
    /**
     * Prefetch a certain section if it needs to be prefetched.
     * If the section is "All sections" it will be ignored.
     *
     * @param {any} section Section to prefetch.
     * @param {number} courseId Course ID the section belongs to.
     * @return {Promise<any>} Promise resolved when the section is prefetched.
     */
    CoreCourseHelperProvider.prototype.prefetchSingleSectionIfNeeded = function (section, courseId) {
        var _this = this;
        if (section.id == __WEBPACK_IMPORTED_MODULE_15__course__["a" /* CoreCourseProvider */].ALL_SECTIONS_ID) {
            return Promise.resolve();
        }
        if (section.hiddenbynumsections) {
            // Hidden section.
            return Promise.resolve();
        }
        var promises = [];
        section.isDownloading = true;
        // Sync the modules first.
        promises.push(this.prefetchDelegate.syncModules(section.modules, courseId).then(function () {
            // Validate the section needs to be downloaded and calculate amount of modules that need to be downloaded.
            return _this.prefetchDelegate.getModulesStatus(section.modules, courseId, section.id).then(function (result) {
                if (result.status == __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].DOWNLOADED || result.status == __WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].NOT_DOWNLOADABLE) {
                    // Section is downloaded or not downloadable, nothing to do.
                    return;
                }
                return _this.prefetchSingleSection(section, result, courseId);
            }, function (error) {
                section.isDownloading = false;
                return Promise.reject(error);
            });
        }));
        // Download the files in the section description.
        var introFiles = this.domUtils.extractDownloadableFilesFromHtmlAsFakeFileObjects(section.summary), siteId = this.sitesProvider.getCurrentSiteId();
        promises.push(this.filepoolProvider.addFilesToQueue(siteId, introFiles, __WEBPACK_IMPORTED_MODULE_15__course__["a" /* CoreCourseProvider */].COMPONENT, courseId)
            .catch(function () {
            // Ignore errors.
        }));
        return Promise.all(promises);
    };
    /**
     * Start or restore the prefetch of a section.
     * If the section is "All sections" it will be ignored.
     *
     * @param {any} section Section to download.
     * @param {any} result Result of CoreCourseModulePrefetchDelegate.getModulesStatus for this section.
     * @param {number} courseId Course ID the section belongs to.
     * @return {Promise<any>} Promise resolved when the section has been prefetched.
     */
    CoreCourseHelperProvider.prototype.prefetchSingleSection = function (section, result, courseId) {
        if (section.id == __WEBPACK_IMPORTED_MODULE_15__course__["a" /* CoreCourseProvider */].ALL_SECTIONS_ID) {
            return Promise.resolve();
        }
        if (section.total > 0) {
            // Already being downloaded.
            return Promise.resolve();
        }
        // We only download modules with status notdownloaded, downloading or outdated.
        var modules = result[__WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].OUTDATED].concat(result[__WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].NOT_DOWNLOADED])
            .concat(result[__WEBPACK_IMPORTED_MODULE_20__core_constants__["a" /* CoreConstants */].DOWNLOADING]), downloadId = this.getSectionDownloadId(section);
        section.isDownloading = true;
        // Prefetch all modules to prevent incoeherences in download count and to download stale data not marked as outdated.
        return this.prefetchDelegate.prefetchModules(downloadId, modules, courseId, function (data) {
            section.count = data.count;
            section.total = data.total;
        });
    };
    /**
     * Check if a section has content.
     *
     * @param {any} section Section to check.
     * @return {boolean} Whether the section has content.
     */
    CoreCourseHelperProvider.prototype.sectionHasContent = function (section) {
        if (section.hiddenbynumsections) {
            return false;
        }
        return (typeof section.availabilityinfo != 'undefined' && section.availabilityinfo != '') ||
            section.summary != '' || (section.modules && section.modules.length > 0);
    };
    /**
     * Wait for any course format plugin to load, and open the course page.
     *
     * If the plugin's promise is resolved, the course page will be opened.  If it is rejected, they will see an error.
     * If the promise for the plugin is still in progress when the user tries to open the course, a loader
     * will be displayed until it is complete, before the course page is opened.  If the promise is already complete,
     * they will see the result immediately.
     *
     * @param {NavController} navCtrl The nav controller to use. If not defined, the course will be opened in main menu.
     * @param {any} course Course to open
     * @param {any} [params] Params to pass to the course page.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreCourseHelperProvider.prototype.openCourse = function (navCtrl, course, params, siteId) {
        if (!siteId || siteId == this.sitesProvider.getCurrentSiteId()) {
            // Current site, we can open the course.
            return this.courseProvider.openCourse(navCtrl, course, params);
        }
        else {
            // We need to load the site first.
            params = params || {};
            Object.assign(params, { course: course });
            return this.loginHelper.redirect(__WEBPACK_IMPORTED_MODULE_19__core_login_providers_helper__["a" /* CoreLoginHelperProvider */].OPEN_COURSE, params, siteId);
        }
    };
    CoreCourseHelperProvider = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_15__course__["a" /* CoreCourseProvider */], __WEBPACK_IMPORTED_MODULE_8__providers_utils_dom__["a" /* CoreDomUtilsProvider */],
            __WEBPACK_IMPORTED_MODULE_17__module_delegate__["a" /* CoreCourseModuleDelegate */], __WEBPACK_IMPORTED_MODULE_18__module_prefetch_delegate__["a" /* CoreCourseModulePrefetchDelegate */],
            __WEBPACK_IMPORTED_MODULE_5__providers_filepool__["a" /* CoreFilepoolProvider */], __WEBPACK_IMPORTED_MODULE_7__providers_sites__["a" /* CoreSitesProvider */],
            __WEBPACK_IMPORTED_MODULE_9__providers_utils_text__["a" /* CoreTextUtilsProvider */], __WEBPACK_IMPORTED_MODULE_10__providers_utils_time__["a" /* CoreTimeUtilsProvider */],
            __WEBPACK_IMPORTED_MODULE_11__providers_utils_utils__["a" /* CoreUtilsProvider */], __WEBPACK_IMPORTED_MODULE_1__ngx_translate_core__["c" /* TranslateService */], __WEBPACK_IMPORTED_MODULE_19__core_login_providers_helper__["a" /* CoreLoginHelperProvider */],
            __WEBPACK_IMPORTED_MODULE_12__options_delegate__["a" /* CoreCourseOptionsDelegate */], __WEBPACK_IMPORTED_MODULE_13__core_sitehome_providers_sitehome__["a" /* CoreSiteHomeProvider */],
            __WEBPACK_IMPORTED_MODULE_3__providers_events__["a" /* CoreEventsProvider */], __WEBPACK_IMPORTED_MODULE_6__providers_file_helper__["a" /* CoreFileHelperProvider */],
            __WEBPACK_IMPORTED_MODULE_2__providers_app__["a" /* CoreAppProvider */], __WEBPACK_IMPORTED_MODULE_4__providers_file__["a" /* CoreFileProvider */], __WEBPACK_IMPORTED_MODULE_0__angular_core__["C" /* Injector */],
            __WEBPACK_IMPORTED_MODULE_14__core_courses_providers_courses__["a" /* CoreCoursesProvider */], __WEBPACK_IMPORTED_MODULE_16__course_offline__["a" /* CoreCourseOfflineProvider */],
            __WEBPACK_IMPORTED_MODULE_21__providers_logger__["a" /* CoreLoggerProvider */]])
    ], CoreCourseHelperProvider);
    return CoreCourseHelperProvider;
}());

//# sourceMappingURL=helper.js.map

/***/ }),
/* 37 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreIframeUtilsProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ngx_translate_core__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__ionic_native_network__ = __webpack_require__(213);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__app__ = __webpack_require__(9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__file__ = __webpack_require__(53);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__logger__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__sites__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__dom__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__text__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__url__ = __webpack_require__(23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__utils__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__core_contentlinks_providers_helper__ = __webpack_require__(13);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};













/*
 * "Utils" service with helper functions for iframes, embed and similar.
 */
var CoreIframeUtilsProvider = /** @class */ (function () {
    function CoreIframeUtilsProvider(logger, fileProvider, sitesProvider, urlUtils, textUtils, utils, domUtils, platform, appProvider, translate, network, zone, config, contentLinksHelper) {
        this.fileProvider = fileProvider;
        this.sitesProvider = sitesProvider;
        this.urlUtils = urlUtils;
        this.textUtils = textUtils;
        this.utils = utils;
        this.domUtils = domUtils;
        this.platform = platform;
        this.appProvider = appProvider;
        this.translate = translate;
        this.network = network;
        this.zone = zone;
        this.config = config;
        this.contentLinksHelper = contentLinksHelper;
        this.logger = logger.getInstance('CoreUtilsProvider');
    }
    CoreIframeUtilsProvider_1 = CoreIframeUtilsProvider;
    /**
     * Check if a frame uses an online URL but the app is offline. If it does, the iframe is hidden and a warning is shown.
     *
     * @param {any} element The frame to check (iframe, embed, ...).
     * @param {boolean} [isSubframe] Whether it's a frame inside another frame.
     * @return {boolean} True if frame is online and the app is offline, false otherwise.
     */
    CoreIframeUtilsProvider.prototype.checkOnlineFrameInOffline = function (element, isSubframe) {
        var _this = this;
        var src = element.src || element.data;
        if (src && src.match(/^https?:\/\//i) && !this.appProvider.isOnline()) {
            if (element.classList.contains('core-iframe-offline-disabled')) {
                // Iframe already hidden, stop.
                return true;
            }
            // The frame has an online URL but the app is offline. Show a warning, or a link if the URL can be opened in the app.
            var div_1 = document.createElement('div');
            div_1.setAttribute('text-center', '');
            div_1.setAttribute('padding', '');
            div_1.classList.add('core-iframe-offline-warning');
            var site = this.sitesProvider.getCurrentSite();
            var username_1 = site ? site.getInfo().username : undefined;
            this.contentLinksHelper.canHandleLink(src, undefined, username_1).then(function (canHandleLink) {
                if (canHandleLink) {
                    var link = document.createElement('a');
                    if (isSubframe) {
                        // Ionic styles are not available in subframes, adding some minimal inline styles.
                        link.style.display = 'block';
                        link.style.padding = '1em';
                        link.style.fontWeight = '500';
                        link.style.textAlign = 'center';
                        link.style.textTransform = 'uppercase';
                        link.style.cursor = 'pointer';
                    }
                    else {
                        var mode = _this.config.get('mode');
                        link.setAttribute('ion-button', '');
                        link.classList.add('button', 'button-' + mode, 'button-default', 'button-default-' + mode, 'button-block', 'button-block-' + mode);
                    }
                    var message = _this.translate.instant('core.viewembeddedcontent');
                    link.innerHTML = isSubframe ? message : '<span class="button-inner">' + message + '</span>';
                    link.onclick = function (event) {
                        _this.contentLinksHelper.handleLink(src, username_1);
                        event.preventDefault();
                    };
                    div_1.appendChild(link);
                }
                else {
                    div_1.innerHTML = (isSubframe ? '' : _this.domUtils.getConnectionWarningIconHtml()) +
                        '<p>' + _this.translate.instant('core.networkerroriframemsg') + '</p>';
                }
                element.parentElement.insertBefore(div_1, element);
            });
            // Add a class to specify that the iframe is hidden.
            element.classList.add('core-iframe-offline-disabled');
            if (isSubframe) {
                // We cannot apply CSS styles in subframes, just hide the iframe.
                element.style.display = 'none';
            }
            // If the network changes, check it again.
            var subscription_1 = this.network.onConnect().subscribe(function () {
                // Execute the callback in the Angular zone, so change detection doesn't stop working.
                _this.zone.run(function () {
                    if (!_this.checkOnlineFrameInOffline(element, isSubframe)) {
                        // Now the app is online, no need to check connection again.
                        subscription_1.unsubscribe();
                    }
                });
            });
            return true;
        }
        else if (element.classList.contains('core-iframe-offline-disabled')) {
            // Reload the frame.
            element.src = element.src;
            element.data = element.data;
            // Remove the warning and show the iframe
            this.domUtils.removeElement(element.parentElement, 'div.core-iframe-offline-warning');
            element.classList.remove('core-iframe-offline-disabled');
            if (isSubframe) {
                element.style.display = '';
            }
        }
        return false;
    };
    /**
     * Given an element, return the content window and document.
     * Please notice that the element should be an iframe, embed or similar.
     *
     * @param {any} element Element to treat (iframe, embed, ...).
     * @return {{ window: Window, document: Document }} Window and Document.
     */
    CoreIframeUtilsProvider.prototype.getContentWindowAndDocument = function (element) {
        var contentWindow = element.contentWindow, contentDocument;
        try {
            contentDocument = element.contentDocument || (contentWindow && contentWindow.document);
        }
        catch (ex) {
            // Ignore errors.
        }
        if (!contentWindow && contentDocument) {
            // It's probably an <object>. Try to get the window.
            contentWindow = contentDocument.defaultView;
        }
        if (!contentWindow && element.getSVGDocument) {
            // It's probably an <embed>. Try to get the window and the document.
            try {
                contentDocument = element.getSVGDocument();
            }
            catch (ex) {
                // Ignore errors.
            }
            if (contentDocument && contentDocument.defaultView) {
                contentWindow = contentDocument.defaultView;
            }
            else if (element.window) {
                contentWindow = element.window;
            }
            else if (element.getWindow) {
                contentWindow = element.getWindow();
            }
        }
        return { window: contentWindow, document: contentDocument };
    };
    /**
     * Redefine the open method in the contentWindow of an element and the sub frames.
     * Please notice that the element should be an iframe, embed or similar.
     *
     * @param {any} element Element to treat (iframe, embed, ...).
     * @param {Window} contentWindow The window of the element contents.
     * @param {Document} contentDocument The document of the element contents.
     * @param {NavController} [navCtrl] NavController to use if a link can be opened in the app.
     */
    CoreIframeUtilsProvider.prototype.redefineWindowOpen = function (element, contentWindow, contentDocument, navCtrl) {
        var _this = this;
        if (contentWindow) {
            // Intercept window.open.
            contentWindow.open = function (url, target) {
                var scheme = _this.urlUtils.getUrlScheme(url);
                if (!scheme) {
                    // It's a relative URL, use the frame src to create the full URL.
                    var src = element.src || element.data;
                    if (src) {
                        var dirAndFile = _this.fileProvider.getFileAndDirectoryFromPath(src);
                        if (dirAndFile.directory) {
                            url = _this.textUtils.concatenatePaths(dirAndFile.directory, url);
                        }
                        else {
                            _this.logger.warn('Cannot get iframe dir path to open relative url', url, element);
                            return null;
                        }
                    }
                    else {
                        _this.logger.warn('Cannot get iframe src to open relative url', url, element);
                        return null;
                    }
                }
                if (target == '_self') {
                    // Link should be loaded in the same frame.
                    if (element.tagName.toLowerCase() == 'object') {
                        element.setAttribute('data', url);
                    }
                    else {
                        element.setAttribute('src', url);
                    }
                }
                else if (url.indexOf('cdvfile://') === 0 || url.indexOf('file://') === 0) {
                    // It's a local file.
                    _this.utils.openFile(url).catch(function (error) {
                        _this.domUtils.showErrorModal(error);
                    });
                }
                else {
                    // It's an external link, check if it can be opened in the app.
                    _this.contentLinksHelper.handleLink(url, undefined, navCtrl, true, true).then(function (treated) {
                        if (!treated) {
                            // Not opened in the app, open with browser. Check if we need to auto-login
                            if (!_this.sitesProvider.isLoggedIn()) {
                                // Not logged in, cannot auto-login.
                                _this.utils.openInBrowser(url);
                            }
                            else {
                                _this.sitesProvider.getCurrentSite().openInBrowserWithAutoLoginIfSameSite(url);
                            }
                        }
                    });
                }
                // We cannot create new Window objects directly, return null which is a valid return value for Window.open().
                return null;
            };
        }
        if (contentDocument) {
            // Search sub frames.
            CoreIframeUtilsProvider_1.FRAME_TAGS.forEach(function (tag) {
                var elements = Array.from(contentDocument.querySelectorAll(tag));
                elements.forEach(function (subElement) {
                    _this.treatFrame(subElement, true, navCtrl);
                });
            });
        }
    };
    /**
     * Intercept window.open in a frame and its subframes, shows an error modal instead.
     * Search links (<a>) and open them in browser or InAppBrowser if needed.
     *
     * @param {any} element Element to treat (iframe, embed, ...).
     * @param {boolean} [isSubframe] Whether it's a frame inside another frame.
     * @param {NavController} [navCtrl] NavController to use if a link can be opened in the app.
     */
    CoreIframeUtilsProvider.prototype.treatFrame = function (element, isSubframe, navCtrl) {
        var _this = this;
        if (element) {
            this.checkOnlineFrameInOffline(element, isSubframe);
            var winAndDoc_1 = this.getContentWindowAndDocument(element);
            // Redefine window.open in this element and sub frames, it might have been loaded already.
            this.redefineWindowOpen(element, winAndDoc_1.window, winAndDoc_1.document, navCtrl);
            // Treat links.
            this.treatFrameLinks(element, winAndDoc_1.document);
            element.addEventListener('load', function () {
                _this.checkOnlineFrameInOffline(element, isSubframe);
                // Element loaded, redefine window.open and treat links again.
                winAndDoc_1 = _this.getContentWindowAndDocument(element);
                _this.redefineWindowOpen(element, winAndDoc_1.window, winAndDoc_1.document, navCtrl);
                _this.treatFrameLinks(element, winAndDoc_1.document);
                if (winAndDoc_1.window) {
                    // Send a resize events to the iframe so it calculates the right size if needed.
                    setTimeout(function () {
                        winAndDoc_1.window.dispatchEvent(new Event('resize'));
                    }, 1000);
                }
            });
        }
    };
    /**
     * Search links (<a>) in a frame and open them in browser or InAppBrowser if needed.
     * Only links that haven't been treated by the frame's Javascript will be treated.
     *
     * @param {any} element Element to treat (iframe, embed, ...).
     * @param {Document} contentDocument The document of the element contents.
     */
    CoreIframeUtilsProvider.prototype.treatFrameLinks = function (element, contentDocument) {
        var _this = this;
        if (!contentDocument) {
            return;
        }
        contentDocument.addEventListener('click', function (event) {
            if (event.defaultPrevented) {
                // Event already prevented by some other code.
                return;
            }
            // Find the link being clicked.
            var el = event.target;
            while (el && el.tagName !== 'A') {
                el = el.parentElement;
            }
            if (!el || el.tagName !== 'A') {
                return;
            }
            var link = el;
            var scheme = _this.urlUtils.getUrlScheme(link.href);
            if (!link.href || (scheme && scheme == 'javascript')) {
                // Links with no URL and Javascript links are ignored.
                return;
            }
            if (scheme && scheme != 'file' && scheme != 'filesystem') {
                // Scheme suggests it's an external resource.
                event.preventDefault();
                var frameSrc = element.src || element.data, frameScheme = _this.urlUtils.getUrlScheme(frameSrc);
                // If the frame is not local, check the target to identify how to treat the link.
                if (frameScheme && frameScheme != 'file' && frameScheme != 'filesystem' &&
                    (!link.target || link.target == '_self')) {
                    // Load the link inside the frame itself.
                    if (element.tagName.toLowerCase() == 'object') {
                        element.setAttribute('data', link.href);
                    }
                    else {
                        element.setAttribute('src', link.href);
                    }
                    return;
                }
                // The frame is local or the link needs to be opened in a new window. Open in browser.
                if (!_this.sitesProvider.isLoggedIn()) {
                    _this.utils.openInBrowser(link.href);
                }
                else {
                    _this.sitesProvider.getCurrentSite().openInBrowserWithAutoLoginIfSameSite(link.href);
                }
            }
            else if (link.target == '_parent' || link.target == '_top' || link.target == '_blank') {
                // Opening links with _parent, _top or _blank can break the app. We'll open it in InAppBrowser.
                event.preventDefault();
                _this.utils.openFile(link.href).catch(function (error) {
                    _this.domUtils.showErrorModal(error);
                });
            }
            else if (_this.platform.is('ios') && (!link.target || link.target == '_self')) {
                // In cordova ios 4.1.0 links inside iframes stopped working. We'll manually treat them.
                event.preventDefault();
                if (element.tagName.toLowerCase() == 'object') {
                    element.setAttribute('data', link.href);
                }
                else {
                    element.setAttribute('src', link.href);
                }
            }
        });
    };
    CoreIframeUtilsProvider.FRAME_TAGS = ['iframe', 'frame', 'object', 'embed'];
    CoreIframeUtilsProvider = CoreIframeUtilsProvider_1 = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_6__logger__["a" /* CoreLoggerProvider */], __WEBPACK_IMPORTED_MODULE_5__file__["a" /* CoreFileProvider */], __WEBPACK_IMPORTED_MODULE_7__sites__["a" /* CoreSitesProvider */],
            __WEBPACK_IMPORTED_MODULE_10__url__["a" /* CoreUrlUtilsProvider */], __WEBPACK_IMPORTED_MODULE_9__text__["a" /* CoreTextUtilsProvider */], __WEBPACK_IMPORTED_MODULE_11__utils__["a" /* CoreUtilsProvider */],
            __WEBPACK_IMPORTED_MODULE_8__dom__["a" /* CoreDomUtilsProvider */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["v" /* Platform */], __WEBPACK_IMPORTED_MODULE_4__app__["a" /* CoreAppProvider */],
            __WEBPACK_IMPORTED_MODULE_2__ngx_translate_core__["c" /* TranslateService */], __WEBPACK_IMPORTED_MODULE_3__ionic_native_network__["a" /* Network */], __WEBPACK_IMPORTED_MODULE_0__angular_core__["M" /* NgZone */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["e" /* Config */],
            __WEBPACK_IMPORTED_MODULE_12__core_contentlinks_providers_helper__["a" /* CoreContentLinksHelperProvider */]])
    ], CoreIframeUtilsProvider);
    return CoreIframeUtilsProvider;
    var CoreIframeUtilsProvider_1;
}());

//# sourceMappingURL=iframe.js.map

/***/ }),
/* 38 */,
/* 39 */,
/* 40 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreConstants; });
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/**
 * Static class to contain all the core constants.
 */
var CoreConstants = /** @class */ (function () {
    function CoreConstants() {
    }
    CoreConstants.SECONDS_YEAR = 31536000;
    CoreConstants.SECONDS_WEEK = 604800;
    CoreConstants.SECONDS_DAY = 86400;
    CoreConstants.SECONDS_HOUR = 3600;
    CoreConstants.SECONDS_MINUTE = 60;
    CoreConstants.WIFI_DOWNLOAD_THRESHOLD = 104857600; // 100MB.
    CoreConstants.DOWNLOAD_THRESHOLD = 10485760; // 10MB.
    CoreConstants.MINIMUM_FREE_SPACE = 10485760; // 10MB.
    CoreConstants.IOS_FREE_SPACE_THRESHOLD = 524288000; // 500MB.
    CoreConstants.DONT_SHOW_ERROR = 'CoreDontShowError';
    CoreConstants.NO_SITE_ID = 'NoSite';
    // Settings constants.
    CoreConstants.SETTINGS_RICH_TEXT_EDITOR = 'CoreSettingsRichTextEditor';
    CoreConstants.SETTINGS_NOTIFICATION_SOUND = 'CoreSettingsNotificationSound';
    CoreConstants.SETTINGS_SYNC_ONLY_ON_WIFI = 'CoreSettingsSyncOnlyOnWifi';
    CoreConstants.SETTINGS_DEBUG_DISPLAY = 'CoreSettingsDebugDisplay';
    CoreConstants.SETTINGS_REPORT_IN_BACKGROUND = 'CoreSettingsReportInBackground'; // @deprecated since 3.5.0
    CoreConstants.SETTINGS_SEND_ON_ENTER = 'CoreSettingsSendOnEnter';
    CoreConstants.SETTINGS_FONT_SIZE = 'CoreSettingsFontSize';
    CoreConstants.SETTINGS_ANALYTICS_ENABLED = 'CoreSettingsAnalyticsEnabled';
    // WS constants.
    CoreConstants.WS_TIMEOUT = 30000; // Timeout when not in WiFi.
    CoreConstants.WS_TIMEOUT_WIFI = 30000; // Timeout when in WiFi.
    CoreConstants.WS_PREFIX = 'local_mobile_';
    // Login constants.
    CoreConstants.LOGIN_SSO_CODE = 2; // SSO in browser window is required.
    CoreConstants.LOGIN_SSO_INAPP_CODE = 3; // SSO in embedded browser is required.
    CoreConstants.LOGIN_LAUNCH_DATA = 'CoreLoginLaunchData';
    // Download status constants.
    CoreConstants.DOWNLOADED = 'downloaded';
    CoreConstants.DOWNLOADING = 'downloading';
    CoreConstants.NOT_DOWNLOADED = 'notdownloaded';
    CoreConstants.OUTDATED = 'outdated';
    CoreConstants.NOT_DOWNLOADABLE = 'notdownloadable';
    // Constants from Moodle's resourcelib.
    CoreConstants.RESOURCELIB_DISPLAY_AUTO = 0; // Try the best way.
    CoreConstants.RESOURCELIB_DISPLAY_EMBED = 1; // Display using object tag.
    CoreConstants.RESOURCELIB_DISPLAY_FRAME = 2; // Display inside frame.
    CoreConstants.RESOURCELIB_DISPLAY_NEW = 3; // Display normal link in new window.
    CoreConstants.RESOURCELIB_DISPLAY_DOWNLOAD = 4; // Force download of file instead of display.
    CoreConstants.RESOURCELIB_DISPLAY_OPEN = 5; // Open directly.
    CoreConstants.RESOURCELIB_DISPLAY_POPUP = 6; // Open in "emulated" pop-up without navigation.
    // Feature constants. Used to report features that are, or are not, supported by a module.
    CoreConstants.FEATURE_GRADE_HAS_GRADE = 'grade_has_grade'; // True if module can provide a grade.
    CoreConstants.FEATURE_GRADE_OUTCOMES = 'outcomes'; // True if module supports outcomes.
    CoreConstants.FEATURE_ADVANCED_GRADING = 'grade_advanced_grading'; // True if module supports advanced grading methods.
    CoreConstants.FEATURE_CONTROLS_GRADE_VISIBILITY = 'controlsgradevisbility'; // True if module controls grade visibility over gradebook.
    CoreConstants.FEATURE_PLAGIARISM = 'plagiarism'; // True if module supports plagiarism plugins.
    CoreConstants.FEATURE_COMPLETION_TRACKS_VIEWS = 'completion_tracks_views'; // True if module tracks whether somebody viewed it.
    CoreConstants.FEATURE_COMPLETION_HAS_RULES = 'completion_has_rules'; // True if module has custom completion rules.
    CoreConstants.FEATURE_NO_VIEW_LINK = 'viewlink'; // True if module has no 'view' page (like label).
    CoreConstants.FEATURE_IDNUMBER = 'idnumber'; // True if module wants support for setting the ID number for grade calculation purposes.
    CoreConstants.FEATURE_GROUPS = 'groups'; // True if module supports groups.
    CoreConstants.FEATURE_GROUPINGS = 'groupings'; // True if module supports groupings.
    CoreConstants.FEATURE_MOD_ARCHETYPE = 'mod_archetype'; // Type of module.
    CoreConstants.FEATURE_MOD_INTRO = 'mod_intro'; // True if module supports intro editor.
    CoreConstants.FEATURE_MODEDIT_DEFAULT_COMPLETION = 'modedit_default_completion'; // True if module has default completion.
    CoreConstants.FEATURE_COMMENT = 'comment';
    CoreConstants.FEATURE_RATE = 'rate';
    CoreConstants.FEATURE_BACKUP_MOODLE2 = 'backup_moodle2'; // True if module supports backup/restore of moodle2 format.
    CoreConstants.FEATURE_SHOW_DESCRIPTION = 'showdescription'; // True if module can show description on course main page.
    CoreConstants.FEATURE_USES_QUESTIONS = 'usesquestions'; // True if module uses the question bank.
    // Pssobile archetypes for modules.
    CoreConstants.MOD_ARCHETYPE_OTHER = 0; // Unspecified module archetype.
    CoreConstants.MOD_ARCHETYPE_RESOURCE = 1; // Resource-like type module.
    CoreConstants.MOD_ARCHETYPE_ASSIGNMENT = 2; // Assignment module archetype.
    CoreConstants.MOD_ARCHETYPE_SYSTEM = 3; // System (not user-addable) module archetype.
    return CoreConstants;
}());

//# sourceMappingURL=constants.js.map

/***/ }),
/* 41 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreFormatTextDirective; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ngx_translate_core__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_app__ = __webpack_require__(9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__providers_events__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__providers_filepool__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__providers_logger__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__providers_sites__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__providers_utils_dom__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__providers_utils_iframe__ = __webpack_require__(37);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__providers_utils_text__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__providers_utils_url__ = __webpack_require__(23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__providers_utils_utils__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__directives_link__ = __webpack_require__(182);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14__directives_external_content__ = __webpack_require__(215);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15__core_contentlinks_providers_helper__ = __webpack_require__(13);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_16__components_split_view_split_view__ = __webpack_require__(25);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};

















/**
 * Directive to format text rendered. It renders the HTML and treats all links and media, using CoreLinkDirective
 * and CoreExternalContentDirective.
 *
 * Example usage:
 * <core-format-text [text]="myText" [component]="component" [componentId]="componentId"></core-format-text>
 *
 */
var CoreFormatTextDirective = /** @class */ (function () {
    function CoreFormatTextDirective(element, sitesProvider, domUtils, textUtils, translate, platform, utils, urlUtils, loggerProvider, filepoolProvider, appProvider, contentLinksHelper, navCtrl, content, svComponent, iframeUtils, eventsProvider) {
        this.sitesProvider = sitesProvider;
        this.domUtils = domUtils;
        this.textUtils = textUtils;
        this.translate = translate;
        this.platform = platform;
        this.utils = utils;
        this.urlUtils = urlUtils;
        this.loggerProvider = loggerProvider;
        this.filepoolProvider = filepoolProvider;
        this.appProvider = appProvider;
        this.contentLinksHelper = contentLinksHelper;
        this.navCtrl = navCtrl;
        this.content = content;
        this.svComponent = svComponent;
        this.iframeUtils = iframeUtils;
        this.eventsProvider = eventsProvider;
        this.adaptImg = true; // Whether to adapt images to screen width.
        this.element = element.nativeElement;
        this.element.classList.add('opacity-hide'); // Hide contents until they're treated.
        this.afterRender = new __WEBPACK_IMPORTED_MODULE_0__angular_core__["v" /* EventEmitter */]();
        this.element.addEventListener('click', this.elementClicked.bind(this));
    }
    /**
     * Detect changes on input properties.
     */
    CoreFormatTextDirective.prototype.ngOnChanges = function (changes) {
        if (changes.text) {
            this.hideShowMore();
            this.formatAndRenderContents();
        }
    };
    /**
     * Apply CoreExternalContentDirective to a certain element.
     *
     * @param {HTMLElement} element Element to add the attributes to.
     * @return {CoreExternalContentDirective} External content instance.
     */
    CoreFormatTextDirective.prototype.addExternalContent = function (element) {
        // Angular 2 doesn't let adding directives dynamically. Create the CoreExternalContentDirective manually.
        var extContent = new __WEBPACK_IMPORTED_MODULE_14__directives_external_content__["a" /* CoreExternalContentDirective */](element, this.loggerProvider, this.filepoolProvider, this.platform, this.sitesProvider, this.domUtils, this.urlUtils, this.appProvider, this.utils);
        extContent.component = this.component;
        extContent.componentId = this.componentId;
        extContent.siteId = this.siteId;
        extContent.src = element.getAttribute('src');
        extContent.href = element.getAttribute('href');
        extContent.targetSrc = element.getAttribute('target-src');
        extContent.poster = element.getAttribute('poster');
        extContent.ngAfterViewInit();
        return extContent;
    };
    /**
     * Add class to adapt media to a certain element.
     *
     * @param {HTMLElement} element Element to add the class to.
     */
    CoreFormatTextDirective.prototype.addMediaAdaptClass = function (element) {
        element.classList.add('core-media-adapt-width');
    };
    /**
     * Wrap an image with a container to adapt its width.
     *
     * @param {HTMLElement} img Image to adapt.
     */
    CoreFormatTextDirective.prototype.adaptImage = function (img) {
        // Element to wrap the image.
        var container = document.createElement('span'), originalWidth = img.attributes.getNamedItem('width');
        var forcedWidth = parseInt(originalWidth && originalWidth.value);
        if (!isNaN(forcedWidth)) {
            if (originalWidth.value.indexOf('%') < 0) {
                img.style.width = forcedWidth + 'px';
            }
            else {
                img.style.width = forcedWidth + '%';
            }
        }
        container.classList.add('core-adapted-img-container');
        container.style.cssFloat = img.style.cssFloat; // Copy the float to correctly position the search icon.
        if (img.classList.contains('atto_image_button_right')) {
            container.classList.add('atto_image_button_right');
        }
        else if (img.classList.contains('atto_image_button_left')) {
            container.classList.add('atto_image_button_left');
        }
        else if (img.classList.contains('atto_image_button_text-top')) {
            container.classList.add('atto_image_button_text-top');
        }
        else if (img.classList.contains('atto_image_button_middle')) {
            container.classList.add('atto_image_button_middle');
        }
        else if (img.classList.contains('atto_image_button_text-bottom')) {
            container.classList.add('atto_image_button_text-bottom');
        }
        this.domUtils.wrapElement(img, container);
    };
    /**
     * Add magnifying glass icons to view adapted images at full size.
     */
    CoreFormatTextDirective.prototype.addMagnifyingGlasses = function () {
        var _this = this;
        var imgs = Array.from(this.element.querySelectorAll('.core-adapted-img-container > img'));
        if (!imgs.length) {
            return;
        }
        // If cannot calculate element's width, use viewport width to avoid false adapt image icons appearing.
        var elWidth = this.getElementWidth(this.element) || window.innerWidth;
        imgs.forEach(function (img) {
            // Skip image if it's inside a link.
            if (img.closest('a')) {
                return;
            }
            var imgWidth = parseInt(img.getAttribute('width'));
            if (!imgWidth) {
                // No width attribute, use real size.
                imgWidth = img.naturalWidth;
            }
            if (imgWidth <= elWidth) {
                return;
            }
            var imgSrc = _this.textUtils.escapeHTML(img.getAttribute('data-original-src') || img.getAttribute('src')), label = _this.textUtils.escapeHTML(_this.translate.instant('core.openfullimage')), anchor = document.createElement('a');
            anchor.classList.add('core-image-viewer-icon');
            anchor.setAttribute('aria-label', label);
            // Add an ion-icon item to apply the right styles, but the ion-icon component won't be executed.
            anchor.innerHTML = '<ion-icon name="search" class="icon icon-md ion-md-search"></ion-icon>';
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                e.stopPropagation();
                _this.domUtils.viewImage(imgSrc, img.getAttribute('alt'), _this.component, _this.componentId);
            });
            img.parentNode.appendChild(anchor);
        });
    };
    /**
     * Calculate the height and check if we need to display show more or not.
     */
    CoreFormatTextDirective.prototype.calculateHeight = function () {
        // @todo: Work on calculate this height better.
        // Remove max-height (if any) to calculate the real height.
        var initialMaxHeight = this.element.style.maxHeight;
        this.element.style.maxHeight = null;
        var height = this.getElementHeight(this.element);
        // Restore the max height now.
        this.element.style.maxHeight = initialMaxHeight;
        // If cannot calculate height, shorten always.
        if (!height || height > this.maxHeight) {
            if (!this.showMoreDisplayed) {
                this.displayShowMore();
            }
        }
        else if (this.showMoreDisplayed) {
            this.hideShowMore();
        }
    };
    /**
     * Display the "Show more" in the element.
     */
    CoreFormatTextDirective.prototype.displayShowMore = function () {
        var expandInFullview = this.utils.isTrueOrOne(this.fullOnClick) || false, showMoreDiv = document.createElement('div');
        showMoreDiv.classList.add('core-show-more');
        showMoreDiv.innerHTML = this.translate.instant('core.showmore');
        this.element.appendChild(showMoreDiv);
        if (expandInFullview) {
            this.element.classList.add('core-expand-in-fullview');
        }
        this.element.classList.add('core-text-formatted');
        this.element.classList.add('core-shortened');
        this.element.style.maxHeight = this.maxHeight + 'px';
        this.showMoreDisplayed = true;
    };
    /**
     * Listener to call when the element is clicked.
     *
     * @param {MouseEvent} e Click event.
     */
    CoreFormatTextDirective.prototype.elementClicked = function (e) {
        if (e.defaultPrevented) {
            // Ignore it if the event was prevented by some other listener.
            return;
        }
        var expandInFullview = this.utils.isTrueOrOne(this.fullOnClick) || false;
        if (!expandInFullview && !this.showMoreDisplayed) {
            // Nothing to do on click, just stop.
            return;
        }
        e.preventDefault();
        e.stopPropagation();
        if (!expandInFullview) {
            // Change class.
            this.element.classList.toggle('core-shortened');
            return;
        }
        else {
            // Open a new state with the contents.
            this.textUtils.expandText(this.fullTitle || this.translate.instant('core.description'), this.text, this.component, this.componentId);
        }
    };
    /**
     * Finish the rendering, displaying the element again and calling afterRender.
     */
    CoreFormatTextDirective.prototype.finishRender = function () {
        // Show the element again.
        this.element.classList.remove('opacity-hide');
        // Emit the afterRender output.
        this.afterRender.emit();
    };
    /**
     * Format contents and render.
     */
    CoreFormatTextDirective.prototype.formatAndRenderContents = function () {
        var _this = this;
        if (!this.text) {
            this.element.innerHTML = ''; // Remove current contents.
            this.finishRender();
            return;
        }
        // In AOT the inputs and ng-reflect aren't in the DOM sometimes. Add them so styles are applied.
        if (this.maxHeight && !this.element.getAttribute('maxHeight')) {
            this.element.setAttribute('maxHeight', String(this.maxHeight));
        }
        if (!this.element.getAttribute('singleLine')) {
            this.element.setAttribute('singleLine', String(this.utils.isTrueOrOne(this.singleLine)));
        }
        this.text = this.text ? this.text.trim() : '';
        this.formatContents().then(function (div) {
            // Disable media adapt to correctly calculate the height.
            _this.element.classList.add('core-disable-media-adapt');
            _this.element.innerHTML = ''; // Remove current contents.
            if (_this.maxHeight && div.innerHTML != '') {
                // Move the children to the current element to be able to calculate the height.
                _this.domUtils.moveChildren(div, _this.element);
                // Calculate the height now.
                _this.calculateHeight();
                // Add magnifying glasses to images.
                _this.addMagnifyingGlasses();
                if (!_this.loadingChangedListener) {
                    // Recalculate the height if a parent core-loading displays the content.
                    _this.loadingChangedListener = _this.eventsProvider.on(__WEBPACK_IMPORTED_MODULE_4__providers_events__["a" /* CoreEventsProvider */].CORE_LOADING_CHANGED, function (data) {
                        if (data.loaded && _this.domUtils.closest(_this.element.parentElement, '#' + data.uniqueId)) {
                            // The format-text is inside the loading, re-calculate the height.
                            _this.calculateHeight();
                        }
                    });
                }
            }
            else {
                _this.domUtils.moveChildren(div, _this.element);
                // Add magnifying glasses to images.
                _this.addMagnifyingGlasses();
            }
            _this.element.classList.remove('core-disable-media-adapt');
            _this.finishRender();
        });
    };
    /**
     * Apply formatText and set sub-directives.
     *
     * @return {Promise<HTMLElement>} Promise resolved with a div element containing the code.
     */
    CoreFormatTextDirective.prototype.formatContents = function () {
        var _this = this;
        var site;
        // Retrieve the site since it might be needed later.
        return this.sitesProvider.getSite(this.siteId).catch(function () {
            // Error getting the site. This probably means that there is no current site and no siteId was supplied.
        }).then(function (siteInstance) {
            site = siteInstance;
            // Apply format text function.
            return _this.textUtils.formatText(_this.text, _this.utils.isTrueOrOne(_this.clean), _this.utils.isTrueOrOne(_this.singleLine), undefined, _this.highlight);
        }).then(function (formatted) {
            var div = document.createElement('div'), canTreatVimeo = site && site.isVersionGreaterEqualThan(['3.3.4', '3.4']), navCtrl = _this.svComponent ? _this.svComponent.getMasterNav() : _this.navCtrl;
            var images, anchors, audios, videos, iframes, buttons, elementsWithInlineStyles, stopClicksElements, frames;
            div.innerHTML = formatted;
            images = Array.from(div.querySelectorAll('img'));
            anchors = Array.from(div.querySelectorAll('a'));
            audios = Array.from(div.querySelectorAll('audio'));
            videos = Array.from(div.querySelectorAll('video'));
            iframes = Array.from(div.querySelectorAll('iframe'));
            buttons = Array.from(div.querySelectorAll('.button'));
            elementsWithInlineStyles = Array.from(div.querySelectorAll('*[style]'));
            stopClicksElements = Array.from(div.querySelectorAll('button,input,select,textarea'));
            frames = Array.from(div.querySelectorAll(__WEBPACK_IMPORTED_MODULE_9__providers_utils_iframe__["a" /* CoreIframeUtilsProvider */].FRAME_TAGS.join(',').replace(/iframe,?/, '')));
            // Walk through the content to find the links and add our directive to it.
            // Important: We need to look for links first because in 'img' we add new links without core-link.
            anchors.forEach(function (anchor) {
                // Angular 2 doesn't let adding directives dynamically. Create the CoreLinkDirective manually.
                var linkDir = new __WEBPACK_IMPORTED_MODULE_13__directives_link__["a" /* CoreLinkDirective */](anchor, _this.domUtils, _this.utils, _this.sitesProvider, _this.urlUtils, _this.contentLinksHelper, _this.navCtrl, _this.content, _this.svComponent, _this.textUtils);
                linkDir.capture = true;
                linkDir.ngOnInit();
                _this.addExternalContent(anchor);
            });
            var externalImages = [];
            if (images && images.length > 0) {
                // Walk through the content to find images, and add our directive.
                images.forEach(function (img) {
                    _this.addMediaAdaptClass(img);
                    var externalImage = _this.addExternalContent(img);
                    if (!externalImage.invalid) {
                        externalImages.push(externalImage);
                    }
                    if (_this.utils.isTrueOrOne(_this.adaptImg) && !img.classList.contains('icon')) {
                        _this.adaptImage(img);
                    }
                });
            }
            audios.forEach(function (audio) {
                _this.treatMedia(audio);
            });
            videos.forEach(function (video) {
                _this.treatVideoFilters(video, navCtrl);
                _this.treatMedia(video);
            });
            iframes.forEach(function (iframe) {
                _this.treatIframe(iframe, site, canTreatVimeo, navCtrl);
            });
            // Handle buttons with inner links.
            buttons.forEach(function (button) {
                // Check if it has a link inside.
                if (button.querySelector('a')) {
                    button.classList.add('core-button-with-inner-link');
                }
            });
            // Handle inline styles.
            elementsWithInlineStyles.forEach(function (el) {
                // Only add external content for tags that haven't been treated already.
                if (el.tagName != 'A' && el.tagName != 'IMG' && el.tagName != 'AUDIO' && el.tagName != 'VIDEO'
                    && el.tagName != 'SOURCE' && el.tagName != 'TRACK') {
                    _this.addExternalContent(el);
                }
            });
            // Stop propagating click events.
            stopClicksElements.forEach(function (element) {
                element.addEventListener('click', function (e) {
                    e.stopPropagation();
                });
            });
            // Handle all kind of frames.
            frames.forEach(function (frame) {
                _this.iframeUtils.treatFrame(frame, false, navCtrl);
            });
            _this.domUtils.handleBootstrapTooltips(div);
            // Wait for images to load.
            var promise = null;
            if (externalImages.length) {
                // Automatically reject the promise after 5 seconds to prevent blocking the user forever.
                promise = _this.utils.timeoutPromise(_this.utils.allPromises(externalImages.map(function (externalImage) {
                    if (externalImage.loaded) {
                        // Image has already been loaded, no need to wait.
                        return Promise.resolve();
                    }
                    return new Promise(function (resolve) {
                        var subscription = externalImage.onLoad.subscribe(function () {
                            subscription.unsubscribe();
                            resolve();
                        });
                    });
                })), 5000);
            }
            else {
                promise = Promise.resolve();
            }
            return promise.catch(function () {
                // Ignore errors. So content gets always shown.
            }).then(function () {
                return div;
            });
        });
    };
    /**
     * Returns the element width in pixels.
     *
     * @param {HTMLElement} element Element to get width from.
     * @return {number} The width of the element in pixels. When 0 is returned it means the element is not visible.
     */
    CoreFormatTextDirective.prototype.getElementWidth = function (element) {
        var width = this.domUtils.getElementWidth(element);
        if (!width) {
            // All elements inside are floating or inline. Change display mode to allow calculate the width.
            var parentWidth = this.domUtils.getElementWidth(element.parentNode, true, false, false, true), previousDisplay = getComputedStyle(element, null).display;
            element.style.display = 'inline-block';
            width = this.domUtils.getElementWidth(element);
            // If width is incorrectly calculated use parent width instead.
            if (parentWidth > 0 && (!width || width > parentWidth)) {
                width = parentWidth;
            }
            element.style.display = previousDisplay;
        }
        return width;
    };
    /**
     * Returns the element height in pixels.
     *
     * @param {HTMLElement} elementAng Element to get height from.
     * @return {number} The height of the element in pixels. When 0 is returned it means the element is not visible.
     */
    CoreFormatTextDirective.prototype.getElementHeight = function (element) {
        return this.domUtils.getElementHeight(element) || 0;
    };
    /**
     * "Hide" the "Show more" in the element if it's shown.
     */
    CoreFormatTextDirective.prototype.hideShowMore = function () {
        var showMoreDiv = this.element.querySelector('div.core-show-more');
        if (showMoreDiv) {
            showMoreDiv.remove();
        }
        this.element.classList.remove('core-expand-in-fullview');
        this.element.classList.remove('core-text-formatted');
        this.element.classList.remove('core-shortened');
        this.element.style.maxHeight = null;
        this.showMoreDisplayed = false;
    };
    /**
     * Treat video filters. Currently only treating youtube video using video JS.
     *
     * @param {HTMLElement} el Video element.
     * @param {NavController} navCtrl NavController to use.
     */
    CoreFormatTextDirective.prototype.treatVideoFilters = function (video, navCtrl) {
        // Treat Video JS Youtube video links and translate them to iframes.
        if (!video.classList.contains('video-js')) {
            return;
        }
        var data = this.textUtils.parseJSON(video.getAttribute('data-setup') || video.getAttribute('data-setup-lazy') || '{}'), youtubeData = data.techOrder && data.techOrder[0] && data.techOrder[0] == 'youtube' &&
            this.parseYoutubeUrl(data.sources && data.sources[0] && data.sources[0].src);
        if (!youtubeData || !youtubeData.videoId) {
            return;
        }
        var iframe = document.createElement('iframe');
        iframe.id = video.id;
        iframe.src = 'https://www.youtube.com/embed/' + youtubeData.videoId; // Don't apply other params to align with Moodle web.
        iframe.setAttribute('frameborder', '0');
        iframe.setAttribute('allowfullscreen', '1');
        iframe.width = '100%';
        iframe.height = '300';
        // Replace video tag by the iframe.
        video.parentNode.replaceChild(iframe, video);
        this.iframeUtils.treatFrame(iframe, false, navCtrl);
    };
    /**
     * Add media adapt class and apply CoreExternalContentDirective to the media element and its sources and tracks.
     *
     * @param {HTMLElement} element Video or audio to treat.
     */
    CoreFormatTextDirective.prototype.treatMedia = function (element) {
        var _this = this;
        this.addMediaAdaptClass(element);
        this.addExternalContent(element);
        var sources = Array.from(element.querySelectorAll('source')), tracks = Array.from(element.querySelectorAll('track'));
        sources.forEach(function (source) {
            source.setAttribute('target-src', source.getAttribute('src'));
            source.removeAttribute('src');
            _this.addExternalContent(source);
        });
        tracks.forEach(function (track) {
            _this.addExternalContent(track);
        });
        // Stop propagating click events.
        element.addEventListener('click', function (e) {
            e.stopPropagation();
        });
    };
    /**
     * Add media adapt class and treat the iframe source.
     *
     * @param {HTMLIFrameElement} iframe Iframe to treat.
     * @param {CoreSite} site Site instance.
     * @param {boolean} canTreatVimeo Whether Vimeo videos can be treated in the site.
     * @param {NavController} navCtrl NavController to use.
     */
    CoreFormatTextDirective.prototype.treatIframe = function (iframe, site, canTreatVimeo, navCtrl) {
        var _this = this;
        var src = iframe.src, currentSite = this.sitesProvider.getCurrentSite();
        this.addMediaAdaptClass(iframe);
        if (currentSite && currentSite.containsUrl(src)) {
            // URL points to current site, try to use auto-login.
            currentSite.getAutoLoginUrl(src, false).then(function (finalUrl) {
                iframe.src = finalUrl;
                _this.iframeUtils.treatFrame(iframe, false, navCtrl);
            });
            return;
        }
        if (src && canTreatVimeo) {
            // Check if it's a Vimeo video. If it is, use the wsplayer script instead to make restricted videos work.
            var matches = iframe.src.match(/https?:\/\/player\.vimeo\.com\/video\/([0-9]+)/);
            if (matches && matches[1]) {
                var newUrl = this.textUtils.concatenatePaths(site.getURL(), '/media/player/vimeo/wsplayer.php?video=') +
                    matches[1] + '&token=' + site.getToken();
                // Width and height are mandatory, we need to calculate them.
                var width = void 0, height = void 0;
                if (iframe.width) {
                    width = iframe.width;
                }
                else {
                    width = this.getElementWidth(iframe);
                    if (!width) {
                        width = window.innerWidth;
                    }
                }
                if (iframe.height) {
                    height = iframe.height;
                }
                else {
                    height = this.getElementHeight(iframe);
                    if (!height) {
                        height = width;
                    }
                }
                // Width and height parameters are required in 3.6 and older sites.
                if (!site.isVersionGreaterEqualThan('3.7')) {
                    newUrl += '&width=' + width + '&height=' + height;
                }
                iframe.src = newUrl;
                if (!iframe.width) {
                    iframe.width = width;
                }
                if (!iframe.height) {
                    iframe.height = height;
                }
                // Do the iframe responsive.
                if (iframe.parentElement.classList.contains('embed-responsive')) {
                    iframe.addEventListener('load', function () {
                        if (iframe.contentDocument) {
                            var css = document.createElement('style');
                            css.setAttribute('type', 'text/css');
                            css.innerHTML = 'iframe {width: 100%;height: 100%;}';
                            iframe.contentDocument.head.appendChild(css);
                        }
                    });
                }
            }
        }
        this.iframeUtils.treatFrame(iframe, false, navCtrl);
    };
    /**
     * Parse a YouTube URL.
     * Based on Youtube.parseUrl from Moodle media/player/videojs/amd/src/Youtube-lazy.js
     *
     * @param {string} url URL of the video.
     */
    CoreFormatTextDirective.prototype.parseYoutubeUrl = function (url) {
        var result = {
            videoId: null,
            listId: null,
            start: null
        };
        if (!url) {
            return result;
        }
        url = this.textUtils.decodeHTML(url);
        // Get the video ID.
        var match = url.match(/^.*(youtu.be\/|v\/|u\/\w\/|embed\/|watch\?v=|\&v=)([^#\&\?]*).*/);
        if (match && match[2].length === 11) {
            result.videoId = match[2];
        }
        // Now get the playlist (if any).
        match = url.match(/[?&]list=([^#\&\?]+)/);
        if (match && match[1]) {
            result.listId = match[1];
        }
        // Now get the start time (if any).
        match = url.match(/[?&]start=(\d+)/);
        if (match && match[1]) {
            result.start = parseInt(match[1], 10);
        }
        else {
            // No start param, but it could have a time param.
            match = url.match(/[?&]t=(\d+h)?(\d+m)?(\d+s)?/);
            if (match) {
                result.start = (match[1] ? parseInt(match[1], 10) * 3600 : 0) + (match[2] ? parseInt(match[2], 10) * 60 : 0) +
                    (match[3] ? parseInt(match[3], 10) : 0);
            }
        }
        return result;
    };
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["D" /* Input */])(),
        __metadata("design:type", String)
    ], CoreFormatTextDirective.prototype, "text", void 0);
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["D" /* Input */])(),
        __metadata("design:type", String)
    ], CoreFormatTextDirective.prototype, "siteId", void 0);
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["D" /* Input */])(),
        __metadata("design:type", String)
    ], CoreFormatTextDirective.prototype, "component", void 0);
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["D" /* Input */])(),
        __metadata("design:type", Object)
    ], CoreFormatTextDirective.prototype, "componentId", void 0);
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["D" /* Input */])(),
        __metadata("design:type", Object)
    ], CoreFormatTextDirective.prototype, "adaptImg", void 0);
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["D" /* Input */])(),
        __metadata("design:type", Object)
    ], CoreFormatTextDirective.prototype, "clean", void 0);
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["D" /* Input */])(),
        __metadata("design:type", Object)
    ], CoreFormatTextDirective.prototype, "singleLine", void 0);
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["D" /* Input */])(),
        __metadata("design:type", Number)
    ], CoreFormatTextDirective.prototype, "maxHeight", void 0);
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["D" /* Input */])(),
        __metadata("design:type", Object)
    ], CoreFormatTextDirective.prototype, "fullOnClick", void 0);
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["D" /* Input */])(),
        __metadata("design:type", String)
    ], CoreFormatTextDirective.prototype, "fullTitle", void 0);
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["D" /* Input */])(),
        __metadata("design:type", String)
    ], CoreFormatTextDirective.prototype, "highlight", void 0);
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["O" /* Output */])(),
        __metadata("design:type", __WEBPACK_IMPORTED_MODULE_0__angular_core__["v" /* EventEmitter */])
    ], CoreFormatTextDirective.prototype, "afterRender", void 0);
    CoreFormatTextDirective = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["s" /* Directive */])({
            selector: 'core-format-text'
        }),
        __param(12, Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["N" /* Optional */])()),
        __param(13, Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["N" /* Optional */])()), __param(14, Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["N" /* Optional */])()),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_0__angular_core__["t" /* ElementRef */], __WEBPACK_IMPORTED_MODULE_7__providers_sites__["a" /* CoreSitesProvider */], __WEBPACK_IMPORTED_MODULE_8__providers_utils_dom__["a" /* CoreDomUtilsProvider */],
            __WEBPACK_IMPORTED_MODULE_10__providers_utils_text__["a" /* CoreTextUtilsProvider */], __WEBPACK_IMPORTED_MODULE_2__ngx_translate_core__["c" /* TranslateService */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["v" /* Platform */],
            __WEBPACK_IMPORTED_MODULE_12__providers_utils_utils__["a" /* CoreUtilsProvider */], __WEBPACK_IMPORTED_MODULE_11__providers_utils_url__["a" /* CoreUrlUtilsProvider */], __WEBPACK_IMPORTED_MODULE_6__providers_logger__["a" /* CoreLoggerProvider */],
            __WEBPACK_IMPORTED_MODULE_5__providers_filepool__["a" /* CoreFilepoolProvider */], __WEBPACK_IMPORTED_MODULE_3__providers_app__["a" /* CoreAppProvider */],
            __WEBPACK_IMPORTED_MODULE_15__core_contentlinks_providers_helper__["a" /* CoreContentLinksHelperProvider */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["s" /* NavController */],
            __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["f" /* Content */], __WEBPACK_IMPORTED_MODULE_16__components_split_view_split_view__["a" /* CoreSplitViewComponent */],
            __WEBPACK_IMPORTED_MODULE_9__providers_utils_iframe__["a" /* CoreIframeUtilsProvider */], __WEBPACK_IMPORTED_MODULE_4__providers_events__["a" /* CoreEventsProvider */]])
    ], CoreFormatTextDirective);
    return CoreFormatTextDirective;
}());

//# sourceMappingURL=format-text.js.map

/***/ }),
/* 42 */,
/* 43 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreUserProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__providers_filepool__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__providers_logger__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__classes_site__ = __webpack_require__(52);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__providers_sites__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__providers_utils_utils__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__providers_app__ = __webpack_require__(9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__offline__ = __webpack_require__(444);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__core_pushnotifications_providers_pushnotifications__ = __webpack_require__(130);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};









/**
 * Service to provide user functionalities.
 */
var CoreUserProvider = /** @class */ (function () {
    function CoreUserProvider(logger, sitesProvider, utils, filepoolProvider, appProvider, userOffline, pushNotificationsProvider) {
        this.sitesProvider = sitesProvider;
        this.utils = utils;
        this.filepoolProvider = filepoolProvider;
        this.appProvider = appProvider;
        this.userOffline = userOffline;
        this.pushNotificationsProvider = pushNotificationsProvider;
        this.ROOT_CACHE_KEY = 'mmUser:';
        // Variables for database.
        this.USERS_TABLE = 'users';
        this.siteSchema = {
            name: 'CoreUserProvider',
            version: 1,
            canBeCleared: [this.USERS_TABLE],
            tables: [
                {
                    name: this.USERS_TABLE,
                    columns: [
                        {
                            name: 'id',
                            type: 'INTEGER',
                            primaryKey: true
                        },
                        {
                            name: 'fullname',
                            type: 'TEXT'
                        },
                        {
                            name: 'profileimageurl',
                            type: 'TEXT'
                        }
                    ],
                }
            ]
        };
        this.logger = logger.getInstance('CoreUserProvider');
        this.sitesProvider.registerSiteSchema(this.siteSchema);
    }
    CoreUserProvider_1 = CoreUserProvider;
    /**
     * Change the given user profile picture.
     *
     * @param  {number} draftItemId New picture draft item id.
     * @param  {number} userId      User ID.
     * @return {Promise<string>}       Promise resolve with the new profileimageurl
     */
    CoreUserProvider.prototype.changeProfilePicture = function (draftItemId, userId) {
        var data = {
            draftitemid: draftItemId,
            delete: 0,
            userid: userId
        };
        return this.sitesProvider.getCurrentSite().write('core_user_update_picture', data).then(function (result) {
            if (!result.success) {
                return Promise.reject(null);
            }
            return result.profileimageurl;
        });
    };
    /**
     * Store user basic information in local DB to be retrieved if the WS call fails.
     *
     * @param  {number} userId  User ID.
     * @param {string} [siteId] ID of the site. If not defined, use current site.
     * @return {Promise<any>}   Promise resolve when the user is deleted.
     */
    CoreUserProvider.prototype.deleteStoredUser = function (userId, siteId) {
        var _this = this;
        if (isNaN(userId)) {
            return Promise.reject(null);
        }
        var promises = [];
        siteId = siteId || this.sitesProvider.getCurrentSiteId();
        // Invalidate WS calls.
        promises.push(this.invalidateUserCache(userId, siteId));
        promises.push(this.sitesProvider.getSite(siteId).then(function (site) {
            return site.getDb().deleteRecords(_this.USERS_TABLE, { id: userId });
        }));
        return Promise.all(promises);
    };
    /**
     * Get participants for a certain course.
     *
     * @param  {number} courseId    ID of the course.
     * @param  {number} limitFrom   Position of the first participant to get.
     * @param  {number} limitNumber Number of participants to get.
     * @param  {string} [siteId]    Site Id. If not defined, use current site.
     * @param  {boolean} [ignoreCache] True if it should ignore cached data (it will always fail in offline or server down).
     * @return {Promise<{participants: any[], canLoadMore: boolean}>} Promise resolved when the participants are retrieved.
     */
    CoreUserProvider.prototype.getParticipants = function (courseId, limitFrom, limitNumber, siteId, ignoreCache) {
        var _this = this;
        if (limitFrom === void 0) { limitFrom = 0; }
        if (limitNumber === void 0) { limitNumber = CoreUserProvider_1.PARTICIPANTS_LIST_LIMIT; }
        return this.sitesProvider.getSite(siteId).then(function (site) {
            _this.logger.debug("Get participants for course '" + courseId + "' starting at '" + limitFrom + "'");
            var data = {
                courseid: courseId,
                options: [
                    {
                        name: 'limitfrom',
                        value: limitFrom
                    },
                    {
                        name: 'limitnumber',
                        value: limitNumber
                    },
                    {
                        name: 'sortby',
                        value: 'siteorder'
                    }
                ]
            }, preSets = {
                cacheKey: _this.getParticipantsListCacheKey(courseId),
                updateFrequency: __WEBPACK_IMPORTED_MODULE_3__classes_site__["a" /* CoreSite */].FREQUENCY_RARELY
            };
            if (ignoreCache) {
                preSets.getFromCache = false;
                preSets.emergencyCache = false;
            }
            return site.read('core_enrol_get_enrolled_users', data, preSets).then(function (users) {
                var canLoadMore = users.length >= limitNumber;
                _this.storeUsers(users, siteId);
                return { participants: users, canLoadMore: canLoadMore };
            });
        });
    };
    /**
     * Get cache key for participant list WS calls.
     *
     * @param  {number} courseId Course ID.
     * @return {string}          Cache key.
     */
    CoreUserProvider.prototype.getParticipantsListCacheKey = function (courseId) {
        return this.ROOT_CACHE_KEY + 'list:' + courseId;
    };
    /**
     * Get user profile. The type of profile retrieved depends on the params.
     *
     * @param  {number} userId      User's ID.
     * @param  {number} [courseId]  Course ID to get course profile, undefined or 0 to get site profile.
     * @param  {boolean} [forceLocal] True to retrieve the user data from local DB, false to retrieve it from WS.
     * @param {string} [siteId] ID of the site. If not defined, use current site.
     * @return {Promise<any>}            Promise resolved with the user data.
     */
    CoreUserProvider.prototype.getProfile = function (userId, courseId, forceLocal, siteId) {
        var _this = this;
        if (forceLocal === void 0) { forceLocal = false; }
        siteId = siteId || this.sitesProvider.getCurrentSiteId();
        if (forceLocal) {
            return this.getUserFromLocalDb(userId, siteId).catch(function () {
                return _this.getUserFromWS(userId, courseId, siteId);
            });
        }
        return this.getUserFromWS(userId, courseId, siteId).catch(function () {
            return _this.getUserFromLocalDb(userId, siteId);
        });
    };
    /**
     * Get cache key for a user WS call.
     *
     * @param  {number} userId User ID.
     * @return {string}        Cache key.
     */
    CoreUserProvider.prototype.getUserCacheKey = function (userId) {
        return this.ROOT_CACHE_KEY + 'data:' + userId;
    };
    /**
     * Get user basic information from local DB.
     *
     * @param {number} userId User ID.
     * @param {string} [siteId] ID of the site. If not defined, use current site.
     * @return {Promise<any>}   Promise resolve when the user is retrieved.
     */
    CoreUserProvider.prototype.getUserFromLocalDb = function (userId, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.getDb().getRecord(_this.USERS_TABLE, { id: userId });
        });
    };
    /**
     * Get user profile from WS.
     *
     * @param {number} userId         User ID.
     * @param {number} [courseId] Course ID to get course profile, undefined or 0 to get site profile.
     * @param {string} [siteId] ID of the site. If not defined, use current site.
     * @return {Promise<any>}           Promise resolve when the user is retrieved.
     */
    CoreUserProvider.prototype.getUserFromWS = function (userId, courseId, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var presets = {
                cacheKey: _this.getUserCacheKey(userId),
                updateFrequency: __WEBPACK_IMPORTED_MODULE_3__classes_site__["a" /* CoreSite */].FREQUENCY_RARELY
            };
            var wsName, data;
            // Determine WS and data to use.
            if (courseId && courseId != site.getSiteHomeId()) {
                _this.logger.debug("Get participant with ID '" + userId + "' in course '" + courseId);
                wsName = 'core_user_get_course_user_profiles';
                data = {
                    userlist: [
                        {
                            userid: userId,
                            courseid: courseId
                        }
                    ]
                };
            }
            else {
                _this.logger.debug("Get user with ID '" + userId + "'");
                wsName = 'core_user_get_users_by_field';
                data = {
                    field: 'id',
                    values: [userId]
                };
            }
            return site.read(wsName, data, presets).then(function (users) {
                if (users.length == 0) {
                    return Promise.reject('Cannot retrieve user info.');
                }
                var user = users.shift();
                if (user.country) {
                    user.country = _this.utils.getCountryName(user.country);
                }
                _this.storeUser(user.id, user.fullname, user.profileimageurl);
                return user;
            });
        });
    };
    /**
     * Get a user preference (online or offline).
     *
     * @param {string} name Name of the preference.
     * @param {string} [siteId] Site Id. If not defined, use current site.
     * @return {string} Preference value or null if preference not set.
     */
    CoreUserProvider.prototype.getUserPreference = function (name, siteId) {
        var _this = this;
        siteId = siteId || this.sitesProvider.getCurrentSiteId();
        return this.userOffline.getPreference(name, siteId).catch(function () {
            return null;
        }).then(function (preference) {
            if (preference && !_this.appProvider.isOnline()) {
                // Offline, return stored value.
                return preference.value;
            }
            return _this.getUserPreferenceOnline(name, siteId).then(function (wsValue) {
                if (preference && preference.value != preference.onlinevalue && preference.onlinevalue == wsValue) {
                    // Sync is pending for this preference, return stored value.
                    return preference.value;
                }
                return _this.userOffline.setPreference(name, wsValue, wsValue).then(function () {
                    return wsValue;
                });
            });
        });
    };
    /**
     * Get cache key for a user preference WS call.
     *
     * @param {string} name Preference name.
     * @return {string} Cache key.
     */
    CoreUserProvider.prototype.getUserPreferenceCacheKey = function (name) {
        return this.ROOT_CACHE_KEY + 'preference:' + name;
    };
    /**
     * Get a user preference online.
     *
     * @param {string} name Name of the preference.
     * @param {string} [siteId] Site Id. If not defined, use current site.
     * @return {string} Preference value or null if preference not set.
     */
    CoreUserProvider.prototype.getUserPreferenceOnline = function (name, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var data = { name: name };
            var preSets = {
                cacheKey: _this.getUserPreferenceCacheKey(data.name),
                updateFrequency: __WEBPACK_IMPORTED_MODULE_3__classes_site__["a" /* CoreSite */].FREQUENCY_SOMETIMES
            };
            return site.read('core_user_get_user_preferences', data, preSets).then(function (result) {
                return result.preferences[0] ? result.preferences[0].value : null;
            });
        });
    };
    /**
     * Invalidates user WS calls.
     *
     * @param {number} userId User ID.
     * @param {string} [siteId] Site Id. If not defined, use current site.
     * @return {Promise<any>}       Promise resolved when the data is invalidated.
     */
    CoreUserProvider.prototype.invalidateUserCache = function (userId, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.invalidateWsCacheForKey(_this.getUserCacheKey(userId));
        });
    };
    /**
     * Invalidates participant list for a certain course.
     *
     * @param  {number} courseId Course ID.
     * @param  {string} [siteId] Site Id. If not defined, use current site.
     * @return {Promise<any>}         Promise resolved when the list is invalidated.
     */
    CoreUserProvider.prototype.invalidateParticipantsList = function (courseId, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.invalidateWsCacheForKey(_this.getParticipantsListCacheKey(courseId));
        });
    };
    /**
     * Invalidate user preference.
     *
     * @param {string} name Name of the preference.
     * @param {string} [siteId] Site Id. If not defined, use current site.
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreUserProvider.prototype.invalidateUserPreference = function (name, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.invalidateWsCacheForKey(_this.getUserPreferenceCacheKey(name));
        });
    };
    /**
     * Check if course participants is disabled in a certain site.
     *
     * @param  {string} [siteId] Site Id. If not defined, use current site.
     * @return {Promise<boolean>}     Promise resolved with true if disabled, rejected or resolved with false otherwise.
     */
    CoreUserProvider.prototype.isParticipantsDisabled = function (siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return _this.isParticipantsDisabledInSite(site);
        });
    };
    /**
     * Check if course participants is disabled in a certain site.
     *
     * @param {CoreSite} [site] Site. If not defined, use current site.
     * @return {boolean} Whether it's disabled.
     */
    CoreUserProvider.prototype.isParticipantsDisabledInSite = function (site) {
        site = site || this.sitesProvider.getCurrentSite();
        return site.isFeatureDisabled('CoreCourseOptionsDelegate_CoreUserParticipants');
    };
    /**
     * Returns whether or not participants is enabled for a certain course.
     *
     * @param {number} courseId Course ID.
     * @param  {string} [siteId] Site Id. If not defined, use current site.
     * @return {Promise<any>}    Promise resolved with true if plugin is enabled, rejected or resolved with false otherwise.
     */
    CoreUserProvider.prototype.isPluginEnabledForCourse = function (courseId, siteId) {
        if (!courseId) {
            return Promise.reject(null);
        }
        // Retrieving one participant will fail if browsing users is disabled by capabilities.
        return this.utils.promiseWorks(this.getParticipants(courseId, 0, 1, siteId));
    };
    /**
     * Check if update profile picture is disabled in a certain site.
     *
     * @param  {CoreSite} [site] Site. If not defined, use current site.
     * @return {boolean}       True if disabled, false otherwise.
     */
    CoreUserProvider.prototype.isUpdatePictureDisabledInSite = function (site) {
        site = site || this.sitesProvider.getCurrentSite();
        return site.isFeatureDisabled('CoreUserDelegate_picture');
    };
    /**
     * Log User Profile View in Moodle.
     * @param  {number}       userId   User ID.
     * @param  {number}       [courseId] Course ID.
     * @param  {string}       [name] Name of the user.
     * @return {Promise<any>}          Promise resolved when done.
     */
    CoreUserProvider.prototype.logView = function (userId, courseId, name) {
        var params = {
            userid: userId
        }, wsName = 'core_user_view_user_profile';
        if (courseId) {
            params['courseid'] = courseId;
        }
        this.pushNotificationsProvider.logViewEvent(userId, name, 'user', wsName, { courseid: courseId });
        return this.sitesProvider.getCurrentSite().write(wsName, params);
    };
    /**
     * Log Participants list view in Moodle.
     * @param  {number}       courseId Course ID.
     * @return {Promise<any>}          Promise resolved when done.
     */
    CoreUserProvider.prototype.logParticipantsView = function (courseId) {
        var params = {
            courseid: courseId
        };
        this.pushNotificationsProvider.logViewListEvent('user', 'core_user_view_user_list', params);
        return this.sitesProvider.getCurrentSite().write('core_user_view_user_list', params);
    };
    /**
     * Prefetch user profiles and their images from a certain course. It prevents duplicates.
     *
     * @param {number[]} userIds List of user IDs.
     * @param {number} [courseId] Course the users belong to.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved when prefetched.
     */
    CoreUserProvider.prototype.prefetchProfiles = function (userIds, courseId, siteId) {
        var _this = this;
        siteId = siteId || this.sitesProvider.getCurrentSiteId();
        var treated = {}, promises = [];
        userIds.forEach(function (userId) {
            if (userId === null) {
                return;
            }
            userId = Number(userId); // Make sure it's a number.
            // Prevent repeats and errors.
            if (!isNaN(userId) && !treated[userId] && userId > 0) {
                treated[userId] = true;
                promises.push(_this.getProfile(userId, courseId, false, siteId).then(function (profile) {
                    if (profile.profileimageurl) {
                        _this.filepoolProvider.addToQueueByUrl(siteId, profile.profileimageurl);
                    }
                }));
            }
        });
        return Promise.all(promises);
    };
    /**
     * Store user basic information in local DB to be retrieved if the WS call fails.
     *
     * @param {number} userId   User ID.
     * @param {string} fullname User full name.
     * @param {string} avatar   User avatar URL.
     * @param  {string} [siteId] ID of the site. If not defined, use current site.
     * @return {Promise<any>}         Promise resolve when the user is stored.
     */
    CoreUserProvider.prototype.storeUser = function (userId, fullname, avatar, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var userRecord = {
                id: userId,
                fullname: fullname,
                profileimageurl: avatar
            };
            return site.getDb().insertRecord(_this.USERS_TABLE, userRecord);
        });
    };
    /**
     * Store users basic information in local DB.
     *
     * @param  {any[]} users     Users to store. Fields stored: id, fullname, profileimageurl.
     * @param  {string} [siteId] ID of the site. If not defined, use current site.
     * @return {Promise<any>}        Promise resolve when the user is stored.
     */
    CoreUserProvider.prototype.storeUsers = function (users, siteId) {
        var _this = this;
        var promises = [];
        users.forEach(function (user) {
            if (typeof user.id != 'undefined' && !isNaN(parseInt(user.id, 10))) {
                promises.push(_this.storeUser(parseInt(user.id, 10), user.fullname, user.profileimageurl, siteId));
            }
        });
        return Promise.all(promises);
    };
    /**
     * Set a user preference (online or offline).
     *
     * @param {string} name Name of the preference.
     * @param {string} value Value of the preference.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved on success.
     */
    CoreUserProvider.prototype.setUserPreference = function (name, value, siteId) {
        var _this = this;
        siteId = siteId || this.sitesProvider.getCurrentSiteId();
        var isOnline = this.appProvider.isOnline();
        var promise;
        if (isOnline) {
            var preferences = [{ type: name, value: value }];
            promise = this.updateUserPreferences(preferences, undefined, undefined, siteId).catch(function (error) {
                // Preference not saved online.
                isOnline = false;
                return Promise.reject(error);
            });
        }
        else {
            promise = Promise.resolve();
        }
        return promise.finally(function () {
            // Update stored online value if saved online.
            var onlineValue = isOnline ? value : undefined;
            return Promise.all([
                _this.userOffline.setPreference(name, value, onlineValue),
                _this.invalidateUserPreference(name).catch(function () {
                    // Ignore error.
                })
            ]);
        });
    };
    /**
     * Update a preference for a user.
     *
     * @param  {string} name     Preference name.
     * @param  {any} value       Preference new value.
     * @param  {number} [userId] User ID. If not defined, site's current user.
     * @param  {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>}    Promise resolved if success.
     */
    CoreUserProvider.prototype.updateUserPreference = function (name, value, userId, siteId) {
        var preferences = [
            {
                type: name,
                value: value
            }
        ];
        return this.updateUserPreferences(preferences, undefined, userId, siteId);
    };
    /**
     * Update some preferences for a user.
     *
     * @param  {{name: string, value: string}[]} preferences List of preferences.
     * @param  {boolean} [disableNotifications] Whether to disable all notifications. Undefined to not update this value.
     * @param  {number} [userId]                User ID. If not defined, site's current user.
     * @param  {string} [siteId]                Site ID. If not defined, current site.
     * @return {Promise<any>}                   Promise resolved if success.
     */
    CoreUserProvider.prototype.updateUserPreferences = function (preferences, disableNotifications, userId, siteId) {
        return this.sitesProvider.getSite(siteId).then(function (site) {
            userId = userId || site.getUserId();
            var data = {
                userid: userId,
                preferences: preferences
            }, preSets = {
                responseExpected: false
            };
            if (typeof disableNotifications != 'undefined') {
                data['emailstop'] = disableNotifications ? 1 : 0;
            }
            return site.write('core_user_update_user_preferences', data, preSets);
        });
    };
    CoreUserProvider.PARTICIPANTS_LIST_LIMIT = 50; // Max of participants to retrieve in each WS call.
    CoreUserProvider.PROFILE_REFRESHED = 'CoreUserProfileRefreshed';
    CoreUserProvider.PROFILE_PICTURE_UPDATED = 'CoreUserProfilePictureUpdated';
    CoreUserProvider = CoreUserProvider_1 = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_2__providers_logger__["a" /* CoreLoggerProvider */], __WEBPACK_IMPORTED_MODULE_4__providers_sites__["a" /* CoreSitesProvider */], __WEBPACK_IMPORTED_MODULE_5__providers_utils_utils__["a" /* CoreUtilsProvider */],
            __WEBPACK_IMPORTED_MODULE_1__providers_filepool__["a" /* CoreFilepoolProvider */], __WEBPACK_IMPORTED_MODULE_6__providers_app__["a" /* CoreAppProvider */],
            __WEBPACK_IMPORTED_MODULE_7__offline__["a" /* CoreUserOfflineProvider */], __WEBPACK_IMPORTED_MODULE_8__core_pushnotifications_providers_pushnotifications__["a" /* CorePushNotificationsProvider */]])
    ], CoreUserProvider);
    return CoreUserProvider;
    var CoreUserProvider_1;
}());

//# sourceMappingURL=user.js.map

/***/ }),
/* 44 */,
/* 45 */,
/* 46 */,
/* 47 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreLoadingComponent; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__ngx_translate_core__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__classes_animations__ = __webpack_require__(731);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_events__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__providers_utils_utils__ = __webpack_require__(2);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};





/**
 * Component to show a loading spinner and message while data is being loaded.
 *
 * It will show a spinner with a message and hide all the content until 'dataLoaded' variable is set to true.
 * If 'message' and 'dynMessage' attributes aren't set, default message "Loading" is shown.
 * 'message' attribute accepts hardcoded strings, variables, filters, etc. E.g. message="'core.loading' | translate".
 *
 * Usage:
 * <core-loading [message]="loadingMessage" [hideUntil]="dataLoaded">
 *     <!-- CONTENT TO HIDE UNTIL LOADED -->
 * </core-loading>
 *
 * IMPORTANT: Due to how ng-content works in Angular, the content of core-loading will be executed as soon as your view
 * is loaded, even if the content hidden. So if you have the following code:
 * <core-loading [hideUntil]="dataLoaded"><my-component></my-component></core-loading>
 *
 * The component "my-component" will be initialized immediately, even if dataLoaded is false, but it will be hidden. If you want
 * your component to be initialized only if dataLoaded is true, then you should use ngIf:
 * <core-loading [hideUntil]="dataLoaded"><my-component *ngIf="dataLoaded"></my-component></core-loading>
 */
var CoreLoadingComponent = /** @class */ (function () {
    function CoreLoadingComponent(translate, element, eventsProvider, utils) {
        this.translate = translate;
        this.eventsProvider = eventsProvider;
        this.element = element.nativeElement;
        // Calculate the unique ID.
        this.uniqueId = 'core-loading-content-' + utils.getUniqueId('CoreLoadingComponent');
    }
    /**
     * Component being initialized.
     */
    CoreLoadingComponent.prototype.ngOnInit = function () {
        if (!this.message) {
            // Default loading message.
            this.message = this.translate.instant('core.loading');
        }
        // Add class if loaded on init.
        if (this.hideUntil) {
            this.element.classList.add('core-loading-loaded');
            this.content.nativeElement.classList.add('core-loading-content');
        }
    };
    CoreLoadingComponent.prototype.ngOnChanges = function (changes) {
        var _this = this;
        if (changes.hideUntil) {
            if (changes.hideUntil.currentValue === true) {
                setTimeout(function () {
                    // Content is loaded so, center the spinner on the content itself.
                    _this.element.classList.add('core-loading-loaded');
                    setTimeout(function () {
                        // Change CSS to force calculate height.
                        _this.content.nativeElement.classList.add('core-loading-content');
                    }, 500);
                });
            }
            else {
                this.element.classList.remove('core-loading-loaded');
                this.content.nativeElement.classList.remove('core-loading-content');
            }
            // Trigger the event after a timeout since the elements inside ngIf haven't been added to DOM yet.
            setTimeout(function () {
                _this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_3__providers_events__["a" /* CoreEventsProvider */].CORE_LOADING_CHANGED, {
                    loaded: changes.hideUntil.currentValue,
                    uniqueId: _this.uniqueId
                });
            });
        }
    };
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["D" /* Input */])(),
        __metadata("design:type", Boolean)
    ], CoreLoadingComponent.prototype, "hideUntil", void 0);
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["D" /* Input */])(),
        __metadata("design:type", String)
    ], CoreLoadingComponent.prototype, "message", void 0);
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["_9" /* ViewChild */])('content'),
        __metadata("design:type", __WEBPACK_IMPORTED_MODULE_0__angular_core__["t" /* ElementRef */])
    ], CoreLoadingComponent.prototype, "content", void 0);
    CoreLoadingComponent = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: 'core-loading',
            templateUrl: 'core-loading.html',
            animations: [__WEBPACK_IMPORTED_MODULE_2__classes_animations__["a" /* coreShowHideAnimation */]]
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_1__ngx_translate_core__["c" /* TranslateService */], __WEBPACK_IMPORTED_MODULE_0__angular_core__["t" /* ElementRef */], __WEBPACK_IMPORTED_MODULE_3__providers_events__["a" /* CoreEventsProvider */],
            __WEBPACK_IMPORTED_MODULE_4__providers_utils_utils__["a" /* CoreUtilsProvider */]])
    ], CoreLoadingComponent);
    return CoreLoadingComponent;
}());

//# sourceMappingURL=loading.js.map

/***/ }),
/* 48 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreCourseModulePrefetchDelegate; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__providers_events__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__providers_file__ = __webpack_require__(53);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_filepool__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__providers_logger__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__providers_sites__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__providers_utils_time__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__providers_utils_utils__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__course__ = __webpack_require__(14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__classes_cache__ = __webpack_require__(1041);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__constants__ = __webpack_require__(40);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_ts_md5_dist_md5__ = __webpack_require__(203);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11_ts_md5_dist_md5___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_11_ts_md5_dist_md5__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_rxjs__ = __webpack_require__(148);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_rxjs___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_12_rxjs__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__classes_delegate__ = __webpack_require__(107);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};














/**
 * Delegate to register module prefetch handlers.
 */
var CoreCourseModulePrefetchDelegate = /** @class */ (function (_super) {
    __extends(CoreCourseModulePrefetchDelegate, _super);
    function CoreCourseModulePrefetchDelegate(loggerProvider, sitesProvider, utils, courseProvider, filepoolProvider, timeUtils, fileProvider, eventsProvider) {
        var _this = _super.call(this, 'CoreCourseModulePrefetchDelegate', loggerProvider, sitesProvider, eventsProvider) || this;
        _this.sitesProvider = sitesProvider;
        _this.utils = utils;
        _this.courseProvider = courseProvider;
        _this.filepoolProvider = filepoolProvider;
        _this.timeUtils = timeUtils;
        _this.fileProvider = fileProvider;
        _this.eventsProvider = eventsProvider;
        // Variables for database.
        _this.CHECK_UPDATES_TIMES_TABLE = 'check_updates_times';
        _this.siteSchema = {
            name: 'CoreCourseModulePrefetchDelegate',
            version: 1,
            tables: [
                {
                    name: _this.CHECK_UPDATES_TIMES_TABLE,
                    columns: [
                        {
                            name: 'courseId',
                            type: 'INTEGER',
                            primaryKey: true
                        },
                        {
                            name: 'time',
                            type: 'INTEGER',
                            notNull: true
                        }
                    ]
                }
            ]
        };
        _this.ROOT_CACHE_KEY = 'mmCourse:';
        _this.statusCache = new __WEBPACK_IMPORTED_MODULE_9__classes_cache__["a" /* CoreCache */]();
        _this.handlerNameProperty = 'modName';
        // Promises for check updates, to prevent performing the same request twice at the same time.
        _this.courseUpdatesPromises = {};
        // Promises and observables for prefetching, to prevent downloading same section twice at the same time and notify progress.
        _this.prefetchData = {};
        _this.sitesProvider.registerSiteSchema(_this.siteSchema);
        eventsProvider.on(__WEBPACK_IMPORTED_MODULE_1__providers_events__["a" /* CoreEventsProvider */].LOGOUT, _this.clearStatusCache.bind(_this));
        eventsProvider.on(__WEBPACK_IMPORTED_MODULE_1__providers_events__["a" /* CoreEventsProvider */].PACKAGE_STATUS_CHANGED, function (data) {
            _this.updateStatusCache(data.status, data.component, data.componentId);
        }, _this.sitesProvider.getCurrentSiteId());
        return _this;
    }
    /**
     * Check if current site can check updates using core_course_check_updates.
     *
     * @return {boolean} True if can check updates, false otherwise.
     */
    CoreCourseModulePrefetchDelegate.prototype.canCheckUpdates = function () {
        return this.sitesProvider.wsAvailableInCurrentSite('core_course_check_updates');
    };
    /**
     * Check if a certain module can use core_course_check_updates.
     *
     * @param {any} module Module.
     * @param {number} courseId Course ID the module belongs to.
     * @return {Promise<boolean>} Promise resolved with boolean: whether the module can use check updates WS.
     */
    CoreCourseModulePrefetchDelegate.prototype.canModuleUseCheckUpdates = function (module, courseId) {
        var handler = this.getPrefetchHandlerFor(module);
        if (!handler) {
            // Module not supported, cannot use check updates.
            return Promise.resolve(false);
        }
        if (handler.canUseCheckUpdates) {
            return Promise.resolve(handler.canUseCheckUpdates(module, courseId));
        }
        // By default, modules can use check updates.
        return Promise.resolve(true);
    };
    /**
     * Clear the status cache.
     */
    CoreCourseModulePrefetchDelegate.prototype.clearStatusCache = function () {
        this.statusCache.clear();
    };
    /**
     * Creates the list of modules to check for get course updates.
     *
     * @param {any[]} modules List of modules.
     * @param {number} courseId Course ID the modules belong to.
     * @return {Promise<{toCheck: any[], cannotUse: any[]}>} Promise resolved with the lists.
     */
    CoreCourseModulePrefetchDelegate.prototype.createToCheckList = function (modules, courseId) {
        var _this = this;
        var result = {
            toCheck: [],
            cannotUse: []
        }, promises = [];
        modules.forEach(function (module) {
            promises.push(_this.getModuleStatusAndDownloadTime(module, courseId).then(function (data) {
                if (data.status == __WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].DOWNLOADED) {
                    // Module is downloaded and not outdated. Check if it can check updates.
                    return _this.canModuleUseCheckUpdates(module, courseId).then(function (canUse) {
                        if (canUse) {
                            // Can use check updates, add it to the tocheck list.
                            result.toCheck.push({
                                contextlevel: 'module',
                                id: module.id,
                                since: data.downloadTime || 0
                            });
                        }
                        else {
                            // Cannot use check updates, add it to the cannotUse array.
                            result.cannotUse.push(module);
                        }
                    });
                }
            }).catch(function () {
                // Ignore errors.
            }));
        });
        return Promise.all(promises).then(function () {
            // Sort toCheck list.
            result.toCheck.sort(function (a, b) {
                return a.id >= b.id ? 1 : -1;
            });
            return result;
        });
    };
    /**
     * Determines a module status based on current status, restoring downloads if needed.
     *
     * @param {any} module Module.
     * @param {string} status Current status.
     * @param {boolean} [canCheck] True if updates can be checked using core_course_check_updates.
     * @return {string} Module status.
     */
    CoreCourseModulePrefetchDelegate.prototype.determineModuleStatus = function (module, status, canCheck) {
        var handler = this.getPrefetchHandlerFor(module), siteId = this.sitesProvider.getCurrentSiteId();
        if (handler) {
            if (status == __WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].DOWNLOADING) {
                // Check if the download is being handled.
                if (!this.filepoolProvider.getPackageDownloadPromise(siteId, handler.component, module.id)) {
                    // Not handled, the app was probably restarted or something weird happened.
                    // Re-start download (files already on queue or already downloaded will be skipped).
                    handler.prefetch(module);
                }
            }
            else if (handler.determineStatus) {
                // The handler implements a determineStatus function. Apply it.
                canCheck = canCheck || this.canCheckUpdates();
                return handler.determineStatus(module, status, canCheck);
            }
        }
        return status;
    };
    /**
     * Check for updates in a course.
     *
     * @param {any[]} modules List of modules.
     * @param {number} courseId  Course ID the modules belong to.
     * @return {Promise<any>} Promise resolved with the updates. If a module is set to false, it means updates cannot be
     *                        checked for that module in the current site.
     */
    CoreCourseModulePrefetchDelegate.prototype.getCourseUpdates = function (modules, courseId) {
        var _this = this;
        if (!this.canCheckUpdates()) {
            return Promise.reject(null);
        }
        // Check if there's already a getCourseUpdates in progress.
        var id = __WEBPACK_IMPORTED_MODULE_11_ts_md5_dist_md5__["Md5"].hashAsciiStr(courseId + '#' + JSON.stringify(modules)), siteId = this.sitesProvider.getCurrentSiteId();
        if (this.courseUpdatesPromises[siteId] && this.courseUpdatesPromises[siteId][id]) {
            // There's already a get updates ongoing, return the promise.
            return this.courseUpdatesPromises[siteId][id];
        }
        else if (!this.courseUpdatesPromises[siteId]) {
            this.courseUpdatesPromises[siteId] = {};
        }
        this.courseUpdatesPromises[siteId][id] = this.createToCheckList(modules, courseId).then(function (data) {
            var result = {};
            // Mark as false the modules that cannot use check updates WS.
            data.cannotUse.forEach(function (module) {
                result[module.id] = false;
            });
            if (!data.toCheck.length) {
                // Nothing to check, no need to call the WS.
                return result;
            }
            // Get the site, maybe the user changed site.
            return _this.sitesProvider.getSite(siteId).then(function (site) {
                var params = {
                    courseid: courseId,
                    tocheck: data.toCheck
                }, preSets = {
                    cacheKey: _this.getCourseUpdatesCacheKey(courseId),
                    emergencyCache: false,
                    uniqueCacheKey: true
                };
                return site.read('core_course_check_updates', params, preSets).then(function (response) {
                    if (!response || typeof response.instances == 'undefined') {
                        return Promise.reject(null);
                    }
                    // Store the last execution of the check updates call.
                    var entry = {
                        courseId: courseId,
                        time: _this.timeUtils.timestamp()
                    };
                    site.getDb().insertRecord(_this.CHECK_UPDATES_TIMES_TABLE, entry).catch(function () {
                        // Ignore errors.
                    });
                    return _this.treatCheckUpdatesResult(data.toCheck, response, result);
                }).catch(function (error) {
                    // Cannot get updates.
                    // Get cached entries but discard modules with a download time higher than the last execution of check updates.
                    return site.getDb().getRecord(_this.CHECK_UPDATES_TIMES_TABLE, { courseId: courseId }).then(function (entry) {
                        preSets.getCacheUsingCacheKey = true;
                        preSets.omitExpires = true;
                        return site.read('core_course_check_updates', params, preSets).then(function (response) {
                            if (!response || typeof response.instances == 'undefined') {
                                return Promise.reject(error);
                            }
                            return _this.treatCheckUpdatesResult(data.toCheck, response, result, entry.time);
                        });
                    }, function () {
                        // No previous executions, return result as it is.
                        return result;
                    });
                });
            });
        }).finally(function () {
            // Get updates finished, delete the promise.
            delete _this.courseUpdatesPromises[siteId][id];
        });
        return this.courseUpdatesPromises[siteId][id];
    };
    /**
     * Check for updates in a course.
     *
     * @param {number} courseId Course ID the modules belong to.
     * @return {Promise<any>} Promise resolved with the updates.
     */
    CoreCourseModulePrefetchDelegate.prototype.getCourseUpdatesByCourseId = function (courseId) {
        var _this = this;
        if (!this.canCheckUpdates()) {
            return Promise.reject(null);
        }
        // Get course sections and all their modules.
        return this.courseProvider.getSections(courseId, false, true, { omitExpires: true }).then(function (sections) {
            return _this.getCourseUpdates(_this.courseProvider.getSectionsModules(sections), courseId);
        });
    };
    /**
     * Get cache key for course updates WS calls.
     *
     * @param {number} courseId Course ID.
     * @return {string} Cache key.
     */
    CoreCourseModulePrefetchDelegate.prototype.getCourseUpdatesCacheKey = function (courseId) {
        return this.ROOT_CACHE_KEY + 'courseUpdates:' + courseId;
    };
    /**
     * Get modules download size. Only treat the modules with status not downloaded or outdated.
     *
     * @param {any[]} modules List of modules.
     * @param {number} courseId Course ID the modules belong to.
     * @return {Promise<{size: number, total: boolean}>} Promise resolved with the size and a boolean indicating if it was able
     *                                                   to calculate the total size.
     */
    CoreCourseModulePrefetchDelegate.prototype.getDownloadSize = function (modules, courseId) {
        var _this = this;
        // Get the status of each module.
        return this.getModulesStatus(modules, courseId).then(function (data) {
            var downloadableModules = data[__WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].NOT_DOWNLOADED].concat(data[__WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].OUTDATED]), promises = [], result = {
                size: 0,
                total: true
            };
            downloadableModules.forEach(function (module) {
                promises.push(_this.getModuleDownloadSize(module, courseId).then(function (size) {
                    result.total = result.total && size.total;
                    result.size += size.size;
                }));
            });
            return Promise.all(promises).then(function () {
                return result;
            });
        });
    };
    /**
     * Get the download size of a module.
     *
     * @param {any} module Module to get size.
     * @param {Number} courseId Course ID the module belongs to.
     * @param {boolean} [single] True if we're downloading a single module, false if we're downloading a whole section.
     * @return {Promise<{size: number, total: boolean}>} Promise resolved with the size and a boolean indicating if it was able
     *                                                   to calculate the total size.
     */
    CoreCourseModulePrefetchDelegate.prototype.getModuleDownloadSize = function (module, courseId, single) {
        var _this = this;
        var handler = this.getPrefetchHandlerFor(module);
        var downloadSize, packageId;
        // Check if the module has a prefetch handler.
        if (handler) {
            return this.isModuleDownloadable(module, courseId).then(function (downloadable) {
                if (!downloadable) {
                    return { size: 0, total: true };
                }
                packageId = _this.filepoolProvider.getPackageId(handler.component, module.id);
                downloadSize = _this.statusCache.getValue(packageId, 'downloadSize');
                if (typeof downloadSize != 'undefined') {
                    return downloadSize;
                }
                return Promise.resolve(handler.getDownloadSize(module, courseId, single)).then(function (size) {
                    return _this.statusCache.setValue(packageId, 'downloadSize', size);
                }).catch(function (error) {
                    var cachedSize = _this.statusCache.getValue(packageId, 'downloadSize', true);
                    if (cachedSize) {
                        return cachedSize;
                    }
                    return Promise.reject(error);
                });
            });
        }
        return Promise.resolve({ size: 0, total: false });
    };
    /**
     * Get the download size of a module.
     *
     * @param {any} module Module to get size.
     * @param {number} courseId Course ID the module belongs to.
     * @return {Promise<number>} Promise resolved with the size.
     */
    CoreCourseModulePrefetchDelegate.prototype.getModuleDownloadedSize = function (module, courseId) {
        var _this = this;
        var handler = this.getPrefetchHandlerFor(module);
        var downloadedSize, packageId, promise;
        // Check if the module has a prefetch handler.
        if (handler) {
            return this.isModuleDownloadable(module, courseId).then(function (downloadable) {
                if (!downloadable) {
                    return 0;
                }
                packageId = _this.filepoolProvider.getPackageId(handler.component, module.id);
                downloadedSize = _this.statusCache.getValue(packageId, 'downloadedSize');
                if (typeof downloadedSize != 'undefined') {
                    return downloadedSize;
                }
                if (handler.getDownloadedSize) {
                    // Handler implements a method to calculate the downloaded size, use it.
                    promise = Promise.resolve(handler.getDownloadedSize(module, courseId));
                }
                else {
                    // Handler doesn't implement it, get the module files and check if they're downloaded.
                    promise = _this.getModuleFiles(module, courseId).then(function (files) {
                        var siteId = _this.sitesProvider.getCurrentSiteId(), promises = [];
                        var size = 0;
                        // Retrieve file size if it's downloaded.
                        files.forEach(function (file) {
                            var fileUrl = file.url || file.fileurl;
                            promises.push(_this.filepoolProvider.getFilePathByUrl(siteId, fileUrl).then(function (path) {
                                return _this.fileProvider.getFileSize(path).catch(function () {
                                    // Error getting size. Check if the file is being downloaded.
                                    return _this.filepoolProvider.isFileDownloadingByUrl(siteId, fileUrl).then(function () {
                                        // If downloading, count as downloaded.
                                        return file.filesize;
                                    }).catch(function () {
                                        // Not downloading and not found in disk.
                                        return 0;
                                    });
                                }).then(function (fs) {
                                    size += fs;
                                });
                            }));
                        });
                        return Promise.all(promises).then(function () {
                            return size;
                        });
                    });
                }
                return promise.then(function (size) {
                    return _this.statusCache.setValue(packageId, 'downloadedSize', size);
                }).catch(function () {
                    return _this.statusCache.getValue(packageId, 'downloadedSize', true);
                });
            });
        }
        return Promise.resolve(0);
    };
    /**
     * Get module files.
     *
     * @param {any} module Module to get the files.
     * @param {number} courseId Course ID the module belongs to.
     * @return {Promise<any[]>} Promise resolved with the list of files.
     */
    CoreCourseModulePrefetchDelegate.prototype.getModuleFiles = function (module, courseId) {
        var handler = this.getPrefetchHandlerFor(module);
        if (handler.getFiles) {
            // The handler defines a function to get files, use it.
            return Promise.resolve(handler.getFiles(module, courseId));
        }
        else if (handler.loadContents) {
            // The handler defines a function to load contents, use it before returning module contents.
            return handler.loadContents(module, courseId).then(function () {
                return module.contents;
            });
        }
        else {
            return Promise.resolve(module.contents || []);
        }
    };
    /**
     * Get the module status.
     *
     * @param {any} module Module.
     * @param {number} courseId Course ID the module belongs to.
     * @param {any} [updates] Result of getCourseUpdates for all modules in the course. If not provided, it will be
     *                        calculated (slower). If it's false it means the site doesn't support check updates.
     * @param {boolean} [refresh] True if it should ignore the cache.
     * @param {number} [sectionId] ID of the section the module belongs to.
     * @return {Promise<string>} Promise resolved with the status.
     */
    CoreCourseModulePrefetchDelegate.prototype.getModuleStatus = function (module, courseId, updates, refresh, sectionId) {
        var _this = this;
        var handler = this.getPrefetchHandlerFor(module), siteId = this.sitesProvider.getCurrentSiteId(), canCheck = this.canCheckUpdates();
        if (handler) {
            // Check if the status is cached.
            var component_1 = handler.component, packageId_1 = this.filepoolProvider.getPackageId(component_1, module.id);
            var status_1 = this.statusCache.getValue(packageId_1, 'status'), updateStatus_1 = true, promise_1;
            if (!refresh && typeof status_1 != 'undefined') {
                this.storeCourseAndSection(packageId_1, courseId, sectionId);
                return Promise.resolve(this.determineModuleStatus(module, status_1, canCheck));
            }
            // Check if the module is downloadable.
            return this.isModuleDownloadable(module, courseId).then(function (downloadable) {
                if (!downloadable) {
                    return __WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].NOT_DOWNLOADABLE;
                }
                // Get the saved package status.
                return _this.filepoolProvider.getPackageStatus(siteId, component_1, module.id).then(function (currentStatus) {
                    status_1 = handler.determineStatus ? handler.determineStatus(module, currentStatus, canCheck) : currentStatus;
                    if (status_1 != __WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].DOWNLOADED) {
                        return status_1;
                    }
                    // Module is downloaded. Determine if there are updated in the module to show them outdated.
                    if (typeof updates == 'undefined') {
                        // We don't have course updates, calculate them.
                        promise_1 = _this.getCourseUpdatesByCourseId(courseId);
                    }
                    else if (updates === false) {
                        // Cannot check updates.
                        return status_1;
                    }
                    else {
                        promise_1 = Promise.resolve(updates);
                    }
                    return promise_1.then(function (updates) {
                        if (!updates || updates[module.id] === false) {
                            // Cannot check updates, always show outdated.
                            return __WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].OUTDATED;
                        }
                        // Check if the module has any update.
                        return _this.moduleHasUpdates(module, courseId, updates).then(function (hasUpdates) {
                            if (!hasUpdates) {
                                // No updates, keep current status.
                                return status_1;
                            }
                            // Has updates, mark the module as outdated.
                            status_1 = __WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].OUTDATED;
                            return _this.filepoolProvider.storePackageStatus(siteId, status_1, component_1, module.id).catch(function () {
                                // Ignore errors.
                            }).then(function () {
                                return status_1;
                            });
                        }).catch(function () {
                            // Error checking if module has updates.
                            var status = _this.statusCache.getValue(packageId_1, 'status', true);
                            return _this.determineModuleStatus(module, status, canCheck);
                        });
                    }, function () {
                        // Error getting updates, show the stored status.
                        updateStatus_1 = false;
                        _this.storeCourseAndSection(packageId_1, courseId, sectionId);
                        return currentStatus;
                    });
                });
            }).then(function (status) {
                if (updateStatus_1) {
                    _this.updateStatusCache(status, component_1, module.id, courseId, sectionId);
                }
                return _this.determineModuleStatus(module, status, canCheck);
            });
        }
        // No handler found, module not downloadable.
        return Promise.resolve(__WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].NOT_DOWNLOADABLE);
    };
    /**
     * Get the status of a list of modules, along with the lists of modules for each status.
     * @see {@link CoreFilepoolProvider.determinePackagesStatus}
     *
     * @param {any[]} modules List of modules to prefetch.
     * @param {number} courseId Course ID the modules belong to.
     * @param {number} [sectionId] ID of the section the modules belong to.
     * @param {boolean} [refresh] True if it should always check the DB (slower).
     * @param {boolean} [onlyToDisplay] True if the status will only be used to determine which button should be displayed.
     * @param {boolean} [checkUpdates=true] Whether to use the WS to check updates. Defaults to true.
     * @return {Promise<any>} Promise resolved with an object with the following properties:
     *                                - status (string) Status of the module.
     *                                - total (number) Number of modules.
     *                                - CoreConstants.NOT_DOWNLOADED (any[]) Modules with state NOT_DOWNLOADED.
     *                                - CoreConstants.DOWNLOADED (any[]) Modules with state DOWNLOADED.
     *                                - CoreConstants.DOWNLOADING (any[]) Modules with state DOWNLOADING.
     *                                - CoreConstants.OUTDATED (any[]) Modules with state OUTDATED.
     */
    CoreCourseModulePrefetchDelegate.prototype.getModulesStatus = function (modules, courseId, sectionId, refresh, onlyToDisplay, checkUpdates) {
        var _this = this;
        if (checkUpdates === void 0) { checkUpdates = true; }
        var promises = [], result = {
            total: 0
        };
        var status = __WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].NOT_DOWNLOADABLE, promise;
        // Init result.
        result[__WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].NOT_DOWNLOADED] = [];
        result[__WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].DOWNLOADED] = [];
        result[__WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].DOWNLOADING] = [];
        result[__WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].OUTDATED] = [];
        if (checkUpdates) {
            // Check updates in course. Don't use getCourseUpdates because the list of modules might not be the whole course list.
            promise = this.getCourseUpdatesByCourseId(courseId).catch(function () {
                // Cannot get updates.
                return false;
            });
        }
        else {
            promise = Promise.resolve(false);
        }
        return promise.then(function (updates) {
            modules.forEach(function (module) {
                // Check if the module has a prefetch handler.
                var handler = _this.getPrefetchHandlerFor(module);
                if (handler) {
                    if (onlyToDisplay && handler.skipListStatus) {
                        // Skip this module.
                        return;
                    }
                    var packageId_2 = _this.filepoolProvider.getPackageId(handler.component, module.id);
                    promises.push(_this.getModuleStatus(module, courseId, updates, refresh).then(function (modStatus) {
                        if (result[modStatus]) {
                            status = _this.filepoolProvider.determinePackagesStatus(status, modStatus);
                            result[modStatus].push(module);
                            result.total++;
                        }
                    }).catch(function (error) {
                        var cacheStatus = _this.statusCache.getValue(packageId_2, 'status', true);
                        if (typeof cacheStatus == 'undefined') {
                            return Promise.reject(error);
                        }
                        if (result[cacheStatus]) {
                            status = _this.filepoolProvider.determinePackagesStatus(status, cacheStatus);
                            result[cacheStatus].push(module);
                            result.total++;
                        }
                    }));
                }
            });
            return Promise.all(promises).then(function () {
                result.status = status;
                return result;
            });
        });
    };
    /**
     * Get a module status and download time. It will only return the download time if the module is downloaded or outdated.
     *
     * @param {any} module Module.
     * @param {number} courseId Course ID the module belongs to.
     * @return {Promise<{status: string, downloadTime?: number}>} Promise resolved with the data.
     */
    CoreCourseModulePrefetchDelegate.prototype.getModuleStatusAndDownloadTime = function (module, courseId) {
        var _this = this;
        var handler = this.getPrefetchHandlerFor(module), siteId = this.sitesProvider.getCurrentSiteId();
        if (handler) {
            // Get the status from the cache.
            var packageId = this.filepoolProvider.getPackageId(handler.component, module.id), status_2 = this.statusCache.getValue(packageId, 'status');
            if (typeof status_2 != 'undefined' && status_2 != __WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].DOWNLOADED && status_2 != __WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].OUTDATED) {
                // Module isn't downloaded, just return the status.
                return Promise.resolve({
                    status: status_2
                });
            }
            // Check if the module is downloadable.
            return this.isModuleDownloadable(module, courseId).then(function (downloadable) {
                if (!downloadable) {
                    return {
                        status: __WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].NOT_DOWNLOADABLE
                    };
                }
                // Get the stored data to get the status and downloadTime.
                return _this.filepoolProvider.getPackageData(siteId, handler.component, module.id).then(function (data) {
                    return {
                        status: data.status,
                        downloadTime: data.downloadTime || 0
                    };
                });
            });
        }
        // No handler found, module not downloadable.
        return Promise.resolve({
            status: __WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].NOT_DOWNLOADABLE
        });
    };
    /**
     * Get updates for a certain module.
     * It will only return the updates if the module can use check updates and it's downloaded or outdated.
     *
     * @param {any} module Module to check.
     * @param {number} courseId Course the module belongs to.
     * @param {boolean} [ignoreCache] True if it should ignore cached data (it will always fail in offline or server down).
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved with the updates.
     */
    CoreCourseModulePrefetchDelegate.prototype.getModuleUpdates = function (module, courseId, ignoreCache, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            // Get the status and download time of the module.
            return _this.getModuleStatusAndDownloadTime(module, courseId).then(function (data) {
                if (data.status != __WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].DOWNLOADED && data.status != __WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].OUTDATED) {
                    // Not downloaded, no updates.
                    return {};
                }
                // Module is downloaded. Check if it can check updates.
                return _this.canModuleUseCheckUpdates(module, courseId).then(function (canUse) {
                    if (!canUse) {
                        // Can't use check updates, no updates.
                        return {};
                    }
                    var params = {
                        courseid: courseId,
                        tocheck: [
                            {
                                contextlevel: 'module',
                                id: module.id,
                                since: data.downloadTime || 0
                            }
                        ]
                    }, preSets = {
                        cacheKey: _this.getModuleUpdatesCacheKey(courseId, module.id),
                    };
                    if (ignoreCache) {
                        preSets.getFromCache = false;
                        preSets.emergencyCache = false;
                    }
                    return site.read('core_course_check_updates', params, preSets).then(function (response) {
                        if (!response || !response.instances || !response.instances[0]) {
                            return Promise.reject(null);
                        }
                        return response.instances[0];
                    });
                });
            });
        });
    };
    /**
     * Get cache key for module updates WS calls.
     *
     * @param {number} courseId Course ID.
     * @param {number} moduleId Module ID.
     * @return {string} Cache key.
     */
    CoreCourseModulePrefetchDelegate.prototype.getModuleUpdatesCacheKey = function (courseId, moduleId) {
        return this.getCourseUpdatesCacheKey(courseId) + ':' + moduleId;
    };
    /**
     * Get a prefetch handler.
     *
     * @param {any} module The module to work on.
     * @return {CoreCourseModulePrefetchHandler} Prefetch handler.
     */
    CoreCourseModulePrefetchDelegate.prototype.getPrefetchHandlerFor = function (module) {
        return this.getHandler(module.modname, true);
    };
    /**
     * Invalidate check updates WS call.
     *
     * @param {number} courseId Course ID.
     * @return {Promise<any>} Promise resolved when data is invalidated.
     */
    CoreCourseModulePrefetchDelegate.prototype.invalidateCourseUpdates = function (courseId) {
        return this.sitesProvider.getCurrentSite().invalidateWsCacheForKey(this.getCourseUpdatesCacheKey(courseId));
    };
    /**
     * Invalidate a list of modules in a course. This should only invalidate WS calls, not downloaded files.
     *
     * @param {any[]} modules List of modules.
     * @param {number} courseId Course ID.
     * @return {Promise<any>} Promise resolved when modules are invalidated.
     */
    CoreCourseModulePrefetchDelegate.prototype.invalidateModules = function (modules, courseId) {
        var _this = this;
        var promises = [];
        modules.forEach(function (module) {
            var handler = _this.getPrefetchHandlerFor(module);
            if (handler) {
                if (handler.invalidateModule) {
                    promises.push(handler.invalidateModule(module, courseId).catch(function () {
                        // Ignore errors.
                    }));
                }
                // Invalidate cache.
                _this.invalidateModuleStatusCache(module);
            }
        });
        promises.push(this.invalidateCourseUpdates(courseId));
        return Promise.all(promises);
    };
    /**
     * Invalidates the cache for a given module.
     *
     * @param {any} module Module to be invalidated.
     */
    CoreCourseModulePrefetchDelegate.prototype.invalidateModuleStatusCache = function (module) {
        var handler = this.getPrefetchHandlerFor(module);
        if (handler) {
            this.statusCache.invalidate(this.filepoolProvider.getPackageId(handler.component, module.id));
        }
    };
    /**
     * Invalidate check updates WS call for a certain module.
     *
     * @param {number} courseId Course ID.
     * @param {number} moduleId Module ID.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved when data is invalidated.
     */
    CoreCourseModulePrefetchDelegate.prototype.invalidateModuleUpdates = function (courseId, moduleId, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.invalidateWsCacheForKey(_this.getModuleUpdatesCacheKey(courseId, moduleId));
        });
    };
    /**
     * Check if a list of modules is being downloaded.
     *
     * @param {string} id An ID to identify the download.
     * @return {boolean} True if it's being downloaded, false otherwise.
     */
    CoreCourseModulePrefetchDelegate.prototype.isBeingDownloaded = function (id) {
        var siteId = this.sitesProvider.getCurrentSiteId();
        return !!(this.prefetchData[siteId] && this.prefetchData[siteId][id]);
    };
    /**
     * Check if a module is downloadable.
     *
     * @param {any} module Module.
     * @param {Number} courseId Course ID the module belongs to.
     * @return {Promise<boolean>} Promise resolved with true if downloadable, false otherwise.
     */
    CoreCourseModulePrefetchDelegate.prototype.isModuleDownloadable = function (module, courseId) {
        var _this = this;
        if (module.uservisible === false) {
            // Module isn't visible by the user, cannot be downloaded.
            return Promise.resolve(false);
        }
        var handler = this.getPrefetchHandlerFor(module);
        if (handler) {
            if (typeof handler.isDownloadable == 'function') {
                var packageId_3 = this.filepoolProvider.getPackageId(handler.component, module.id), downloadable = this.statusCache.getValue(packageId_3, 'downloadable');
                if (typeof downloadable != 'undefined') {
                    return Promise.resolve(downloadable);
                }
                else {
                    return Promise.resolve(handler.isDownloadable(module, courseId)).then(function (downloadable) {
                        return _this.statusCache.setValue(packageId_3, 'downloadable', downloadable);
                    }).catch(function () {
                        // Something went wrong, assume it's not downloadable.
                        return false;
                    });
                }
            }
            else {
                // Function not defined, assume it's not downloadable.
                return Promise.resolve(true);
            }
        }
        else {
            // No handler for module, so it's not downloadable.
            return Promise.resolve(false);
        }
    };
    /**
     * Check if a module has updates based on the result of getCourseUpdates.
     *
     * @param {any} module Module.
     * @param {number} courseId Course ID the module belongs to.
     * @param {any} updates Result of getCourseUpdates.
     * @return {Promise<boolean>} Promise resolved with boolean: whether the module has updates.
     */
    CoreCourseModulePrefetchDelegate.prototype.moduleHasUpdates = function (module, courseId, updates) {
        var handler = this.getPrefetchHandlerFor(module), moduleUpdates = updates[module.id];
        if (handler && handler.hasUpdates) {
            // Handler implements its own function to check the updates, use it.
            return Promise.resolve(handler.hasUpdates(module, courseId, moduleUpdates));
        }
        else if (!moduleUpdates || !moduleUpdates.updates || !moduleUpdates.updates.length) {
            // Module doesn't have any update.
            return Promise.resolve(false);
        }
        else if (handler && handler.updatesNames && handler.updatesNames.test) {
            // Check the update names defined by the handler.
            for (var i = 0, len = moduleUpdates.updates.length; i < len; i++) {
                if (handler.updatesNames.test(moduleUpdates.updates[i].name)) {
                    return Promise.resolve(true);
                }
            }
            return Promise.resolve(false);
        }
        // Handler doesn't define hasUpdates or updatesNames and there is at least 1 update. Assume it has updates.
        return Promise.resolve(true);
    };
    /**
     * Prefetch a module.
     *
     * @param {any} module Module to prefetch.
     * @param {number} courseId Course ID the module belongs to.
     * @param {boolean} [single] True if we're downloading a single module, false if we're downloading a whole section.
     * @return {Promise<any>} Promise resolved when finished.
     */
    CoreCourseModulePrefetchDelegate.prototype.prefetchModule = function (module, courseId, single) {
        var handler = this.getPrefetchHandlerFor(module);
        // Check if the module has a prefetch handler.
        if (handler) {
            return this.syncModule(module, courseId).then(function () {
                return handler.prefetch(module, courseId, single);
            });
        }
        return Promise.resolve();
    };
    /**
     * Sync a group of modules.
     *
     * @param  {any[]}        modules Array of modules to sync.
     * @param {number} courseId Course ID the module belongs to.
     * @return {Promise<any>}         Promise resolved when finished.
     */
    CoreCourseModulePrefetchDelegate.prototype.syncModules = function (modules, courseId) {
        var _this = this;
        return Promise.all(modules.map(function (module) {
            return _this.syncModule(module, courseId).then(function () {
                // Invalidate course updates.
                return _this.invalidateCourseUpdates(courseId).catch(function () {
                    // Ignore errors.
                });
            });
        }));
    };
    /**
     * Sync a module.
     *
     * @param {any} module Module to sync.
     * @param {number} courseId Course ID the module belongs to.
     * @return {Promise<any>} Promise resolved when finished.
     */
    CoreCourseModulePrefetchDelegate.prototype.syncModule = function (module, courseId) {
        var _this = this;
        var handler = this.getPrefetchHandlerFor(module);
        if (handler && handler.sync) {
            return handler.sync(module, courseId).then(function (result) {
                // Always invalidate status cache for this module. We cannot know if data was sent to server or not.
                _this.invalidateModuleStatusCache(module);
                return result;
            }).catch(function () {
                // Ignore errors.
            });
        }
        return Promise.resolve();
    };
    /**
     * Prefetches a list of modules using their prefetch handlers.
     * If a prefetch already exists for this site and id, returns the current promise.
     *
     * @param {string} id An ID to identify the download. It can be used to retrieve the download promise.
     * @param {any[]} modules List of modules to prefetch.
     * @param {number} courseId Course ID the modules belong to.
     * @param {CoreCourseModulesProgressFunction} [onProgress] Function to call everytime a module is downloaded.
     * @return {Promise<any>} Promise resolved when all modules have been prefetched.
     */
    CoreCourseModulePrefetchDelegate.prototype.prefetchModules = function (id, modules, courseId, onProgress) {
        var _this = this;
        var siteId = this.sitesProvider.getCurrentSiteId(), currentData = this.prefetchData[siteId] && this.prefetchData[siteId][id];
        if (currentData) {
            // There's a prefetch ongoing, return the current promise.
            if (onProgress) {
                currentData.subscriptions.push(currentData.observable.subscribe(onProgress));
            }
            return currentData.promise;
        }
        var count = 0;
        var promises = [], total = modules.length, moduleIds = modules.map(function (module) {
            return module.id;
        }), prefetchData = {
            observable: new __WEBPACK_IMPORTED_MODULE_12_rxjs__["BehaviorSubject"]({ count: count, total: total }),
            promise: undefined,
            subscriptions: []
        };
        if (onProgress) {
            prefetchData.observable.subscribe(onProgress);
        }
        modules.forEach(function (module) {
            // Check if the module has a prefetch handler.
            var handler = _this.getPrefetchHandlerFor(module);
            if (handler) {
                promises.push(_this.isModuleDownloadable(module, courseId).then(function (downloadable) {
                    if (!downloadable) {
                        return;
                    }
                    return handler.prefetch(module, courseId).then(function () {
                        var index = moduleIds.indexOf(module.id);
                        if (index > -1) {
                            // It's one of the modules we were expecting to download.
                            moduleIds.splice(index, 1);
                            count++;
                            prefetchData.observable.next({ count: count, total: total });
                        }
                    });
                }));
            }
        });
        // Set the promise.
        prefetchData.promise = this.utils.allPromises(promises).finally(function () {
            // Unsubscribe all observers.
            prefetchData.subscriptions.forEach(function (subscription) {
                subscription.unsubscribe();
            });
            delete _this.prefetchData[siteId][id];
        });
        // Store the prefetch data in the list.
        if (!this.prefetchData[siteId]) {
            this.prefetchData[siteId] = {};
        }
        this.prefetchData[siteId][id] = prefetchData;
        return prefetchData.promise;
    };
    /**
     * Remove module Files from handler.
     *
     * @param {any} module Module to remove the files.
     * @param {number} courseId Course ID the module belongs to.
     * @return {Promise<void>} Promise resolved when done.
     */
    CoreCourseModulePrefetchDelegate.prototype.removeModuleFiles = function (module, courseId) {
        var _this = this;
        var handler = this.getPrefetchHandlerFor(module), siteId = this.sitesProvider.getCurrentSiteId();
        var promise;
        if (handler && handler.removeFiles) {
            // Handler implements a method to remove the files, use it.
            promise = handler.removeFiles(module, courseId);
        }
        else {
            // No method to remove files, use get files to try to remove the files.
            promise = this.getModuleFiles(module, courseId).then(function (files) {
                var promises = [];
                files.forEach(function (file) {
                    promises.push(_this.filepoolProvider.removeFileByUrl(siteId, file.url || file.fileurl).catch(function () {
                        // Ignore errors.
                    }));
                });
                return Promise.all(promises);
            });
        }
        return promise.then(function () {
            if (handler) {
                // Update status of the module.
                var packageId = _this.filepoolProvider.getPackageId(handler.component, module.id);
                _this.statusCache.setValue(packageId, 'downloadedSize', 0);
                return _this.filepoolProvider.storePackageStatus(siteId, __WEBPACK_IMPORTED_MODULE_10__constants__["a" /* CoreConstants */].NOT_DOWNLOADED, handler.component, module.id);
            }
        });
    };
    /**
     * Set an on progress function for the download of a list of modules.
     *
     * @param {string} id An ID to identify the download.
     * @param {CoreCourseModulesProgressFunction} onProgress Function to call everytime a module is downloaded.
     */
    CoreCourseModulePrefetchDelegate.prototype.setOnProgress = function (id, onProgress) {
        var siteId = this.sitesProvider.getCurrentSiteId(), currentData = this.prefetchData[siteId] && this.prefetchData[siteId][id];
        if (currentData) {
            // There's a prefetch ongoing, return the current promise.
            currentData.subscriptions.push(currentData.observable.subscribe(onProgress));
        }
    };
    /**
     * If courseId or sectionId is set, save them in the cache.
     *
     * @param {string} packageId The package ID.
     * @param {number} [courseId] Course ID.
     * @param {number} [sectionId] Section ID.
     */
    CoreCourseModulePrefetchDelegate.prototype.storeCourseAndSection = function (packageId, courseId, sectionId) {
        if (courseId) {
            this.statusCache.setValue(packageId, 'courseId', courseId);
        }
        if (sectionId && sectionId > 0) {
            this.statusCache.setValue(packageId, 'sectionId', sectionId);
        }
    };
    /**
     * Treat the result of the check updates WS call.
     *
     * @param {any[]} toCheckList List of modules to check (from createToCheckList).
     * @param {any} response WS call response.
     * @param {any} result Object where to store the result.
     * @param {number} [previousTime] Time of the previous check updates execution. If set, modules downloaded
     *                                after this time will be ignored.
     * @return {any} Result.
     */
    CoreCourseModulePrefetchDelegate.prototype.treatCheckUpdatesResult = function (toCheckList, response, result, previousTime) {
        // Format the response to index it by module ID.
        this.utils.arrayToObject(response.instances, 'id', result);
        // Treat warnings, adding the not supported modules.
        response.warnings.forEach(function (warning) {
            if (warning.warningcode == 'missingcallback') {
                result[warning.itemid] = false;
            }
        });
        if (previousTime) {
            // Remove from the list the modules downloaded after previousTime.
            toCheckList.forEach(function (entry) {
                if (result[entry.id] && entry.since > previousTime) {
                    delete result[entry.id];
                }
            });
        }
        return result;
    };
    /**
     * Update the status of a module in the "cache".
     *
     * @param {string} status New status.
     * @param {string} component Package's component.
     * @param {string|number} [componentId] An ID to use in conjunction with the component.
     * @param {number} [courseId] Course ID of the module.
     * @param {number} [sectionId] Section ID of the module.
     */
    CoreCourseModulePrefetchDelegate.prototype.updateStatusCache = function (status, component, componentId, courseId, sectionId) {
        var packageId = this.filepoolProvider.getPackageId(component, componentId), cachedStatus = this.statusCache.getValue(packageId, 'status', true);
        var notify;
        // If the status has changed, notify that the section has changed.
        notify = typeof cachedStatus != 'undefined' && cachedStatus !== status;
        // If courseId/sectionId is set, store it.
        this.storeCourseAndSection(packageId, courseId, sectionId);
        if (notify) {
            if (!courseId) {
                courseId = this.statusCache.getValue(packageId, 'courseId', true);
            }
            if (!sectionId) {
                sectionId = this.statusCache.getValue(packageId, 'sectionId', true);
            }
            // Invalidate and set again.
            this.statusCache.invalidate(packageId);
            this.statusCache.setValue(packageId, 'status', status);
            if (sectionId) {
                this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_1__providers_events__["a" /* CoreEventsProvider */].SECTION_STATUS_CHANGED, {
                    sectionId: sectionId,
                    courseId: courseId
                }, this.sitesProvider.getCurrentSiteId());
            }
        }
        else {
            this.statusCache.setValue(packageId, 'status', status);
        }
    };
    CoreCourseModulePrefetchDelegate = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_4__providers_logger__["a" /* CoreLoggerProvider */], __WEBPACK_IMPORTED_MODULE_5__providers_sites__["a" /* CoreSitesProvider */], __WEBPACK_IMPORTED_MODULE_7__providers_utils_utils__["a" /* CoreUtilsProvider */],
            __WEBPACK_IMPORTED_MODULE_8__course__["a" /* CoreCourseProvider */], __WEBPACK_IMPORTED_MODULE_3__providers_filepool__["a" /* CoreFilepoolProvider */],
            __WEBPACK_IMPORTED_MODULE_6__providers_utils_time__["a" /* CoreTimeUtilsProvider */], __WEBPACK_IMPORTED_MODULE_2__providers_file__["a" /* CoreFileProvider */],
            __WEBPACK_IMPORTED_MODULE_1__providers_events__["a" /* CoreEventsProvider */]])
    ], CoreCourseModulePrefetchDelegate);
    return CoreCourseModulePrefetchDelegate;
}(__WEBPACK_IMPORTED_MODULE_13__classes_delegate__["a" /* CoreDelegate */]));

//# sourceMappingURL=module-prefetch-delegate.js.map

/***/ }),
/* 49 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreContentLinksHandlerBase; });
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/**
 * Base handler to be registered in CoreContentLinksHandler. It is useful to minimize the amount of
 * functions that handlers need to implement.
 *
 * It allows you to specify a "pattern" (RegExp) that will be used to check if the handler handles a URL and to get its site URL.
 */
var CoreContentLinksHandlerBase = /** @class */ (function () {
    function CoreContentLinksHandlerBase() {
        /**
         * A name to identify the handler.
         * @type {string}
         */
        this.name = 'CoreContentLinksHandlerBase';
        /**
         * Handler's priority. The highest priority is treated first.
         * @type {number}
         */
        this.priority = 0;
        /**
         * Whether the isEnabled function should be called for all the users in a site. It should be true only if the isEnabled call
         * can return different values for different users in same site.
         * @type {boolean}
         */
        this.checkAllUsers = false;
        /**
         * Name of the feature this handler is related to.
         * It will be used to check if the feature is disabled (@see CoreSite.isFeatureDisabled).
         * @type {string}
         */
        this.featureName = '';
        // Nothing to do.
    }
    /**
     * Get the list of actions for a link (url).
     *
     * @param {string[]} siteIds List of sites the URL belongs to.
     * @param {string} url The URL to treat.
     * @param {any} params The params of the URL. E.g. 'mysite.com?id=1' -> {id: 1}
     * @param {number} [courseId] Course ID related to the URL. Optional but recommended.
     * @return {CoreContentLinksAction[]|Promise<CoreContentLinksAction[]>} List of (or promise resolved with list of) actions.
     */
    CoreContentLinksHandlerBase.prototype.getActions = function (siteIds, url, params, courseId) {
        return [];
    };
    /**
     * Check if a URL is handled by this handler.
     *
     * @param {string} url The URL to check.
     * @return {boolean} Whether the URL is handled by this handler
     */
    CoreContentLinksHandlerBase.prototype.handles = function (url) {
        return this.pattern && url.search(this.pattern) >= 0;
    };
    /**
     * If the URL is handled by this handler, return the site URL.
     *
     * @param {string} url The URL to check.
     * @return {string} Site URL if it is handled, undefined otherwise.
     */
    CoreContentLinksHandlerBase.prototype.getSiteUrl = function (url) {
        if (this.pattern) {
            var position = url.search(this.pattern);
            if (position > -1) {
                return url.substr(0, position);
            }
        }
    };
    /**
     * Check if the handler is enabled for a certain site (site + user) and a URL.
     * If not defined, defaults to true.
     *
     * @param {string} siteId The site ID.
     * @param {string} url The URL to treat.
     * @param {any} params The params of the URL. E.g. 'mysite.com?id=1' -> {id: 1}
     * @param {number} [courseId] Course ID related to the URL. Optional but recommended.
     * @return {boolean|Promise<boolean>} Whether the handler is enabled for the URL and site.
     */
    CoreContentLinksHandlerBase.prototype.isEnabled = function (siteId, url, params, courseId) {
        return true;
    };
    return CoreContentLinksHandlerBase;
}());

//# sourceMappingURL=base-handler.js.map

/***/ }),
/* 50 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return RenderType_CoreLoadingComponent; });
/* harmony export (immutable) */ __webpack_exports__["b"] = View_CoreLoadingComponent_0;
/* unused harmony export View_CoreLoadingComponent_Host_0 */
/* unused harmony export CoreLoadingComponentNgFactory */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_ionic_angular_components_spinner_spinner_ngfactory__ = __webpack_require__(128);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_ionic_angular_components_spinner_spinner__ = __webpack_require__(112);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ionic_angular_config_config__ = __webpack_require__(7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__angular_common__ = __webpack_require__(8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__loading__ = __webpack_require__(47);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__ngx_translate_core_src_translate_service__ = __webpack_require__(18);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__providers_events__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__providers_utils_utils__ = __webpack_require__(2);
/**
 * @fileoverview This file was generated by the Angular template compiler. Do not edit.
 *
 * @suppress {suspiciousCode,uselessCode,missingProperties,missingOverride,checkTypes}
 * tslint:disable
 */ 









var styles_CoreLoadingComponent = [];
var RenderType_CoreLoadingComponent = __WEBPACK_IMPORTED_MODULE_0__angular_core__["_29" /* ɵcrt */]({ encapsulation: 2, styles: styles_CoreLoadingComponent, data: { "animation": [{ type: 7, name: "coreShowHideAnimation", definitions: [{ type: 1, expr: ":enter", animation: [{ type: 6, styles: { opacity: 0 }, offset: null }, { type: 4, styles: { type: 6, styles: { opacity: 1 }, offset: null }, timings: "500ms ease-in-out" }], options: null }, { type: 1, expr: ":leave", animation: [{ type: 6, styles: { opacity: 1 }, offset: null }, { type: 4, styles: { type: 6, styles: { opacity: 0 }, offset: null }, timings: "500ms ease-in-out" }], options: null }], options: {} }] } });

function View_CoreLoadingComponent_2(_l) { return __WEBPACK_IMPORTED_MODULE_0__angular_core__["_57" /* ɵvid */](0, [(_l()(), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_31" /* ɵeld */](0, 0, null, null, 1, "p", [["class", "core-loading-message"], ["role", "status"]], null, null, null, null, null)), (_l()(), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_55" /* ɵted */](1, null, ["", ""]))], null, function (_ck, _v) { var _co = _v.component; var currVal_0 = _co.message; _ck(_v, 1, 0, currVal_0); }); }
function View_CoreLoadingComponent_1(_l) { return __WEBPACK_IMPORTED_MODULE_0__angular_core__["_57" /* ɵvid */](0, [(_l()(), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_31" /* ɵeld */](0, 0, null, null, 10, "div", [["class", "core-loading-container"], ["role", "status"]], [[24, "@coreShowHideAnimation", 0]], null, null, null, null)), (_l()(), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_55" /* ɵted */](-1, null, ["\n    "])), (_l()(), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_31" /* ɵeld */](2, 0, null, null, 7, "span", [["class", "core-loading-spinner"]], null, null, null, null, null)), (_l()(), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_55" /* ɵted */](-1, null, ["\n        "])), (_l()(), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_31" /* ɵeld */](4, 0, null, null, 1, "ion-spinner", [], [[2, "spinner-paused", null]], null, null, __WEBPACK_IMPORTED_MODULE_1__node_modules_ionic_angular_components_spinner_spinner_ngfactory__["b" /* View_Spinner_0 */], __WEBPACK_IMPORTED_MODULE_1__node_modules_ionic_angular_components_spinner_spinner_ngfactory__["a" /* RenderType_Spinner */])), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_30" /* ɵdid */](5, 114688, null, 0, __WEBPACK_IMPORTED_MODULE_2_ionic_angular_components_spinner_spinner__["a" /* Spinner */], [__WEBPACK_IMPORTED_MODULE_3_ionic_angular_config_config__["a" /* Config */], __WEBPACK_IMPORTED_MODULE_0__angular_core__["t" /* ElementRef */], __WEBPACK_IMPORTED_MODULE_0__angular_core__["V" /* Renderer */]], null, null), (_l()(), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_55" /* ɵted */](-1, null, ["\n        "])), (_l()(), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_26" /* ɵand */](16777216, null, null, 1, null, View_CoreLoadingComponent_2)), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_30" /* ɵdid */](8, 16384, null, 0, __WEBPACK_IMPORTED_MODULE_4__angular_common__["k" /* NgIf */], [__WEBPACK_IMPORTED_MODULE_0__angular_core__["_11" /* ViewContainerRef */], __WEBPACK_IMPORTED_MODULE_0__angular_core__["_6" /* TemplateRef */]], { ngIf: [0, "ngIf"] }, null), (_l()(), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_55" /* ɵted */](-1, null, ["\n    "])), (_l()(), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_55" /* ɵted */](-1, null, ["\n"]))], function (_ck, _v) { var _co = _v.component; _ck(_v, 5, 0); var currVal_2 = _co.message; _ck(_v, 8, 0, currVal_2); }, function (_ck, _v) { var currVal_0 = undefined; _ck(_v, 0, 0, currVal_0); var currVal_1 = __WEBPACK_IMPORTED_MODULE_0__angular_core__["_44" /* ɵnov */](_v, 5)._paused; _ck(_v, 4, 0, currVal_1); }); }
function View_CoreLoadingComponent_3(_l) { return __WEBPACK_IMPORTED_MODULE_0__angular_core__["_57" /* ɵvid */](0, [__WEBPACK_IMPORTED_MODULE_0__angular_core__["_43" /* ɵncd */](null, 0), (_l()(), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_26" /* ɵand */](0, null, null, 0))], null, null); }
function View_CoreLoadingComponent_0(_l) { return __WEBPACK_IMPORTED_MODULE_0__angular_core__["_57" /* ɵvid */](0, [__WEBPACK_IMPORTED_MODULE_0__angular_core__["_52" /* ɵqud */](402653184, 1, { content: 0 }), (_l()(), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_26" /* ɵand */](16777216, null, null, 1, null, View_CoreLoadingComponent_1)), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_30" /* ɵdid */](2, 16384, null, 0, __WEBPACK_IMPORTED_MODULE_4__angular_common__["k" /* NgIf */], [__WEBPACK_IMPORTED_MODULE_0__angular_core__["_11" /* ViewContainerRef */], __WEBPACK_IMPORTED_MODULE_0__angular_core__["_6" /* TemplateRef */]], { ngIf: [0, "ngIf"] }, null), (_l()(), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_55" /* ɵted */](-1, null, ["\n"])), (_l()(), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_31" /* ɵeld */](4, 0, [[1, 0], ["content", 1]], null, 4, "div", [["class", "core-loading-content"]], [[8, "id", 0], [1, "aria-busy", 0]], null, null, null, null)), (_l()(), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_55" /* ɵted */](-1, null, ["\n    "])), (_l()(), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_26" /* ɵand */](16777216, null, null, 1, null, View_CoreLoadingComponent_3)), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_30" /* ɵdid */](7, 16384, null, 0, __WEBPACK_IMPORTED_MODULE_4__angular_common__["k" /* NgIf */], [__WEBPACK_IMPORTED_MODULE_0__angular_core__["_11" /* ViewContainerRef */], __WEBPACK_IMPORTED_MODULE_0__angular_core__["_6" /* TemplateRef */]], { ngIf: [0, "ngIf"] }, null), (_l()(), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_55" /* ɵted */](-1, null, ["\n"]))], function (_ck, _v) { var _co = _v.component; var currVal_0 = !_co.hideUntil; _ck(_v, 2, 0, currVal_0); var currVal_3 = _co.hideUntil; _ck(_v, 7, 0, currVal_3); }, function (_ck, _v) { var _co = _v.component; var currVal_1 = _co.uniqueId; var currVal_2 = _co.hideUntil; _ck(_v, 4, 0, currVal_1, currVal_2); }); }
function View_CoreLoadingComponent_Host_0(_l) { return __WEBPACK_IMPORTED_MODULE_0__angular_core__["_57" /* ɵvid */](0, [(_l()(), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_31" /* ɵeld */](0, 0, null, null, 1, "core-loading", [], null, null, null, View_CoreLoadingComponent_0, RenderType_CoreLoadingComponent)), __WEBPACK_IMPORTED_MODULE_0__angular_core__["_30" /* ɵdid */](1, 638976, null, 0, __WEBPACK_IMPORTED_MODULE_5__loading__["a" /* CoreLoadingComponent */], [__WEBPACK_IMPORTED_MODULE_6__ngx_translate_core_src_translate_service__["a" /* TranslateService */], __WEBPACK_IMPORTED_MODULE_0__angular_core__["t" /* ElementRef */], __WEBPACK_IMPORTED_MODULE_7__providers_events__["a" /* CoreEventsProvider */], __WEBPACK_IMPORTED_MODULE_8__providers_utils_utils__["a" /* CoreUtilsProvider */]], null, null)], function (_ck, _v) { _ck(_v, 1, 0); }, null); }
var CoreLoadingComponentNgFactory = __WEBPACK_IMPORTED_MODULE_0__angular_core__["_27" /* ɵccf */]("core-loading", __WEBPACK_IMPORTED_MODULE_5__loading__["a" /* CoreLoadingComponent */], View_CoreLoadingComponent_Host_0, { hideUntil: "hideUntil", message: "message" }, {}, ["*"]);

//# sourceMappingURL=loading.ngfactory.js.map

/***/ }),
/* 51 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreCoursesProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__providers_events__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__providers_logger__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_sites__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__classes_site__ = __webpack_require__(52);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};





/**
 * Service that provides some features regarding lists of courses and categories.
 */
var CoreCoursesProvider = /** @class */ (function () {
    function CoreCoursesProvider(logger, sitesProvider, eventsProvider) {
        this.sitesProvider = sitesProvider;
        this.eventsProvider = eventsProvider;
        this.ROOT_CACHE_KEY = 'mmCourses:';
        this.logger = logger.getInstance('CoreCoursesProvider');
    }
    CoreCoursesProvider_1 = CoreCoursesProvider;
    /**
     * Whether current site supports getting course options.
     *
     * @return {boolean} Whether current site supports getting course options.
     */
    CoreCoursesProvider.prototype.canGetAdminAndNavOptions = function () {
        return this.sitesProvider.wsAvailableInCurrentSite('core_course_get_user_navigation_options') &&
            this.sitesProvider.wsAvailableInCurrentSite('core_course_get_user_administration_options');
    };
    /**
     * Get categories. They can be filtered by id.
     *
     * @param {number} categoryId Category ID to get.
     * @param {boolean} [addSubcategories] If it should add subcategories to the list.
     * @param {string} [siteId] Site to get the courses from. If not defined, use current site.
     * @return {Promise<any[]>} Promise resolved with the categories.
     */
    CoreCoursesProvider.prototype.getCategories = function (categoryId, addSubcategories, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            // Get parent when id is the root category.
            var criteriaKey = categoryId == 0 ? 'parent' : 'id', data = {
                criteria: [
                    { key: criteriaKey, value: categoryId }
                ],
                addsubcategories: addSubcategories ? 1 : 0
            }, preSets = {
                cacheKey: _this.getCategoriesCacheKey(categoryId, addSubcategories),
                updateFrequency: __WEBPACK_IMPORTED_MODULE_4__classes_site__["a" /* CoreSite */].FREQUENCY_RARELY
            };
            return site.read('core_course_get_categories', data, preSets);
        });
    };
    /**
     * Get cache key for get categories methods WS call.
     *
     * @param {number} categoryId Category ID to get.
     * @param {boolean} [addSubcategories] If add subcategories to the list.
     * @return {string} Cache key.
     */
    CoreCoursesProvider.prototype.getCategoriesCacheKey = function (categoryId, addSubcategories) {
        return this.ROOT_CACHE_KEY + 'categories:' + categoryId + ':' + !!addSubcategories;
    };
    /**
     * Given a list of course IDs to get course admin and nav options, return the list of courseIds to use.
     *
     * @param {number[]} courseIds Course IDs.
     * @param {string} [siteId] Site Id. If not defined, use current site.
     * @return {Promise}            Promise resolved with the list of course IDs.
     */
    CoreCoursesProvider.prototype.getCourseIdsForAdminAndNavOptions = function (courseIds, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var siteHomeId = site.getSiteHomeId();
            if (courseIds.length == 1) {
                // Only 1 course, check if it belongs to the user courses. If so, use all user courses.
                return _this.getUserCourses(true, siteId).then(function (courses) {
                    var courseId = courseIds[0];
                    var useAllCourses = false;
                    if (courseId == siteHomeId) {
                        // It's site home, use all courses.
                        useAllCourses = true;
                    }
                    else {
                        for (var i = 0; i < courses.length; i++) {
                            if (courses[i].id == courseId) {
                                useAllCourses = true;
                                break;
                            }
                        }
                    }
                    if (useAllCourses) {
                        // User is enrolled, retrieve all the courses.
                        courseIds = courses.map(function (course) {
                            return course.id;
                        });
                        // Always add the site home ID.
                        courseIds.push(siteHomeId);
                        // Sort the course IDs.
                        courseIds.sort(function (a, b) {
                            return b - a;
                        });
                    }
                    return courseIds;
                }).catch(function () {
                    // Ignore errors.
                    return courseIds;
                });
            }
            else {
                if (courseIds.length > 1 && courseIds.indexOf(siteHomeId) == -1) {
                    courseIds.push(siteHomeId);
                }
                // Sort the course IDs.
                courseIds.sort(function (a, b) {
                    return b - a;
                });
                return courseIds;
            }
        });
    };
    /**
     * Check if download a whole course is disabled in a certain site.
     *
     * @param {string} [siteId] Site Id. If not defined, use current site.
     * @return {Promise<boolean>} Promise resolved with true if disabled, rejected or resolved with false otherwise.
     */
    CoreCoursesProvider.prototype.isDownloadCourseDisabled = function (siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return _this.isDownloadCoursesDisabledInSite(site);
        });
    };
    /**
     * Check if download a whole course is disabled in a certain site.
     *
     * @param {CoreSite} [site] Site. If not defined, use current site.
     * @return {boolean} Whether it's disabled.
     */
    CoreCoursesProvider.prototype.isDownloadCourseDisabledInSite = function (site) {
        site = site || this.sitesProvider.getCurrentSite();
        return site.isOfflineDisabled() || site.isFeatureDisabled('NoDelegate_CoreCourseDownload');
    };
    /**
     * Check if download all courses is disabled in a certain site.
     *
     * @param {string} [siteId] Site Id. If not defined, use current site.
     * @return {Promise<boolean>} Promise resolved with true if disabled, rejected or resolved with false otherwise.
     */
    CoreCoursesProvider.prototype.isDownloadCoursesDisabled = function (siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return _this.isDownloadCoursesDisabledInSite(site);
        });
    };
    /**
     * Check if download all courses is disabled in a certain site.
     *
     * @param {CoreSite} [site] Site. If not defined, use current site.
     * @return {boolean} Whether it's disabled.
     */
    CoreCoursesProvider.prototype.isDownloadCoursesDisabledInSite = function (site) {
        site = site || this.sitesProvider.getCurrentSite();
        return site.isOfflineDisabled() || site.isFeatureDisabled('NoDelegate_CoreCoursesDownload');
    };
    /**
     * Check if My Courses is disabled in a certain site.
     *
     * @param {string} [siteId] Site Id. If not defined, use current site.
     * @return {Promise<boolean>} Promise resolved with true if disabled, rejected or resolved with false otherwise.
     */
    CoreCoursesProvider.prototype.isMyCoursesDisabled = function (siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return _this.isMyCoursesDisabledInSite(site);
        });
    };
    /**
     * Check if My Courses is disabled in a certain site.
     *
     * @param {CoreSite} [site] Site. If not defined, use current site.
     * @return {boolean} Whether it's disabled.
     */
    CoreCoursesProvider.prototype.isMyCoursesDisabledInSite = function (site) {
        site = site || this.sitesProvider.getCurrentSite();
        return site.isFeatureDisabled('CoreMainMenuDelegate_CoreCourses');
    };
    /**
     * Check if Search Courses is disabled in a certain site.
     *
     * @param {string} [siteId] Site Id. If not defined, use current site.
     * @return {Promise<boolean>} Promise resolved with true if disabled, rejected or resolved with false otherwise.
     */
    CoreCoursesProvider.prototype.isSearchCoursesDisabled = function (siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return _this.isSearchCoursesDisabledInSite(site);
        });
    };
    /**
     * Check if Search Courses is disabled in a certain site.
     *
     * @param {CoreSite} [site] Site. If not defined, use current site.
     * @return {boolean} Whether it's disabled.
     */
    CoreCoursesProvider.prototype.isSearchCoursesDisabledInSite = function (site) {
        site = site || this.sitesProvider.getCurrentSite();
        return site.isFeatureDisabled('CoreCourseOptionsDelegate_search');
    };
    /**
     * Get course.
     *
     * @param {number} id ID of the course to get.
     * @param {string} [siteId] Site to get the courses from. If not defined, use current site.
     * @return {Promise<any>} Promise resolved with the course.
     */
    CoreCoursesProvider.prototype.getCourse = function (id, siteId) {
        return this.getCourses([id], siteId).then(function (courses) {
            if (courses && courses.length > 0) {
                return courses[0];
            }
            return Promise.reject(null);
        });
    };
    /**
     * Get the enrolment methods from a course.
     *
     * @param {number} id ID of the course.
     * @param {string} [siteId] Site ID. If not defined, use current site.
     * @return {Promise<any[]} Promise resolved with the methods.
     */
    CoreCoursesProvider.prototype.getCourseEnrolmentMethods = function (id, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var params = {
                courseid: id
            }, preSets = {
                cacheKey: _this.getCourseEnrolmentMethodsCacheKey(id),
                updateFrequency: __WEBPACK_IMPORTED_MODULE_4__classes_site__["a" /* CoreSite */].FREQUENCY_RARELY
            };
            return site.read('core_enrol_get_course_enrolment_methods', params, preSets);
        });
    };
    /**
     * Get cache key for get course enrolment methods WS call.
     *
     * @param {number} id Course ID.
     * @return {string} Cache key.
     */
    CoreCoursesProvider.prototype.getCourseEnrolmentMethodsCacheKey = function (id) {
        return this.ROOT_CACHE_KEY + 'enrolmentmethods:' + id;
    };
    /**
     * Get info from a course guest enrolment method.
     *
     * @param {number} instanceId Guest instance ID.
     * @param {string} [siteId] Site ID. If not defined, use current site.
     * @return {Promise<any>} Promise resolved when the info is retrieved.
     */
    CoreCoursesProvider.prototype.getCourseGuestEnrolmentInfo = function (instanceId, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var params = {
                instanceid: instanceId
            }, preSets = {
                cacheKey: _this.getCourseGuestEnrolmentInfoCacheKey(instanceId),
                updateFrequency: __WEBPACK_IMPORTED_MODULE_4__classes_site__["a" /* CoreSite */].FREQUENCY_RARELY
            };
            return site.read('enrol_guest_get_instance_info', params, preSets).then(function (response) {
                return response.instanceinfo;
            });
        });
    };
    /**
     * Get cache key for get course guest enrolment methods WS call.
     *
     * @param {number} instanceId Guest instance ID.
     * @return {string} Cache key.
     */
    CoreCoursesProvider.prototype.getCourseGuestEnrolmentInfoCacheKey = function (instanceId) {
        return this.ROOT_CACHE_KEY + 'guestinfo:' + instanceId;
    };
    /**
     * Get courses.
     * Warning: if the user doesn't have permissions to view some of the courses passed the WS call will fail.
     * The user must be able to view ALL the courses passed.
     *
     * @param {number[]} ids List of IDs of the courses to get.
     * @param {string} [siteId] Site to get the courses from. If not defined, use current site.
     * @return {Promise<any[]>}  Promise resolved with the courses.
     */
    CoreCoursesProvider.prototype.getCourses = function (ids, siteId) {
        var _this = this;
        if (!Array.isArray(ids)) {
            return Promise.reject(null);
        }
        else if (ids.length === 0) {
            return Promise.resolve([]);
        }
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var data = {
                options: {
                    ids: ids
                }
            }, preSets = {
                cacheKey: _this.getCoursesCacheKey(ids),
                updateFrequency: __WEBPACK_IMPORTED_MODULE_4__classes_site__["a" /* CoreSite */].FREQUENCY_RARELY
            };
            return site.read('core_course_get_courses', data, preSets);
        });
    };
    /**
     * Get cache key for get courses WS call.
     *
     * @param {number[]} ids Courses IDs.
     * @return {string} Cache key.
     */
    CoreCoursesProvider.prototype.getCoursesCacheKey = function (ids) {
        return this.ROOT_CACHE_KEY + 'course:' + JSON.stringify(ids);
    };
    /**
     * This function is meant to decrease WS calls.
     * When requesting a single course that belongs to enrolled courses, request all enrolled courses because
     * the WS call is probably cached.
     *
     * @param {string} [field] The field to search.
     * @param {any} [value] The value to match.
     * @param {string} [siteId] Site ID. If not defined, use current site.
     * @return {Promise<{field: string, value: any}>} Promise resolved with the field and value to use.
     */
    CoreCoursesProvider.prototype.fixCoursesByFieldParams = function (field, value, siteId) {
        if (field == 'id' || field == 'ids') {
            var courseIds = String(value).split(',');
            // Use the same optimization as in get admin and nav options. This will return the course IDs to use.
            return this.getCourseIdsForAdminAndNavOptions(courseIds, siteId).then(function (courseIds) {
                if (courseIds.length > 1) {
                    return { field: 'ids', value: courseIds.join(',') };
                }
                else {
                    return { field: 'id', value: Number(courseIds[0]) };
                }
            });
        }
        else {
            // Nothing to do.
            return Promise.resolve({ field: field, value: value });
        }
    };
    /**
     * Get the first course returned by getCoursesByField.
     *
     * @param {string} [field] The field to search. Can be left empty for all courses or:
     *                             id: course id.
     *                             ids: comma separated course ids.
     *                             shortname: course short name.
     *                             idnumber: course id number.
     *                             category: category id the course belongs to.
     * @param {any} [value] The value to match.
     * @param {string} [siteId] Site ID. If not defined, use current site.
     * @return {Promise<any>} Promise resolved with the first course.
     * @since 3.2
     */
    CoreCoursesProvider.prototype.getCourseByField = function (field, value, siteId) {
        return this.getCoursesByField(field, value, siteId).then(function (courses) {
            if (courses && courses.length > 0) {
                return courses[0];
            }
            return Promise.reject(null);
        });
    };
    /**
     * Get courses. They can be filtered by field.
     *
     * @param {string} [field] The field to search. Can be left empty for all courses or:
     *                             id: course id.
     *                             ids: comma separated course ids.
     *                             shortname: course short name.
     *                             idnumber: course id number.
     *                             category: category id the course belongs to.
     * @param {any} [value] The value to match.
     * @param {string} [siteId] Site ID. If not defined, use current site.
     * @return {Promise<any[]>} Promise resolved with the courses.
     * @since 3.2
     */
    CoreCoursesProvider.prototype.getCoursesByField = function (field, value, siteId) {
        var _this = this;
        siteId = siteId || this.sitesProvider.getCurrentSiteId();
        var originalValue = value;
        var hasChanged = false;
        return this.fixCoursesByFieldParams(field, value, siteId).then(function (result) {
            hasChanged = result.field != field || result.value != value;
            field = result.field;
            value = result.value;
            return _this.sitesProvider.getSite(siteId);
        }).then(function (site) {
            var data = {
                field: field || '',
                value: field ? value : ''
            }, preSets = {
                cacheKey: _this.getCoursesByFieldCacheKey(field, value),
                updateFrequency: __WEBPACK_IMPORTED_MODULE_4__classes_site__["a" /* CoreSite */].FREQUENCY_RARELY
            };
            return site.read('core_course_get_courses_by_field', data, preSets).then(function (courses) {
                if (courses.courses) {
                    if (field == 'ids' && hasChanged) {
                        // The list of courses requestes was changed to optimize it.
                        // Return only the ones that were being requested.
                        var courseIds_1 = String(originalValue).split(','), finalCourses_1 = [];
                        courses.courses.forEach(function (course) {
                            var position = courseIds_1.indexOf(String(course.id));
                            if (position != -1) {
                                // Course is in the original list, take it.
                                finalCourses_1.push(course);
                                courseIds_1.splice(position, 1);
                            }
                        });
                        courses.courses = finalCourses_1;
                    }
                    // Courses will be sorted using sortorder if avalaible.
                    return courses.courses.sort(function (a, b) {
                        if (typeof a.sortorder == 'undefined' && typeof b.sortorder == 'undefined') {
                            return b.id - a.id;
                        }
                        if (typeof a.sortorder == 'undefined') {
                            return 1;
                        }
                        if (typeof b.sortorder == 'undefined') {
                            return -1;
                        }
                        return a.sortorder - b.sortorder;
                    });
                }
                return Promise.reject(null);
            });
        });
    };
    /**
     * Get cache key for get courses WS call.
     *
     * @param {string} [field] The field to search.
     * @param {any} [value] The value to match.
     * @return {string} Cache key.
     */
    CoreCoursesProvider.prototype.getCoursesByFieldCacheKey = function (field, value) {
        field = field || '';
        value = field ? value : '';
        return this.ROOT_CACHE_KEY + 'coursesbyfield:' + field + ':' + value;
    };
    /**
     * Check if get courses by field WS is available in a certain site.
     *
     * @param {CoreSite} [site] Site to check.
     * @return {boolean} Whether get courses by field is available.
     * @since 3.2
     */
    CoreCoursesProvider.prototype.isGetCoursesByFieldAvailable = function (site) {
        site = site || this.sitesProvider.getCurrentSite();
        return site.wsAvailable('core_course_get_courses_by_field');
    };
    /**
     * Check if get courses by field WS is available in a certain site, by site ID.
     *
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<boolean>} Promise resolved with boolean: whether get courses by field is available.
     * @since 3.2
     */
    CoreCoursesProvider.prototype.isGetCoursesByFieldAvailableInSite = function (siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return _this.isGetCoursesByFieldAvailable(site);
        });
    };
    /**
     * Get the navigation and administration options for the given courses.
     *
     * @param {number[]} courseIds IDs of courses to get.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<{navOptions: any, admOptions: any}>} Promise resolved with the options for each course.
     */
    CoreCoursesProvider.prototype.getCoursesAdminAndNavOptions = function (courseIds, siteId) {
        var _this = this;
        siteId = siteId || this.sitesProvider.getCurrentSiteId();
        // Get the list of courseIds to use based on the param.
        return this.getCourseIdsForAdminAndNavOptions(courseIds, siteId).then(function (courseIds) {
            var promises = [];
            var navOptions, admOptions;
            // Get user navigation and administration options.
            promises.push(_this.getUserNavigationOptions(courseIds, siteId).catch(function () {
                // Couldn't get it, return empty options.
                return {};
            }).then(function (options) {
                navOptions = options;
            }));
            promises.push(_this.getUserAdministrationOptions(courseIds, siteId).catch(function () {
                // Couldn't get it, return empty options.
                return {};
            }).then(function (options) {
                admOptions = options;
            }));
            return Promise.all(promises).then(function () {
                return { navOptions: navOptions, admOptions: admOptions };
            });
        });
    };
    /**
     * Get the common part of the cache keys for user administration options WS calls.
     *
     * @return {string} Cache key.
     */
    CoreCoursesProvider.prototype.getUserAdministrationOptionsCommonCacheKey = function () {
        return this.ROOT_CACHE_KEY + 'administrationOptions:';
    };
    /**
     * Get cache key for get user administration options WS call.
     *
     * @param {number[]} courseIds IDs of courses to get.
     * @return {string} Cache key.
     */
    CoreCoursesProvider.prototype.getUserAdministrationOptionsCacheKey = function (courseIds) {
        return this.getUserAdministrationOptionsCommonCacheKey() + courseIds.join(',');
    };
    /**
     * Get user administration options for a set of courses.
     *
     * @param {number[]} courseIds IDs of courses to get.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved with administration options for each course.
     */
    CoreCoursesProvider.prototype.getUserAdministrationOptions = function (courseIds, siteId) {
        var _this = this;
        if (!courseIds || courseIds.length == 0) {
            return Promise.resolve({});
        }
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var params = {
                courseids: courseIds
            }, preSets = {
                cacheKey: _this.getUserAdministrationOptionsCacheKey(courseIds),
                updateFrequency: __WEBPACK_IMPORTED_MODULE_4__classes_site__["a" /* CoreSite */].FREQUENCY_RARELY
            };
            return site.read('core_course_get_user_administration_options', params, preSets).then(function (response) {
                // Format returned data.
                return _this.formatUserAdminOrNavOptions(response.courses);
            });
        });
    };
    /**
     * Get the common part of the cache keys for user navigation options WS calls.
     *
     * @param {number[]} courseIds IDs of courses to get.
     * @return {string} Cache key.
     */
    CoreCoursesProvider.prototype.getUserNavigationOptionsCommonCacheKey = function () {
        return this.ROOT_CACHE_KEY + 'navigationOptions:';
    };
    /**
     * Get cache key for get user navigation options WS call.
     *
     * @return {string} Cache key.
     */
    CoreCoursesProvider.prototype.getUserNavigationOptionsCacheKey = function (courseIds) {
        return this.getUserNavigationOptionsCommonCacheKey() + courseIds.join(',');
    };
    /**
     * Get user navigation options for a set of courses.
     *
     * @param {number[]} courseIds IDs of courses to get.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved with navigation options for each course.
     */
    CoreCoursesProvider.prototype.getUserNavigationOptions = function (courseIds, siteId) {
        var _this = this;
        if (!courseIds || courseIds.length == 0) {
            return Promise.resolve({});
        }
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var params = {
                courseids: courseIds
            }, preSets = {
                cacheKey: _this.getUserNavigationOptionsCacheKey(courseIds),
                updateFrequency: __WEBPACK_IMPORTED_MODULE_4__classes_site__["a" /* CoreSite */].FREQUENCY_RARELY
            };
            return site.read('core_course_get_user_navigation_options', params, preSets).then(function (response) {
                // Format returned data.
                return _this.formatUserAdminOrNavOptions(response.courses);
            });
        });
    };
    /**
     * Format user navigation or administration options.
     *
     * @param {any[]} courses Navigation or administration options for each course.
     * @return {any} Formatted options.
     */
    CoreCoursesProvider.prototype.formatUserAdminOrNavOptions = function (courses) {
        var result = {};
        courses.forEach(function (course) {
            var options = {};
            if (course.options) {
                course.options.forEach(function (option) {
                    options[option.name] = option.available;
                });
            }
            result[course.id] = options;
        });
        return result;
    };
    /**
     * Get a course the user is enrolled in. This function relies on getUserCourses.
     * preferCache=true will try to speed up the response, but the data returned might not be updated.
     *
     * @param {number} id ID of the course to get.
     * @param {boolean} [preferCache] True if shouldn't call WS if data is cached, false otherwise.
     * @param {string} [siteId] Site to get the courses from. If not defined, use current site.
     * @return {Promise<any>} Promise resolved with the course.
     */
    CoreCoursesProvider.prototype.getUserCourse = function (id, preferCache, siteId) {
        if (!id) {
            return Promise.reject(null);
        }
        return this.getUserCourses(preferCache, siteId).then(function (courses) {
            var course;
            for (var i in courses) {
                if (courses[i].id == id) {
                    course = courses[i];
                    break;
                }
            }
            return course ? course : Promise.reject(null);
        });
    };
    /**
     * Get user courses.
     *
     * @param {boolean} [preferCache] True if shouldn't call WS if data is cached, false otherwise.
     * @param {string} [siteId] Site to get the courses from. If not defined, use current site.
     * @return {Promise<any[]>} Promise resolved with the courses.
     */
    CoreCoursesProvider.prototype.getUserCourses = function (preferCache, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var userId = site.getUserId(), data = {
                userid: userId
            }, preSets = {
                cacheKey: _this.getUserCoursesCacheKey(),
                getCacheUsingCacheKey: true,
                omitExpires: !!preferCache,
                updateFrequency: __WEBPACK_IMPORTED_MODULE_4__classes_site__["a" /* CoreSite */].FREQUENCY_RARELY
            };
            if (site.isVersionGreaterEqualThan('3.7')) {
                data.returnusercount = 0;
            }
            return site.read('core_enrol_get_users_courses', data, preSets).then(function (courses) {
                if (_this.userCoursesIds) {
                    // Check if the list of courses has changed.
                    var added_1 = [], removed_1 = [], previousIds = Object.keys(_this.userCoursesIds), currentIds_1 = {}; // Use an object to make it faster to search.
                    courses.forEach(function (course) {
                        currentIds_1[course.id] = true;
                        if (!_this.userCoursesIds[course.id]) {
                            // Course added.
                            added_1.push(course.id);
                        }
                    });
                    if (courses.length - added_1.length != previousIds.length) {
                        // A course was removed, check which one.
                        previousIds.forEach(function (id) {
                            if (!currentIds_1[id]) {
                                // Course removed.
                                removed_1.push(Number(id));
                            }
                        });
                    }
                    if (added_1.length || removed_1.length) {
                        // At least 1 course was added or removed, trigger the event.
                        _this.eventsProvider.trigger(CoreCoursesProvider_1.EVENT_MY_COURSES_CHANGED, {
                            added: added_1,
                            removed: removed_1
                        }, site.getId());
                    }
                    _this.userCoursesIds = currentIds_1;
                }
                else {
                    _this.userCoursesIds = {};
                    // Store the list of courses.
                    courses.forEach(function (course) {
                        _this.userCoursesIds[course.id] = true;
                    });
                }
                return courses;
            });
        });
    };
    /**
     * Get cache key for get user courses WS call.
     *
     * @return {string} Cache key.
     */
    CoreCoursesProvider.prototype.getUserCoursesCacheKey = function () {
        return this.ROOT_CACHE_KEY + 'usercourses';
    };
    /**
     * Invalidates get categories WS call.
     *
     * @param {number} categoryId Category ID to get.
     * @param {boolean} [addSubcategories] If it should add subcategories to the list.
     * @param {string} [siteId] Site Id. If not defined, use current site.
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreCoursesProvider.prototype.invalidateCategories = function (categoryId, addSubcategories, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.invalidateWsCacheForKey(_this.getCategoriesCacheKey(categoryId, addSubcategories));
        });
    };
    /**
     * Invalidates get course WS call.
     *
     * @param {number} id Course ID.
     * @param {string} [siteId] Site Id. If not defined, use current site.
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreCoursesProvider.prototype.invalidateCourse = function (id, siteId) {
        return this.invalidateCourses([id], siteId);
    };
    /**
     * Invalidates get course enrolment methods WS call.
     *
     * @param {number} id Course ID.
     * @param {string} [siteId] Site Id. If not defined, use current site.
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreCoursesProvider.prototype.invalidateCourseEnrolmentMethods = function (id, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.invalidateWsCacheForKey(_this.getCourseEnrolmentMethodsCacheKey(id));
        });
    };
    /**
     * Invalidates get course guest enrolment info WS call.
     *
     * @param {number} instanceId Guest instance ID.
     * @param {string} [siteId] Site Id. If not defined, use current site.
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreCoursesProvider.prototype.invalidateCourseGuestEnrolmentInfo = function (instanceId, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.invalidateWsCacheForKey(_this.getCourseGuestEnrolmentInfoCacheKey(instanceId));
        });
    };
    /**
     * Invalidates the navigation and administration options for the given courses.
     *
     * @param {number[]} courseIds IDs of courses to get.
     * @param {string} [siteId] Site ID to invalidate. If not defined, use current site.
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreCoursesProvider.prototype.invalidateCoursesAdminAndNavOptions = function (courseIds, siteId) {
        var _this = this;
        siteId = siteId || this.sitesProvider.getCurrentSiteId();
        return this.getCourseIdsForAdminAndNavOptions(courseIds, siteId).then(function (ids) {
            var promises = [];
            promises.push(_this.invalidateUserAdministrationOptionsForCourses(ids, siteId));
            promises.push(_this.invalidateUserNavigationOptionsForCourses(ids, siteId));
            return Promise.all(promises);
        });
    };
    /**
     * Invalidates get courses WS call.
     *
     * @param {number[]} ids Courses IDs.
     * @param {string} [siteId] Site Id. If not defined, use current site.
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreCoursesProvider.prototype.invalidateCourses = function (ids, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.invalidateWsCacheForKey(_this.getCoursesCacheKey(ids));
        });
    };
    /**
     * Invalidates get courses by field WS call.
     *
     * @param {string} [field] See getCoursesByField for info.
     * @param {any} [value] The value to match.
     * @param {string} [siteId] Site Id. If not defined, use current site.
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreCoursesProvider.prototype.invalidateCoursesByField = function (field, value, siteId) {
        var _this = this;
        siteId = siteId || this.sitesProvider.getCurrentSiteId();
        return this.fixCoursesByFieldParams(field, value, siteId).then(function (result) {
            field = result.field;
            value = result.value;
            return _this.sitesProvider.getSite(siteId);
        }).then(function (site) {
            return site.invalidateWsCacheForKey(_this.getCoursesByFieldCacheKey(field, value));
        });
    };
    /**
     * Invalidates all user administration options.
     *
     * @param {string} [siteId] Site ID to invalidate. If not defined, use current site.
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreCoursesProvider.prototype.invalidateUserAdministrationOptions = function (siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.invalidateWsCacheForKeyStartingWith(_this.getUserAdministrationOptionsCommonCacheKey());
        });
    };
    /**
     * Invalidates user administration options for certain courses.
     *
     * @param {number[]} courseIds IDs of courses.
     * @param {string} [siteId] Site ID to invalidate. If not defined, use current site.
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreCoursesProvider.prototype.invalidateUserAdministrationOptionsForCourses = function (courseIds, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.invalidateWsCacheForKey(_this.getUserAdministrationOptionsCacheKey(courseIds));
        });
    };
    /**
     * Invalidates get user courses WS call.
     *
     * @param {string} [siteId] Site ID to invalidate. If not defined, use current site.
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreCoursesProvider.prototype.invalidateUserCourses = function (siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.invalidateWsCacheForKey(_this.getUserCoursesCacheKey());
        });
    };
    /**
     * Invalidates all user navigation options.
     *
     * @param {string} [siteId] Site ID to invalidate. If not defined, use current site.
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreCoursesProvider.prototype.invalidateUserNavigationOptions = function (siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.invalidateWsCacheForKeyStartingWith(_this.getUserNavigationOptionsCommonCacheKey());
        });
    };
    /**
     * Invalidates user navigation options for certain courses.
     *
     * @param {number[]} courseIds IDs of courses.
     * @param {string} [siteId] Site ID to invalidate. If not defined, use current site.
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreCoursesProvider.prototype.invalidateUserNavigationOptionsForCourses = function (courseIds, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.invalidateWsCacheForKey(_this.getUserNavigationOptionsCacheKey(courseIds));
        });
    };
    /**
     * Check if WS to retrieve guest enrolment data is available.
     *
     * @return {boolean} Whether guest WS is available.
     */
    CoreCoursesProvider.prototype.isGuestWSAvailable = function () {
        var currentSite = this.sitesProvider.getCurrentSite();
        return currentSite && currentSite.wsAvailable('enrol_guest_get_instance_info');
    };
    /**
     * Search courses.
     *
     * @param {string} text Text to search.
     * @param {number} [page=0] Page to get.
     * @param {number} [perPage] Number of courses per page. Defaults to CoreCoursesProvider.SEARCH_PER_PAGE.
     * @param {string} [siteId] Site ID. If not defined, use current site.
     * @return {Promise<{total: number, courses: any[]}>} Promise resolved with the courses and the total of matches.
     */
    CoreCoursesProvider.prototype.search = function (text, page, perPage, siteId) {
        if (page === void 0) { page = 0; }
        perPage = perPage || CoreCoursesProvider_1.SEARCH_PER_PAGE;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var params = {
                criterianame: 'search',
                criteriavalue: text,
                page: page,
                perpage: perPage
            }, preSets = {
                getFromCache: false
            };
            return site.read('core_course_search_courses', params, preSets).then(function (response) {
                return { total: response.total, courses: response.courses };
            });
        });
    };
    /**
     * Self enrol current user in a certain course.
     *
     * @param {number} courseId Course ID.
     * @param {string} [password] Password to use.
     * @param {number} [instanceId] Enrol instance ID.
     * @param {string} [siteId] Site ID. If not defined, use current site.
     * @return {Promise<any>} Promise resolved if the user is enrolled. If the password is invalid, the promise is rejected
     *                        with an object with code = CoreCoursesProvider.ENROL_INVALID_KEY.
     */
    CoreCoursesProvider.prototype.selfEnrol = function (courseId, password, instanceId, siteId) {
        if (password === void 0) { password = ''; }
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var params = {
                courseid: courseId,
                password: password
            };
            if (instanceId) {
                params.instanceid = instanceId;
            }
            return site.write('enrol_self_enrol_user', params).then(function (response) {
                if (response) {
                    if (response.status) {
                        return true;
                    }
                    else if (response.warnings && response.warnings.length) {
                        var message_1;
                        response.warnings.forEach(function (warning) {
                            // Invalid password warnings.
                            if (warning.warningcode == '2' || warning.warningcode == '3' || warning.warningcode == '4') {
                                message_1 = warning.message;
                            }
                        });
                        if (message_1) {
                            return Promise.reject({ code: CoreCoursesProvider_1.ENROL_INVALID_KEY, message: message_1 });
                        }
                        else {
                            return Promise.reject(response.warnings[0]);
                        }
                    }
                }
                return Promise.reject(null);
            });
        });
    };
    /**
     * Set favourite property on a course.
     *
     * @param {number} courseId   Course ID.
     * @param {boolean} favourite If favourite or unfavourite.
     * @param {string} [siteId] Site ID. If not defined, use current site.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreCoursesProvider.prototype.setFavouriteCourse = function (courseId, favourite, siteId) {
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var params = {
                courses: [
                    {
                        id: courseId,
                        favourite: favourite ? 1 : 0
                    }
                ]
            };
            return site.write('core_course_set_favourite_courses', params);
        });
    };
    CoreCoursesProvider.SEARCH_PER_PAGE = 20;
    CoreCoursesProvider.ENROL_INVALID_KEY = 'CoreCoursesEnrolInvalidKey';
    CoreCoursesProvider.EVENT_MY_COURSES_CHANGED = 'courses_my_courses_changed'; // User course list changed while app is running.
    CoreCoursesProvider.EVENT_MY_COURSES_UPDATED = 'courses_my_courses_updated'; // A course was hidden/favourite, or user enroled in a course.
    CoreCoursesProvider.EVENT_MY_COURSES_REFRESHED = 'courses_my_courses_refreshed';
    CoreCoursesProvider.EVENT_DASHBOARD_DOWNLOAD_ENABLED_CHANGED = 'dashboard_download_enabled_changed';
    CoreCoursesProvider = CoreCoursesProvider_1 = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_2__providers_logger__["a" /* CoreLoggerProvider */], __WEBPACK_IMPORTED_MODULE_3__providers_sites__["a" /* CoreSitesProvider */], __WEBPACK_IMPORTED_MODULE_1__providers_events__["a" /* CoreEventsProvider */]])
    ], CoreCoursesProvider);
    return CoreCoursesProvider;
    var CoreCoursesProvider_1;
}());

//# sourceMappingURL=courses.js.map

/***/ }),
/* 52 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreSite; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__ngx_translate_core__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_common_http__ = __webpack_require__(263);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__providers_app__ = __webpack_require__(9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_db__ = __webpack_require__(424);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__providers_events__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__providers_file__ = __webpack_require__(53);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__providers_logger__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__providers_ws__ = __webpack_require__(202);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__providers_utils_dom__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__providers_utils_text__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__providers_utils_time__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__providers_utils_url__ = __webpack_require__(23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__providers_utils_utils__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__core_constants__ = __webpack_require__(40);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14__configconstants__ = __webpack_require__(119);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15_ts_md5_dist_md5__ = __webpack_require__(203);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15_ts_md5_dist_md5___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_15_ts_md5_dist_md5__);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
















/**
 * Class that represents a site (combination of site + user).
 * It will have all the site data and provide utility functions regarding a site.
 * To add tables to the site's database, please use CoreSitesProvider.createTablesFromSchema. This will make sure that
 * the tables are created in all the sites, not just the current one.
 */
var CoreSite = /** @class */ (function () {
    /**
     * Create a site.
     *
     * @param {Injector} injector Angular injector to prevent having to pass all the required services.
     * @param {string} id Site ID.
     * @param {string} siteUrl Site URL.
     * @param {string} [token] Site's WS token.
     * @param {any} [info] Site info.
     * @param {string} [privateToken] Private token.
     * @param {any} [config] Site public config.
     * @param {boolean} [loggedOut] Whether user is logged out.
     */
    function CoreSite(injector, id, siteUrl, token, infos, privateToken, config, loggedOut) {
        this.id = id;
        this.siteUrl = siteUrl;
        this.token = token;
        this.infos = infos;
        this.privateToken = privateToken;
        this.config = config;
        this.loggedOut = loggedOut;
        // Versions of Moodle releases.
        this.MOODLE_RELEASES = {
            3.1: 2016052300,
            3.2: 2016120500,
            3.3: 2017051503,
            3.4: 2017111300,
            3.5: 2018051700,
            3.6: 2018120300,
            3.7: 2019052000
        };
        // Possible cache update frequencies.
        this.UPDATE_FREQUENCIES = [
            __WEBPACK_IMPORTED_MODULE_14__configconstants__["a" /* CoreConfigConstants */].cache_update_frequency_usually || 420000,
            __WEBPACK_IMPORTED_MODULE_14__configconstants__["a" /* CoreConfigConstants */].cache_update_frequency_often || 1200000,
            __WEBPACK_IMPORTED_MODULE_14__configconstants__["a" /* CoreConfigConstants */].cache_update_frequency_sometimes || 3600000,
            __WEBPACK_IMPORTED_MODULE_14__configconstants__["a" /* CoreConfigConstants */].cache_update_frequency_rarely || 43200000
        ];
        this.cleanUnicode = false;
        this.lastAutoLogin = 0;
        this.offlineDisabled = false;
        this.ongoingRequests = {};
        this.requestQueue = [];
        this.requestQueueTimeout = null;
        // Inject the required services.
        var logger = injector.get(__WEBPACK_IMPORTED_MODULE_6__providers_logger__["a" /* CoreLoggerProvider */]);
        this.appProvider = injector.get(__WEBPACK_IMPORTED_MODULE_2__providers_app__["a" /* CoreAppProvider */]);
        this.dbProvider = injector.get(__WEBPACK_IMPORTED_MODULE_3__providers_db__["a" /* CoreDbProvider */]);
        this.domUtils = injector.get(__WEBPACK_IMPORTED_MODULE_8__providers_utils_dom__["a" /* CoreDomUtilsProvider */]);
        this.eventsProvider = injector.get(__WEBPACK_IMPORTED_MODULE_4__providers_events__["a" /* CoreEventsProvider */]);
        this.fileProvider = injector.get(__WEBPACK_IMPORTED_MODULE_5__providers_file__["a" /* CoreFileProvider */]);
        this.http = injector.get(__WEBPACK_IMPORTED_MODULE_1__angular_common_http__["c" /* HttpClient */]);
        this.textUtils = injector.get(__WEBPACK_IMPORTED_MODULE_9__providers_utils_text__["a" /* CoreTextUtilsProvider */]);
        this.timeUtils = injector.get(__WEBPACK_IMPORTED_MODULE_10__providers_utils_time__["a" /* CoreTimeUtilsProvider */]);
        this.translate = injector.get(__WEBPACK_IMPORTED_MODULE_0__ngx_translate_core__["c" /* TranslateService */]);
        this.utils = injector.get(__WEBPACK_IMPORTED_MODULE_12__providers_utils_utils__["a" /* CoreUtilsProvider */]);
        this.urlUtils = injector.get(__WEBPACK_IMPORTED_MODULE_11__providers_utils_url__["a" /* CoreUrlUtilsProvider */]);
        this.wsProvider = injector.get(__WEBPACK_IMPORTED_MODULE_7__providers_ws__["a" /* CoreWSProvider */]);
        this.logger = logger.getInstance('CoreWSProvider');
        this.setInfo(infos);
        this.calculateOfflineDisabled();
        if (this.id) {
            this.initDB();
        }
    }
    /**
     * Initialize the database.
     */
    CoreSite.prototype.initDB = function () {
        this.db = this.dbProvider.getDB('Site-' + this.id);
    };
    /**
     * Get site ID.
     *
     * @return {string} Site ID.
     */
    CoreSite.prototype.getId = function () {
        return this.id;
    };
    /**
     * Get site URL.
     *
     * @return {string} Site URL.
     */
    CoreSite.prototype.getURL = function () {
        return this.siteUrl;
    };
    /**
     * Get site token.
     *
     * @return {string} Site token.
     */
    CoreSite.prototype.getToken = function () {
        return this.token;
    };
    /**
     * Get site info.
     *
     * @return {any} Site info.
     */
    CoreSite.prototype.getInfo = function () {
        return this.infos;
    };
    /**
     * Get site private token.
     *
     * @return {string} Site private token.
     */
    CoreSite.prototype.getPrivateToken = function () {
        return this.privateToken;
    };
    /**
     * Get site DB.
     *
     * @return {SQLiteDB} Site DB.
     */
    CoreSite.prototype.getDb = function () {
        return this.db;
    };
    /**
     * Get site user's ID.
     *
     * @return {number} User's ID.
     */
    CoreSite.prototype.getUserId = function () {
        if (typeof this.infos != 'undefined' && typeof this.infos.userid != 'undefined') {
            return this.infos.userid;
        }
    };
    /**
     * Get site Course ID for frontpage course. If not declared it will return 1 as default.
     *
     * @return {number} Site Home ID.
     */
    CoreSite.prototype.getSiteHomeId = function () {
        return this.infos && this.infos.siteid || 1;
    };
    /**
     * Get site name.
     *
     * @return {string} Site name.
     */
    CoreSite.prototype.getSiteName = function () {
        if (__WEBPACK_IMPORTED_MODULE_14__configconstants__["a" /* CoreConfigConstants */].sitename) {
            // Overridden by config.
            return __WEBPACK_IMPORTED_MODULE_14__configconstants__["a" /* CoreConfigConstants */].sitename;
        }
        else {
            return this.infos && this.infos.sitename || '';
        }
    };
    /**
     * Set site ID.
     *
     * @param {string} New ID.
     */
    CoreSite.prototype.setId = function (id) {
        this.id = id;
        this.initDB();
    };
    /**
     * Set site token.
     *
     * @param {string} New token.
     */
    CoreSite.prototype.setToken = function (token) {
        this.token = token;
    };
    /**
     * Set site private token.
     *
     * @param {string} privateToken New private token.
     */
    CoreSite.prototype.setPrivateToken = function (privateToken) {
        this.privateToken = privateToken;
    };
    /**
     * Check if user logged out from the site and needs to authenticate again.
     *
     * @return {boolean} Whether is logged out.
     */
    CoreSite.prototype.isLoggedOut = function () {
        return !!this.loggedOut;
    };
    /**
     * Set site info.
     *
     * @param {any} New info.
     */
    CoreSite.prototype.setInfo = function (infos) {
        this.infos = infos;
        // Index function by name to speed up wsAvailable method.
        if (infos && infos.functions) {
            infos.functionsByName = {};
            infos.functions.forEach(function (func) {
                infos.functionsByName[func.name] = func;
            });
        }
    };
    /**
     * Set site config.
     *
     * @param {any} Config.
     */
    CoreSite.prototype.setConfig = function (config) {
        if (config) {
            config.tool_mobile_disabledfeatures = this.textUtils.treatDisabledFeatures(config.tool_mobile_disabledfeatures);
        }
        this.config = config;
        this.calculateOfflineDisabled();
    };
    /**
     * Set site logged out.
     *
     * @param {boolean} loggedOut True if logged out and needs to authenticate again, false otherwise.
     */
    CoreSite.prototype.setLoggedOut = function (loggedOut) {
        this.loggedOut = !!loggedOut;
    };
    /**
     * Can the user access their private files?
     *
     * @return {boolean} Whether can access my files.
     */
    CoreSite.prototype.canAccessMyFiles = function () {
        var infos = this.getInfo();
        return infos && (typeof infos.usercanmanageownfiles === 'undefined' || infos.usercanmanageownfiles);
    };
    /**
     * Can the user download files?
     *
     * @return {boolean} Whether can download files.
     */
    CoreSite.prototype.canDownloadFiles = function () {
        var infos = this.getInfo();
        return infos && infos.downloadfiles;
    };
    /**
     * Can the user use an advanced feature?
     *
     * @param {string} feature The name of the feature.
     * @param {boolean} [whenUndefined=true] The value to return when the parameter is undefined.
     * @return {boolean} Whether can use advanced feature.
     */
    CoreSite.prototype.canUseAdvancedFeature = function (feature, whenUndefined) {
        if (whenUndefined === void 0) { whenUndefined = true; }
        var infos = this.getInfo();
        var canUse = true;
        if (typeof infos.advancedfeatures === 'undefined') {
            canUse = whenUndefined;
        }
        else {
            for (var i in infos.advancedfeatures) {
                var item = infos.advancedfeatures[i];
                if (item.name === feature && parseInt(item.value, 10) === 0) {
                    canUse = false;
                }
            }
        }
        return canUse;
    };
    /**
     * Can the user upload files?
     *
     * @return {boolean} Whether can upload files.
     */
    CoreSite.prototype.canUploadFiles = function () {
        var infos = this.getInfo();
        return infos && infos.uploadfiles;
    };
    /**
     * Fetch site info from the Moodle site.
     *
     * @return {Promise<any>} A promise to be resolved when the site info is retrieved.
     */
    CoreSite.prototype.fetchSiteInfo = function () {
        // The get_site_info WS call won't be cached.
        var preSets = {
            getFromCache: false,
            saveToCache: false,
            skipQueue: true
        };
        // Reset clean Unicode to check if it's supported again.
        this.cleanUnicode = false;
        return this.read('core_webservice_get_site_info', {}, preSets);
    };
    /**
     * Read some data from the Moodle site using WS. Requests are cached by default.
     *
     * @param {string} method WS method to use.
     * @param {any} data Data to send to the WS.
     * @param {CoreSiteWSPreSets} [preSets] Extra options.
     * @return {Promise<any>} Promise resolved with the response, rejected with CoreWSError if it fails.
     */
    CoreSite.prototype.read = function (method, data, preSets) {
        preSets = preSets || {};
        if (typeof preSets.getFromCache == 'undefined') {
            preSets.getFromCache = true;
        }
        if (typeof preSets.saveToCache == 'undefined') {
            preSets.saveToCache = true;
        }
        if (typeof preSets.reusePending == 'undefined') {
            preSets.reusePending = true;
        }
        return this.request(method, data, preSets);
    };
    /**
     * Sends some data to the Moodle site using WS. Requests are NOT cached by default.
     *
     * @param {string} method  WS method to use.
     * @param {any} data Data to send to the WS.
     * @param {CoreSiteWSPreSets} [preSets] Extra options.
     * @return {Promise<any>} Promise resolved with the response, rejected with CoreWSError if it fails.
     */
    CoreSite.prototype.write = function (method, data, preSets) {
        preSets = preSets || {};
        if (typeof preSets.getFromCache == 'undefined') {
            preSets.getFromCache = false;
        }
        if (typeof preSets.saveToCache == 'undefined') {
            preSets.saveToCache = false;
        }
        if (typeof preSets.emergencyCache == 'undefined') {
            preSets.emergencyCache = false;
        }
        return this.request(method, data, preSets);
    };
    /**
     * WS request to the site.
     *
     * @param {string} method The WebService method to be called.
     * @param {any} data Arguments to pass to the method.
     * @param {CoreSiteWSPreSets} preSets Extra options.
     * @param {boolean} [retrying] True if we're retrying the call for some reason. This is to prevent infinite loops.
     * @return {Promise<any>} Promise resolved with the response, rejected with CoreWSError if it fails.
     * @description
     *
     * Sends a webservice request to the site. This method will automatically add the
     * required parameters and pass it on to the low level API in CoreWSProvider.call().
     *
     * Caching is also implemented, when enabled this method will returned a cached version of the request if the
     * data hasn't expired.
     *
     * This method is smart which means that it will try to map the method to a compatibility one if need be, usually this
     * means that it will fallback on the 'local_mobile_' prefixed function if it is available and the non-prefixed is not.
     */
    CoreSite.prototype.request = function (method, data, preSets, retrying) {
        var _this = this;
        var initialToken = this.token;
        data = data || {};
        if (!this.appProvider.isOnline() && this.offlineDisabled) {
            return Promise.reject(this.wsProvider.createFakeWSError('core.errorofflinedisabled', true));
        }
        // Check if the method is available, use a prefixed version if possible.
        // We ignore this check when we do not have the site info, as the list of functions is not loaded yet.
        if (this.getInfo() && !this.wsAvailable(method, false)) {
            var compatibilityMethod = __WEBPACK_IMPORTED_MODULE_13__core_constants__["a" /* CoreConstants */].WS_PREFIX + method;
            if (this.wsAvailable(compatibilityMethod, false)) {
                this.logger.info("Using compatibility WS method '" + compatibilityMethod + "'");
                method = compatibilityMethod;
            }
            else {
                this.logger.error("WS function '" + method + "' is not available, even in compatibility mode.");
                return Promise.reject(this.utils.createFakeWSError('core.wsfunctionnotavailable', true));
            }
        }
        var wsPreSets = {
            wsToken: this.token,
            siteUrl: this.siteUrl,
            cleanUnicode: this.cleanUnicode,
            typeExpected: preSets.typeExpected,
            responseExpected: preSets.responseExpected
        };
        if (wsPreSets.cleanUnicode && this.textUtils.hasUnicodeData(data)) {
            // Data will be cleaned, notify the user.
            this.domUtils.showToast('core.unicodenotsupported', true, 3000);
        }
        else {
            // No need to clean data in this call.
            wsPreSets.cleanUnicode = false;
        }
        if (this.offlineDisabled) {
            // Offline is disabled, don't use cache.
            preSets.getFromCache = false;
            preSets.saveToCache = false;
            preSets.emergencyCache = false;
        }
        // Enable text filtering by default.
        data.moodlewssettingfilter = preSets.filter === false ? false : true;
        data.moodlewssettingfileurl = preSets.rewriteurls === false ? false : true;
        var originalData = data;
        // Convert arguments to strings before starting the cache process.
        data = this.wsProvider.convertValuesToString(data, wsPreSets.cleanUnicode);
        if (data == null) {
            // Empty cleaned text found.
            return Promise.reject(this.utils.createFakeWSError('core.unicodenotsupportedcleanerror', true));
        }
        var cacheId = this.getCacheId(method, data);
        // Check for an ongoing identical request if we're not ignoring cache.
        if (preSets.getFromCache && this.ongoingRequests[cacheId]) {
            return this.ongoingRequests[cacheId].then(function (response) {
                // Clone the data, this may prevent errors if in the callback the object is modified.
                return _this.utils.clone(response);
            });
        }
        var promise = this.getFromCache(method, data, preSets, false, originalData).catch(function () {
            if (preSets.forceOffline) {
                // Don't call the WS, just fail.
                return Promise.reject(_this.wsProvider.createFakeWSError('core.cannotconnect', true));
            }
            // Call the WS.
            return _this.callOrEnqueueRequest(method, data, preSets, wsPreSets).then(function (response) {
                if (preSets.saveToCache) {
                    _this.saveToCache(method, data, response, preSets);
                }
                return response;
            }).catch(function (error) {
                if (error.errorcode == 'invalidtoken' ||
                    (error.errorcode == 'accessexception' && error.message.indexOf('Invalid token - token expired') > -1)) {
                    if (initialToken !== _this.token && !retrying) {
                        // Token has changed, retry with the new token.
                        preSets.getFromCache = false; // Don't check cache now. Also, it will skip ongoingRequests.
                        return _this.request(method, data, preSets, true);
                    }
                    else if (_this.appProvider.isSSOAuthenticationOngoing()) {
                        // There's an SSO authentication ongoing, wait for it to finish and try again.
                        return _this.appProvider.waitForSSOAuthentication().then(function () {
                            return _this.request(method, data, preSets, true);
                        });
                    }
                    // Session expired, trigger event.
                    _this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_4__providers_events__["a" /* CoreEventsProvider */].SESSION_EXPIRED, {}, _this.id);
                    // Change error message. Try to get data from cache, the event will handle the error.
                    error.message = _this.translate.instant('core.lostconnection');
                }
                else if (error.errorcode === 'userdeleted') {
                    // User deleted, trigger event.
                    _this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_4__providers_events__["a" /* CoreEventsProvider */].USER_DELETED, { params: data }, _this.id);
                    error.message = _this.translate.instant('core.userdeleted');
                    return Promise.reject(error);
                }
                else if (error.errorcode === 'forcepasswordchangenotice') {
                    // Password Change Forced, trigger event. Try to get data from cache, the event will handle the error.
                    _this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_4__providers_events__["a" /* CoreEventsProvider */].PASSWORD_CHANGE_FORCED, {}, _this.id);
                    error.message = _this.translate.instant('core.forcepasswordchangenotice');
                }
                else if (error.errorcode === 'usernotfullysetup') {
                    // User not fully setup, trigger event. Try to get data from cache, the event will handle the error.
                    _this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_4__providers_events__["a" /* CoreEventsProvider */].USER_NOT_FULLY_SETUP, {}, _this.id);
                    error.message = _this.translate.instant('core.usernotfullysetup');
                }
                else if (error.errorcode === 'sitepolicynotagreed') {
                    // Site policy not agreed, trigger event.
                    _this.eventsProvider.trigger(__WEBPACK_IMPORTED_MODULE_4__providers_events__["a" /* CoreEventsProvider */].SITE_POLICY_NOT_AGREED, {}, _this.id);
                    error.message = _this.translate.instant('core.login.sitepolicynotagreederror');
                    return Promise.reject(error);
                }
                else if (error.errorcode === 'dmlwriteexception' && _this.textUtils.hasUnicodeData(data)) {
                    if (!_this.cleanUnicode) {
                        // Try again cleaning unicode.
                        _this.cleanUnicode = true;
                        return _this.request(method, data, preSets);
                    }
                    // This should not happen.
                    error.message = _this.translate.instant('core.unicodenotsupported');
                    return Promise.reject(error);
                }
                else if (error.exception === 'required_capability_exception' || error.errorcode === 'nopermission' ||
                    error.errorcode === 'notingroup') {
                    // Translate error messages with missing strings.
                    if (error.message === 'error/nopermission') {
                        error.message = _this.translate.instant('core.nopermissionerror');
                    }
                    else if (error.message === 'error/notingroup') {
                        error.message = _this.translate.instant('core.notingroup');
                    }
                    // Save the error instead of deleting the cache entry so the same content is displayed in offline.
                    _this.saveToCache(method, data, error, preSets);
                    return Promise.reject(error);
                }
                else if (preSets.cacheErrors && preSets.cacheErrors.indexOf(error.errorcode) != -1) {
                    // Save the error instead of deleting the cache entry so the same content is displayed in offline.
                    _this.saveToCache(method, data, error, preSets);
                    return Promise.reject(error);
                }
                else if (typeof preSets.emergencyCache !== 'undefined' && !preSets.emergencyCache) {
                    _this.logger.debug("WS call '" + method + "' failed. Emergency cache is forbidden, rejecting.");
                    return Promise.reject(error);
                }
                if (preSets.deleteCacheIfWSError && _this.utils.isWebServiceError(error)) {
                    // Delete the cache entry and return the entry. Don't block the user with the delete.
                    _this.deleteFromCache(method, data, preSets).catch(function () {
                        // Ignore errors.
                    });
                    return Promise.reject(error);
                }
                _this.logger.debug("WS call '" + method + "' failed. Trying to use the emergency cache.");
                preSets.omitExpires = true;
                preSets.getFromCache = true;
                return _this.getFromCache(method, data, preSets, true, originalData).catch(function () {
                    return Promise.reject(error);
                });
            });
        }).then(function (response) {
            // Check if the response is an error, this happens if the error was stored in the cache.
            if (response && (typeof response.exception != 'undefined' || typeof response.errorcode != 'undefined')) {
                return Promise.reject(response);
            }
            return response;
        });
        this.ongoingRequests[cacheId] = promise;
        // Clear ongoing request after setting the promise (just in case it's already resolved).
        return promise.finally(function () {
            // Make sure we don't clear the promise of a newer request that ignores the cache.
            if (_this.ongoingRequests[cacheId] === promise) {
                delete _this.ongoingRequests[cacheId];
            }
        }).then(function (response) {
            // We pass back a clone of the original object, this may prevent errors if in the callback the object is modified.
            return _this.utils.clone(response);
        });
    };
    /**
     * Adds a request to the queue or calls it immediately when not using the queue.
     *
     * @param {string} method The WebService method to be called.
     * @param {any} data Arguments to pass to the method.
     * @param {CoreSiteWSPreSets} preSets Extra options related to the site.
     * @param {CoreWSPreSets} wsPreSets Extra options related to the WS call.
     * @returns {Promise<any>} Promise resolved with the response when the WS is called.
     */
    CoreSite.prototype.callOrEnqueueRequest = function (method, data, preSets, wsPreSets) {
        if (preSets.skipQueue || !this.wsAvailable('tool_mobile_call_external_functions')) {
            return this.wsProvider.call(method, data, wsPreSets);
        }
        var cacheId = this.getCacheId(method, data);
        // Check if there is an identical request waiting in the queue (read requests only by default).
        if (preSets.reusePending) {
            var request_1 = this.requestQueue.find(function (request) { return request.cacheId == cacheId; });
            if (request_1) {
                return request_1.deferred.promise;
            }
        }
        var request = {
            cacheId: cacheId,
            method: method,
            data: data,
            preSets: preSets,
            wsPreSets: wsPreSets,
            deferred: {}
        };
        request.deferred.promise = new Promise(function (resolve, reject) {
            request.deferred.resolve = resolve;
            request.deferred.reject = reject;
        });
        return this.enqueueRequest(request);
    };
    /**
     * Adds a request to the queue.
     *
     * @param {RequestQueueItem} request The request to enqueue.
     * @returns {Promise<any>} Promise resolved with the response when the WS is called.
     */
    CoreSite.prototype.enqueueRequest = function (request) {
        this.requestQueue.push(request);
        if (this.requestQueue.length >= CoreSite.REQUEST_QUEUE_LIMIT) {
            this.processRequestQueue();
        }
        else if (!this.requestQueueTimeout) {
            this.requestQueueTimeout = setTimeout(this.processRequestQueue.bind(this), CoreSite.REQUEST_QUEUE_DELAY);
        }
        return request.deferred.promise;
    };
    /**
     * Call the enqueued web service requests.
     */
    CoreSite.prototype.processRequestQueue = function () {
        var _this = this;
        this.logger.debug("Processing request queue (" + this.requestQueue.length + " requests)");
        // Clear timeout if set.
        if (this.requestQueueTimeout) {
            clearTimeout(this.requestQueueTimeout);
            this.requestQueueTimeout = null;
        }
        // Extract all requests from the queue.
        var requests = this.requestQueue;
        this.requestQueue = [];
        if (requests.length == 1 && !CoreSite.REQUEST_QUEUE_FORCE_WS) {
            // Only one request, do a regular web service call.
            this.wsProvider.call(requests[0].method, requests[0].data, requests[0].wsPreSets).then(function (data) {
                requests[0].deferred.resolve(data);
            }).catch(function (error) {
                requests[0].deferred.reject(error);
            });
            return;
        }
        var data = {
            requests: requests.map(function (request) {
                var args = {};
                var settings = {};
                // Separate WS settings from function arguments.
                Object.keys(request.data).forEach(function (key) {
                    var value = request.data[key];
                    var match = /^moodlews(setting.*)$/.exec(key);
                    if (match) {
                        if (match[1] == 'settingfilter' || match[1] == 'settingfileurl') {
                            // Undo special treatment of these settings in CoreWSProvider.convertValuesToString.
                            value = (value == 'true' ? '1' : '0');
                        }
                        settings[match[1]] = value;
                    }
                    else {
                        args[key] = value;
                    }
                });
                return __assign({ function: request.method, arguments: JSON.stringify(args) }, settings);
            })
        };
        var wsPresets = {
            siteUrl: this.siteUrl,
            wsToken: this.token,
        };
        this.wsProvider.call('tool_mobile_call_external_functions', data, wsPresets).then(function (data) {
            if (!data || !data.responses) {
                return Promise.reject(null);
            }
            requests.forEach(function (request, i) {
                var response = data.responses[i];
                if (!response) {
                    // Request not executed, enqueue again.
                    _this.enqueueRequest(request);
                }
                else if (response.error) {
                    request.deferred.reject(_this.textUtils.parseJSON(response.exception));
                }
                else {
                    var responseData = _this.textUtils.parseJSON(response.data);
                    // Match the behaviour of CoreWSProvider.call when no response is expected.
                    var responseExpected = typeof wsPresets.responseExpected == 'undefined' || wsPresets.responseExpected;
                    if (!responseExpected && (responseData == null || responseData === '')) {
                        responseData = {};
                    }
                    request.deferred.resolve(responseData);
                }
            });
        }).catch(function (error) {
            // Error not specific to a single request, reject all promises.
            requests.forEach(function (request) {
                request.deferred.reject(error);
            });
        });
    };
    /**
     * Check if a WS is available in this site.
     *
     * @param {string} method WS name.
     * @param {boolean} [checkPrefix=true] When true also checks with the compatibility prefix.
     * @return {boolean} Whether the WS is available.
     */
    CoreSite.prototype.wsAvailable = function (method, checkPrefix) {
        if (checkPrefix === void 0) { checkPrefix = true; }
        if (typeof this.infos == 'undefined') {
            return false;
        }
        if (this.infos.functionsByName[method]) {
            return true;
        }
        // Let's try again with the compatibility prefix.
        if (checkPrefix) {
            return this.wsAvailable(__WEBPACK_IMPORTED_MODULE_13__core_constants__["a" /* CoreConstants */].WS_PREFIX + method, false);
        }
        return false;
    };
    /**
     * Get cache ID.
     *
     * @param {string} method The WebService method.
     * @param {any} data Arguments to pass to the method.
     * @return {string} Cache ID.
     */
    CoreSite.prototype.getCacheId = function (method, data) {
        return __WEBPACK_IMPORTED_MODULE_15_ts_md5_dist_md5__["Md5"].hashAsciiStr(method + ':' + this.utils.sortAndStringify(data));
    };
    /**
     * Get the cache ID used in Ionic 1 version of the app.
     *
     * @param {string} method The WebService method.
     * @param {any} data Arguments to pass to the method.
     * @return {string} Cache ID.
     */
    CoreSite.prototype.getCacheOldId = function (method, data) {
        return __WEBPACK_IMPORTED_MODULE_15_ts_md5_dist_md5__["Md5"].hashAsciiStr(method + ':' + JSON.stringify(data));
    };
    /**
     * Get a WS response from cache.
     *
     * @param {string} method The WebService method to be called.
     * @param {any} data Arguments to pass to the method.
     * @param {CoreSiteWSPreSets} preSets Extra options.
     * @param {boolean} [emergency] Whether it's an "emergency" cache call (WS call failed).
     * @param {any} [originalData] Arguments to pass to the method before being converted to strings.
     * @return {Promise<any>} Promise resolved with the WS response.
     */
    CoreSite.prototype.getFromCache = function (method, data, preSets, emergency, originalData) {
        var _this = this;
        if (!this.db || !preSets.getFromCache) {
            return Promise.reject(null);
        }
        var id = this.getCacheId(method, data);
        var promise;
        if (preSets.getCacheUsingCacheKey || (emergency && preSets.getEmergencyCacheUsingCacheKey)) {
            promise = this.db.getRecords(CoreSite.WS_CACHE_TABLE, { key: preSets.cacheKey }).then(function (entries) {
                if (!entries.length) {
                    // Cache key not found, get by params sent.
                    return _this.db.getRecord(CoreSite.WS_CACHE_TABLE, { id: id });
                }
                else if (entries.length > 1) {
                    // More than one entry found. Search the one with same ID as this call.
                    for (var i = 0, len = entries.length; i < len; i++) {
                        var entry = entries[i];
                        if (entry.id == id) {
                            return entry;
                        }
                    }
                }
                return entries[0];
            });
        }
        else {
            promise = this.db.getRecord(CoreSite.WS_CACHE_TABLE, { id: id }).catch(function () {
                // Entry not found, try to get it using the old ID.
                var oldId = _this.getCacheOldId(method, originalData || {});
                return _this.db.getRecord(CoreSite.WS_CACHE_TABLE, { id: oldId }).then(function (entry) {
                    // Update the entry ID to use the new one.
                    _this.db.updateRecords(CoreSite.WS_CACHE_TABLE, { id: id }, { id: oldId });
                    return entry;
                });
            });
        }
        return promise.then(function (entry) {
            var now = Date.now();
            var expirationTime;
            preSets.omitExpires = preSets.omitExpires || preSets.forceOffline || !_this.appProvider.isOnline();
            if (!preSets.omitExpires) {
                var expirationDelay = _this.UPDATE_FREQUENCIES[preSets.updateFrequency] ||
                    _this.UPDATE_FREQUENCIES[CoreSite.FREQUENCY_USUALLY];
                if (_this.appProvider.isNetworkAccessLimited()) {
                    // Not WiFi, increase the expiration delay a 50% to decrease the data usage in this case.
                    expirationDelay *= 1.5;
                }
                expirationTime = entry.expirationTime + expirationDelay;
                if (now > expirationTime) {
                    _this.logger.debug('Cached element found, but it is expired');
                    return Promise.reject(null);
                }
            }
            if (typeof entry != 'undefined' && typeof entry.data != 'undefined') {
                if (!expirationTime) {
                    _this.logger.info("Cached element found, id: " + id + ". Expiration time ignored.");
                }
                else {
                    var expires = (expirationTime - now) / 1000;
                    _this.logger.info("Cached element found, id: " + id + ". Expires in expires in " + expires + " seconds");
                }
                return _this.textUtils.parseJSON(entry.data, {});
            }
            return Promise.reject(null);
        });
    };
    /**
     * Save a WS response to cache.
     *
     * @param {string} method The WebService method.
     * @param {any} data Arguments to pass to the method.
     * @param {any} response The WS response.
     * @param {CoreSiteWSPreSets} preSets Extra options.
     * @return {Promise<any>} Promise resolved when the response is saved.
     */
    CoreSite.prototype.saveToCache = function (method, data, response, preSets) {
        var _this = this;
        if (!this.db) {
            return Promise.reject(null);
        }
        var promise;
        if (preSets.uniqueCacheKey) {
            // Cache key must be unique, delete all entries with same cache key.
            promise = this.deleteFromCache(method, data, preSets, true).catch(function () {
                // Ignore errors.
            });
        }
        else {
            promise = Promise.resolve();
        }
        return promise.then(function () {
            // Since 3.7, the expiration time contains the time the entry is modified instead of the expiration time.
            // We decided to reuse this field to prevent modifying the database table.
            var id = _this.getCacheId(method, data), entry = {
                id: id,
                data: JSON.stringify(response),
                expirationTime: Date.now()
            };
            if (preSets.cacheKey) {
                entry.key = preSets.cacheKey;
            }
            return _this.db.insertRecord(CoreSite.WS_CACHE_TABLE, entry);
        });
    };
    /**
     * Delete a WS cache entry or entries.
     *
     * @param {string} method The WebService method to be called.
     * @param {any} data Arguments to pass to the method.
     * @param {CoreSiteWSPreSets} preSets Extra options.
     * @param {boolean} [allCacheKey] True to delete all entries with the cache key, false to delete only by ID.
     * @return {Promise<any>} Promise resolved when the entries are deleted.
     */
    CoreSite.prototype.deleteFromCache = function (method, data, preSets, allCacheKey) {
        if (!this.db) {
            return Promise.reject(null);
        }
        var id = this.getCacheId(method, data);
        if (allCacheKey) {
            return this.db.deleteRecords(CoreSite.WS_CACHE_TABLE, { key: preSets.cacheKey });
        }
        return this.db.deleteRecords(CoreSite.WS_CACHE_TABLE, { id: id });
    };
    /*
     * Uploads a file using Cordova File API.
     *
     * @param {string} filePath File path.
     * @param {CoreWSFileUploadOptions} options File upload options.
     * @param {Function} [onProgress] Function to call on progress.
     * @return {Promise<any>} Promise resolved when uploaded.
     */
    CoreSite.prototype.uploadFile = function (filePath, options, onProgress) {
        if (!options.fileArea) {
            options.fileArea = 'draft';
        }
        return this.wsProvider.uploadFile(filePath, options, {
            siteUrl: this.siteUrl,
            wsToken: this.token
        }, onProgress);
    };
    /**
     * Invalidates all the cache entries.
     *
     * @return {Promise<any>} Promise resolved when the cache entries are invalidated.
     */
    CoreSite.prototype.invalidateWsCache = function () {
        if (!this.db) {
            return Promise.reject(null);
        }
        this.logger.debug('Invalidate all the cache for site: ' + this.id);
        return this.db.updateRecords(CoreSite.WS_CACHE_TABLE, { expirationTime: 0 });
    };
    /**
     * Invalidates all the cache entries with a certain key.
     *
     * @param {string} key Key to search.
     * @return {Promise<any>} Promise resolved when the cache entries are invalidated.
     */
    CoreSite.prototype.invalidateWsCacheForKey = function (key) {
        if (!this.db) {
            return Promise.reject(null);
        }
        if (!key) {
            return Promise.resolve();
        }
        this.logger.debug('Invalidate cache for key: ' + key);
        return this.db.updateRecords(CoreSite.WS_CACHE_TABLE, { expirationTime: 0 }, { key: key });
    };
    /**
     * Invalidates all the cache entries in an array of keys.
     *
     * @param {string[]} keys Keys to search.
     * @return {Promise<any>} Promise resolved when the cache entries are invalidated.
     */
    CoreSite.prototype.invalidateMultipleWsCacheForKey = function (keys) {
        var _this = this;
        if (!this.db) {
            return Promise.reject(null);
        }
        if (!keys || !keys.length) {
            return Promise.resolve();
        }
        var promises = [];
        this.logger.debug('Invalidating multiple cache keys');
        keys.forEach(function (key) {
            promises.push(_this.invalidateWsCacheForKey(key));
        });
        return Promise.all(promises);
    };
    /**
     * Invalidates all the cache entries whose key starts with a certain value.
     *
     * @param {string} key Key to search.
     * @return {Promise}    Promise resolved when the cache entries are invalidated.
     */
    CoreSite.prototype.invalidateWsCacheForKeyStartingWith = function (key) {
        if (!this.db) {
            return Promise.reject(null);
        }
        if (!key) {
            return Promise.resolve();
        }
        this.logger.debug('Invalidate cache for key starting with: ' + key);
        var sql = 'UPDATE ' + CoreSite.WS_CACHE_TABLE + ' SET expirationTime=0 WHERE key LIKE ?';
        return this.db.execute(sql, [key + '%']);
    };
    /**
     * Generic function for adding the wstoken to Moodle urls and for pointing to the correct script.
     * Uses CoreUtilsProvider.fixPluginfileURL, passing site's token.
     *
     * @param {string} url The url to be fixed.
     * @return {string} Fixed URL.
     */
    CoreSite.prototype.fixPluginfileURL = function (url) {
        return this.urlUtils.fixPluginfileURL(url, this.token, this.siteUrl);
    };
    /**
     * Deletes site's DB.
     *
     * @return {Promise<any>} Promise to be resolved when the DB is deleted.
     */
    CoreSite.prototype.deleteDB = function () {
        return this.dbProvider.deleteDB('Site-' + this.id);
    };
    /**
     * Deletes site's folder.
     *
     * @return {Promise<any>} Promise to be resolved when the DB is deleted.
     */
    CoreSite.prototype.deleteFolder = function () {
        if (this.fileProvider.isAvailable()) {
            var siteFolder = this.fileProvider.getSiteFolder(this.id);
            return this.fileProvider.removeDir(siteFolder).catch(function () {
                // Ignore any errors, CoreFileProvider.removeDir fails if folder doesn't exists.
            });
        }
        else {
            return Promise.resolve();
        }
    };
    /**
     * Get space usage of the site.
     *
     * @return {Promise<number>} Promise resolved with the site space usage (size).
     */
    CoreSite.prototype.getSpaceUsage = function () {
        if (this.fileProvider.isAvailable()) {
            var siteFolderPath = this.fileProvider.getSiteFolder(this.id);
            return this.fileProvider.getDirectorySize(siteFolderPath).catch(function () {
                return 0;
            });
        }
        else {
            return Promise.resolve(0);
        }
    };
    /**
     * Returns the URL to the documentation of the app, based on Moodle version and current language.
     *
     * @param {string} [page] Docs page to go to.
     * @return {Promise<string>} Promise resolved with the Moodle docs URL.
     */
    CoreSite.prototype.getDocsUrl = function (page) {
        var release = this.infos.release ? this.infos.release : undefined;
        return this.urlUtils.getDocsUrl(release, page);
    };
    /**
     * Check if the local_mobile plugin is installed in the Moodle site.
     *
     * @param {boolean} [retrying] True if we're retrying the check.
     * @return {Promise<LocalMobileResponse>} Promise resolved when the check is done.
     */
    CoreSite.prototype.checkLocalMobilePlugin = function (retrying) {
        var _this = this;
        var checkUrl = this.siteUrl + '/local/mobile/check.php', service = __WEBPACK_IMPORTED_MODULE_14__configconstants__["a" /* CoreConfigConstants */].wsextservice;
        if (!service) {
            // External service not defined.
            return Promise.resolve({ code: 0 });
        }
        var promise = this.http.post(checkUrl, { service: service }).timeout(this.wsProvider.getRequestTimeout()).toPromise();
        return promise.then(function (data) {
            if (typeof data != 'undefined' && data.errorcode === 'requirecorrectaccess') {
                if (!retrying) {
                    _this.siteUrl = _this.urlUtils.addOrRemoveWWW(_this.siteUrl);
                    return _this.checkLocalMobilePlugin(true);
                }
                else {
                    return Promise.reject(data.error);
                }
            }
            else if (typeof data == 'undefined' || typeof data.code == 'undefined') {
                // The local_mobile returned something we didn't expect. Let's assume it's not installed.
                return { code: 0, warning: 'core.login.localmobileunexpectedresponse' };
            }
            var code = parseInt(data.code, 10);
            if (data.error) {
                switch (code) {
                    case 1:
                        // Site in maintenance mode.
                        return Promise.reject(_this.translate.instant('core.login.siteinmaintenance'));
                    case 2:
                        // Web services not enabled.
                        return Promise.reject(_this.translate.instant('core.login.webservicesnotenabled'));
                    case 3:
                        // Extended service not enabled, but the official is enabled.
                        return { code: 0 };
                    case 4:
                        // Neither extended or official services enabled.
                        return Promise.reject(_this.translate.instant('core.login.mobileservicesnotenabled'));
                    default:
                        return Promise.reject(_this.translate.instant('core.unexpectederror'));
                }
            }
            else {
                return { code: code, service: service, coreSupported: !!data.coresupported };
            }
        }, function () {
            return { code: 0 };
        });
    };
    /**
     * Check if local_mobile has been installed in Moodle.
     *
     * @return {boolean} Whether the App is able to use local_mobile plugin for this site.
     */
    CoreSite.prototype.checkIfAppUsesLocalMobile = function () {
        var appUsesLocalMobile = false;
        if (!this.infos || !this.infos.functions) {
            return appUsesLocalMobile;
        }
        this.infos.functions.forEach(function (func) {
            if (func.name.indexOf(__WEBPACK_IMPORTED_MODULE_13__core_constants__["a" /* CoreConstants */].WS_PREFIX) != -1) {
                appUsesLocalMobile = true;
            }
        });
        return appUsesLocalMobile;
    };
    /**
     * Check if local_mobile has been installed in Moodle but the app is not using it.
     *
     * @return {Promise<any>} Promise resolved it local_mobile was added, rejected otherwise.
     */
    CoreSite.prototype.checkIfLocalMobileInstalledAndNotUsed = function () {
        var appUsesLocalMobile = this.checkIfAppUsesLocalMobile();
        if (appUsesLocalMobile) {
            // App already uses local_mobile, it wasn't added.
            return Promise.reject(null);
        }
        return this.checkLocalMobilePlugin().then(function (data) {
            if (typeof data.service == 'undefined') {
                // The local_mobile NOT installed. Reject.
                return Promise.reject(null);
            }
            return data;
        });
    };
    /**
     * Check if a URL belongs to this site.
     *
     * @param {string} url URL to check.
     * @return {boolean} Whether the URL belongs to this site.
     */
    CoreSite.prototype.containsUrl = function (url) {
        if (!url) {
            return false;
        }
        var siteUrl = this.textUtils.removeEndingSlash(this.urlUtils.removeProtocolAndWWW(this.siteUrl));
        url = this.urlUtils.removeProtocolAndWWW(url);
        return url.indexOf(siteUrl) == 0;
    };
    /**
     * Get the public config of this site.
     *
     * @return {Promise<any>} Promise resolved with public config. Rejected with an object if error, see CoreWSProvider.callAjax.
     */
    CoreSite.prototype.getPublicConfig = function () {
        var _this = this;
        var preSets = {
            siteUrl: this.siteUrl
        };
        return this.wsProvider.callAjax('tool_mobile_get_public_config', {}, preSets).catch(function (error) {
            if ((!_this.getInfo() || _this.isVersionGreaterEqualThan('3.8')) && error && error.errorcode == 'codingerror') {
                // This error probably means that there is a redirect in the site. Try to use a GET request.
                preSets.noLogin = true;
                preSets.useGet = true;
                return _this.wsProvider.callAjax('tool_mobile_get_public_config', {}, preSets).catch(function (error2) {
                    if (_this.getInfo() && _this.isVersionGreaterEqualThan('3.8')) {
                        // GET is supported, return the second error.
                        return Promise.reject(error2);
                    }
                    else {
                        // GET not supported or we don't know if it's supported. Return first error.
                        return Promise.reject(error);
                    }
                });
            }
            return Promise.reject(error);
        }).then(function (config) {
            // Use the wwwroot returned by the server.
            if (config.httpswwwroot) {
                _this.siteUrl = config.httpswwwroot;
            }
            return config;
        });
    };
    /**
     * Open a URL in browser using auto-login in the Moodle site if available.
     *
     * @param {string} url The URL to open.
     * @param {string} [alertMessage] If defined, an alert will be shown before opening the browser.
     * @return {Promise<any>} Promise resolved when done, rejected otherwise.
     */
    CoreSite.prototype.openInBrowserWithAutoLogin = function (url, alertMessage) {
        return this.openWithAutoLogin(false, url, undefined, alertMessage);
    };
    /**
     * Open a URL in browser using auto-login in the Moodle site if available and the URL belongs to the site.
     *
     * @param {string} url The URL to open.
     * @param {string} [alertMessage] If defined, an alert will be shown before opening the browser.
     * @return {Promise<any>} Promise resolved when done, rejected otherwise.
     */
    CoreSite.prototype.openInBrowserWithAutoLoginIfSameSite = function (url, alertMessage) {
        return this.openWithAutoLoginIfSameSite(false, url, undefined, alertMessage);
    };
    /**
     * Open a URL in inappbrowser using auto-login in the Moodle site if available.
     *
     * @param {string} url The URL to open.
     * @param {any} [options] Override default options passed to InAppBrowser.
     * @param {string} [alertMessage] If defined, an alert will be shown before opening the inappbrowser.
     * @return {Promise<InAppBrowserObject|void>} Promise resolved when done.
     */
    CoreSite.prototype.openInAppWithAutoLogin = function (url, options, alertMessage) {
        return this.openWithAutoLogin(true, url, options, alertMessage);
    };
    /**
     * Open a URL in inappbrowser using auto-login in the Moodle site if available and the URL belongs to the site.
     *
     * @param {string} url The URL to open.
     * @param {object} [options] Override default options passed to inappbrowser.
     * @param {string} [alertMessage] If defined, an alert will be shown before opening the inappbrowser.
     * @return {Promise<InAppBrowserObject|void>} Promise resolved when done.
     */
    CoreSite.prototype.openInAppWithAutoLoginIfSameSite = function (url, options, alertMessage) {
        return this.openWithAutoLoginIfSameSite(true, url, options, alertMessage);
    };
    /**
     * Open a URL in browser or InAppBrowser using auto-login in the Moodle site if available.
     *
     * @param {boolean} inApp True to open it in InAppBrowser, false to open in browser.
     * @param {string} url The URL to open.
     * @param {object} [options] Override default options passed to $cordovaInAppBrowser#open.
     * @param {string} [alertMessage] If defined, an alert will be shown before opening the browser/inappbrowser.
     * @return {Promise<InAppBrowserObject|void>} Promise resolved when done. Resolve param is returned only if inApp=true.
     */
    CoreSite.prototype.openWithAutoLogin = function (inApp, url, options, alertMessage) {
        var _this = this;
        // Get the URL to open.
        return this.getAutoLoginUrl(url).then(function (url) {
            if (!alertMessage) {
                // Just open the URL.
                if (inApp) {
                    return _this.utils.openInApp(url, options);
                }
                else {
                    return _this.utils.openInBrowser(url);
                }
            }
            // Show an alert first.
            return _this.domUtils.showAlert(_this.translate.instant('core.notice'), alertMessage, undefined, 3000).then(function (alert) {
                return new Promise(function (resolve, reject) {
                    var subscription = alert.didDismiss.subscribe(function () {
                        subscription && subscription.unsubscribe();
                        if (inApp) {
                            resolve(_this.utils.openInApp(url, options));
                        }
                        else {
                            resolve(_this.utils.openInBrowser(url));
                        }
                    });
                });
            });
        });
    };
    /**
     * Open a URL in browser or InAppBrowser using auto-login in the Moodle site if available and the URL belongs to the site.
     *
     * @param {boolean} inApp True to open it in InAppBrowser, false to open in browser.
     * @param {string} url The URL to open.
     * @param {object} [options] Override default options passed to inappbrowser.
     * @param {string} [alertMessage] If defined, an alert will be shown before opening the browser/inappbrowser.
     * @return {Promise<InAppBrowserObject|void>} Promise resolved when done. Resolve param is returned only if inApp=true.
     */
    CoreSite.prototype.openWithAutoLoginIfSameSite = function (inApp, url, options, alertMessage) {
        if (this.containsUrl(url)) {
            return this.openWithAutoLogin(inApp, url, options, alertMessage);
        }
        else {
            if (inApp) {
                this.utils.openInApp(url, options);
            }
            else {
                this.utils.openInBrowser(url);
            }
            return Promise.resolve(null);
        }
    };
    /**
     * Get the config of this site.
     * It is recommended to use getStoredConfig instead since it's faster and doesn't use network.
     *
     * @param {string} [name] Name of the setting to get. If not set or false, all settings will be returned.
     * @param {boolean} [ignoreCache] True if it should ignore cached data.
     * @return {Promise<any>} Promise resolved with site config.
     */
    CoreSite.prototype.getConfig = function (name, ignoreCache) {
        var preSets = {
            cacheKey: this.getConfigCacheKey()
        };
        if (ignoreCache) {
            preSets.getFromCache = false;
            preSets.emergencyCache = false;
        }
        return this.read('tool_mobile_get_config', {}, preSets).then(function (config) {
            if (name) {
                // Return the requested setting.
                for (var x in config.settings) {
                    if (config.settings[x].name == name) {
                        return config.settings[x].value;
                    }
                }
                return Promise.reject(null);
            }
            else {
                // Return all settings in the same array.
                var settings_1 = {};
                config.settings.forEach(function (setting) {
                    settings_1[setting.name] = setting.value;
                });
                return settings_1;
            }
        });
    };
    /**
     * Invalidates config WS call.
     *
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreSite.prototype.invalidateConfig = function () {
        return this.invalidateWsCacheForKey(this.getConfigCacheKey());
    };
    /**
     * Get cache key for getConfig WS calls.
     *
     * @return {string} Cache key.
     */
    CoreSite.prototype.getConfigCacheKey = function () {
        return 'tool_mobile_get_config';
    };
    /**
     * Get the stored config of this site.
     *
     * @param {string} [name] Name of the setting to get. If not set, all settings will be returned.
     * @return {any} Site config or a specific setting.
     */
    CoreSite.prototype.getStoredConfig = function (name) {
        if (!this.config) {
            return;
        }
        if (name) {
            return this.config[name];
        }
        else {
            return this.config;
        }
    };
    /**
     * Check if a certain feature is disabled in the site.
     *
     * @param {string} name Name of the feature to check.
     * @return {boolean} Whether it's disabled.
     */
    CoreSite.prototype.isFeatureDisabled = function (name) {
        var disabledFeatures = this.getStoredConfig('tool_mobile_disabledfeatures');
        if (!disabledFeatures) {
            return false;
        }
        var regEx = new RegExp('(,|^)' + this.textUtils.escapeForRegex(name) + '(,|$)', 'g');
        return !!disabledFeatures.match(regEx);
    };
    /**
     * Calculate if offline is disabled in the site.
     */
    CoreSite.prototype.calculateOfflineDisabled = function () {
        this.offlineDisabled = this.isFeatureDisabled('NoDelegate_CoreOffline');
    };
    /**
     * Get whether offline is disabled in the site.
     *
     * @return {boolean} Whether it's disabled.
     */
    CoreSite.prototype.isOfflineDisabled = function () {
        return this.offlineDisabled;
    };
    /**
     * Check if the site version is greater than one or several versions.
     * This function accepts a string or an array of strings. If array, the last version must be the highest.
     *
     * @param {string | string[]} versions Version or list of versions to check.
     * @return {boolean} Whether it's greater or equal, false otherwise.
     * @description
     * If a string is supplied (e.g. '3.2.1'), it will check if the site version is greater or equal than this version.
     *
     * If an array of versions is supplied, it will check if the site version is greater or equal than the last version,
     * or if it's higher or equal than any of the other releases supplied but lower than the next major release. The last
     * version of the array must be the highest version.
     * For example, if the values supplied are ['3.0.5', '3.2.3', '3.3.1'] the function will return true if the site version
     * is either:
     *     - Greater or equal than 3.3.1.
     *     - Greater or equal than 3.2.3 but lower than 3.3.
     *     - Greater or equal than 3.0.5 but lower than 3.1.
     *
     * This function only accepts versions from 2.4.0 and above. If any of the versions supplied isn't found, it will assume
     * it's the last released major version.
     */
    CoreSite.prototype.isVersionGreaterEqualThan = function (versions) {
        var siteVersion = parseInt(this.getInfo().version, 10);
        if (Array.isArray(versions)) {
            if (!versions.length) {
                return false;
            }
            for (var i = 0; i < versions.length; i++) {
                var versionNumber = this.getVersionNumber(versions[i]);
                if (i == versions.length - 1) {
                    // It's the last version, check only if site version is greater than this one.
                    return siteVersion >= versionNumber;
                }
                else {
                    // Check if site version if bigger than this number but lesser than next major.
                    if (siteVersion >= versionNumber && siteVersion < this.getNextMajorVersionNumber(versions[i])) {
                        return true;
                    }
                }
            }
        }
        else if (typeof versions == 'string') {
            // Compare with this version.
            return siteVersion >= this.getVersionNumber(versions);
        }
        return false;
    };
    /**
     * Given a URL, convert it to a URL that will auto-login if supported.
     *
     * @param {string} url The URL to convert.
     * @param {boolean} [showModal=true] Whether to show a loading modal.
     * @return {Promise<string>} Promise resolved with the converted URL.
     */
    CoreSite.prototype.getAutoLoginUrl = function (url, showModal) {
        var _this = this;
        if (showModal === void 0) { showModal = true; }
        if (!this.privateToken || !this.wsAvailable('tool_mobile_get_autologin_key') ||
            (this.lastAutoLogin && this.timeUtils.timestamp() - this.lastAutoLogin < __WEBPACK_IMPORTED_MODULE_13__core_constants__["a" /* CoreConstants */].SECONDS_MINUTE * 6)) {
            // No private token, WS not available or last auto-login was less than 6 minutes ago. Don't change the URL.
            return Promise.resolve(url);
        }
        var userId = this.getUserId(), params = {
            privatetoken: this.privateToken
        };
        var modal;
        if (showModal) {
            modal = this.domUtils.showModalLoading();
        }
        // Use write to not use cache.
        return this.write('tool_mobile_get_autologin_key', params).then(function (data) {
            if (!data.autologinurl || !data.key) {
                // Not valid data, return the same URL.
                return url;
            }
            _this.lastAutoLogin = _this.timeUtils.timestamp();
            return data.autologinurl + '?userid=' + userId + '&key=' + data.key + '&urltogo=' + url;
        }).catch(function () {
            // Couldn't get autologin key, return the same URL.
            return url;
        }).finally(function () {
            modal && modal.dismiss();
        });
    };
    /**
     * Get a version number from a release version.
     * If release version is valid but not found in the list of Moodle releases, it will use the last released major version.
     *
     * @param {string} version Release version to convert to version number.
     * @return {number} Version number, 0 if invalid.
     */
    CoreSite.prototype.getVersionNumber = function (version) {
        var data = this.getMajorAndMinor(version);
        if (!data) {
            // Invalid version.
            return 0;
        }
        if (typeof this.MOODLE_RELEASES[data.major] == 'undefined') {
            // Major version not found. Use the last one.
            data.major = Object.keys(this.MOODLE_RELEASES).slice(-1);
        }
        return this.MOODLE_RELEASES[data.major] + data.minor;
    };
    /**
     * Given a release version, return the major and minor versions.
     *
     * @param {string} version Release version (e.g. '3.1.0').
     * @return {object} Object with major and minor. Returns false if invalid version.
     */
    CoreSite.prototype.getMajorAndMinor = function (version) {
        var match = version.match(/(\d)+(?:\.(\d)+)?(?:\.(\d)+)?/);
        if (!match || !match[1]) {
            // Invalid version.
            return false;
        }
        return {
            major: match[1] + '.' + (match[2] || '0'),
            minor: parseInt(match[3], 10) || 0
        };
    };
    /**
     * Given a release version, return the next major version number.
     *
     * @param {string} version Release version (e.g. '3.1.0').
     * @return {number} Next major version number.
     */
    CoreSite.prototype.getNextMajorVersionNumber = function (version) {
        var data = this.getMajorAndMinor(version), releases = Object.keys(this.MOODLE_RELEASES);
        var position;
        if (!data) {
            // Invalid version.
            return 0;
        }
        position = releases.indexOf(data.major);
        if (position == -1 || position == releases.length - 1) {
            // Major version not found or it's the last one. Use the last one.
            return this.MOODLE_RELEASES[releases[position]];
        }
        return this.MOODLE_RELEASES[releases[position + 1]];
    };
    /**
     * Deletes a site setting.
     *
     * @param {string} name The config name.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreSite.prototype.deleteSiteConfig = function (name) {
        return this.db.deleteRecords(CoreSite.CONFIG_TABLE, { name: name });
    };
    /**
     * Get a site setting on local device.
     *
     * @param {string} name The config name.
     * @param {any} [defaultValue] Default value to use if the entry is not found.
     * @return {Promise<any>} Resolves upon success along with the config data. Reject on failure.
     */
    CoreSite.prototype.getLocalSiteConfig = function (name, defaultValue) {
        return this.db.getRecord(CoreSite.CONFIG_TABLE, { name: name }).then(function (entry) {
            return entry.value;
        }).catch(function (error) {
            if (typeof defaultValue != 'undefined') {
                return defaultValue;
            }
            return Promise.reject(error);
        });
    };
    /**
     * Set a site setting on local device.
     *
     * @param {string} name The config name.
     * @param {number|string} value The config value. Can only store number or strings.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreSite.prototype.setLocalSiteConfig = function (name, value) {
        return this.db.insertRecord(CoreSite.CONFIG_TABLE, { name: name, value: value });
    };
    CoreSite.REQUEST_QUEUE_DELAY = 50; // Maximum number of miliseconds to wait before processing the queue.
    CoreSite.REQUEST_QUEUE_LIMIT = 10; // Maximum number of requests allowed in the queue.
    CoreSite.REQUEST_QUEUE_FORCE_WS = false; // Use "tool_mobile_call_external_functions" even for calling a single function.
    // Constants for cache update frequency.
    CoreSite.FREQUENCY_USUALLY = 0;
    CoreSite.FREQUENCY_OFTEN = 1;
    CoreSite.FREQUENCY_SOMETIMES = 2;
    CoreSite.FREQUENCY_RARELY = 3;
    // Variables for the database.
    CoreSite.WS_CACHE_TABLE = 'wscache';
    CoreSite.CONFIG_TABLE = 'core_site_config';
    return CoreSite;
}());

//# sourceMappingURL=site.js.map

/***/ }),
/* 53 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreFileProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ionic_native_file__ = __webpack_require__(304);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__app__ = __webpack_require__(9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__logger__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__utils_mimetype__ = __webpack_require__(66);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__utils_text__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__ionic_native_zip__ = __webpack_require__(432);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};








/**
 * Factory to interact with the file system.
 */
var CoreFileProvider = /** @class */ (function () {
    function CoreFileProvider(logger, platform, file, appProvider, textUtils, zip, mimeUtils) {
        this.platform = platform;
        this.file = file;
        this.appProvider = appProvider;
        this.textUtils = textUtils;
        this.zip = zip;
        this.mimeUtils = mimeUtils;
        this.initialized = false;
        this.basePath = '';
        this.isHTMLAPI = false;
        this.CHUNK_SIZE = 10485760; // 10 MB.
        this.logger = logger.getInstance('CoreFileProvider');
        if (platform.is('android') && !Object.getOwnPropertyDescriptor(FileReader.prototype, 'onloadend')) {
            // Cordova File plugin creates some getters and setter for FileReader, but Ionic's polyfills override them in Android.
            // Create the getters and setters again. This code comes from FileReader.js in cordova-plugin-file.
            this.defineGetterSetter(FileReader.prototype, 'readyState', function () {
                return this._localURL ? this._readyState : this._realReader.readyState;
            });
            this.defineGetterSetter(FileReader.prototype, 'error', function () {
                return this._localURL ? this._error : this._realReader.error;
            });
            this.defineGetterSetter(FileReader.prototype, 'result', function () {
                return this._localURL ? this._result : this._realReader.result;
            });
            this.defineEvent('onloadstart');
            this.defineEvent('onprogress');
            this.defineEvent('onload');
            this.defineEvent('onerror');
            this.defineEvent('onloadend');
            this.defineEvent('onabort');
        }
    }
    CoreFileProvider_1 = CoreFileProvider;
    /**
     * Define an event for FileReader.
     *
     * @param {string} eventName Name of the event.
     */
    CoreFileProvider.prototype.defineEvent = function (eventName) {
        this.defineGetterSetter(FileReader.prototype, eventName, function () {
            return this._realReader[eventName] || null;
        }, function (value) {
            this._realReader[eventName] = value;
        });
    };
    /**
     * Define a getter and, optionally, a setter for a certain property in an object.
     *
     * @param {any} obj Object to set the getter/setter for.
     * @param {string} key Name of the property where to set them.
     * @param {Function} getFunc The getter function.
     * @param {Function} [setFunc] The setter function.
     */
    CoreFileProvider.prototype.defineGetterSetter = function (obj, key, getFunc, setFunc) {
        if (Object.defineProperty) {
            var desc = {
                get: getFunc,
                configurable: true
            };
            if (setFunc) {
                desc.set = setFunc;
            }
            Object.defineProperty(obj, key, desc);
        }
        else {
            obj.__defineGetter__(key, getFunc);
            if (setFunc) {
                obj.__defineSetter__(key, setFunc);
            }
        }
    };
    /**
     * Sets basePath to use with HTML API. Reserved for core use.
     *
     * @param {string} path Base path to use.
     */
    CoreFileProvider.prototype.setHTMLBasePath = function (path) {
        this.isHTMLAPI = true;
        this.basePath = path;
    };
    /**
     * Checks if we're using HTML API.
     *
     * @return {boolean} True if uses HTML API, false otherwise.
     */
    CoreFileProvider.prototype.usesHTMLAPI = function () {
        return this.isHTMLAPI;
    };
    /**
     * Initialize basePath based on the OS if it's not initialized already.
     *
     * @return {Promise<void>} Promise to be resolved when the initialization is finished.
     */
    CoreFileProvider.prototype.init = function () {
        var _this = this;
        if (this.initialized) {
            return Promise.resolve();
        }
        return this.platform.ready().then(function () {
            if (_this.platform.is('android')) {
                _this.basePath = _this.file.externalApplicationStorageDirectory || _this.basePath;
            }
            else if (_this.platform.is('ios')) {
                _this.basePath = _this.file.documentsDirectory || _this.basePath;
            }
            else if (!_this.isAvailable() || _this.basePath === '') {
                _this.logger.error('Error getting device OS.');
                return Promise.reject(null);
            }
            _this.initialized = true;
            _this.logger.debug('FS initialized: ' + _this.basePath);
        });
    };
    /**
     * Check if the plugin is available.
     *
     * @return {boolean} Whether the plugin is available.
     */
    CoreFileProvider.prototype.isAvailable = function () {
        return typeof window.resolveLocalFileSystemURL !== 'undefined';
    };
    /**
     * Get a file.
     *
     * @param {string} path Relative path to the file.
     * @return {Promise<FileEntry>} Promise resolved when the file is retrieved.
     */
    CoreFileProvider.prototype.getFile = function (path) {
        var _this = this;
        return this.init().then(function () {
            _this.logger.debug('Get file: ' + path);
            return _this.file.resolveLocalFilesystemUrl(_this.addBasePathIfNeeded(path));
        }).then(function (entry) {
            return entry;
        });
    };
    /**
     * Get a directory.
     *
     * @param {string} path Relative path to the directory.
     * @return {Promise<DirectoryEntry>} Promise resolved when the directory is retrieved.
     */
    CoreFileProvider.prototype.getDir = function (path) {
        var _this = this;
        return this.init().then(function () {
            _this.logger.debug('Get directory: ' + path);
            return _this.file.resolveDirectoryUrl(_this.addBasePathIfNeeded(path));
        });
    };
    /**
     * Get site folder path.
     *
     * @param {string} siteId Site ID.
     * @return {string} Site folder path.
     */
    CoreFileProvider.prototype.getSiteFolder = function (siteId) {
        return CoreFileProvider_1.SITESFOLDER + '/' + siteId;
    };
    /**
     * Create a directory or a file.
     *
     * @param {boolean} isDirectory True if a directory should be created, false if it should create a file.
     * @param {string} path Relative path to the dir/file.
     * @param {boolean} [failIfExists] True if it should fail if the dir/file exists, false otherwise.
     * @param {string} [base] Base path to create the dir/file in. If not set, use basePath.
     * @return {Promise<any>} Promise to be resolved when the dir/file is created.
     */
    CoreFileProvider.prototype.create = function (isDirectory, path, failIfExists, base) {
        var _this = this;
        return this.init().then(function () {
            // Remove basePath if it's in the path.
            path = _this.removeStartingSlash(path.replace(_this.basePath, ''));
            base = base || _this.basePath;
            if (path.indexOf('/') == -1) {
                if (isDirectory) {
                    _this.logger.debug('Create dir ' + path + ' in ' + base);
                    return _this.file.createDir(base, path, !failIfExists);
                }
                else {
                    _this.logger.debug('Create file ' + path + ' in ' + base);
                    return _this.file.createFile(base, path, !failIfExists);
                }
            }
            else {
                // The file plugin doesn't allow creating more than 1 level at a time (e.g. tmp/folder).
                // We need to create them 1 by 1.
                var firstDir_1 = path.substr(0, path.indexOf('/')), restOfPath_1 = path.substr(path.indexOf('/') + 1);
                _this.logger.debug('Create dir ' + firstDir_1 + ' in ' + base);
                return _this.file.createDir(base, firstDir_1, true).then(function (newDirEntry) {
                    return _this.create(isDirectory, restOfPath_1, failIfExists, newDirEntry.toURL());
                }).catch(function (error) {
                    _this.logger.error('Error creating directory ' + firstDir_1 + ' in ' + base);
                    return Promise.reject(error);
                });
            }
        });
    };
    /**
     * Create a directory.
     *
     * @param {string} path Relative path to the directory.
     * @param {boolean} [failIfExists] True if it should fail if the directory exists, false otherwise.
     * @return {Promise<DirectoryEntry>} Promise to be resolved when the directory is created.
     */
    CoreFileProvider.prototype.createDir = function (path, failIfExists) {
        return this.create(true, path, failIfExists);
    };
    /**
     * Create a file.
     *
     * @param {string} path Relative path to the file.
     * @param {boolean} [failIfExists] True if it should fail if the file exists, false otherwise..
     * @return {Promise<FileEntry>} Promise to be resolved when the file is created.
     */
    CoreFileProvider.prototype.createFile = function (path, failIfExists) {
        return this.create(false, path, failIfExists);
    };
    /**
     * Removes a directory and all its contents.
     *
     * @param {string} path Relative path to the directory.
     * @return {Promise<any>} Promise to be resolved when the directory is deleted.
     */
    CoreFileProvider.prototype.removeDir = function (path) {
        var _this = this;
        return this.init().then(function () {
            // Remove basePath if it's in the path.
            path = _this.removeStartingSlash(path.replace(_this.basePath, ''));
            _this.logger.debug('Remove directory: ' + path);
            return _this.file.removeRecursively(_this.basePath, path);
        });
    };
    /**
     * Removes a file and all its contents.
     *
     * @param {string} path Relative path to the file.
     * @return {Promise<any>} Promise to be resolved when the file is deleted.
     */
    CoreFileProvider.prototype.removeFile = function (path) {
        var _this = this;
        return this.init().then(function () {
            // Remove basePath if it's in the path.
            path = _this.removeStartingSlash(path.replace(_this.basePath, ''));
            _this.logger.debug('Remove file: ' + path);
            return _this.file.removeFile(_this.basePath, path).catch(function (error) {
                // The delete can fail if the path has encoded characters. Try again if that's the case.
                var decodedPath = decodeURI(path);
                if (decodedPath != path) {
                    return _this.file.removeFile(_this.basePath, decodedPath);
                }
                else {
                    return Promise.reject(error);
                }
            });
        });
    };
    /**
     * Removes a file given its FileEntry.
     *
     * @param {FileEntry} fileEntry File Entry.
     * @return {Promise<any>} Promise resolved when the file is deleted.
     */
    CoreFileProvider.prototype.removeFileByFileEntry = function (fileEntry) {
        return new Promise(function (resolve, reject) {
            fileEntry.remove(resolve, reject);
        });
    };
    /**
     * Retrieve the contents of a directory (not subdirectories).
     *
     * @param {string} path Relative path to the directory.
     * @return {Promise<any>} Promise to be resolved when the contents are retrieved.
     */
    CoreFileProvider.prototype.getDirectoryContents = function (path) {
        var _this = this;
        return this.init().then(function () {
            // Remove basePath if it's in the path.
            path = _this.removeStartingSlash(path.replace(_this.basePath, ''));
            _this.logger.debug('Get contents of dir: ' + path);
            return _this.file.listDir(_this.basePath, path);
        });
    };
    /**
     * Calculate the size of a directory or a file.
     *
     * @param {any} entry Directory or file.
     * @return {Promise<number>} Promise to be resolved when the size is calculated.
     */
    CoreFileProvider.prototype.getSize = function (entry) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            if (entry.isDirectory) {
                var directoryReader = entry.createReader();
                directoryReader.readEntries(function (entries) {
                    var promises = [];
                    for (var i = 0; i < entries.length; i++) {
                        promises.push(_this.getSize(entries[i]));
                    }
                    Promise.all(promises).then(function (sizes) {
                        var directorySize = 0;
                        for (var i = 0; i < sizes.length; i++) {
                            var fileSize = parseInt(sizes[i]);
                            if (isNaN(fileSize)) {
                                reject();
                                return;
                            }
                            directorySize += fileSize;
                        }
                        resolve(directorySize);
                    }, reject);
                }, reject);
            }
            else if (entry.isFile) {
                entry.file(function (file) {
                    resolve(file.size);
                }, reject);
            }
        });
    };
    /**
     * Calculate the size of a directory.
     *
     * @param {string} path Relative path to the directory.
     * @return {Promise<number>} Promise to be resolved when the size is calculated.
     */
    CoreFileProvider.prototype.getDirectorySize = function (path) {
        var _this = this;
        // Remove basePath if it's in the path.
        path = this.removeStartingSlash(path.replace(this.basePath, ''));
        this.logger.debug('Get size of dir: ' + path);
        return this.getDir(path).then(function (dirEntry) {
            return _this.getSize(dirEntry);
        });
    };
    /**
     * Calculate the size of a file.
     *
     * @param {string} path Relative path to the file.
     * @return {Promise<number>} Promise to be resolved when the size is calculated.
     */
    CoreFileProvider.prototype.getFileSize = function (path) {
        var _this = this;
        // Remove basePath if it's in the path.
        path = this.removeStartingSlash(path.replace(this.basePath, ''));
        this.logger.debug('Get size of file: ' + path);
        return this.getFile(path).then(function (fileEntry) {
            return _this.getSize(fileEntry);
        });
    };
    /**
     * Get file object from a FileEntry.
     *
     * @param {FileEntry} path Relative path to the file.
     * @return {Promise<any>} Promise to be resolved when the file is retrieved.
     */
    CoreFileProvider.prototype.getFileObjectFromFileEntry = function (entry) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            _this.logger.debug('Get file object of: ' + entry.fullPath);
            entry.file(resolve, reject);
        });
    };
    /**
     * Calculate the free space in the disk.
     * Please notice that this function isn't reliable and it's not documented in the Cordova File plugin.
     *
     * @return {Promise<number>} Promise resolved with the estimated free space in bytes.
     */
    CoreFileProvider.prototype.calculateFreeSpace = function () {
        var _this = this;
        return this.file.getFreeDiskSpace().then(function (size) {
            if (_this.platform.is('ios')) {
                // In iOS the size is in bytes.
                return Number(size);
            }
            // The size is in KB, convert it to bytes.
            return Number(size) * 1024;
        });
    };
    /**
     * Normalize a filename that usually comes URL encoded.
     *
     * @param {string} filename The file name.
     * @return {string} The file name normalized.
     */
    CoreFileProvider.prototype.normalizeFileName = function (filename) {
        filename = this.textUtils.decodeURIComponent(filename);
        return filename;
    };
    /**
     * Read a file from local file system.
     *
     * @param {string} path Relative path to the file.
     * @param {number} [format=FORMATTEXT] Format to read the file. Must be one of:
     *                                  FORMATTEXT
     *                                  FORMATDATAURL
     *                                  FORMATBINARYSTRING
     *                                  FORMATARRAYBUFFER
     * @return {Promise<any>} Promise to be resolved when the file is read.
     */
    CoreFileProvider.prototype.readFile = function (path, format) {
        if (format === void 0) { format = CoreFileProvider_1.FORMATTEXT; }
        // Remove basePath if it's in the path.
        path = this.removeStartingSlash(path.replace(this.basePath, ''));
        this.logger.debug('Read file ' + path + ' with format ' + format);
        switch (format) {
            case CoreFileProvider_1.FORMATDATAURL:
                return this.file.readAsDataURL(this.basePath, path);
            case CoreFileProvider_1.FORMATBINARYSTRING:
                return this.file.readAsBinaryString(this.basePath, path);
            case CoreFileProvider_1.FORMATARRAYBUFFER:
                return this.file.readAsArrayBuffer(this.basePath, path);
            default:
                return this.file.readAsText(this.basePath, path);
        }
    };
    /**
     * Read file contents from a file data object.
     *
     * @param {any} fileData File's data.
     * @param {number} [format=FORMATTEXT] Format to read the file. Must be one of:
     *                                  FORMATTEXT
     *                                  FORMATDATAURL
     *                                  FORMATBINARYSTRING
     *                                  FORMATARRAYBUFFER
     * @return {Promise<any>} Promise to be resolved when the file is read.
     */
    CoreFileProvider.prototype.readFileData = function (fileData, format) {
        if (format === void 0) { format = CoreFileProvider_1.FORMATTEXT; }
        format = format || CoreFileProvider_1.FORMATTEXT;
        this.logger.debug('Read file from file data with format ' + format);
        return new Promise(function (resolve, reject) {
            var reader = new FileReader();
            reader.onloadend = function (evt) {
                var target = evt.target; // Convert to <any> to be able to use non-standard properties.
                if (target.result !== undefined || target.result !== null) {
                    resolve(target.result);
                }
                else if (target.error !== undefined || target.error !== null) {
                    reject(target.error);
                }
                else {
                    reject({ code: null, message: 'READER_ONLOADEND_ERR' });
                }
            };
            // Check if the load starts. If it doesn't start in 3 seconds, reject.
            // Sometimes in Android the read doesn't start for some reason, so the promise never finishes.
            var hasStarted = false;
            reader.onloadstart = function (evt) {
                hasStarted = true;
            };
            setTimeout(function () {
                if (!hasStarted) {
                    reject('Upload cannot start.');
                }
            }, 3000);
            switch (format) {
                case CoreFileProvider_1.FORMATDATAURL:
                    reader.readAsDataURL(fileData);
                    break;
                case CoreFileProvider_1.FORMATBINARYSTRING:
                    reader.readAsBinaryString(fileData);
                    break;
                case CoreFileProvider_1.FORMATARRAYBUFFER:
                    reader.readAsArrayBuffer(fileData);
                    break;
                default:
                    reader.readAsText(fileData);
            }
        });
    };
    /**
     * Writes some data in a file.
     *
     * @param {string} path Relative path to the file.
     * @param {any} data Data to write.
     * @param {boolean} [append] Whether to append the data to the end of the file.
     * @return {Promise<any>} Promise to be resolved when the file is written.
     */
    CoreFileProvider.prototype.writeFile = function (path, data, append) {
        var _this = this;
        return this.init().then(function () {
            // Remove basePath if it's in the path.
            path = _this.removeStartingSlash(path.replace(_this.basePath, ''));
            _this.logger.debug('Write file: ' + path);
            // Create file (and parent folders) to prevent errors.
            return _this.createFile(path).then(function (fileEntry) {
                if (_this.isHTMLAPI && !_this.appProvider.isDesktop() &&
                    (typeof data == 'string' || data.toString() == '[object ArrayBuffer]')) {
                    // We need to write Blobs.
                    var type = _this.mimeUtils.getMimeType(_this.mimeUtils.getFileExtension(path));
                    data = new Blob([data], { type: type || 'text/plain' });
                }
                return _this.file.writeFile(_this.basePath, path, data, { replace: !append, append: !!append }).then(function () {
                    return fileEntry;
                });
            });
        });
    };
    /**
     * Write some file data into a filesystem file.
     * It's done in chunks to prevent crashing the app for big files.
     *
     * @param {any} file The data to write.
     * @param {string} path Path where to store the data.
     * @param {Function} [onProgress] Function to call on progress.
     * @param {number} [offset=0] Offset where to start reading from.
     * @param {boolean} [append] Whether to append the data to the end of the file.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreFileProvider.prototype.writeFileDataInFile = function (file, path, onProgress, offset, append) {
        var _this = this;
        if (offset === void 0) { offset = 0; }
        offset = offset || 0;
        // Get the chunk to read.
        var blob = file.slice(offset, Math.min(offset + this.CHUNK_SIZE, file.size));
        return this.writeFileDataInFileChunk(blob, path, append).then(function (fileEntry) {
            offset += _this.CHUNK_SIZE;
            onProgress && onProgress({
                lengthComputable: true,
                loaded: offset,
                total: file.size
            });
            if (offset >= file.size) {
                // Done, stop.
                return fileEntry;
            }
            // Read the next chunk.
            return _this.writeFileDataInFile(file, path, onProgress, offset, true);
        });
    };
    /**
     * Write a chunk of data into a file.
     *
     * @param {any} chunkData The chunk of data.
     * @param {string} path Path where to store the data.
     * @param {boolean} [append] Whether to append the data to the end of the file.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreFileProvider.prototype.writeFileDataInFileChunk = function (chunkData, path, append) {
        var _this = this;
        // Read the chunk data.
        return this.readFileData(chunkData, CoreFileProvider_1.FORMATARRAYBUFFER).then(function (fileData) {
            // Write the data in the file.
            return _this.writeFile(path, fileData, append);
        });
    };
    /**
     * Gets a file that might be outside the app's folder.
     *
     * @param {string} fullPath Absolute path to the file.
     * @return {Promise<FileEntry>} Promise to be resolved when the file is retrieved.
     */
    CoreFileProvider.prototype.getExternalFile = function (fullPath) {
        return this.file.resolveLocalFilesystemUrl(fullPath).then(function (entry) {
            return entry;
        });
    };
    /**
     * Removes a file that might be outside the app's folder.
     *
     * @param {string} fullPath Absolute path to the file.
     * @return {Promise<any>} Promise to be resolved when the file is removed.
     */
    CoreFileProvider.prototype.removeExternalFile = function (fullPath) {
        var directory = fullPath.substring(0, fullPath.lastIndexOf('/')), filename = fullPath.substr(fullPath.lastIndexOf('/') + 1);
        return this.file.removeFile(directory, filename);
    };
    /**
     * Get the base path where the application files are stored.
     *
     * @return {Promise<string>} Promise to be resolved when the base path is retrieved.
     */
    CoreFileProvider.prototype.getBasePath = function () {
        var _this = this;
        return this.init().then(function () {
            if (_this.basePath.slice(-1) == '/') {
                return _this.basePath;
            }
            else {
                return _this.basePath + '/';
            }
        });
    };
    /**
     * Get the base path where the application files are stored in the format to be used for downloads.
     * iOS: Internal URL (cdvfile://).
     * Others: basePath (file://)
     *
     * @return {Promise<string>} Promise to be resolved when the base path is retrieved.
     */
    CoreFileProvider.prototype.getBasePathToDownload = function () {
        var _this = this;
        return this.init().then(function () {
            if (_this.platform.is('ios')) {
                // In iOS we want the internal URL (cdvfile://localhost/persistent/...).
                return _this.file.resolveDirectoryUrl(_this.basePath).then(function (dirEntry) {
                    return dirEntry.toInternalURL();
                });
            }
            else {
                // In the other platforms we use the basePath as it is (file://...).
                return _this.basePath;
            }
        });
    };
    /**
     * Get the base path where the application files are stored. Returns the value instantly, without waiting for it to be ready.
     *
     * @return {string} Base path. If the service hasn't been initialized it will return an invalid value.
     */
    CoreFileProvider.prototype.getBasePathInstant = function () {
        if (!this.basePath) {
            return this.basePath;
        }
        else if (this.basePath.slice(-1) == '/') {
            return this.basePath;
        }
        else {
            return this.basePath + '/';
        }
    };
    /**
     * Move a file.
     *
     * @param {string} [originalPath] Path to the file to move.
     * @param {string} [newPath] New path of the file.
     * @return {Promise<any>} Promise resolved when the entry is moved.
     */
    CoreFileProvider.prototype.moveFile = function (originalPath, newPath) {
        var _this = this;
        return this.init().then(function () {
            // Remove basePath if it's in the paths.
            originalPath = _this.removeStartingSlash(originalPath.replace(_this.basePath, ''));
            newPath = _this.removeStartingSlash(newPath.replace(_this.basePath, ''));
            if (_this.isHTMLAPI) {
                // In Cordova API we need to calculate the longest matching path to make it work.
                // The function this.file.moveFile('a/', 'b/c.ext', 'a/', 'b/d.ext') doesn't work.
                // The function this.file.moveFile('a/b/', 'c.ext', 'a/b/', 'd.ext') works.
                var dirsA = originalPath.split('/'), dirsB = newPath.split('/');
                var commonPath = _this.basePath;
                for (var i = 0; i < dirsA.length; i++) {
                    var dir = dirsA[i];
                    if (dirsB[i] === dir) {
                        // Found a common folder, add it to common path and remove it from each specific path.
                        dir = dir + '/';
                        commonPath = _this.textUtils.concatenatePaths(commonPath, dir);
                        originalPath = originalPath.replace(dir, '');
                        newPath = newPath.replace(dir, '');
                    }
                    else {
                        // Folder doesn't match, stop searching.
                        break;
                    }
                }
                return _this.file.moveFile(commonPath, originalPath, commonPath, newPath);
            }
            else {
                return _this.file.moveFile(_this.basePath, originalPath, _this.basePath, newPath).catch(function (error) {
                    // The move can fail if the path has encoded characters. Try again if that's the case.
                    var decodedOriginal = decodeURI(originalPath), decodedNew = decodeURI(newPath);
                    if (decodedOriginal != originalPath || decodedNew != newPath) {
                        return _this.file.moveFile(_this.basePath, decodedOriginal, _this.basePath, decodedNew);
                    }
                    else {
                        return Promise.reject(error);
                    }
                });
            }
        });
    };
    /**
     * Copy a file.
     *
     * @param {string} from Path to the file to move.
     * @param {string} to New path of the file.
     * @return {Promise<any>} Promise resolved when the entry is copied.
     */
    CoreFileProvider.prototype.copyFile = function (from, to) {
        var _this = this;
        var fromFileAndDir, toFileAndDir;
        return this.init().then(function () {
            // Paths cannot start with "/". Remove basePath if present.
            from = _this.removeStartingSlash(from.replace(_this.basePath, ''));
            to = _this.removeStartingSlash(to.replace(_this.basePath, ''));
            fromFileAndDir = _this.getFileAndDirectoryFromPath(from);
            toFileAndDir = _this.getFileAndDirectoryFromPath(to);
            if (toFileAndDir.directory) {
                // Create the target directory if it doesn't exist.
                return _this.createDir(toFileAndDir.directory);
            }
        }).then(function () {
            if (_this.isHTMLAPI) {
                // In HTML API, the file name cannot include a directory, otherwise it fails.
                var fromDir = _this.textUtils.concatenatePaths(_this.basePath, fromFileAndDir.directory), toDir = _this.textUtils.concatenatePaths(_this.basePath, toFileAndDir.directory);
                return _this.file.copyFile(fromDir, fromFileAndDir.name, toDir, toFileAndDir.name);
            }
            else {
                return _this.file.copyFile(_this.basePath, from, _this.basePath, to).catch(function (error) {
                    // The copy can fail if the path has encoded characters. Try again if that's the case.
                    var decodedFrom = decodeURI(from), decodedTo = decodeURI(to);
                    if (from != decodedFrom || to != decodedTo) {
                        return _this.file.copyFile(_this.basePath, decodedFrom, _this.basePath, decodedTo);
                    }
                    else {
                        return Promise.reject(error);
                    }
                });
            }
        });
    };
    /**
     * Extract the file name and directory from a given path.
     *
     * @param {string} path Path to be extracted.
     * @return {any} Plain object containing the file name and directory.
     * @description
     * file.pdf         -> directory: '', name: 'file.pdf'
     * /file.pdf        -> directory: '', name: 'file.pdf'
     * path/file.pdf    -> directory: 'path', name: 'file.pdf'
     * path/            -> directory: 'path', name: ''
     * path             -> directory: '', name: 'path'
     */
    CoreFileProvider.prototype.getFileAndDirectoryFromPath = function (path) {
        var file = {
            directory: '',
            name: ''
        };
        file.directory = path.substring(0, path.lastIndexOf('/'));
        file.name = path.substr(path.lastIndexOf('/') + 1);
        return file;
    };
    /**
     * Get the internal URL of a file.
     *
     * @param {FileEntry} fileEntry File Entry.
     * @return {string} Internal URL.
     */
    CoreFileProvider.prototype.getInternalURL = function (fileEntry) {
        if (!fileEntry.toInternalURL) {
            // File doesn't implement toInternalURL, use toURL.
            return fileEntry.toURL();
        }
        return fileEntry.toInternalURL();
    };
    /**
     * Adds the basePath to a path if it doesn't have it already.
     *
     * @param {string} path Path to treat.
     * @return {string} Path with basePath added.
     */
    CoreFileProvider.prototype.addBasePathIfNeeded = function (path) {
        if (path.indexOf(this.basePath) > -1) {
            return path;
        }
        else {
            return this.textUtils.concatenatePaths(this.basePath, path);
        }
    };
    /**
     * Remove the base path from a path. If basePath isn't found, return false.
     *
     * @param {string} path Path to treat.
     * @return {string} Path without basePath if basePath was found, undefined otherwise.
     */
    CoreFileProvider.prototype.removeBasePath = function (path) {
        if (path.indexOf(this.basePath) > -1) {
            return path.replace(this.basePath, '');
        }
    };
    /**
     * Unzips a file.
     *
     * @param {string} path Path to the ZIP file.
     * @param {string} [destFolder] Path to the destination folder. If not defined, a new folder will be created with the
     *                     same location and name as the ZIP file (without extension).
     * @param {Function} [onProgress] Function to call on progress.
     * @return {Promise<any>} Promise resolved when the file is unzipped.
     */
    CoreFileProvider.prototype.unzipFile = function (path, destFolder, onProgress) {
        var _this = this;
        // Get the source file.
        return this.getFile(path).then(function (fileEntry) {
            // If destFolder is not set, use same location as ZIP file. We need to use absolute paths (including basePath).
            destFolder = _this.addBasePathIfNeeded(destFolder || _this.mimeUtils.removeExtension(path));
            return _this.zip.unzip(fileEntry.toURL(), destFolder, onProgress);
        }).then(function (result) {
            if (result == -1) {
                return Promise.reject(null);
            }
        });
    };
    /**
     * Search a string or regexp in a file contents and replace it. The result is saved in the same file.
     *
     * @param {string} path Path to the file.
     * @param {string|RegExp} search Value to search.
     * @param {string} newValue New value.
     * @return {Promise<any>} Promise resolved in success.
     */
    CoreFileProvider.prototype.replaceInFile = function (path, search, newValue) {
        var _this = this;
        return this.readFile(path).then(function (content) {
            if (typeof content == 'undefined' || content === null || !content.replace) {
                return Promise.reject(null);
            }
            if (content.match(search)) {
                content = content.replace(search, newValue);
                return _this.writeFile(path, content);
            }
        });
    };
    /**
     * Get a file/dir metadata given the file's entry.
     *
     * @param {Entry} fileEntry FileEntry retrieved from getFile or similar.
     * @return {Promise<any>} Promise resolved with metadata.
     */
    CoreFileProvider.prototype.getMetadata = function (fileEntry) {
        if (!fileEntry || !fileEntry.getMetadata) {
            return Promise.reject(null);
        }
        return new Promise(function (resolve, reject) {
            fileEntry.getMetadata(resolve, reject);
        });
    };
    /**
     * Get a file/dir metadata given the path.
     *
     * @param {string} path Path to the file/dir.
     * @param {boolean} [isDir] True if directory, false if file.
     * @return {Promise<any>} Promise resolved with metadata.
     */
    CoreFileProvider.prototype.getMetadataFromPath = function (path, isDir) {
        var _this = this;
        var promise;
        if (isDir) {
            promise = this.getDir(path);
        }
        else {
            promise = this.getFile(path);
        }
        return promise.then(function (entry) {
            return _this.getMetadata(entry);
        });
    };
    /**
     * Remove the starting slash of a path if it's there. E.g. '/sites/filepool' -> 'sites/filepool'.
     *
     * @param {string} path Path.
     * @return {string} Path without a slash in the first position.
     */
    CoreFileProvider.prototype.removeStartingSlash = function (path) {
        if (path[0] == '/') {
            return path.substr(1);
        }
        return path;
    };
    /**
     * Convenience function to copy or move an external file.
     *
     * @param {string} from Absolute path to the file to copy/move.
     * @param {string} to Relative new path of the file (inside the app folder).
     * @param {boolean} copy True to copy, false to move.
     * @return {Promise<any>} Promise resolved when the entry is copied/moved.
     */
    CoreFileProvider.prototype.copyOrMoveExternalFile = function (from, to, copy) {
        var _this = this;
        // Get the file to copy/move.
        return this.getExternalFile(from).then(function (fileEntry) {
            // Create the destination dir if it doesn't exist.
            var dirAndFile = _this.getFileAndDirectoryFromPath(to);
            return _this.createDir(dirAndFile.directory).then(function (dirEntry) {
                // Now copy/move the file.
                return new Promise(function (resolve, reject) {
                    if (copy) {
                        fileEntry.copyTo(dirEntry, dirAndFile.name, resolve, reject);
                    }
                    else {
                        fileEntry.moveTo(dirEntry, dirAndFile.name, resolve, reject);
                    }
                });
            });
        });
    };
    /**
     * Copy a file from outside of the app folder to somewhere inside the app folder.
     *
     * @param {string} from Absolute path to the file to copy.
     * @param {string} to Relative new path of the file (inside the app folder).
     * @return {Promise<any>} Promise resolved when the entry is copied.
     */
    CoreFileProvider.prototype.copyExternalFile = function (from, to) {
        return this.copyOrMoveExternalFile(from, to, true);
    };
    /**
     * Move a file from outside of the app folder to somewhere inside the app folder.
     *
     * @param {string} from Absolute path to the file to move.
     * @param {string} to Relative new path of the file (inside the app folder).
     * @return {Promise<any>} Promise resolved when the entry is moved.
     */
    CoreFileProvider.prototype.moveExternalFile = function (from, to) {
        return this.copyOrMoveExternalFile(from, to, false);
    };
    /**
     * Get a unique file name inside a folder, adding numbers to the file name if needed.
     *
     * @param {string} dirPath Path to the destination folder.
     * @param {string} fileName File name that wants to be used.
     * @param {string} [defaultExt] Default extension to use if no extension found in the file.
     * @return {Promise<string>} Promise resolved with the unique file name.
     */
    CoreFileProvider.prototype.getUniqueNameInFolder = function (dirPath, fileName, defaultExt) {
        var _this = this;
        // Get existing files in the folder.
        return this.getDirectoryContents(dirPath).then(function (entries) {
            var files = {};
            var num = 1, fileNameWithoutExtension = _this.mimeUtils.removeExtension(fileName), extension = _this.mimeUtils.getFileExtension(fileName) || defaultExt, newName;
            // Clean the file name.
            fileNameWithoutExtension = _this.textUtils.removeSpecialCharactersForFiles(_this.textUtils.decodeURIComponent(fileNameWithoutExtension));
            // Index the files by name.
            entries.forEach(function (entry) {
                files[entry.name.toLowerCase()] = entry;
            });
            // Format extension.
            if (extension) {
                extension = '.' + extension;
            }
            else {
                extension = '';
            }
            newName = fileNameWithoutExtension + extension;
            if (typeof files[newName.toLowerCase()] == 'undefined') {
                // No file with the same name.
                return newName;
            }
            else {
                // Repeated name. Add a number until we find a free name.
                do {
                    newName = fileNameWithoutExtension + '(' + num + ')' + extension;
                    num++;
                } while (typeof files[newName] != 'undefined');
                // Ask the user what he wants to do.
                return newName;
            }
        }).catch(function () {
            // Folder doesn't exist, name is unique. Clean it and return it.
            return _this.textUtils.removeSpecialCharactersForFiles(_this.textUtils.decodeURIComponent(fileName));
        });
    };
    /**
     * Remove app temporary folder.
     *
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreFileProvider.prototype.clearTmpFolder = function () {
        return this.removeDir(CoreFileProvider_1.TMPFOLDER).catch(function () {
            // Ignore errors because the folder might not exist.
        });
    };
    /**
     * Given a folder path and a list of used files, remove all the files of the folder that aren't on the list of used files.
     *
     * @param {string} dirPath Folder path.
     * @param {any[]} files List of used files.
     * @return {Promise<any>} Promise resolved when done, rejected if failure.
     */
    CoreFileProvider.prototype.removeUnusedFiles = function (dirPath, files) {
        var _this = this;
        // Get the directory contents.
        return this.getDirectoryContents(dirPath).then(function (contents) {
            if (!contents.length) {
                return;
            }
            var filesMap = {}, promises = [];
            // Index the received files by fullPath and ignore the invalid ones.
            files.forEach(function (file) {
                if (file.fullPath) {
                    filesMap[file.fullPath] = file;
                }
            });
            // Check which of the content files aren't used anymore and delete them.
            contents.forEach(function (file) {
                if (!filesMap[file.fullPath]) {
                    // File isn't used, delete it.
                    promises.push(_this.removeFileByFileEntry(file));
                }
            });
            return Promise.all(promises);
        }).catch(function () {
            // Ignore errors, maybe it doesn't exist.
        });
    };
    /**
     * Check if a file is inside the app's folder.
     *
     * @param {string} path The absolute path of the file to check.
     * @return {boolean} Whether the file is in the app's folder.
     */
    CoreFileProvider.prototype.isFileInAppFolder = function (path) {
        return path.indexOf(this.basePath) != -1;
    };
    // Formats to read a file.
    CoreFileProvider.FORMATTEXT = 0;
    CoreFileProvider.FORMATDATAURL = 1;
    CoreFileProvider.FORMATBINARYSTRING = 2;
    CoreFileProvider.FORMATARRAYBUFFER = 3;
    // Folders.
    CoreFileProvider.SITESFOLDER = 'sites';
    CoreFileProvider.TMPFOLDER = 'tmp';
    CoreFileProvider = CoreFileProvider_1 = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_4__logger__["a" /* CoreLoggerProvider */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["v" /* Platform */], __WEBPACK_IMPORTED_MODULE_2__ionic_native_file__["a" /* File */], __WEBPACK_IMPORTED_MODULE_3__app__["a" /* CoreAppProvider */],
            __WEBPACK_IMPORTED_MODULE_6__utils_text__["a" /* CoreTextUtilsProvider */], __WEBPACK_IMPORTED_MODULE_7__ionic_native_zip__["a" /* Zip */], __WEBPACK_IMPORTED_MODULE_5__utils_mimetype__["a" /* CoreMimetypeUtilsProvider */]])
    ], CoreFileProvider);
    return CoreFileProvider;
    var CoreFileProvider_1;
}());

//# sourceMappingURL=file.js.map

/***/ }),
/* 54 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreSitePluginsProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__providers_app__ = __webpack_require__(9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_filepool__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__providers_lang__ = __webpack_require__(170);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__providers_logger__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__classes_site__ = __webpack_require__(52);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__providers_sites__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__providers_utils_text__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__providers_utils_utils__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__configconstants__ = __webpack_require__(119);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__core_courses_providers_courses__ = __webpack_require__(51);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__providers_events__ = __webpack_require__(11);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};













/**
 * Service to provide functionalities regarding site plugins.
 */
var CoreSitePluginsProvider = /** @class */ (function () {
    function CoreSitePluginsProvider(logger, sitesProvider, utils, langProvider, appProvider, platform, filepoolProvider, coursesProvider, textUtils, eventsProvider) {
        var _this = this;
        this.sitesProvider = sitesProvider;
        this.utils = utils;
        this.langProvider = langProvider;
        this.appProvider = appProvider;
        this.platform = platform;
        this.filepoolProvider = filepoolProvider;
        this.coursesProvider = coursesProvider;
        this.textUtils = textUtils;
        this.eventsProvider = eventsProvider;
        this.ROOT_CACHE_KEY = 'CoreSitePlugins:';
        this.sitePlugins = {}; // Site plugins registered.
        this.sitePluginPromises = {}; // Promises of loading plugins.
        this.hasSitePluginsLoaded = false;
        this.sitePluginsFinishedLoading = false;
        this.logger = logger.getInstance('CoreUserProvider');
        var observer = this.eventsProvider.on(__WEBPACK_IMPORTED_MODULE_12__providers_events__["a" /* CoreEventsProvider */].SITE_PLUGINS_LOADED, function () {
            _this.sitePluginsFinishedLoading = true;
            observer && observer.off();
        });
        // Initialize deferred at start and on logout.
        this.fetchPluginsDeferred = this.utils.promiseDefer();
        eventsProvider.on(__WEBPACK_IMPORTED_MODULE_12__providers_events__["a" /* CoreEventsProvider */].LOGOUT, function () {
            _this.fetchPluginsDeferred = _this.utils.promiseDefer();
        });
    }
    /**
     * Add some params that will always be sent for get content.
     *
     * @param {any} args Original params.
     * @param {CoreSite} [site] Site. If not defined, current site.
     * @return {Promise<any>} Promise resolved with the new params.
     */
    CoreSitePluginsProvider.prototype.addDefaultArgs = function (args, site) {
        var _this = this;
        args = args || {};
        site = site || this.sitesProvider.getCurrentSite();
        return this.langProvider.getCurrentLanguage().then(function (lang) {
            // Clone the object so the original one isn't modified.
            var argsToSend = _this.utils.clone(args);
            argsToSend.userid = args.userid || site.getUserId();
            argsToSend.appid = __WEBPACK_IMPORTED_MODULE_10__configconstants__["a" /* CoreConfigConstants */].app_id;
            argsToSend.appversioncode = __WEBPACK_IMPORTED_MODULE_10__configconstants__["a" /* CoreConfigConstants */].versioncode;
            argsToSend.appversionname = __WEBPACK_IMPORTED_MODULE_10__configconstants__["a" /* CoreConfigConstants */].versionname;
            argsToSend.applang = lang;
            argsToSend.appcustomurlscheme = __WEBPACK_IMPORTED_MODULE_10__configconstants__["a" /* CoreConfigConstants */].customurlscheme;
            argsToSend.appisdesktop = _this.appProvider.isDesktop();
            argsToSend.appismobile = _this.appProvider.isMobile();
            argsToSend.appiswide = _this.appProvider.isWide();
            if (argsToSend.appisdevice) {
                if (_this.platform.is('ios')) {
                    argsToSend.appplatform = 'ios';
                }
                else {
                    argsToSend.appplatform = 'android';
                }
            }
            else if (argsToSend.appisdesktop) {
                if (_this.appProvider.isMac()) {
                    argsToSend.appplatform = 'mac';
                }
                else if (_this.appProvider.isLinux()) {
                    argsToSend.appplatform = 'linux';
                }
                else {
                    argsToSend.appplatform = 'windows';
                }
            }
            else {
                argsToSend.appplatform = 'browser';
            }
            return argsToSend;
        });
    };
    /**
     * Call a WS for a site plugin.
     *
     * @param {string} method WS method to use.
     * @param {any} data Data to send to the WS.
     * @param {CoreSiteWSPreSets} [preSets] Extra options.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved with the response.
     */
    CoreSitePluginsProvider.prototype.callWS = function (method, data, preSets, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            preSets = preSets || {};
            preSets.cacheKey = preSets.cacheKey || _this.getCallWSCacheKey(method, data);
            return site.read(method, data, preSets);
        });
    };
    /**
     * Given the result of a init get_content and, optionally, the result of another get_content,
     * build an object with the data to pass to the JS of the get_content.
     *
     * @param {any} initResult Result of the init WS call.
     * @param {any} [contentResult] Result of the content WS call (if any).
     * @return {any} An object with the data to pass to the JS.
     */
    CoreSitePluginsProvider.prototype.createDataForJS = function (initResult, contentResult) {
        var data;
        if (initResult) {
            // First of all, add the data returned by the init JS (if any).
            data = this.utils.clone(initResult.jsResult || {});
            if (typeof data == 'boolean') {
                data = {};
            }
            // Now add some data returned by the init WS call.
            data.INIT_TEMPLATES = this.utils.objectToKeyValueMap(initResult.templates, 'id', 'html');
            data.INIT_OTHERDATA = initResult.otherdata;
        }
        if (contentResult) {
            // Now add the data returned by the content WS call.
            data.CONTENT_TEMPLATES = this.utils.objectToKeyValueMap(contentResult.templates, 'id', 'html');
            data.CONTENT_OTHERDATA = contentResult.otherdata;
        }
        return data;
    };
    /**
     * Get cache key for a WS call.
     *
     * @param {string} method Name of the method.
     * @param {any} data Data to identify the WS call.
     * @return {string} Cache key.
     */
    CoreSitePluginsProvider.prototype.getCallWSCacheKey = function (method, data) {
        return this.getCallWSCommonCacheKey(method) + ':' + this.utils.sortAndStringify(data);
    };
    /**
     * Get common cache key for a WS call.
     *
     * @param {string} method Name of the method.
     * @return {string} Cache key.
     */
    CoreSitePluginsProvider.prototype.getCallWSCommonCacheKey = function (method) {
        return this.ROOT_CACHE_KEY + 'ws:' + method;
    };
    /**
     * Get a certain content for a site plugin.
     *
     * @param {string} component Component where the class is. E.g. mod_assign.
     * @param {string} method Method to execute in the class.
     * @param {any} args The params for the method.
     * @param {CoreSiteWSPreSets} [preSets] Extra options.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved with the result.
     */
    CoreSitePluginsProvider.prototype.getContent = function (component, method, args, preSets, siteId) {
        var _this = this;
        this.logger.debug("Get content for component '" + component + "' and method '" + method + "'");
        return this.sitesProvider.getSite(siteId).then(function (site) {
            // Add some params that will always be sent.
            return _this.addDefaultArgs(args, site).then(function (argsToSend) {
                // Now call the WS.
                var data = {
                    component: component,
                    method: method,
                    args: _this.utils.objectToArrayOfObjects(argsToSend, 'name', 'value', true)
                };
                preSets = preSets || {};
                preSets.cacheKey = _this.getContentCacheKey(component, method, args);
                preSets.updateFrequency = typeof preSets.updateFrequency != 'undefined' ? preSets.updateFrequency :
                    __WEBPACK_IMPORTED_MODULE_6__classes_site__["a" /* CoreSite */].FREQUENCY_OFTEN;
                return _this.sitesProvider.getCurrentSite().read('tool_mobile_get_content', data, preSets);
            }).then(function (result) {
                if (result.otherdata) {
                    result.otherdata = _this.utils.objectToKeyValueMap(result.otherdata, 'name', 'value');
                    // Try to parse all properties that could be JSON encoded strings.
                    for (var name_1 in result.otherdata) {
                        var value = result.otherdata[name_1];
                        if (typeof value == 'string' && (value[0] == '{' || value[0] == '[')) {
                            result.otherdata[name_1] = _this.textUtils.parseJSON(value);
                        }
                    }
                }
                else {
                    result.otherdata = {};
                }
                return result;
            });
        });
    };
    /**
     * Get cache key for get content WS calls.
     *
     * @param {string} component Component where the class is. E.g. mod_assign.
     * @param {string} method Method to execute in the class.
     * @param {any} args The params for the method.
     * @return {string} Cache key.
     */
    CoreSitePluginsProvider.prototype.getContentCacheKey = function (component, method, args) {
        return this.ROOT_CACHE_KEY + 'content:' + component + ':' + method + ':' + this.utils.sortAndStringify(args);
    };
    /**
     * Get the value of a WS param for prefetch.
     *
     * @param {string} component The component of the handler.
     * @param {string} paramName Name of the param as defined by the handler.
     * @param {number} [courseId] Course ID (if prefetching a course).
     * @param {any} [module] The module object returned by WS (if prefetching a module).
     * @return {any} The value.
     */
    CoreSitePluginsProvider.prototype.getDownloadParam = function (component, paramName, courseId, module) {
        switch (paramName) {
            case 'courseids':
                // The WS needs the list of course IDs. Create the list.
                return [courseId];
            case component + 'id':
                // The WS needs the instance id.
                return module && module.instance;
            default:
        }
    };
    /**
     * Get the unique name of a handler (plugin + handler).
     *
     * @param {any} plugin Data of the plugin.
     * @param {string} handlerName Name of the handler inside the plugin.
     * @return {string} Unique name.
     */
    CoreSitePluginsProvider.prototype.getHandlerUniqueName = function (plugin, handlerName) {
        return plugin.addon + '_' + handlerName;
    };
    /**
     * Get a site plugin handler.
     *
     * @param {string} name Unique name of the handler.
     * @return {CoreSitePluginsHandler} Handler.
     */
    CoreSitePluginsProvider.prototype.getSitePluginHandler = function (name) {
        return this.sitePlugins[name];
    };
    /**
     * Invalidate all WS call to a certain method.
     *
     * @param {string} method WS method to use.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreSitePluginsProvider.prototype.invalidateAllCallWSForMethod = function (method, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.invalidateWsCacheForKeyStartingWith(_this.getCallWSCommonCacheKey(method));
        });
    };
    /**
     * Invalidate a WS call.
     *
     * @param {string} method WS method to use.
     * @param {any} data Data to send to the WS.
     * @param {CoreSiteWSPreSets} [preSets] Extra options.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreSitePluginsProvider.prototype.invalidateCallWS = function (method, data, preSets, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.invalidateWsCacheForKey(preSets.cacheKey || _this.getCallWSCacheKey(method, data));
        });
    };
    /**
     * Invalidate a page content.
     *
     * @param {string} component Component where the class is. E.g. mod_assign.
     * @param {string} method Method to execute in the class.
     * @param {any} args The params for the method.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved when the data is invalidated.
     */
    CoreSitePluginsProvider.prototype.invalidateContent = function (component, callback, args, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.invalidateWsCacheForKey(_this.getContentCacheKey(component, callback, args));
        });
    };
    /**
     * Check if the get content WS is available.
     *
     * @param {CoreSite} site The site to check. If not defined, current site.
     */
    CoreSitePluginsProvider.prototype.isGetContentAvailable = function (site) {
        site = site || this.sitesProvider.getCurrentSite();
        return site.wsAvailable('tool_mobile_get_content');
    };
    /**
     * Check if a handler is enabled for a certain course.
     *
     * @param {number} courseId Course ID to check.
     * @param {boolean} [restrictEnrolled] If true or undefined, handler is only enabled for courses the user is enrolled in.
     * @param {any} [restrict] Users and courses the handler is restricted to.
     * @return {boolean | Promise<boolean>} Whether the handler is enabled.
     */
    CoreSitePluginsProvider.prototype.isHandlerEnabledForCourse = function (courseId, restrictEnrolled, restrict) {
        if (restrict && restrict.courses && restrict.courses.indexOf(courseId) == -1) {
            // Course is not in the list of restricted courses.
            return false;
        }
        if (restrictEnrolled || typeof restrictEnrolled == 'undefined') {
            // Only enabled for courses the user is enrolled to. Check if the user is enrolled in the course.
            return this.coursesProvider.getUserCourse(courseId, true).then(function () {
                return true;
            }).catch(function () {
                return false;
            });
        }
        return true;
    };
    /**
     * Check if a handler is enabled for a certain user.
     *
     * @param {number} userId User ID to check.
     * @param {boolean} [restrictCurrent] Whether handler is only enabled for current user.
     * @param {any} [restrict] Users and courses the handler is restricted to.
     * @return {boolean} Whether the handler is enabled.
     */
    CoreSitePluginsProvider.prototype.isHandlerEnabledForUser = function (userId, restrictCurrent, restrict) {
        if (restrictCurrent && userId != this.sitesProvider.getCurrentSite().getUserId()) {
            // Only enabled for current user.
            return false;
        }
        if (restrict && restrict.users && restrict.users.indexOf(userId) == -1) {
            // User is not in the list of restricted users.
            return false;
        }
        return true;
    };
    /**
     * Load other data into args as determined by useOtherData list.
     * If useOtherData is undefined, it won't add any data.
     * If useOtherData is an array, it will only copy the properties whose names are in the array.
     * If useOtherData is any other value, it will copy all the data from otherData to args.
     *
     * @param {any} args The current args.
     * @param {any} otherData All the other data.
     * @param {any} useOtherData Names of the attributes to include.
     * @return {any} New args.
     */
    CoreSitePluginsProvider.prototype.loadOtherDataInArgs = function (args, otherData, useOtherData) {
        if (!args) {
            args = {};
        }
        else {
            args = this.utils.clone(args);
        }
        otherData = otherData || {};
        if (typeof useOtherData == 'undefined') {
            // No need to add other data, return args as they are.
            return args;
        }
        else if (Array.isArray(useOtherData)) {
            // Include only the properties specified in the array.
            for (var i in useOtherData) {
                var name_2 = useOtherData[i];
                if (typeof otherData[name_2] == 'object' && otherData[name_2] !== null) {
                    // Stringify objects.
                    args[name_2] = JSON.stringify(otherData[name_2]);
                }
                else {
                    args[name_2] = otherData[name_2];
                }
            }
        }
        else {
            // Add all the data to args.
            for (var name_3 in otherData) {
                if (typeof otherData[name_3] == 'object' && otherData[name_3] !== null) {
                    // Stringify objects.
                    args[name_3] = JSON.stringify(otherData[name_3]);
                }
                else {
                    args[name_3] = otherData[name_3];
                }
            }
        }
        return args;
    };
    /**
     * Prefetch offline functions for a site plugin handler.
     *
     * @param {string} component The component of the handler.
     * @param {any} args Params to send to the get_content calls.
     * @param {any} handlerSchema The handler schema.
     * @param {number} [courseId] Course ID (if prefetching a course).
     * @param {any} [module] The module object returned by WS (if prefetching a module).
     * @param {boolean} [prefetch] True to prefetch, false to download right away.
     * @param {string} [dirPath] Path of the directory where to store all the content files.
     * @param {CoreSite} [site] Site. If not defined, current site.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreSitePluginsProvider.prototype.prefetchFunctions = function (component, args, handlerSchema, courseId, module, prefetch, dirPath, site) {
        var _this = this;
        site = site || this.sitesProvider.getCurrentSite();
        var promises = [];
        for (var method in handlerSchema.offlinefunctions) {
            if (site.wsAvailable(method)) {
                // The method is a WS.
                var paramsList = handlerSchema.offlinefunctions[method], cacheKey = this.getCallWSCacheKey(method, args);
                var params = {};
                if (!paramsList.length) {
                    // No params defined, send the default ones.
                    params = args;
                }
                else {
                    for (var i in paramsList) {
                        var paramName = paramsList[i];
                        if (typeof args[paramName] != 'undefined') {
                            params[paramName] = args[paramName];
                        }
                        else {
                            // The param is not one of the default ones. Try to calculate the param to use.
                            var value = this.getDownloadParam(component, paramName, courseId, module);
                            if (typeof value != 'undefined') {
                                params[paramName] = value;
                            }
                        }
                    }
                }
                promises.push(this.callWS(method, params, { cacheKey: cacheKey }));
            }
            else {
                // It's a method to get content.
                promises.push(this.getContent(component, method, args).then(function (result) {
                    var subPromises = [];
                    // Prefetch the files in the content.
                    if (result.files && result.files.length) {
                        subPromises.push(_this.filepoolProvider.downloadOrPrefetchFiles(site.id, result.files, prefetch, false, component, module.id, dirPath));
                    }
                    return Promise.all(subPromises);
                }));
            }
        }
        return Promise.all(promises);
    };
    /**
     * Store a site plugin handler.
     *
     * @param {string} name A unique name to identify the handler.
     * @param {CoreSitePluginsHandler} handler Handler to set.
     */
    CoreSitePluginsProvider.prototype.setSitePluginHandler = function (name, handler) {
        this.sitePlugins[name] = handler;
    };
    /**
     * Store the promise for a plugin that is being initialised.
     *
     * @param {String} component
     * @param {Promise<any>} promise
     */
    CoreSitePluginsProvider.prototype.registerSitePluginPromise = function (component, promise) {
        this.sitePluginPromises[component] = promise;
    };
    /**
     * Set plugins fetched.
     */
    CoreSitePluginsProvider.prototype.setPluginsFetched = function () {
        this.fetchPluginsDeferred.resolve();
    };
    /**
     * Is a plugin being initialised for the specified component?
     *
     * @param {String} component
     * @return {boolean}
     */
    CoreSitePluginsProvider.prototype.sitePluginPromiseExists = function (component) {
        return this.sitePluginPromises.hasOwnProperty(component);
    };
    /**
     * Get the promise for a plugin that is being initialised.
     *
     * @param {String} component
     * @return {Promise<any>}
     */
    CoreSitePluginsProvider.prototype.sitePluginLoaded = function (component) {
        return this.sitePluginPromises[component];
    };
    /**
     * Wait for fetch plugins to be done.
     *
     * @return {Promise<any>} Promise resolved when site plugins have been fetched.
     */
    CoreSitePluginsProvider.prototype.waitFetchPlugins = function () {
        return this.fetchPluginsDeferred.promise;
    };
    CoreSitePluginsProvider.COMPONENT = 'CoreSitePlugins';
    CoreSitePluginsProvider = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_5__providers_logger__["a" /* CoreLoggerProvider */], __WEBPACK_IMPORTED_MODULE_7__providers_sites__["a" /* CoreSitesProvider */], __WEBPACK_IMPORTED_MODULE_9__providers_utils_utils__["a" /* CoreUtilsProvider */],
            __WEBPACK_IMPORTED_MODULE_4__providers_lang__["a" /* CoreLangProvider */], __WEBPACK_IMPORTED_MODULE_2__providers_app__["a" /* CoreAppProvider */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["v" /* Platform */],
            __WEBPACK_IMPORTED_MODULE_3__providers_filepool__["a" /* CoreFilepoolProvider */], __WEBPACK_IMPORTED_MODULE_11__core_courses_providers_courses__["a" /* CoreCoursesProvider */],
            __WEBPACK_IMPORTED_MODULE_8__providers_utils_text__["a" /* CoreTextUtilsProvider */], __WEBPACK_IMPORTED_MODULE_12__providers_events__["a" /* CoreEventsProvider */]])
    ], CoreSitePluginsProvider);
    return CoreSitePluginsProvider;
}());

//# sourceMappingURL=siteplugins.js.map

/***/ }),
/* 55 */,
/* 56 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreBlockDelegate; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__providers_logger__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__providers_events__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_sites__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__classes_delegate__ = __webpack_require__(107);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__default_block_handler__ = __webpack_require__(583);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__core_siteplugins_providers_siteplugins__ = __webpack_require__(54);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_rxjs__ = __webpack_require__(148);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_rxjs___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_7_rxjs__);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};








/**
 * Delegate to register block handlers.
 */
var CoreBlockDelegate = /** @class */ (function (_super) {
    __extends(CoreBlockDelegate, _super);
    function CoreBlockDelegate(logger, sitesProvider, eventsProvider, defaultHandler, sitePluginsProvider) {
        var _this = _super.call(this, 'CoreBlockDelegate', logger, sitesProvider, eventsProvider) || this;
        _this.defaultHandler = defaultHandler;
        _this.sitePluginsProvider = sitePluginsProvider;
        _this.handlerNameProperty = 'blockName';
        _this.featurePrefix = 'CoreBlockDelegate_';
        _this.blocksUpdateObservable = new __WEBPACK_IMPORTED_MODULE_7_rxjs__["Subject"]();
        return _this;
    }
    /**
     * Check if blocks are disabled in a certain site.
     *
     * @param {CoreSite} [site] Site. If not defined, use current site.
     * @return {boolean} Whether it's disabled.
     */
    CoreBlockDelegate.prototype.areBlocksDisabledInSite = function (site) {
        site = site || this.sitesProvider.getCurrentSite();
        return site.isFeatureDisabled('NoDelegate_SiteBlocks');
    };
    /**
     * Check if blocks are disabled in a certain site for courses.
     *
     * @param {CoreSite} [site] Site. If not defined, use current site.
     * @return {boolean} Whether it's disabled.
     */
    CoreBlockDelegate.prototype.areBlocksDisabledInCourses = function (site) {
        site = site || this.sitesProvider.getCurrentSite();
        return site.isFeatureDisabled('NoDelegate_CourseBlocks');
    };
    /**
     * Check if blocks are disabled in a certain site.
     *
     * @param  {string} [siteId] Site Id. If not defined, use current site.
     * @return {Promise<boolean>}     Promise resolved with true if disabled, rejected or resolved with false otherwise.
     */
    CoreBlockDelegate.prototype.areBlocksDisabled = function (siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return _this.areBlocksDisabledInSite(site);
        });
    };
    /**
     * Get the display data for a certain block.
     *
     * @param {Injector} injector Injector.
     * @param {any} block The block to render.
     * @param {string} contextLevel The context where the block will be used.
     * @param {number} instanceId The instance ID associated with the context level.
     * @return {Promise<CoreBlockHandlerData>} Promise resolved with the display data.
     */
    CoreBlockDelegate.prototype.getBlockDisplayData = function (injector, block, contextLevel, instanceId) {
        return Promise.resolve(this.executeFunctionOnEnabled(block.name, 'getDisplayData', [injector, block, contextLevel, instanceId]));
    };
    /**
     * Check if any of the blocks in a list is supported.
     *
     * @param {any[]} blocks The list of blocks.
     * @return {boolean} Whether any of the blocks is supported.
     */
    CoreBlockDelegate.prototype.hasSupportedBlock = function (blocks) {
        var _this = this;
        blocks = blocks || [];
        return !!blocks.find(function (block) { return _this.isBlockSupported(block.name); });
    };
    /**
     * Check if a block is supported.
     *
     * @param {string} name Block "name". E.g. 'activity_modules'.
     * @return {boolean} Whether it's supported.
     */
    CoreBlockDelegate.prototype.isBlockSupported = function (name) {
        return this.hasHandler(name, true);
    };
    /**
     * Check if feature is enabled or disabled in the site, depending on the feature prefix and the handler name.
     *
     * @param  {CoreDelegateHandler} handler Handler to check.
     * @param  {CoreSite} site Site to check.
     * @return {boolean} Whether is enabled or disabled in site.
     */
    CoreBlockDelegate.prototype.isFeatureDisabled = function (handler, site) {
        return this.areBlocksDisabledInSite(site) || _super.prototype.isFeatureDisabled.call(this, handler, site);
    };
    /**
     * Called when there are new block handlers available. Informs anyone who subscribed to the
     * observable.
     */
    CoreBlockDelegate.prototype.updateData = function () {
        this.blocksUpdateObservable.next();
    };
    CoreBlockDelegate = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_1__providers_logger__["a" /* CoreLoggerProvider */], __WEBPACK_IMPORTED_MODULE_3__providers_sites__["a" /* CoreSitesProvider */], __WEBPACK_IMPORTED_MODULE_2__providers_events__["a" /* CoreEventsProvider */],
            __WEBPACK_IMPORTED_MODULE_5__default_block_handler__["a" /* CoreBlockDefaultHandler */], __WEBPACK_IMPORTED_MODULE_6__core_siteplugins_providers_siteplugins__["a" /* CoreSitePluginsProvider */]])
    ], CoreBlockDelegate);
    return CoreBlockDelegate;
}(__WEBPACK_IMPORTED_MODULE_4__classes_delegate__["a" /* CoreDelegate */]));

//# sourceMappingURL=delegate.js.map

/***/ }),
/* 57 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreCourseModuleDelegate; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__providers_events__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__providers_logger__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_sites__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__course__ = __webpack_require__(14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__default_module__ = __webpack_require__(584);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__classes_delegate__ = __webpack_require__(107);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};







/**
 * Delegate to register module handlers.
 */
var CoreCourseModuleDelegate = /** @class */ (function (_super) {
    __extends(CoreCourseModuleDelegate, _super);
    function CoreCourseModuleDelegate(loggerProvider, sitesProvider, eventsProvider, courseProvider, defaultHandler) {
        var _this = _super.call(this, 'CoreCourseModuleDelegate', loggerProvider, sitesProvider, eventsProvider) || this;
        _this.sitesProvider = sitesProvider;
        _this.courseProvider = courseProvider;
        _this.defaultHandler = defaultHandler;
        _this.featurePrefix = 'CoreCourseModuleDelegate_';
        _this.handlerNameProperty = 'modName';
        return _this;
    }
    /**
     * Get the component to render the module.
     *
     * @param {Injector} injector Injector.
     * @param {any} course The course object.
     * @param {any} module The module object.
     * @return {Promise<any>} Promise resolved with component to use, undefined if not found.
     */
    CoreCourseModuleDelegate.prototype.getMainComponent = function (injector, course, module) {
        var _this = this;
        return Promise.resolve(this.executeFunctionOnEnabled(module.modname, 'getMainComponent', [injector, course, module]))
            .catch(function (err) {
            _this.logger.error('Error getting main component', err);
        });
    };
    /**
     * Get the data required to display the module in the course contents view.
     *
     * @param {string} modname The name of the module type.
     * @param {any} module The module object.
     * @param {number} courseId The course ID.
     * @param {number} sectionId The section ID.
     * @return {CoreCourseModuleHandlerData} Data to render the module.
     */
    CoreCourseModuleDelegate.prototype.getModuleDataFor = function (modname, module, courseId, sectionId) {
        return this.executeFunctionOnEnabled(modname, 'getData', [module, courseId, sectionId]);
    };
    /**
     * Check if a certain module type is disabled in a site.
     *
     * @param {string} modname The name of the module type.
     * @param {string} [siteId] Site ID. If not defined, current site.
     * @return {Promise<boolean>} Promise resolved with boolean: whether module is disabled.
     */
    CoreCourseModuleDelegate.prototype.isModuleDisabled = function (modname, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return _this.isModuleDisabledInSite(modname, site);
        });
    };
    /**
     * Check if a certain module type is disabled in a site.
     *
     * @param {string} modname The name of the module type.
     * @param {CoreSite} [site] Site. If not defined, use current site.
     * @return {boolean} Whether module is disabled.
     */
    CoreCourseModuleDelegate.prototype.isModuleDisabledInSite = function (modname, site) {
        var handler = this.getHandler(modname, true);
        if (handler) {
            site = site || this.sitesProvider.getCurrentSite();
            return this.isFeatureDisabled(handler, site);
        }
        return false;
    };
    /**
     * Whether to display the course refresher in single activity course format. If it returns false, a refresher must be
     * included in the template that calls the doRefresh method of the component. Defaults to true.
     *
     * @param {any} modname The name of the module type.
     * @return {boolean} Whether the refresher should be displayed.
     */
    CoreCourseModuleDelegate.prototype.displayRefresherInSingleActivity = function (modname) {
        return this.executeFunctionOnEnabled(modname, 'displayRefresherInSingleActivity');
    };
    /**
     * Get the icon src for a certain type of module.
     *
     * @param {any} modname The name of the module type.
     * @param {string} [modicon] The mod icon string.
     * @return {string} The icon src.
     */
    CoreCourseModuleDelegate.prototype.getModuleIconSrc = function (modname, modicon) {
        return this.executeFunctionOnEnabled(modname, 'getIconSrc') || this.courseProvider.getModuleIconSrc(modname, modicon);
    };
    /**
     * Check if a certain type of module supports a certain feature.
     *
     * @param {string} modname The modname.
     * @param {string} feature The feature to check.
     * @param {any} defaultValue Value to return if the module is not supported or doesn't know if it's supported.
     * @return {any} The result of the supports check.
     */
    CoreCourseModuleDelegate.prototype.supportsFeature = function (modname, feature, defaultValue) {
        var handler = this.enabledHandlers[modname];
        var result;
        if (handler) {
            if (handler['supportsFeature']) {
                // The handler specified a function to determine the feature, use it.
                result = handler['supportsFeature'].apply(handler, [feature]);
            }
            else if (handler['supportedFeatures']) {
                // Handler has an object to determine the feature, use it.
                result = handler['supportedFeatures'][feature];
            }
        }
        if (result === null || typeof result == 'undefined') {
            // Not supported or doesn't know, return defaul.
            return defaultValue;
        }
        else {
            return result;
        }
    };
    CoreCourseModuleDelegate = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_2__providers_logger__["a" /* CoreLoggerProvider */], __WEBPACK_IMPORTED_MODULE_3__providers_sites__["a" /* CoreSitesProvider */], __WEBPACK_IMPORTED_MODULE_1__providers_events__["a" /* CoreEventsProvider */],
            __WEBPACK_IMPORTED_MODULE_4__course__["a" /* CoreCourseProvider */], __WEBPACK_IMPORTED_MODULE_5__default_module__["a" /* CoreCourseModuleDefaultHandler */]])
    ], CoreCourseModuleDelegate);
    return CoreCourseModuleDelegate;
}(__WEBPACK_IMPORTED_MODULE_6__classes_delegate__["a" /* CoreDelegate */]));

//# sourceMappingURL=module-delegate.js.map

/***/ }),
/* 58 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreContentLinksDelegate; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__providers_logger__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__providers_sites__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_utils_url__ = __webpack_require__(23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__providers_utils_utils__ = __webpack_require__(2);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};





/**
 * Delegate to register handlers to handle links.
 */
var CoreContentLinksDelegate = /** @class */ (function () {
    function CoreContentLinksDelegate(logger, sitesProvider, urlUtils, utils) {
        this.sitesProvider = sitesProvider;
        this.urlUtils = urlUtils;
        this.utils = utils;
        this.handlers = {}; // All registered handlers.
        this.logger = logger.getInstance('CoreContentLinksDelegate');
    }
    /**
     * Get the list of possible actions to do for a URL.
     *
     * @param {string} url URL to handle.
     * @param {number} [courseId] Course ID related to the URL. Optional but recommended.
     * @param {string} [username] Username to use to filter sites.
     * @param {any} [data] Extra data to handle the URL.
     * @return {Promise<CoreContentLinksAction[]>}  Promise resolved with the actions.
     */
    CoreContentLinksDelegate.prototype.getActionsFor = function (url, courseId, username, data) {
        var _this = this;
        if (!url) {
            return Promise.resolve([]);
        }
        // Get the list of sites the URL belongs to.
        return this.sitesProvider.getSiteIdsFromUrl(url, true, username).then(function (siteIds) {
            var linkActions = [], promises = [], params = _this.urlUtils.extractUrlParams(url);
            var _loop_1 = function (name_1) {
                var handler = _this.handlers[name_1], checkAll = handler.checkAllUsers, isEnabledFn = _this.isHandlerEnabled.bind(_this, handler, url, params, courseId);
                if (!handler.handles(url)) {
                    return "continue";
                }
                // Filter the site IDs using the isEnabled function.
                promises.push(_this.utils.filterEnabledSites(siteIds, isEnabledFn, checkAll).then(function (siteIds) {
                    if (!siteIds.length) {
                        // No sites supported, no actions.
                        return;
                    }
                    return Promise.resolve(handler.getActions(siteIds, url, params, courseId, data)).then(function (actions) {
                        if (actions && actions.length) {
                            // Set default values if any value isn't supplied.
                            actions.forEach(function (action) {
                                action.message = action.message || 'core.view';
                                action.icon = action.icon || 'eye';
                                action.sites = action.sites || siteIds;
                            });
                            // Add them to the list.
                            linkActions.push({
                                priority: handler.priority,
                                actions: actions
                            });
                        }
                    });
                }));
            };
            for (var name_1 in _this.handlers) {
                _loop_1(name_1);
            }
            return _this.utils.allPromises(promises).catch(function () {
                // Ignore errors.
            }).then(function () {
                // Sort link actions by priority.
                return _this.sortActionsByPriority(linkActions);
            });
        });
    };
    /**
     * Get the site URL if the URL is supported by any handler.
     *
     * @param {string} url URL to handle.
     * @return {string} Site URL if the URL is supported by any handler, undefined otherwise.
     */
    CoreContentLinksDelegate.prototype.getSiteUrl = function (url) {
        if (!url) {
            return;
        }
        // Check if any handler supports this URL.
        for (var name_2 in this.handlers) {
            var handler = this.handlers[name_2], siteUrl = handler.getSiteUrl(url);
            if (siteUrl) {
                return siteUrl;
            }
        }
    };
    /**
     * Check if a handler is enabled for a certain site and URL.
     *
     * @param {CoreContentLinksHandler} handler Handler to check.
     * @param {string} url The URL to check.
     * @param {any} params The params of the URL
     * @param {number} courseId Course ID the URL belongs to (can be undefined).
     * @param {string} siteId The site ID to check.
     * @return {Promise<boolean>} Promise resolved with boolean: whether the handler is enabled.
     */
    CoreContentLinksDelegate.prototype.isHandlerEnabled = function (handler, url, params, courseId, siteId) {
        var promise;
        if (handler.featureName) {
            // Check if the feature is disabled.
            promise = this.sitesProvider.isFeatureDisabled(handler.featureName, siteId);
        }
        else {
            promise = Promise.resolve(false);
        }
        return promise.then(function (disabled) {
            if (disabled) {
                return false;
            }
            if (!handler.isEnabled) {
                // Handler doesn't implement isEnabled, assume it's enabled.
                return true;
            }
            return handler.isEnabled(siteId, url, params, courseId);
        });
    };
    /**
     * Register a handler.
     *
     * @param {CoreContentLinksHandler} handler The handler to register.
     * @return {boolean} True if registered successfully, false otherwise.
     */
    CoreContentLinksDelegate.prototype.registerHandler = function (handler) {
        if (typeof this.handlers[handler.name] !== 'undefined') {
            this.logger.log("Addon '" + handler.name + "' already registered");
            return false;
        }
        this.logger.log("Registered addon '" + handler.name + "'");
        this.handlers[handler.name] = handler;
        return true;
    };
    /**
     * Sort actions by priority.
     *
     * @param {CoreContentLinksHandlerActions[]} actions Actions to sort.
     * @return {CoreContentLinksAction[]} Sorted actions.
     */
    CoreContentLinksDelegate.prototype.sortActionsByPriority = function (actions) {
        var sorted = [];
        // Sort by priority.
        actions = actions.sort(function (a, b) {
            return a.priority <= b.priority ? 1 : -1;
        });
        // Fill result array.
        actions.forEach(function (entry) {
            sorted = sorted.concat(entry.actions);
        });
        return sorted;
    };
    CoreContentLinksDelegate = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_1__providers_logger__["a" /* CoreLoggerProvider */], __WEBPACK_IMPORTED_MODULE_2__providers_sites__["a" /* CoreSitesProvider */], __WEBPACK_IMPORTED_MODULE_3__providers_utils_url__["a" /* CoreUrlUtilsProvider */],
            __WEBPACK_IMPORTED_MODULE_4__providers_utils_utils__["a" /* CoreUtilsProvider */]])
    ], CoreContentLinksDelegate);
    return CoreContentLinksDelegate;
}());

//# sourceMappingURL=delegate.js.map

/***/ }),
/* 59 */,
/* 60 */,
/* 61 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreCourseLogHelperProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__providers_sites__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__providers_utils_text__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_utils_time__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__providers_utils_utils__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__providers_app__ = __webpack_require__(9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__core_pushnotifications_providers_pushnotifications__ = __webpack_require__(130);
// (C) Copyright 2015 Martin Dougiamas
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};







/**
 * Helper to manage logging to Moodle.
 */
var CoreCourseLogHelperProvider = /** @class */ (function () {
    function CoreCourseLogHelperProvider(sitesProvider, timeUtils, textUtils, utils, appProvider, pushNotificationsProvider) {
        this.sitesProvider = sitesProvider;
        this.timeUtils = timeUtils;
        this.textUtils = textUtils;
        this.utils = utils;
        this.appProvider = appProvider;
        this.pushNotificationsProvider = pushNotificationsProvider;
        this.siteSchema = {
            name: 'CoreCourseLogHelperProvider',
            version: 1,
            tables: [
                {
                    name: CoreCourseLogHelperProvider_1.ACTIVITY_LOG_TABLE,
                    columns: [
                        {
                            name: 'component',
                            type: 'TEXT'
                        },
                        {
                            name: 'componentid',
                            type: 'INTEGER'
                        },
                        {
                            name: 'ws',
                            type: 'TEXT'
                        },
                        {
                            name: 'data',
                            type: 'TEXT'
                        },
                        {
                            name: 'time',
                            type: 'INTEGER'
                        }
                    ],
                    primaryKeys: ['component', 'componentid', 'ws', 'time']
                }
            ]
        };
        this.sitesProvider.registerSiteSchema(this.siteSchema);
    }
    CoreCourseLogHelperProvider_1 = CoreCourseLogHelperProvider;
    /**
     * Delete the offline saved activity logs.
     *
     * @param  {string}         component   Component name.
     * @param  {number}         componentId Component ID.
     * @param  {string}         [siteId]    Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved when deleted, rejected if failure.
     */
    CoreCourseLogHelperProvider.prototype.deleteLogs = function (component, componentId, siteId) {
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.getDb().deleteRecords(CoreCourseLogHelperProvider_1.ACTIVITY_LOG_TABLE, { component: component, componentid: componentId });
        });
    };
    /**
     * Delete a WS based log.
     *
     * @param  {string}         component   Component name.
     * @param  {number}         componentId Component ID.
     * @param  {string}         ws          WS name.
     * @param  {string}         [siteId]    Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved when deleted, rejected if failure.
     */
    CoreCourseLogHelperProvider.prototype.deleteWSLogsByComponent = function (component, componentId, ws, siteId) {
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.getDb().deleteRecords(CoreCourseLogHelperProvider_1.ACTIVITY_LOG_TABLE, { component: component, componentid: componentId, ws: ws });
        });
    };
    /**
     * Delete the offline saved activity logs using call data.
     *
     * @param  {string}         ws          WS name.
     * @param  {any}            data        Data to send to the WS.
     * @param  {string}         [siteId]    Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved when deleted, rejected if failure.
     */
    CoreCourseLogHelperProvider.prototype.deleteWSLogs = function (ws, data, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.getDb().deleteRecords(CoreCourseLogHelperProvider_1.ACTIVITY_LOG_TABLE, { ws: ws, data: _this.utils.sortAndStringify(data) });
        });
    };
    /**
     * Get all the offline saved activity logs.
     *
     * @param  {string}         [siteId]    Site ID. If not defined, current site.
     * @return {Promise<any[]>} Promise resolved with the list of offline logs.
     */
    CoreCourseLogHelperProvider.prototype.getAllLogs = function (siteId) {
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.getDb().getAllRecords(CoreCourseLogHelperProvider_1.ACTIVITY_LOG_TABLE);
        });
    };
    /**
     * Get the offline saved activity logs.
     *
     * @param  {string}         component   Component name.
     * @param  {number}         componentId Component ID.
     * @param  {string}         [siteId]    Site ID. If not defined, current site.
     * @return {Promise<any[]>} Promise resolved with the list of offline logs.
     */
    CoreCourseLogHelperProvider.prototype.getLogs = function (component, componentId, siteId) {
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.getDb().getRecords(CoreCourseLogHelperProvider_1.ACTIVITY_LOG_TABLE, { component: component, componentid: componentId });
        });
    };
    /**
     * Perform log online. Data will be saved offline for syncing.
     *
     * @param  {string}         ws          WS name.
     * @param  {any}            data        Data to send to the WS.
     * @param  {string}         component   Component name.
     * @param  {number}         componentId Component ID.
     * @param  {string}         [siteId]    Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreCourseLogHelperProvider.prototype.log = function (ws, data, component, componentId, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            if (!_this.appProvider.isOnline()) {
                // App is offline, store the action.
                return _this.storeOffline(ws, data, component, componentId, site.getId());
            }
            return _this.logOnline(ws, data, site.getId()).catch(function (error) {
                if (_this.utils.isWebServiceError(error)) {
                    // The WebService has thrown an error, this means that responses cannot be submitted.
                    return Promise.reject(error);
                }
                // Couldn't connect to server, store in offline.
                return _this.storeOffline(ws, data, component, componentId, site.getId());
            });
        });
    };
    /**
     * Perform the log online.
     *
     * @param  {string}       ws       WS name.
     * @param  {any}          data     Data to send to the WS.
     * @param  {string}       [siteId] Site ID. If not defined, current site.
     * @return {Promise<any>}  Promise resolved when log is successfully submitted. Rejected with object containing
     *                            the error message (if any) and a boolean indicating if the error was returned by WS.
     */
    CoreCourseLogHelperProvider.prototype.logOnline = function (ws, data, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            return site.write(ws, data).then(function (response) {
                if (!response.status) {
                    return Promise.reject(_this.utils.createFakeWSError(''));
                }
                // Remove all the logs performed.
                // TODO: Remove this lines when time is accepted in logs.
                return _this.deleteWSLogs(ws, data);
            });
        });
    };
    /**
     * Perform log online. Data will be saved offline for syncing.
     * It also triggers a Firebase view_item event.
     *
     * @param  {string}         ws          WS name.
     * @param  {any}            data        Data to send to the WS.
     * @param  {string}         component   Component name.
     * @param  {number}         componentId Component ID.
     * @param  {string}         [name] Name of the viewed item.
     * @param  {string}         [category] Category of the viewed item.
     * @param  {string}         [eventData] Data to pass to the Firebase event.
     * @param  {string}         [siteId]    Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreCourseLogHelperProvider.prototype.logSingle = function (ws, data, component, componentId, name, category, eventData, siteId) {
        this.pushNotificationsProvider.logViewEvent(componentId, name, category, ws, eventData, siteId);
        return this.log(ws, data, component, componentId, siteId);
    };
    /**
     * Perform log online. Data will be saved offline for syncing.
     * It also triggers a Firebase view_item_list event.
     *
     * @param  {string}         ws          WS name.
     * @param  {any}            data        Data to send to the WS.
     * @param  {string}         component   Component name.
     * @param  {number}         componentId Component ID.
     * @param  {string}         category    Category of the viewed item.
     * @param  {string}         [eventData] Data to pass to the Firebase event.
     * @param  {string}         [siteId]    Site ID. If not defined, current site.
     * @return {Promise<any>} Promise resolved when done.
     */
    CoreCourseLogHelperProvider.prototype.logList = function (ws, data, component, componentId, category, eventData, siteId) {
        this.pushNotificationsProvider.logViewListEvent(category, ws, eventData, siteId);
        return this.log(ws, data, component, componentId, siteId);
    };
    /**
     * Save activity log for offline sync.
     *
     * @param  {string}         ws          WS name.
     * @param  {any}            data        Data to send to the WS.
     * @param  {string}         component   Component name.
     * @param  {number}         componentId Component ID.
     * @param  {string}         [siteId]    Site ID. If not defined, current site.
     * @return {Promise<number>} Resolved with the inserted rowId field.
     */
    CoreCourseLogHelperProvider.prototype.storeOffline = function (ws, data, component, componentId, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var log = {
                ws: ws,
                data: _this.utils.sortAndStringify(data),
                component: component,
                componentid: componentId,
                time: _this.timeUtils.timestamp()
            };
            return site.getDb().insertRecord(CoreCourseLogHelperProvider_1.ACTIVITY_LOG_TABLE, log);
        });
    };
    /**
     * Sync all the offline saved activity logs.
     *
     * @param  {string}         [siteId]    Site ID. If not defined, current site.
     * @return {Promise<any>}   Promise resolved when done.
     */
    CoreCourseLogHelperProvider.prototype.syncSite = function (siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var siteId = site.getId();
            return _this.getAllLogs(siteId).then(function (logs) {
                var unique = [];
                // TODO: When time is accepted on log, do not discard same logs.
                logs.forEach(function (log) {
                    // Just perform unique syncs.
                    var found = unique.find(function (doneLog) {
                        return log.component == doneLog.component && log.componentid == doneLog.componentid &&
                            log.ws == doneLog.ws && log.data == doneLog.data;
                    });
                    if (!found) {
                        unique.push(log);
                    }
                });
                return _this.syncLogs(unique, siteId);
            });
        });
    };
    /**
     * Sync the offline saved activity logs.
     *
     * @param  {string}         component   Component name.
     * @param  {number}         componentId Component ID.
     * @param  {string}         [siteId]    Site ID. If not defined, current site.
     * @return {Promise<any>}   Promise resolved when done.
     */
    CoreCourseLogHelperProvider.prototype.syncIfNeeded = function (component, componentId, siteId) {
        var _this = this;
        return this.sitesProvider.getSite(siteId).then(function (site) {
            var siteId = site.getId();
            return _this.getLogs(component, componentId, siteId).then(function (logs) {
                var unique = [];
                // TODO: When time is accepted on log, do not discard same logs.
                logs.forEach(function (log) {
                    // Just perform unique syncs.
                    var found = unique.find(function (doneLog) {
                        return log.ws == doneLog.ws && log.data == doneLog.data;
                    });
                    if (!found) {
                        unique.push(log);
                    }
                });
                return _this.syncLogs(unique, siteId);
            });
        });
    };
    /**
     * Sync and delete given logs.
     *
     * @param  {any[]}        logs   Array of log objects.
     * @param  {string}       siteId Site Id.
     * @return {Promise<any>}        Promise resolved when done.
     */
    CoreCourseLogHelperProvider.prototype.syncLogs = function (logs, siteId) {
        var _this = this;
        return Promise.all(logs.map(function (